/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionFactory;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassAbstractDelegate;
import com.orientechnologies.orient.core.metadata.schema.OGlobalProperty;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingClusterSelectionStrategy;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.storage.OAutoshardedStorage;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;

public class OClassImpl
extends ODocumentWrapperNoClass
implements OClass {
    private static final long serialVersionUID = 1L;
    private static final int NOT_EXISTENT_CLUSTER_ID = -1;
    final OSchemaShared owner;
    private final Map<String, OProperty> properties = new HashMap<String, OProperty>();
    private int defaultClusterId = -1;
    private volatile String name;
    private String description;
    private int[] clusterIds;
    private List<OClassImpl> superClasses = new ArrayList<OClassImpl>();
    private int[] polymorphicClusterIds;
    private List<OClass> subclasses;
    private float overSize = 0.0f;
    private String shortName;
    private boolean strictMode = false;
    private boolean abstractClass = false;
    private Map<String, String> customFields;
    private volatile OClusterSelectionStrategy clusterSelection;
    private volatile int hashCode;

    protected OClassImpl(OSchemaShared iOwner, String iName) {
        this(iOwner, new ODocument().setTrackingChanges(false), iName);
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        this(iOwner, iName);
        this.setClusterIds(iClusterIds);
        this.defaultClusterId = iClusterIds[0];
        if (this.defaultClusterId == -1) {
            this.abstractClass = true;
        }
        if (this.abstractClass) {
            this.setPolymorphicClusterIds(OCommonConst.EMPTY_INT_ARRAY);
        } else {
            this.setPolymorphicClusterIds(iClusterIds);
        }
        this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstanceOfDefaultClass();
    }

    protected OClassImpl(OSchemaShared iOwner, ODocument iDocument, String iName) {
        this.name = iName;
        this.document = iDocument;
        this.owner = iOwner;
    }

    public static int[] readableClusters(ODatabaseDocument iDatabase, int[] iClusterIds) {
        ArrayList<Integer> listOfReadableIds = new ArrayList<Integer>();
        boolean all = true;
        for (int clusterId : iClusterIds) {
            try {
                OClass clazz = iDatabase.getMetadata().getSchema().getClassByClusterId(clusterId);
                if (clazz != null) {
                    iDatabase.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)clazz.getName());
                }
                String clusterName = iDatabase.getClusterNameById(clusterId);
                iDatabase.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)clusterName);
                listOfReadableIds.add(clusterId);
            }
            catch (OSecurityAccessException securityException) {
                all = false;
            }
        }
        if (all) {
            return iClusterIds;
        }
        int[] readableClusterIds = new int[listOfReadableIds.size()];
        int index = 0;
        Iterator iterator = listOfReadableIds.iterator();
        while (iterator.hasNext()) {
            int clusterId;
            clusterId = (Integer)iterator.next();
            readableClusterIds[index++] = clusterId;
        }
        return readableClusterIds;
    }

    @Override
    public OClusterSelectionStrategy getClusterSelection() {
        this.acquireSchemaReadLock();
        try {
            OClusterSelectionStrategy oClusterSelectionStrategy = this.clusterSelection;
            return oClusterSelectionStrategy;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass setClusterSelection(OClusterSelectionStrategy clusterSelection) {
        return this.setClusterSelection(clusterSelection.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setClusterSelection(String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd;
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                cmd = String.format("alter class `%s` clusterselection '%s'", this.name, value);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                cmd = String.format("alter class `%s` clusterselection '%s'", this.name, value);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setClusterSelectionInternal(value);
            } else {
                this.setClusterSelectionInternal(value);
            }
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public <RET extends ODocumentWrapper> RET reload() {
        return this.owner.reload();
    }

    @Override
    public String getCustom(String iName) {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields == null) {
                String string = null;
                return string;
            }
            String string = this.customFields.get(iName);
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClassImpl setCustom(String name, String value) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            String cmd;
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                cmd = String.format("alter class `%s` custom %s=%s", this.getName(), name, value);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                cmd = String.format("alter class `%s` custom %s=%s", this.getName(), name, value);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setCustomInternal(name, value);
            } else {
                this.setCustomInternal(name, value);
            }
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public Map<String, String> getCustomInternal() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Map<String, String> map = Collections.unmodifiableMap(this.customFields);
                return map;
            }
            Map<String, String> map = null;
            return map;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void removeCustom(String name) {
        this.setCustom(name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCustom() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` custom clear", this.getName());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` custom clear", this.getName());
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.clearCustomInternal();
            } else {
                this.clearCustomInternal();
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public Set<String> getCustomKeys() {
        this.acquireSchemaReadLock();
        try {
            if (this.customFields != null) {
                Set<String> set = Collections.unmodifiableSet(this.customFields.keySet());
                return set;
            }
            HashSet<String> hashSet = new HashSet<String>();
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean hasClusterId(int clusterId) {
        return Arrays.binarySearch(this.clusterIds, clusterId) >= 0;
    }

    @Override
    public boolean hasPolymorphicClusterId(int clusterId) {
        return Arrays.binarySearch(this.polymorphicClusterIds, clusterId) >= 0;
    }

    @Override
    public OClass getSuperClass() {
        this.acquireSchemaReadLock();
        try {
            OClassImpl oClassImpl = this.superClasses.isEmpty() ? null : this.superClasses.get(0);
            return oClassImpl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OClass setSuperClass(OClass iSuperClass) {
        this.setSuperClasses((List<? extends OClass>)(iSuperClass != null ? Arrays.asList(iSuperClass) : Collections.EMPTY_LIST));
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<OClass> getSuperClasses() {
        this.acquireSchemaReadLock();
        try {
            List<OClass> list = Collections.unmodifiableList(this.superClasses);
            return list;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean hasSuperClasses() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = !this.superClasses.isEmpty();
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSuperClassesNames() {
        this.acquireSchemaReadLock();
        try {
            ArrayList<String> superClassesNames = new ArrayList<String>(this.superClasses.size());
            for (OClassImpl superClass : this.superClasses) {
                superClassesNames.add(superClass.getName());
            }
            ArrayList<String> arrayList = superClassesNames;
            return arrayList;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    public OClass setSuperClassesByNames(List<String> classNames) {
        if (classNames == null) {
            classNames = Collections.EMPTY_LIST;
        }
        ArrayList<OClass> classes = new ArrayList<OClass>(classNames.size());
        OSchema schema = this.getDatabase().getMetadata().getSchema();
        for (String className : classNames) {
            classes.add(schema.getClass(OClassImpl.decodeClassName(className)));
        }
        return this.setSuperClasses(classes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setSuperClasses(List<? extends OClass> classes) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (classes != null) {
            ArrayList<OClass> toCheck = new ArrayList<OClass>(classes);
            toCheck.add(this);
            OClassImpl.checkParametersConflict(toCheck);
        }
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            StringBuilder sb = new StringBuilder();
            if (classes != null && classes.size() > 0) {
                for (OClass oClass : classes) {
                    sb.append('`').append(oClass.getName()).append("`,");
                }
                sb.deleteCharAt(sb.length() - 1);
            } else {
                sb.append("null");
            }
            String cmd = String.format("alter class `%s` superclasses %s", this.name, sb);
            if (storage instanceof OStorageProxy) {
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                OCommandSQL oCommandSQL = new OCommandSQL(cmd);
                oCommandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(oCommandSQL).execute(new Object[0]);
                this.setSuperClassesInternal(classes);
            } else {
                this.setSuperClassesInternal(classes);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSuperClassesInternal(List<? extends OClass> classes) {
        this.acquireSchemaWriteLock();
        try {
            ArrayList<OClassImpl> newSuperClasses = new ArrayList<OClassImpl>();
            for (OClass oClass : classes) {
                OClassImpl cls = oClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)oClass).delegate : (OClassImpl)oClass;
                if (newSuperClasses.contains(cls)) {
                    throw new OSchemaException("Duplicated superclass '" + cls.getName() + "'");
                }
                newSuperClasses.add(cls);
            }
            ArrayList toAddList = new ArrayList(newSuperClasses);
            toAddList.removeAll(this.superClasses);
            ArrayList<OClassImpl> arrayList = new ArrayList<OClassImpl>(this.superClasses);
            arrayList.removeAll(newSuperClasses);
            for (OClassImpl toRemove : arrayList) {
                toRemove.removeBaseClassInternal(this);
            }
            for (OClassImpl addTo : toAddList) {
                addTo.addBaseClass(this);
            }
            this.superClasses.clear();
            this.superClasses.addAll(newSuperClasses);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addSuperClass(OClass superClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.checkParametersConflict(superClass);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` superclass +`%s`", this.name, superClass != null ? superClass.getName() : null);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` superclass +`%s`", this.name, superClass != null ? superClass.getName() : null);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.addSuperClassInternal(superClass);
            } else {
                this.addSuperClassInternal(superClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSuperClassInternal(OClass superClass) {
        this.acquireSchemaWriteLock();
        try {
            OClassImpl cls = superClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)superClass).delegate : (OClassImpl)superClass;
            if (cls != null) {
                OSecurityUser user = this.getDatabase().getUser();
                if (user != null) {
                    user.allow(ORule.ResourceGeneric.CLASS, cls.getName(), ORole.PERMISSION_UPDATE);
                }
                if (this.superClasses.contains(superClass)) {
                    throw new OSchemaException("Class: '" + this.getName() + "' already has the class '" + superClass.getName() + "' as superclass");
                }
                cls.addBaseClass(this);
                this.superClasses.add(cls);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass removeSuperClass(OClass superClass) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` superclass -`%s`", this.name, superClass != null ? superClass.getName() : null);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` superclass -`%s`", this.name, superClass != null ? superClass.getName() : null);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.removeSuperClassInternal(superClass);
            } else {
                this.removeSuperClassInternal(superClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    void removeSuperClassInternal(OClass superClass) {
        this.acquireSchemaWriteLock();
        try {
            OClassImpl cls = superClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)superClass).delegate : (OClassImpl)superClass;
            if (this.superClasses.contains(cls)) {
                if (cls != null) {
                    cls.removeBaseClassInternal(this);
                }
                this.superClasses.remove(superClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setName(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        Character wrongCharacter = OSchemaShared.checkClassNameIfValid(name);
        OClass oClass = this.getDatabase().getMetadata().getSchema().getClass(name);
        if (oClass != null) {
            String error = String.format("Cannot rename class %s to %s. A Class with name %s exists", this.name, name, name);
            throw new OSchemaException(error);
        }
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid class name found. Character '" + wrongCharacter + "' cannot be used in class name '" + name + "'");
        }
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` name `%s`", this.name, name);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` name `%s`", this.name, name);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setNameInternal(name);
            } else {
                this.setNameInternal(name);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.acquireSchemaReadLock();
        try {
            long size = 0L;
            for (int clusterId : this.clusterIds) {
                size += this.getDatabase().getClusterRecordSizeById(clusterId);
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public String getShortName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.shortName;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setShortName(String shortName) {
        if (shortName != null && (shortName = shortName.trim()).isEmpty()) {
            shortName = null;
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` shortname %s", this.name, shortName);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` shortname %s", this.name, shortName);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setShortNameInternal(shortName);
            } else {
                this.setShortNameInternal(shortName);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getDescription() {
        this.acquireSchemaReadLock();
        try {
            String string = this.description;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setDescription(String iDescription) {
        if (iDescription != null && (iDescription = iDescription.trim()).isEmpty()) {
            iDescription = null;
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` description ?", this.name);
                database.command(new OCommandSQL(cmd)).execute(iDescription);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` description ?", this.name);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(iDescription);
                this.setDescriptionInternal(iDescription);
            } else {
                this.setDescriptionInternal(iDescription);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String getStreamableName() {
        this.acquireSchemaReadLock();
        try {
            String string = this.shortName != null ? this.shortName : this.name;
            return string;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        this.acquireSchemaReadLock();
        try {
            Collection<OProperty> collection = Collections.unmodifiableCollection(this.properties.values());
            return collection;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Map<String, OProperty> propertiesMap() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            HashMap<String, OProperty> props = new HashMap<String, OProperty>(20);
            this.propertiesMap(props, true);
            HashMap<String, OProperty> hashMap = props;
            return hashMap;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void propertiesMap(Map<String, OProperty> propertiesMap, boolean keepCase) {
        for (OProperty p : this.properties.values()) {
            String propName = p.getName();
            if (!keepCase) {
                propName = propName.toLowerCase();
            }
            if (propertiesMap.containsKey(propName)) continue;
            propertiesMap.put(propName, p);
        }
        for (OClassImpl superClass : this.superClasses) {
            superClass.propertiesMap(propertiesMap, keepCase);
        }
    }

    @Override
    public Collection<OProperty> properties() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            ArrayList<OProperty> props = new ArrayList<OProperty>();
            this.properties(props);
            ArrayList<OProperty> arrayList = props;
            return arrayList;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void properties(Collection<OProperty> properties) {
        properties.addAll(this.properties.values());
        for (OClassImpl superClass : this.superClasses) {
            superClass.properties(properties);
        }
    }

    public void getIndexedProperties(Collection<OProperty> indexedProperties) {
        for (OProperty p : this.properties.values()) {
            if (!this.areIndexed(p.getName())) continue;
            indexedProperties.add(p);
        }
        for (OClassImpl superClass : this.superClasses) {
            superClass.getIndexedProperties(indexedProperties);
        }
    }

    @Override
    public Collection<OProperty> getIndexedProperties() {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_READ, new Object[0]);
        this.acquireSchemaReadLock();
        try {
            HashSet<OProperty> indexedProps = new HashSet<OProperty>();
            this.getIndexedProperties(indexedProps);
            HashSet<OProperty> hashSet = indexedProps;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OProperty getProperty(String propertyName) {
        this.acquireSchemaReadLock();
        try {
            propertyName = propertyName.toLowerCase();
            OProperty p = this.properties.get(propertyName);
            if (p != null) {
                OProperty oProperty = p;
                return oProperty;
            }
            for (int i = 0; i < this.superClasses.size() && p == null; ++i) {
                p = this.superClasses.get(i).getProperty(propertyName);
            }
            OProperty oProperty = p;
            return oProperty;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        return this.addProperty(iPropertyName, iType, null, null, false);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        return this.addProperty(iPropertyName, iType, null, iLinkedClass, false);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass, boolean unsafe) {
        return this.addProperty(iPropertyName, iType, null, iLinkedClass, unsafe);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null, false);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType, boolean unsafe) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null, unsafe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean existsProperty(String propertyName) {
        this.acquireSchemaReadLock();
        try {
            propertyName = propertyName.toLowerCase();
            boolean result = this.properties.containsKey(propertyName);
            if (result) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                result = superClass.existsProperty(propertyName);
                if (!result) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropProperty(final String propertyName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        String lowerName = propertyName.toLowerCase();
        this.acquireSchemaWriteLock();
        try {
            if (!this.properties.containsKey(lowerName)) {
                throw new OSchemaException("Property '" + propertyName + "' not found in class " + this.name + "'");
            }
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                    database.command(new OCommandSQL("drop property " + this.name + ".`" + propertyName + "`")).execute(new Object[0]);
                } else {
                    database.command(new OCommandSQL("drop property " + this.name + '.' + propertyName)).execute(new Object[0]);
                }
            } else if (this.isDistributedCommand()) {
                OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<OProperty>(){

                    @Override
                    public OProperty call() throws Exception {
                        OClassImpl.this.dropPropertyInternal(propertyName);
                        return null;
                    }
                });
                String stm = this.getDatabase().getStorage().getConfiguration().isStrictSql() ? "drop property " + this.name + ".`" + propertyName + "`" : "drop property " + this.name + "." + propertyName;
                OCommandSQL commandSQL = new OCommandSQL(stm);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
            } else {
                OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<OProperty>(){

                    @Override
                    public OProperty call() throws Exception {
                        OClassImpl.this.dropPropertyInternal(propertyName);
                        return null;
                    }
                });
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public void fromStream() {
        this.subclasses = null;
        this.superClasses.clear();
        this.name = (String)this.document.field("name");
        this.shortName = this.document.containsField("shortName") ? (String)this.document.field("shortName") : null;
        this.description = this.document.containsField("description") ? (String)this.document.field("description") : null;
        this.defaultClusterId = (Integer)this.document.field("defaultClusterId");
        this.strictMode = this.document.containsField("strictMode") ? (Boolean)this.document.field("strictMode") : false;
        this.abstractClass = this.document.containsField("abstract") ? (Boolean)this.document.field("abstract") : false;
        this.overSize = this.document.field("overSize") != null ? ((Float)this.document.field("overSize")).floatValue() : 0.0f;
        Object cc = this.document.field("clusterIds");
        if (cc instanceof Collection) {
            Collection coll = (Collection)this.document.field("clusterIds");
            this.clusterIds = new int[coll.size()];
            int i = 0;
            for (Integer item : coll) {
                this.clusterIds[i++] = item;
            }
        } else {
            this.clusterIds = (int[])cc;
        }
        Arrays.sort(this.clusterIds);
        if (this.clusterIds.length == 1 && this.clusterIds[0] == -1) {
            this.setPolymorphicClusterIds(OCommonConst.EMPTY_INT_ARRAY);
        } else {
            this.setPolymorphicClusterIds(this.clusterIds);
        }
        HashMap<String, OPropertyImpl> newProperties = new HashMap<String, OPropertyImpl>();
        Collection storedProperties = (Collection)this.document.field("properties");
        if (storedProperties != null) {
            for (OIdentifiable id : storedProperties) {
                ODocument p = (ODocument)id.getRecord();
                OPropertyImpl prop = new OPropertyImpl(this, p);
                prop.fromStream();
                if (this.properties.containsKey(prop.getName())) {
                    prop = (OPropertyImpl)this.properties.get(prop.getName().toLowerCase());
                    prop.fromStream(p);
                }
                newProperties.put(prop.getName().toLowerCase(), prop);
            }
        }
        this.properties.clear();
        this.properties.putAll(newProperties);
        this.customFields = (Map)this.document.field("customFields", OType.EMBEDDEDMAP);
        this.clusterSelection = this.owner.getClusterSelectionFactory().getStrategy((String)this.document.field("clusterSelection"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.name);
            this.document.field("shortName", this.shortName);
            this.document.field("description", this.description);
            this.document.field("defaultClusterId", this.defaultClusterId);
            this.document.field("clusterIds", this.clusterIds);
            this.document.field("clusterSelection", this.clusterSelection.getName());
            this.document.field("overSize", Float.valueOf(this.overSize));
            this.document.field("strictMode", this.strictMode);
            this.document.field("abstract", this.abstractClass);
            LinkedHashSet<ODocument> props = new LinkedHashSet<ODocument>();
            for (OProperty p : this.properties.values()) {
                props.add(((OPropertyImpl)p).toStream());
            }
            this.document.field("properties", props, OType.EMBEDDEDSET);
            if (this.superClasses.isEmpty()) {
                this.document.field("superClass", null, OType.STRING);
                this.document.field("superClasses", null, OType.EMBEDDEDLIST);
            } else {
                this.document.field("superClass", this.superClasses.get(0).getName(), OType.STRING);
                ArrayList<String> superClassesNames = new ArrayList<String>();
                for (OClassImpl superClass : this.superClasses) {
                    superClassesNames.add(superClass.getName());
                }
                this.document.field("superClasses", superClassesNames, OType.EMBEDDEDLIST);
            }
            this.document.field("customFields", this.customFields != null && this.customFields.size() > 0 ? this.customFields : null, OType.EMBEDDEDMAP);
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    @Override
    public int getClusterForNewInstance(ODocument doc) {
        this.acquireSchemaReadLock();
        try {
            int n = this.clusterSelection.getCluster(this, doc);
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int getDefaultClusterId() {
        this.acquireSchemaReadLock();
        try {
            int n = this.defaultClusterId;
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void setDefaultClusterId(int defaultClusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.defaultClusterId = defaultClusterId;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    @Override
    public int[] getClusterIds() {
        this.acquireSchemaReadLock();
        try {
            int[] nArray = this.clusterIds;
            return nArray;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        this.acquireSchemaReadLock();
        try {
            int[] nArray = Arrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length);
            return nArray;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    private void setPolymorphicClusterIds(int[] iClusterIds) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int iClusterId : iClusterIds) {
            set.add(iClusterId);
        }
        this.polymorphicClusterIds = new int[set.size()];
        int i = 0;
        for (Integer clusterId : set) {
            this.polymorphicClusterIds[i] = clusterId;
            ++i;
        }
    }

    public void renameProperty(String iOldName, String iNewName) {
        OProperty p = this.properties.remove(iOldName.toLowerCase());
        if (p != null) {
            this.properties.put(iNewName.toLowerCase(), p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addClusterId(int clusterId) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` addcluster %d", this.name, clusterId);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` addcluster %d", this.name, clusterId);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.addClusterIdInternal(clusterId);
            } else {
                this.addClusterIdInternal(clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    public static OClass addClusters(OClass cls, int iClusters) {
        String clusterBase = cls.getName().toLowerCase() + "_";
        for (int i = 1; i < iClusters; ++i) {
            cls.addCluster(clusterBase + i);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass addCluster(String clusterNameOrId) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isAbstract()) {
            throw new OSchemaException("Impossible to associate a cluster to an abstract class class");
        }
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` addcluster `%s`", this.name, clusterNameOrId);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                int clusterId = this.owner.createClusterIfNeeded(clusterNameOrId);
                this.addClusterIdInternal(clusterId);
                String cmd = String.format("alter class `%s` addcluster `%s`", this.name, clusterNameOrId);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
            } else {
                int clusterId = this.owner.createClusterIfNeeded(clusterNameOrId);
                this.addClusterIdInternal(clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass truncateCluster(String clusterName) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_DELETE, (Object)this.name);
        this.acquireSchemaReadLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("truncate cluster %s", clusterName);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("truncate cluster %s", clusterName);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.truncateClusterInternal(clusterName, storage);
            } else {
                this.truncateClusterInternal(clusterName, storage);
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
        return this;
    }

    private void truncateClusterInternal(String clusterName, OStorage storage) {
        OCluster cluster = storage.getClusterByName(clusterName);
        if (cluster == null) {
            throw new ODatabaseException("Cluster with name " + clusterName + " does not exist");
        }
        try {
            storage.checkForClusterPermissions(clusterName);
            cluster.truncate();
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during truncate of cluster " + clusterName), e);
        }
        for (OIndex<?> index : this.getIndexes()) {
            index.rebuild();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass removeClusterId(int clusterId) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.clusterIds.length == 1 && clusterId == this.clusterIds[0]) {
            throw new ODatabaseException(" Impossible to remove the last cluster of class '" + this.getName() + "' drop the class instead");
        }
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` removecluster %d", this.name, clusterId);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` removecluster %d", this.name, clusterId);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.removeClusterIdInternal(clusterId);
            } else {
                this.removeClusterIdInternal(clusterId);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public Collection<OClass> getSubclasses() {
        this.acquireSchemaReadLock();
        try {
            if (this.subclasses == null || this.subclasses.size() == 0) {
                List<OClass> list = Collections.emptyList();
                return list;
            }
            Collection<OClass> collection = Collections.unmodifiableCollection(this.subclasses);
            return collection;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<OClass> getAllSubclasses() {
        this.acquireSchemaReadLock();
        try {
            HashSet<OClass> set = new HashSet<OClass>();
            if (this.subclasses != null) {
                set.addAll(this.subclasses);
                for (OClass c : this.subclasses) {
                    set.addAll(c.getAllSubclasses());
                }
            }
            HashSet<OClass> hashSet = set;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Collection<OClass> getBaseClasses() {
        return this.getSubclasses();
    }

    @Override
    public Collection<OClass> getAllBaseClasses() {
        return this.getAllSubclasses();
    }

    @Override
    public Collection<OClass> getAllSuperClasses() {
        HashSet<OClass> ret = new HashSet<OClass>();
        this.getAllSuperClasses(ret);
        return ret;
    }

    private void getAllSuperClasses(Set<OClass> set) {
        set.addAll(this.superClasses);
        for (OClassImpl superClass : this.superClasses) {
            superClass.getAllSuperClasses(set);
        }
    }

    OClass removeBaseClassInternal(OClass baseClass) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.subclasses == null) {
                OClassImpl oClassImpl = this;
                return oClassImpl;
            }
            if (this.subclasses.remove(baseClass)) {
                this.removePolymorphicClusterIds((OClassImpl)baseClass);
            }
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getOverSize() {
        this.acquireSchemaReadLock();
        try {
            if (this.overSize > 0.0f) {
                float f = this.overSize;
                return f;
            }
            float maxOverSize = 0.0f;
            for (OClassImpl superClass : this.superClasses) {
                float thisOverSize = superClass.getOverSize();
                if (!(thisOverSize > maxOverSize)) continue;
                maxOverSize = thisOverSize;
            }
            float f = maxOverSize;
            return f;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setOverSize(float overSize) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` oversize %s", this.name, new Float(overSize).toString());
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` oversize %s", this.name, new Float(overSize).toString());
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setOverSizeInternal(overSize);
            } else {
                this.setOverSizeInternal(overSize);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public float getClassOverSize() {
        this.acquireSchemaReadLock();
        try {
            float f = this.overSize;
            return f;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isAbstract() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.abstractClass;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setAbstract(boolean isAbstract) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` abstract %s", this.name, isAbstract);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` abstract %s", this.name, isAbstract);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setAbstractInternal(isAbstract);
            } else {
                this.setAbstractInternal(isAbstract);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public boolean isStrictMode() {
        this.acquireSchemaReadLock();
        try {
            boolean bl = this.strictMode;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OClass setStrictMode(boolean isStrict) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` strictmode %s", this.name, isStrict);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` strictmode %s", this.name, isStrict);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setStrictModeInternal(isStrict);
            } else {
                this.setStrictModeInternal(isStrict);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    @Override
    public String toString() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        this.acquireSchemaReadLock();
        try {
            if (this == obj) {
                boolean bl = true;
                return bl;
            }
            if (obj == null) {
                boolean bl = false;
                return bl;
            }
            if (!OClass.class.isAssignableFrom(obj.getClass())) {
                boolean bl = false;
                return bl;
            }
            OClass other = (OClass)obj;
            if (this.name == null) {
                if (other.getName() != null) {
                    boolean bl = false;
                    return bl;
                }
            } else if (!this.name.equals(other.getName())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int hashCode() {
        int sh = this.hashCode;
        if (sh != 0) {
            return sh;
        }
        this.acquireSchemaReadLock();
        try {
            sh = this.hashCode;
            if (sh != 0) {
                int n = sh;
                return n;
            }
            this.calculateHashCode();
            int n = this.hashCode;
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public int compareTo(OClass o) {
        this.acquireSchemaReadLock();
        try {
            int n = this.name.compareTo(o.getName());
            return n;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public long count() {
        return this.count(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(boolean isPolymorphic) {
        this.acquireSchemaReadLock();
        try {
            if (isPolymorphic) {
                long l = this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.polymorphicClusterIds));
                return l;
            }
            long l = this.getDatabase().countClusterElements(OClassImpl.readableClusters(this.getDatabase(), this.clusterIds));
            return l;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void truncate() throws IOException {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_UPDATE, new Object[0]);
        if (this.isSubClassOf("ORestricted")) {
            throw new OSecurityException("Class '" + this.getName() + "' cannot be truncated because has record level security enabled (extends '" + "ORestricted" + "')");
        }
        OStorage storage = this.getDatabase().getStorage();
        this.acquireSchemaReadLock();
        try {
            void var4_7;
            Object object = this.clusterIds;
            int n = ((int[])object).length;
            boolean bl = false;
            while (var4_7 < n) {
                int id = object[var4_7];
                OCluster cl = storage.getClusterById(id);
                storage.checkForClusterPermissions(cl.getName());
                cl.truncate();
                ++var4_7;
            }
            object = this.getClassIndexes().iterator();
            while (object.hasNext()) {
                OIndex index = (OIndex)object.next();
                index.clear();
            }
            HashSet superclassIndexes = new HashSet();
            superclassIndexes.addAll(this.getIndexes());
            superclassIndexes.removeAll(this.getClassIndexes());
            for (OIndex oIndex : superclassIndexes) {
                oIndex.rebuild();
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubClassOf(String iClassName) {
        this.acquireSchemaReadLock();
        try {
            if (iClassName == null) {
                boolean bl = false;
                return bl;
            }
            if (iClassName.equalsIgnoreCase(this.getName()) || iClassName.equalsIgnoreCase(this.getShortName())) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                if (!superClass.isSubClassOf(iClassName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSubClassOf(OClass clazz) {
        this.acquireSchemaReadLock();
        try {
            if (clazz == null) {
                boolean bl = false;
                return bl;
            }
            if (this.equals(clazz)) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                if (!superClass.isSubClassOf(clazz)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public boolean isSuperClassOf(OClass clazz) {
        return clazz != null && clazz.isSubClassOf(this);
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case SUPERCLASSES: {
                return this.getSuperClasses();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
            case STRICTMODE: {
                return this.isStrictMode();
            }
            case ABSTRACT: {
                return this.isAbstract();
            }
            case CLUSTERSELECTION: {
                return this.getClusterSelection();
            }
            case CUSTOM: {
                return this.getCustomInternal();
            }
            case DESCRIPTION: {
                return this.getDescription();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        boolean isNull = stringValue == null || stringValue.equalsIgnoreCase("NULL");
        switch (attribute) {
            case NAME: {
                this.setName(OClassImpl.decodeClassName(stringValue));
                break;
            }
            case SHORTNAME: {
                this.setShortName(OClassImpl.decodeClassName(stringValue));
                break;
            }
            case SUPERCLASS: {
                if (stringValue == null) {
                    throw new IllegalArgumentException("Superclass is null");
                }
                if (stringValue.startsWith("+")) {
                    this.addSuperClass(this.getDatabase().getMetadata().getSchema().getClass(OClassImpl.decodeClassName(stringValue.substring(1))));
                    break;
                }
                if (stringValue.startsWith("-")) {
                    this.removeSuperClass(this.getDatabase().getMetadata().getSchema().getClass(OClassImpl.decodeClassName(stringValue.substring(1))));
                    break;
                }
                this.setSuperClass(this.getDatabase().getMetadata().getSchema().getClass(OClassImpl.decodeClassName(stringValue)));
                break;
            }
            case SUPERCLASSES: {
                this.setSuperClassesByNames(stringValue != null ? Arrays.asList(stringValue.split(",\\s*")) : null);
                break;
            }
            case OVERSIZE: {
                this.setOverSize(Float.parseFloat(stringValue));
                break;
            }
            case STRICTMODE: {
                this.setStrictMode(Boolean.parseBoolean(stringValue));
                break;
            }
            case ABSTRACT: {
                this.setAbstract(Boolean.parseBoolean(stringValue));
                break;
            }
            case ADDCLUSTER: {
                this.addCluster(stringValue);
                break;
            }
            case REMOVECLUSTER: {
                int clId = this.owner.getClusterId(stringValue);
                if (clId == -1) {
                    throw new IllegalArgumentException("Cluster id '" + stringValue + "' cannot be removed");
                }
                this.removeClusterId(clId);
                break;
            }
            case CLUSTERSELECTION: {
                this.setClusterSelection(stringValue);
                break;
            }
            case CUSTOM: {
                int indx;
                int n = indx = stringValue != null ? stringValue.indexOf(61) : -1;
                if (indx < 0) {
                    if (isNull || "clear".equalsIgnoreCase(stringValue)) {
                        this.clearCustom();
                        break;
                    }
                    throw new IllegalArgumentException("Syntax error: expected <name> = <value> or clear, instead found: " + iValue);
                }
                String customName = stringValue.substring(0, indx).trim();
                String customValue = stringValue.substring(indx + 1).trim();
                if (this.isQuoted(customValue)) {
                    customValue = this.removeQuotes(customValue);
                }
                if (customValue.isEmpty()) {
                    this.removeCustom(customName);
                    break;
                }
                this.setCustom(customName, customValue);
                break;
            }
            case DESCRIPTION: {
                this.setDescription(stringValue);
                break;
            }
            case ENCRYPTION: {
                this.setEncryption(stringValue);
            }
        }
        return this;
    }

    private String removeQuotes(String s) {
        s = s.trim();
        StringBuilder result = new StringBuilder();
        boolean escaping = false;
        for (int i = 1; i < s.length() - 1; ++i) {
            char c = s.charAt(i);
            if (escaping) {
                result.append(c);
                escaping = false;
                continue;
            }
            if (c == '\\') {
                escaping = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean isQuoted(String s) {
        if ((s = s.trim()).startsWith("\"") && s.endsWith("\"")) {
            return true;
        }
        if (s.startsWith("'") && s.endsWith("'")) {
            return true;
        }
        return s.startsWith("`") && s.endsWith("`");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClassImpl setEncryption(String iValue) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (storage instanceof OStorageProxy) {
                String cmd = String.format("alter class `%s` encryption %s", this.name, iValue);
                database.command(new OCommandSQL(cmd)).execute(new Object[0]);
            } else if (this.isDistributedCommand()) {
                String cmd = String.format("alter class `%s` encryption %s", this.name, iValue);
                OCommandSQL commandSQL = new OCommandSQL(cmd);
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                this.setEncryptionInternal(iValue);
            } else {
                this.setEncryptionInternal(iValue);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    protected void setEncryptionInternal(String iValue) {
        for (int cl : this.getClusterIds()) {
            OCluster c = this.getDatabase().getStorage().getClusterById(cl);
            if (c == null) continue;
            try {
                c.set(OCluster.ATTRIBUTES.ENCRYPTION, iValue);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPropertyImpl addPropertyInternal(String name, OType type, OType linkedType, OClass linkedClass, boolean unsafe) {
        OPropertyImpl prop;
        if (name == null || name.length() == 0) {
            throw new OSchemaException("Found property name null");
        }
        Character wrongCharacter = OSchemaShared.checkFieldNameIfValid(name);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid property name '" + name + "'. Character '" + wrongCharacter + "' cannot be used");
        }
        if (!unsafe) {
            this.checkPersistentPropertyType(this.getDatabase(), name, type);
        }
        String lowerName = name.toLowerCase();
        if (linkedType != null) {
            OPropertyImpl.checkLinkTypeSupport(type);
        }
        if (linkedClass != null) {
            OPropertyImpl.checkSupportLinkedClass(type);
        }
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.properties.containsKey(lowerName)) {
                throw new OSchemaException("Class '" + this.name + "' already has property '" + name + "'");
            }
            OGlobalProperty global = this.owner.findOrCreateGlobalProperty(name, type);
            prop = new OPropertyImpl(this, global);
            this.properties.put(lowerName, prop);
            if (linkedType != null) {
                prop.setLinkedTypeInternal(linkedType);
            } else if (linkedClass != null) {
                prop.setLinkedClassInternal(linkedClass);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        if (prop != null && !unsafe) {
            this.fireDatabaseMigration(this.getDatabase(), name, type);
        }
        return prop;
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, String ... fields) {
        return this.createIndex(iName, iType.name(), fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, String ... fields) {
        return this.createIndex(iName, iType, (OProgressListener)null, (ODocument)null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, OProgressListener iProgressListener, String ... fields) {
        return this.createIndex(iName, iType.name(), iProgressListener, null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OProgressListener iProgressListener, ODocument metadata, String ... fields) {
        return this.createIndex(iName, iType, iProgressListener, metadata, (String)null, fields);
    }

    @Override
    public OIndex<?> createIndex(String name, String type, OProgressListener progressListener, ODocument metadata, String algorithm, String ... fields) {
        if (type == null) {
            throw new IllegalArgumentException("Index type is null");
        }
        type = type.toUpperCase();
        if (fields.length == 0) {
            throw new OIndexException("List of fields to index cannot be empty.");
        }
        String localName = this.name;
        int[] localPolymorphicClusterIds = this.polymorphicClusterIds;
        for (String fieldToIndex : fields) {
            String fieldName = OClassImpl.decodeClassName(OIndexDefinitionFactory.extractFieldName(fieldToIndex));
            if (fieldName.equals("@rid") || this.existsProperty(fieldName)) continue;
            throw new OIndexException("Index with name '" + name + "' cannot be created on class '" + localName + "' because the field '" + fieldName + "' is absent in class definition");
        }
        OIndexDefinition indexDefinition = OIndexDefinitionFactory.createIndexDefinition(this, Arrays.asList(fields), this.extractFieldTypes(fields), null, type, algorithm);
        return this.getDatabase().getMetadata().getIndexManager().createIndex(name, type, indexDefinition, localPolymorphicClusterIds, progressListener, metadata, algorithm);
    }

    @Override
    public boolean areIndexed(String ... fields) {
        return this.areIndexed(Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean areIndexed(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        this.acquireSchemaReadLock();
        try {
            boolean currentClassResult = indexManager.areIndexed(this.name, fields);
            if (currentClassResult) {
                boolean bl = true;
                return bl;
            }
            for (OClassImpl superClass : this.superClasses) {
                if (!superClass.areIndexed(fields)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(String ... fields) {
        return this.getInvolvedIndexes(Arrays.asList(fields));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getInvolvedIndexes(Collection<String> fields) {
        this.acquireSchemaReadLock();
        try {
            HashSet result = new HashSet(this.getClassInvolvedIndexes(fields));
            for (OClassImpl superClass : this.superClasses) {
                result.addAll(superClass.getInvolvedIndexes(fields));
            }
            HashSet<OIndex<?>> hashSet = result;
            return hashSet;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        this.acquireSchemaReadLock();
        try {
            Set<OIndex<?>> set = indexManager.getClassInvolvedIndexes(this.name, fields);
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String ... fields) {
        return this.getClassInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public OIndex<?> getClassIndex(String name) {
        this.acquireSchemaReadLock();
        try {
            OIndex<?> oIndex = this.getDatabase().getMetadata().getIndexManager().getClassIndex(this.name, name);
            return oIndex;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getClassIndexes() {
        this.acquireSchemaReadLock();
        try {
            OIndexManagerProxy idxManager = this.getDatabase().getMetadata().getIndexManager();
            if (idxManager == null) {
                HashSet hashSet = new HashSet();
                return hashSet;
            }
            Set<OIndex<?>> set = idxManager.getClassIndexes(this.name);
            return set;
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public void getClassIndexes(Collection<OIndex<?>> indexes) {
        this.acquireSchemaReadLock();
        try {
            OIndexManagerProxy idxManager = this.getDatabase().getMetadata().getIndexManager();
            if (idxManager == null) {
                return;
            }
            idxManager.getClassIndexes(this.name, indexes);
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public OIndex<?> getAutoShardingIndex() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        return db != null ? db.getMetadata().getIndexManager().getClassAutoShardingIndex(this.name) : null;
    }

    @Override
    public boolean isEdgeType() {
        return this.isSubClassOf("E");
    }

    @Override
    public boolean isVertexType() {
        return this.isSubClassOf("V");
    }

    public void onPostIndexManagement() {
        OIndex<?> autoShardingIndex = this.getAutoShardingIndex();
        if (autoShardingIndex != null) {
            if (!this.getDatabase().getStorage().isRemote()) {
                this.acquireSchemaWriteLock();
                try {
                    this.clusterSelection = new OAutoShardingClusterSelectionStrategy(this, autoShardingIndex);
                }
                finally {
                    this.releaseSchemaWriteLock();
                }
            }
        } else if (this.clusterSelection instanceof OAutoShardingClusterSelectionStrategy) {
            this.acquireSchemaWriteLock();
            try {
                this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstanceOfDefaultClass();
            }
            finally {
                this.releaseSchemaWriteLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getIndexes(Collection<OIndex<?>> indexes) {
        this.acquireSchemaReadLock();
        try {
            this.getClassIndexes(indexes);
            for (OClass oClass : this.superClasses) {
                oClass.getIndexes(indexes);
            }
        }
        finally {
            this.releaseSchemaReadLock();
        }
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        HashSet indexes = new HashSet();
        this.getIndexes(indexes);
        return indexes;
    }

    public void acquireSchemaReadLock() {
        this.owner.acquireSchemaReadLock();
    }

    public void releaseSchemaReadLock() {
        this.owner.releaseSchemaReadLock();
    }

    public void acquireSchemaWriteLock() {
        this.owner.acquireSchemaWriteLock();
    }

    public void releaseSchemaWriteLock() {
        this.releaseSchemaWriteLock(true);
    }

    public void releaseSchemaWriteLock(boolean iSave) {
        this.calculateHashCode();
        this.owner.releaseSchemaWriteLock(iSave);
    }

    public void checkEmbedded() {
        this.owner.checkEmbedded(this.getDatabase().getStorage().getUnderlying().getUnderlying());
    }

    public void setClusterSelectionInternal(String clusterSelection) {
        if (this.clusterSelection.getName().equals(clusterSelection)) {
            return;
        }
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.clusterSelection = (OClusterSelectionStrategy)this.owner.getClusterSelectionFactory().newInstance(clusterSelection);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    public void setClusterSelectionInternal(OClusterSelectionStrategy iClusterSelection) {
        if (this.clusterSelection.getClass().equals(iClusterSelection.getClass())) {
            return;
        }
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.clusterSelection = iClusterSelection;
        }
        finally {
            this.releaseSchemaWriteLock(false);
        }
    }

    public void fireDatabaseMigration(final ODatabaseDocument database, final String propertyName, final OType type) {
        boolean strictSQL = ((ODatabaseInternal)((Object)database)).getStorage().getConfiguration().isStrictSql();
        database.query(new OSQLAsynchQuery("select from " + this.getEscapedName(this.name, strictSQL) + " where " + this.getEscapedName(propertyName, strictSQL) + ".type() <> \"" + type.name() + "\"", new OCommandResultListener(){

            @Override
            public boolean result(Object iRecord) {
                ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
                record.field(propertyName, record.field(propertyName), type);
                database.save(record);
                return true;
            }

            @Override
            public void end() {
            }

            @Override
            public Object getResult() {
                return null;
            }
        }), new Object[0]);
    }

    public void firePropertyNameMigration(final ODatabaseDocument database, final String propertyName, final String newPropertyName, final OType type) {
        boolean strictSQL = ((ODatabaseInternal)((Object)database)).getStorage().getConfiguration().isStrictSql();
        database.query(new OSQLAsynchQuery("select from " + this.getEscapedName(this.name, strictSQL) + " where " + this.getEscapedName(propertyName, strictSQL) + " is not null ", new OCommandResultListener(){

            @Override
            public boolean result(Object iRecord) {
                ODocument record = (ODocument)((OIdentifiable)iRecord).getRecord();
                record.setFieldType(propertyName, type);
                record.field(newPropertyName, record.field(propertyName), type);
                database.save(record);
                return true;
            }

            @Override
            public void end() {
            }

            @Override
            public Object getResult() {
                return null;
            }
        }), new Object[0]);
    }

    public void checkPersistentPropertyType(ODatabaseInternal<ORecord> database, String propertyName, OType type) {
        List res;
        boolean strictSQL = database.getStorage().getConfiguration().isStrictSql();
        StringBuilder builder = new StringBuilder(256);
        builder.append("select count(*) from ");
        builder.append(this.getEscapedName(this.name, strictSQL));
        builder.append(" where ");
        builder.append(this.getEscapedName(propertyName, strictSQL));
        builder.append(".type() not in [");
        Iterator<OType> cur = type.getCastable().iterator();
        while (cur.hasNext()) {
            builder.append('\"').append(cur.next().name()).append('\"');
            if (!cur.hasNext()) continue;
            builder.append(",");
        }
        builder.append("] and ").append(this.getEscapedName(propertyName, strictSQL)).append(" is not null ");
        if (type.isMultiValue()) {
            builder.append(" and ").append(this.getEscapedName(propertyName, strictSQL)).append(".size() <> 0 limit 1");
        }
        if ((Long)((ODocument)(res = (List)database.command(new OCommandSQL(builder.toString())).execute(new Object[0])).get(0)).field("count") > 0L) {
            throw new OSchemaException("The database contains some schema-less data in the property '" + this.name + "." + propertyName + "' that is not compatible with the type " + (Object)((Object)type) + ". Fix those records and change the schema again");
        }
    }

    protected String getEscapedName(String iName, boolean iStrictSQL) {
        if (iStrictSQL) {
            return "`" + iName + "`";
        }
        return iName;
    }

    public OSchemaShared getOwner() {
        return this.owner;
    }

    private void calculateHashCode() {
        int result = super.hashCode();
        this.hashCode = result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
    }

    private void setOverSizeInternal(float overSize) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.overSize = overSize;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setCustomInternal(String name, String value) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            if (this.customFields == null) {
                this.customFields = new HashMap<String, String>();
            }
            if (value == null || "null".equalsIgnoreCase(value)) {
                this.customFields.remove(name);
            } else {
                this.customFields.put(name, value);
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void clearCustomInternal() {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.customFields = null;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setNameInternal(String name) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            String oldName = this.name;
            this.owner.changeClassName(this.name, name, this);
            this.name = name;
            ODatabaseDocumentInternal database = this.getDatabase();
            OStorage storage = database.getStorage();
            if (!database.getStorageVersions().classesAreDetectedByClusterId()) {
                for (int clusterId : this.clusterIds) {
                    long[] range = storage.getClusterDataRange(clusterId);
                    OPhysicalPosition[] positions = storage.ceilingPhysicalPositions(clusterId, new OPhysicalPosition(range[0]));
                    do {
                        for (OPhysicalPosition position : positions) {
                            String persName;
                            ORecordSerializerSchemaAware2CSV serializer;
                            ORecordId identity = new ORecordId(clusterId, position.clusterPosition);
                            ORawBuffer record = storage.readRecord(identity, null, true, false, null).getResult();
                            if (record.recordType == 100 && (serializer = (ORecordSerializerSchemaAware2CSV)ORecordSerializerFactory.instance().getFormat("ORecordDocument2csv")).getClassName(persName = new String(record.buffer, "UTF-8")).equalsIgnoreCase(name)) {
                                ODocument document = new ODocument();
                                document.setLazyLoad(false);
                                document.fromStream(record.buffer);
                                ORecordInternal.setVersion(document, record.version);
                                ORecordInternal.setIdentity(document, identity);
                                document.setClassName(name);
                                document.setDirty();
                                document.save();
                            }
                            if (positions.length <= 0) continue;
                            positions = storage.higherPhysicalPositions(clusterId, positions[positions.length - 1]);
                        }
                    } while (positions.length > 0);
                }
            }
            this.renameCluster(oldName, this.name);
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSchemaException("Error reading schema"), e);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void renameCluster(String oldName, String newName) {
        oldName = oldName.toLowerCase();
        newName = newName.toLowerCase();
        ODatabaseDocumentInternal database = this.getDatabase();
        OStorage storage = database.getStorage();
        if (storage.getClusterIdByName(newName) != -1) {
            return;
        }
        int clusterId = storage.getClusterIdByName(oldName);
        if (clusterId == -1) {
            return;
        }
        if (!this.hasClusterId(clusterId)) {
            return;
        }
        database.command(new OCommandSQL("alter cluster `" + oldName + "` name `" + newName + "`")).execute(new Object[0]);
    }

    private void setShortNameInternal(String iShortName) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            String oldName = null;
            if (this.shortName != null) {
                oldName = this.shortName;
            }
            this.owner.changeClassName(oldName, iShortName, this);
            this.shortName = iShortName;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setDescriptionInternal(String iDescription) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.description = iDescription;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void dropPropertyInternal(String iPropertyName) {
        if (this.getDatabase().getTransaction().isActive()) {
            throw new IllegalStateException("Cannot drop a property inside a transaction");
        }
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_DELETE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            OProperty prop = this.properties.remove(iPropertyName.toLowerCase());
            if (prop == null) {
                throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
            }
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass addClusterIdInternal(int clusterId) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.owner.checkClusterCanBeAdded(clusterId, this);
            for (int currId : this.clusterIds) {
                if (currId != clusterId) continue;
                OClassImpl oClassImpl = this;
                return oClassImpl;
            }
            this.clusterIds = OArrays.copyOf(this.clusterIds, this.clusterIds.length + 1);
            this.clusterIds[this.clusterIds.length - 1] = clusterId;
            Arrays.sort(this.clusterIds);
            this.addPolymorphicClusterId(clusterId);
            if (this.defaultClusterId == -1) {
                this.defaultClusterId = clusterId;
            }
            this.owner.addClusterForClass(clusterId, this);
            OClassImpl oClassImpl = this;
            return oClassImpl;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void addPolymorphicClusterId(int clusterId) {
        if (Arrays.binarySearch(this.polymorphicClusterIds, clusterId) >= 0) {
            return;
        }
        this.polymorphicClusterIds = OArrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length + 1);
        this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = clusterId;
        Arrays.sort(this.polymorphicClusterIds);
        this.addClusterIdToIndexes(clusterId);
        for (OClassImpl superClass : this.superClasses) {
            superClass.addPolymorphicClusterId(clusterId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OClass removeClusterIdInternal(int clusterToRemove) {
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            boolean found = false;
            for (int clusterId : this.clusterIds) {
                if (clusterId != clusterToRemove) continue;
                found = true;
                break;
            }
            if (found) {
                int[] newClusterIds = new int[this.clusterIds.length - 1];
                int k = 0;
                for (int i = 0; i < this.clusterIds.length; ++i) {
                    if (this.clusterIds[i] == clusterToRemove) continue;
                    newClusterIds[k] = this.clusterIds[i];
                    ++k;
                }
                this.clusterIds = newClusterIds;
                this.removePolymorphicClusterId(clusterToRemove);
            }
            if (this.defaultClusterId == clusterToRemove) {
                this.defaultClusterId = this.clusterIds.length >= 1 ? this.clusterIds[0] : -1;
            }
            this.owner.removeClusterForClass(clusterToRemove, this);
        }
        finally {
            this.releaseSchemaWriteLock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAbstractInternal(boolean isAbstract) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            if (isAbstract) {
                if (this.defaultClusterId != -1) {
                    if (this.count() > 0L) {
                        throw new IllegalStateException("Cannot set the class as abstract because contains records.");
                    }
                    this.tryDropCluster(this.defaultClusterId);
                    for (int clusterId : this.getClusterIds()) {
                        this.tryDropCluster(clusterId);
                        this.removePolymorphicClusterId(clusterId);
                        this.owner.removeClusterForClass(clusterId, this);
                    }
                    this.setClusterIds(new int[]{-1});
                    this.defaultClusterId = -1;
                }
            } else {
                if (!this.abstractClass) {
                    return;
                }
                int clusterId = this.getDatabase().getClusterIdByName(this.name);
                if (clusterId == -1) {
                    clusterId = this.getDatabase().addCluster(this.name, new Object[0]);
                }
                this.clusterIds[0] = this.defaultClusterId = clusterId;
                this.polymorphicClusterIds = Arrays.copyOf(this.clusterIds, this.clusterIds.length);
                for (OClass clazz : this.getAllSubclasses()) {
                    if (clazz instanceof OClassImpl) {
                        this.addPolymorphicClusterIds((OClassImpl)clazz);
                        continue;
                    }
                    OLogManager.instance().warn((Object)this, "Warning: cannot set polymorphic cluster IDs for class " + this.name, new Object[0]);
                }
            }
            this.abstractClass = isAbstract;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void setStrictModeInternal(boolean iStrict) {
        this.getDatabase().checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        this.acquireSchemaWriteLock();
        try {
            this.checkEmbedded();
            this.strictMode = iStrict;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OProperty addProperty(final String propertyName, final OType type, final OType linkedType, final OClass linkedClass, final boolean unsafe) {
        if (type == null) {
            throw new OSchemaException("Property type not defined.");
        }
        if (propertyName == null || propertyName.length() == 0) {
            throw new OSchemaException("Property name is null or empty");
        }
        if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
            this.validatePropertyName(propertyName);
        }
        if (this.getDatabase().getTransaction().isActive()) {
            throw new OSchemaException("Cannot create property '" + propertyName + "' inside a transaction");
        }
        ODatabaseDocumentInternal database = this.getDatabase();
        database.checkSecurity(ORule.ResourceGeneric.SCHEMA, ORole.PERMISSION_UPDATE, new Object[0]);
        if (linkedType != null) {
            OPropertyImpl.checkLinkTypeSupport(type);
        }
        if (linkedClass != null) {
            OPropertyImpl.checkSupportLinkedClass(type);
        }
        this.acquireSchemaWriteLock();
        try {
            OStorage storage;
            StringBuilder cmd = new StringBuilder("create property ");
            if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                cmd.append('`');
            }
            cmd.append(this.name);
            if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                cmd.append('`');
            }
            cmd.append('.');
            if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                cmd.append('`');
            }
            cmd.append(propertyName);
            if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                cmd.append('`');
            }
            cmd.append(' ');
            cmd.append(type.name);
            if (linkedType != null) {
                cmd.append(' ');
                cmd.append(linkedType.name);
            } else if (linkedClass != null) {
                cmd.append(' ');
                if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                    cmd.append('`');
                }
                cmd.append(linkedClass.getName());
                if (this.getDatabase().getStorage().getConfiguration().isStrictSql()) {
                    cmd.append('`');
                }
            }
            if (unsafe) {
                cmd.append(" unsafe ");
            }
            if ((storage = database.getStorage()) instanceof OStorageProxy) {
                database.command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
                this.reload();
                OProperty oProperty = this.getProperty(propertyName);
                return oProperty;
            }
            if (this.isDistributedCommand()) {
                OProperty prop = (OProperty)OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<OProperty>(){

                    @Override
                    public OProperty call() throws Exception {
                        return OClassImpl.this.addPropertyInternal(propertyName, type, linkedType, linkedClass, unsafe);
                    }
                });
                OCommandSQL commandSQL = new OCommandSQL(cmd.toString());
                commandSQL.addExcludedNode(((OAutoshardedStorage)((Object)storage)).getNodeId());
                database.command(commandSQL).execute(new Object[0]);
                OProperty oProperty = prop;
                return oProperty;
            }
            OProperty oProperty = (OProperty)OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<OProperty>(){

                @Override
                public OProperty call() throws Exception {
                    return OClassImpl.this.addPropertyInternal(propertyName, type, linkedType, linkedClass, unsafe);
                }
            });
            return oProperty;
        }
        finally {
            this.releaseSchemaWriteLock();
        }
    }

    private void validatePropertyName(String propertyName) {
    }

    private int getClusterId(String stringValue) {
        int clId;
        if (!stringValue.isEmpty() && Character.isDigit(stringValue.charAt(0))) {
            try {
                clId = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                clId = this.getDatabase().getClusterIdByName(stringValue);
            }
        } else {
            clId = this.getDatabase().getClusterIdByName(stringValue);
        }
        return clId;
    }

    private void addClusterIdToIndexes(int iId) {
        if (this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
            String clusterName = this.getDatabase().getClusterNameById(iId);
            ArrayList<String> indexesToAdd = new ArrayList<String>();
            for (OIndex<?> index : this.getIndexes()) {
                indexesToAdd.add(index.getName());
            }
            OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
            for (String indexName : indexesToAdd) {
                indexManager.addClusterToIndex(clusterName, indexName);
            }
        }
    }

    private OClass addBaseClass(OClassImpl iBaseClass) {
        this.checkRecursion(iBaseClass);
        if (this.subclasses == null) {
            this.subclasses = new ArrayList<OClass>();
        }
        if (this.subclasses.contains(iBaseClass)) {
            return this;
        }
        this.subclasses.add(iBaseClass);
        this.addPolymorphicClusterIdsWithInheritance(iBaseClass);
        return this;
    }

    private void checkParametersConflict(OClass baseClass) {
        Collection<OProperty> baseClassProperties = baseClass.properties();
        for (OProperty property : baseClassProperties) {
            OProperty thisProperty = this.getProperty(property.getName());
            if (thisProperty == null || thisProperty.getType().equals((Object)property.getType())) continue;
            throw new OSchemaException("Cannot add base class '" + baseClass.getName() + "', because of property conflict: '" + thisProperty + "' vs '" + property + "'");
        }
    }

    protected static void checkParametersConflict(List<OClass> classes) {
        HashMap<String, OProperty> comulative = new HashMap<String, OProperty>();
        HashMap<String, OProperty> properties = new HashMap<String, OProperty>();
        for (OClass superClass : classes) {
            if (superClass == null) continue;
            OClassImpl impl = superClass instanceof OClassAbstractDelegate ? (OClassImpl)((OClassAbstractDelegate)superClass).delegate : (OClassImpl)superClass;
            impl.propertiesMap(properties, false);
            for (Map.Entry entry : properties.entrySet()) {
                String property;
                OProperty existingProperty;
                if (!comulative.containsKey(entry.getKey()) || (existingProperty = (OProperty)comulative.get(property = (String)entry.getKey())).getType().equals((Object)((OProperty)entry.getValue()).getType())) continue;
                throw new OSchemaException("Properties conflict detected: '" + existingProperty + "] vs [" + entry.getValue() + "]");
            }
            comulative.putAll(properties);
            properties.clear();
        }
    }

    private void checkRecursion(OClass baseClass) {
        if (this.isSubClassOf(baseClass)) {
            throw new OSchemaException("Cannot add base class '" + baseClass.getName() + "', because of recursion");
        }
    }

    private void removePolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int clusterId : iBaseClass.polymorphicClusterIds) {
            this.removePolymorphicClusterId(clusterId);
        }
    }

    private void removePolymorphicClusterId(int clusterId) {
        int index = Arrays.binarySearch(this.polymorphicClusterIds, clusterId);
        if (index < 0) {
            return;
        }
        if (index < this.polymorphicClusterIds.length - 1) {
            System.arraycopy(this.polymorphicClusterIds, index + 1, this.polymorphicClusterIds, index, this.polymorphicClusterIds.length - (index + 1));
        }
        this.polymorphicClusterIds = Arrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length - 1);
        this.removeClusterFromIndexes(clusterId);
        for (OClassImpl superClass : this.superClasses) {
            superClass.removePolymorphicClusterId(clusterId);
        }
    }

    private void removeClusterFromIndexes(int iId) {
        if (this.getDatabase().getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
            String clusterName = this.getDatabase().getClusterNameById(iId);
            ArrayList<String> indexesToRemove = new ArrayList<String>();
            for (OIndex<?> index : this.getIndexes()) {
                indexesToRemove.add(index.getName());
            }
            OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
            for (String indexName : indexesToRemove) {
                indexManager.removeClusterFromIndex(clusterName, indexName);
            }
        }
    }

    private void tryDropCluster(int defaultClusterId) {
        if (this.name.toLowerCase().equals(this.getDatabase().getClusterNameById(defaultClusterId)) && this.getDatabase().getClusterRecordSizeById(defaultClusterId) == 0L) {
            this.getDatabase().getStorage().dropCluster(defaultClusterId, true);
        }
    }

    private ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    private void addPolymorphicClusterIds(OClassImpl iBaseClass) {
        TreeSet<Integer> clusters = new TreeSet<Integer>();
        for (int clusterId : this.polymorphicClusterIds) {
            clusters.add(clusterId);
        }
        for (int clusterId : iBaseClass.polymorphicClusterIds) {
            if (!clusters.add(clusterId)) continue;
            try {
                this.addClusterIdToIndexes(clusterId);
            }
            catch (RuntimeException e) {
                OLogManager.instance().warn((Object)this, "Error adding clusterId '%d' to index of class '%s'", e, clusterId, this.getName());
                clusters.remove(clusterId);
            }
        }
        this.polymorphicClusterIds = new int[clusters.size()];
        int i = 0;
        for (Integer cluster : clusters) {
            this.polymorphicClusterIds[i] = cluster;
            ++i;
        }
    }

    private void addPolymorphicClusterIdsWithInheritance(OClassImpl iBaseClass) {
        this.addPolymorphicClusterIds(iBaseClass);
        for (OClassImpl superClass : this.superClasses) {
            superClass.addPolymorphicClusterIdsWithInheritance(iBaseClass);
        }
    }

    public List<OType> extractFieldTypes(String[] fieldNames) {
        ArrayList<OType> types = new ArrayList<OType>(fieldNames.length);
        for (String fieldName : fieldNames) {
            if (!fieldName.equals("@rid")) {
                types.add(this.getProperty(OClassImpl.decodeClassName(OIndexDefinitionFactory.extractFieldName(fieldName)).toLowerCase()).getType());
                continue;
            }
            types.add(OType.LINK);
        }
        return types;
    }

    private OClass setClusterIds(int[] iClusterIds) {
        this.clusterIds = iClusterIds;
        Arrays.sort(this.clusterIds);
        return this;
    }

    private boolean isDistributedCommand() {
        return this.getDatabase().getStorage() instanceof OAutoshardedStorage && !OScenarioThreadLocal.INSTANCE.isRunModeDistributed();
    }

    public static String decodeClassName(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).startsWith("`") && s.endsWith("`")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

