/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OTransactionRealAbstract
extends OTransactionAbstract {
    public static final ORecord DELETED_RECORD = new ORecordBytes();
    protected Map<ORID, ORID> updatedRids = new HashMap<ORID, ORID>();
    protected Map<ORID, ORecordOperation> allEntries = new LinkedHashMap<ORID, ORecordOperation>();
    protected Map<String, OTransactionIndexChanges> indexEntries = new LinkedHashMap<String, OTransactionIndexChanges>();
    protected Map<ORID, List<OTransactionRecordIndexOperation>> recordIndexOperations = new HashMap<ORID, List<OTransactionRecordIndexOperation>>();
    protected int id;
    protected int newObjectCounter = -2;
    protected Map<String, Object> userData = new HashMap<String, Object>();
    protected final Set<ODocument> changedDocuments = new HashSet<ODocument>();

    protected OTransactionRealAbstract(ODatabaseDocumentTx database, int id) {
        super(database);
        this.id = id;
    }

    @Override
    public boolean hasRecordCreation() {
        for (ORecordOperation op : this.allEntries.values()) {
            if (op.type != 3) continue;
            return true;
        }
        return false;
    }

    public void addChangedDocument(ODocument document) {
        if (this.getRecord(document.getIdentity()) == null) {
            this.changedDocuments.add(document);
        }
    }

    @Override
    public void close() {
        super.close();
        for (ORecordOperation recordOperation : this.getAllRecordEntries()) {
            ORecord record = recordOperation.getRecord();
            if (!(record instanceof ODocument)) continue;
            ODocument document = (ODocument)record;
            if (document.isDirty()) {
                document.undo();
            }
            this.changedDocuments.remove(document);
        }
        for (ODocument changedDocument : this.changedDocuments) {
            changedDocument.undo();
        }
        this.changedDocuments.clear();
        this.updatedRids.clear();
        this.allEntries.clear();
        this.indexEntries.clear();
        this.recordIndexOperations.clear();
        this.newObjectCounter = -2;
        this.status = OTransaction.TXSTATUS.INVALID;
        this.database.setDefaultTransactionMode();
        this.userData.clear();
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void clearRecordEntries() {
    }

    public void restore() {
    }

    @Override
    public int getEntryCount() {
        return this.allEntries.size();
    }

    public Collection<ORecordOperation> getCurrentRecordEntries() {
        return this.allEntries.values();
    }

    public Collection<ORecordOperation> getAllRecordEntries() {
        return this.allEntries.values();
    }

    @Override
    public ORecordOperation getRecordEntry(ORID rid) {
        return this.allEntries.get(this.translateRid(rid));
    }

    @Override
    public ORecord getRecord(ORID rid) {
        ORecordOperation e = this.getRecordEntry(rid);
        if (e != null) {
            if (e.type == 2) {
                return DELETED_RECORD;
            }
            return e.getRecord();
        }
        return null;
    }

    @Override
    public List<ORecordOperation> getNewRecordEntriesByClass(OClass iClass, boolean iPolymorphic) {
        ArrayList<ORecordOperation> result = new ArrayList<ORecordOperation>();
        if (iClass == null) {
            for (ORecordOperation entry : this.allEntries.values()) {
                if (entry.type != 3) continue;
                result.add(entry);
            }
        } else {
            for (ORecordOperation entry : this.allEntries.values()) {
                if (entry.type != 3 || entry.getRecord() == null || !(entry.getRecord() instanceof ODocument)) continue;
                if (iPolymorphic) {
                    if (!iClass.isSuperClassOf(((ODocument)entry.getRecord()).getSchemaClass())) continue;
                    result.add(entry);
                    continue;
                }
                if (!iClass.getName().equals(((ODocument)entry.getRecord()).getClassName())) continue;
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public List<ORecordOperation> getNewRecordEntriesByClusterIds(int[] iIds) {
        ArrayList<ORecordOperation> result = new ArrayList<ORecordOperation>();
        if (iIds == null) {
            for (ORecordOperation entry : this.allEntries.values()) {
                if (entry.type != 3) continue;
                result.add(entry);
            }
        } else {
            block1: for (ORecordOperation entry : this.allEntries.values()) {
                for (int id : iIds) {
                    if (entry.getRecord() == null || entry.getRecord().getIdentity().getClusterId() != id || entry.type != 3) continue;
                    result.add(entry);
                    continue block1;
                }
            }
        }
        return result;
    }

    @Override
    public void clearIndexEntries() {
        this.indexEntries.clear();
        this.recordIndexOperations.clear();
    }

    @Override
    public List<String> getInvolvedIndexes() {
        ArrayList<String> list = null;
        for (String indexName : this.indexEntries.keySet()) {
            if (list == null) {
                list = new ArrayList<String>();
            }
            list.add(indexName);
        }
        return list;
    }

    @Override
    public ODocument getIndexChanges() {
        ODocument result = new ODocument().setAllowChainedAccess(false).setTrackingChanges(false);
        for (Map.Entry<String, OTransactionIndexChanges> indexEntry : this.indexEntries.entrySet()) {
            ODocument indexDoc = new ODocument().setTrackingChanges(false);
            ODocumentInternal.addOwner(indexDoc, result);
            result.field(indexEntry.getKey(), indexDoc, OType.EMBEDDED);
            if (indexEntry.getValue().cleared) {
                indexDoc.field("clear", Boolean.TRUE);
            }
            ArrayList<ODocument> entries = new ArrayList<ODocument>();
            indexDoc.field("entries", entries, OType.EMBEDDEDLIST);
            for (OTransactionIndexChangesPerKey entry : indexEntry.getValue().changesPerKey.values()) {
                if (entry.clientTrackOnly) continue;
                entries.add(this.serializeIndexChangeEntry(entry, indexDoc));
            }
            indexDoc.field("nullEntries", this.serializeIndexChangeEntry(indexEntry.getValue().nullKeyChanges, indexDoc));
        }
        this.indexEntries.clear();
        return result;
    }

    public Map<String, OTransactionIndexChanges> getIndexEntries() {
        return this.indexEntries;
    }

    @Override
    public OTransactionIndexChanges getIndexChanges(String iIndexName) {
        return this.indexEntries.get(iIndexName);
    }

    @Override
    public void addIndexEntry(OIndex<?> delegate, String iIndexName, OTransactionIndexChanges.OPERATION iOperation, Object key, OIdentifiable iValue) {
        this.addIndexEntry(delegate, iIndexName, iOperation, key, iValue, false);
    }

    public void addIndexEntry(OIndex<?> delegate, String iIndexName, OTransactionIndexChanges.OPERATION iOperation, Object key, OIdentifiable iValue, boolean clientTrackOnly) {
        OTransactionIndexChanges indexEntry = this.indexEntries.get(iIndexName);
        if (indexEntry == null) {
            indexEntry = new OTransactionIndexChanges();
            this.indexEntries.put(iIndexName, indexEntry);
        }
        if (iOperation == OTransactionIndexChanges.OPERATION.CLEAR) {
            indexEntry.setCleared();
        } else {
            OTransactionIndexChangesPerKey changes = indexEntry.getChangesPerKey(key);
            changes.clientTrackOnly = clientTrackOnly;
            changes.add(iValue, iOperation);
            if (iValue == null) {
                return;
            }
            List<OTransactionRecordIndexOperation> transactionIndexOperations = this.recordIndexOperations.get(iValue.getIdentity());
            if (transactionIndexOperations == null) {
                transactionIndexOperations = new ArrayList<OTransactionRecordIndexOperation>();
                this.recordIndexOperations.put(iValue.getIdentity().copy(), transactionIndexOperations);
            }
            transactionIndexOperations.add(new OTransactionRecordIndexOperation(iIndexName, key, iOperation));
        }
    }

    @Override
    public void updateIdentityAfterCommit(ORID oldRid, ORID newRid) {
        if (oldRid.equals(newRid)) {
            return;
        }
        ArrayList<KeyChangesUpdateRecord> keyRecordsToReinsert = new ArrayList<KeyChangesUpdateRecord>();
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        for (Map.Entry<String, OTransactionIndexChanges> entry : this.indexEntries.entrySet()) {
            OIndex<?> index = indexManager.getIndex(entry.getKey());
            if (index == null) {
                throw new OTransactionException("Cannot find index '" + entry.getValue() + "' while committing transaction");
            }
            Dependency[] fieldRidDependencies = OTransactionRealAbstract.getIndexFieldRidDependencies(index);
            if (!OTransactionRealAbstract.isIndexMayDependOnRids(fieldRidDependencies)) continue;
            OTransactionIndexChanges indexChanges = entry.getValue();
            Iterator iterator = indexChanges.changesPerKey.values().iterator();
            while (iterator.hasNext()) {
                OTransactionIndexChangesPerKey keyChanges = (OTransactionIndexChangesPerKey)iterator.next();
                if (!OTransactionRealAbstract.isIndexKeyMayDependOnRid(keyChanges.key, oldRid, fieldRidDependencies)) continue;
                keyRecordsToReinsert.add(new KeyChangesUpdateRecord(keyChanges, indexChanges));
                iterator.remove();
            }
        }
        ORecordOperation rec = this.getRecordEntry(oldRid);
        if (rec != null) {
            this.updatedRids.put(newRid.copy(), oldRid.copy());
            if (!rec.getRecord().getIdentity().equals(newRid)) {
                ORecordInternal.onBeforeIdentityChanged(rec.getRecord());
                ORecordId recordId = (ORecordId)rec.getRecord().getIdentity();
                if (recordId == null) {
                    ORecordInternal.setIdentity(rec.getRecord(), new ORecordId(newRid));
                } else {
                    recordId.setClusterPosition(newRid.getClusterPosition());
                    recordId.setClusterId(newRid.getClusterId());
                }
                ORecordInternal.onAfterIdentityChanged(rec.getRecord());
            }
        }
        for (KeyChangesUpdateRecord record : keyRecordsToReinsert) {
            record.indexChanges.changesPerKey.put(record.keyChanges.key, record.keyChanges);
        }
        List<OTransactionRecordIndexOperation> transactionIndexOperations = this.recordIndexOperations.get(this.translateRid(oldRid));
        if (transactionIndexOperations != null) {
            for (OTransactionRecordIndexOperation indexOperation : transactionIndexOperations) {
                OTransactionIndexChangesPerKey keyChanges;
                OTransactionIndexChanges indexEntryChanges = this.indexEntries.get(indexOperation.index);
                if (indexEntryChanges == null || (keyChanges = (OTransactionIndexChangesPerKey)indexEntryChanges.changesPerKey.get(indexOperation.key)) == null) continue;
                this.updateChangesIdentity(oldRid, newRid, keyChanges);
            }
        }
    }

    protected void checkTransaction() {
        if (this.status == OTransaction.TXSTATUS.INVALID) {
            throw new OTransactionException("Invalid state of the transaction. The transaction must be begun.");
        }
    }

    protected ODocument serializeIndexChangeEntry(OTransactionIndexChangesPerKey entry, ODocument indexDoc) {
        ODocument keyContainer = new ODocument();
        keyContainer.setTrackingChanges(false);
        try {
            if (entry.key != null) {
                if (entry.key instanceof OCompositeKey) {
                    List<Object> keys = ((OCompositeKey)entry.key).getKeys();
                    keyContainer.field("key", keys, OType.EMBEDDEDLIST);
                    keyContainer.field("binary", false);
                } else if (!(entry.key instanceof ORecordElement) && entry.key instanceof OSerializableStream) {
                    keyContainer.field("key", OStreamSerializerAnyStreamable.INSTANCE.toStream(entry.key), OType.BINARY);
                    keyContainer.field("binary", true);
                } else {
                    keyContainer.field("key", entry.key);
                    keyContainer.field("binary", false);
                }
            } else {
                keyContainer = null;
            }
        }
        catch (IOException ioe) {
            throw OException.wrapException(new OTransactionException("Error during index changes serialization. "), ioe);
        }
        ArrayList<ODocument> operations = new ArrayList<ODocument>();
        if (entry.entries != null && !entry.entries.isEmpty()) {
            for (OTransactionIndexChangesPerKey.OTransactionIndexEntry e : entry.entries) {
                ODocument changeDoc = new ODocument().setAllowChainedAccess(false);
                ODocumentInternal.addOwner(changeDoc, indexDoc);
                changeDoc.field("o", e.operation.ordinal());
                if (e.value instanceof ORecord && e.value.getIdentity().isNew()) {
                    ORecord saved = this.getRecord(e.value.getIdentity());
                    if (saved != null) {
                        e.value = saved;
                    } else {
                        ((ORecord)e.value).save();
                    }
                }
                changeDoc.field("v", e.value != null ? e.value.getIdentity() : null);
                operations.add(changeDoc);
            }
        }
        ODocument res = new ODocument();
        res.setTrackingChanges(false);
        ODocumentInternal.addOwner(res, indexDoc);
        return res.setAllowChainedAccess(false).field("k", keyContainer, OType.EMBEDDED).field("ops", operations, OType.EMBEDDEDLIST);
    }

    private void updateChangesIdentity(ORID oldRid, ORID newRid, OTransactionIndexChangesPerKey changesPerKey) {
        if (changesPerKey == null) {
            return;
        }
        for (OTransactionIndexChangesPerKey.OTransactionIndexEntry indexEntry : changesPerKey.entries) {
            if (!indexEntry.value.getIdentity().equals(oldRid)) continue;
            indexEntry.value = newRid;
        }
    }

    @Override
    public void setCustomData(String iName, Object iValue) {
        this.userData.put(iName, iValue);
    }

    @Override
    public Object getCustomData(String iName) {
        return this.userData.get(iName);
    }

    private ORID translateRid(ORID rid) {
        ORID translatedRid;
        while ((translatedRid = this.updatedRids.get(rid)) != null) {
            rid = translatedRid;
        }
        return rid;
    }

    private static Dependency[] getIndexFieldRidDependencies(OIndex<?> index) {
        OIndexDefinition definition = index.getDefinition();
        if (definition == null) {
            return null;
        }
        OType[] types = definition.getTypes();
        Dependency[] dependencies = new Dependency[types.length];
        for (int i = 0; i < types.length; ++i) {
            dependencies[i] = OTransactionRealAbstract.getTypeRidDependency(types[i]);
        }
        return dependencies;
    }

    private static boolean isIndexMayDependOnRids(Dependency[] fieldDependencies) {
        if (fieldDependencies == null) {
            return true;
        }
        for (Dependency dependency : fieldDependencies) {
            switch (dependency) {
                case Unknown: {
                    return true;
                }
                case Yes: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isIndexKeyMayDependOnRid(Object key, ORID rid, Dependency[] keyDependencies) {
        if (key instanceof OCompositeKey) {
            List<Object> subKeys = ((OCompositeKey)key).getKeys();
            for (int i = 0; i < subKeys.size(); ++i) {
                if (!OTransactionRealAbstract.isIndexKeyMayDependOnRid(subKeys.get(i), rid, keyDependencies == null ? null : keyDependencies[i])) continue;
                return true;
            }
            return false;
        }
        return OTransactionRealAbstract.isIndexKeyMayDependOnRid(key, rid, keyDependencies == null ? null : keyDependencies[0]);
    }

    private static boolean isIndexKeyMayDependOnRid(Object key, ORID rid, Dependency dependency) {
        if (dependency == Dependency.No) {
            return false;
        }
        if (key instanceof OIdentifiable) {
            return key.equals(rid);
        }
        return dependency == Dependency.Unknown || dependency == null;
    }

    private static Dependency getTypeRidDependency(OType type) {
        switch (type) {
            case CUSTOM: 
            case ANY: {
                return Dependency.Unknown;
            }
            case EMBEDDED: 
            case LINK: {
                return Dependency.Yes;
            }
            case LINKLIST: 
            case LINKSET: 
            case LINKMAP: 
            case LINKBAG: 
            case EMBEDDEDLIST: 
            case EMBEDDEDSET: 
            case EMBEDDEDMAP: {
                assert (false);
                return Dependency.Unknown;
            }
        }
        return Dependency.No;
    }

    private static class KeyChangesUpdateRecord {
        public final OTransactionIndexChangesPerKey keyChanges;
        public final OTransactionIndexChanges indexChanges;

        public KeyChangesUpdateRecord(OTransactionIndexChangesPerKey keyChanges, OTransactionIndexChanges indexChanges) {
            this.keyChanges = keyChanges;
            this.indexChanges = indexChanges;
        }
    }

    private static enum Dependency {
        Unknown,
        Yes,
        No;

    }

    public static final class OTransactionRecordIndexOperation {
        public String index;
        public Object key;
        public OTransactionIndexChanges.OPERATION operation;

        public OTransactionRecordIndexOperation(String index, Object key, OTransactionIndexChanges.OPERATION operation) {
            this.index = index;
            this.key = key;
            this.operation = operation;
        }
    }
}

