/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class OSharedContainerImpl
implements OSharedContainer {
    protected Map<String, Object> sharedResources = new ConcurrentHashMap<String, Object>();

    @Override
    public boolean existsResource(String iName) {
        return this.sharedResources.containsKey(iName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T removeResource(String iName) {
        OSharedContainerImpl oSharedContainerImpl = this;
        synchronized (oSharedContainerImpl) {
            Object resource = this.sharedResources.remove(iName);
            if (resource instanceof OSharedResource) {
                ((OSharedResource)resource).releaseExclusiveLock();
            }
            return (T)resource;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getResource(String iName, Callable<T> iCallback) {
        Object value = this.sharedResources.get(iName);
        if (value == null) {
            OSharedContainerImpl oSharedContainerImpl = this;
            synchronized (oSharedContainerImpl) {
                if (value == null) {
                    try {
                        value = iCallback.call();
                    }
                    catch (Exception e) {
                        throw OException.wrapException(new ODatabaseException("Error on creation of shared resource"), e);
                    }
                    if (value instanceof OSharedResource) {
                        ((OSharedResource)value).acquireExclusiveLock();
                    }
                    this.sharedResources.put(iName, value);
                }
            }
        }
        return (T)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearResources() {
        OSharedContainerImpl oSharedContainerImpl = this;
        synchronized (oSharedContainerImpl) {
            for (Object resource : this.sharedResources.values()) {
                if (!(resource instanceof OCloseable)) continue;
                ((OCloseable)resource).close();
            }
            this.sharedResources.clear();
        }
    }
}

