/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.OCommandStream;
import com.orientechnologies.common.console.OConsoleCommandCollection;
import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.ODFACommandStream;
import com.orientechnologies.common.console.ODefaultConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.util.OArrays;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OConsoleApplication {
    protected static final String[] COMMENT_PREFIXS = new String[]{"#", "--", "//"};
    public static final String ONLINE_HELP_URL = "https://raw.githubusercontent.com/orientechnologies/orientdb-docs/master/";
    public static final String ONLINE_HELP_EXT = ".md";
    protected final StringBuilder commandBuffer = new StringBuilder(2048);
    protected InputStream in = System.in;
    protected PrintStream out = System.out;
    protected PrintStream err = System.err;
    protected String wordSeparator = " ";
    protected String[] helpCommands = new String[]{"help", "?"};
    protected String[] exitCommands = new String[]{"exit", "bye", "quit"};
    protected Map<String, String> properties = new HashMap<String, String>();
    protected OConsoleReader reader = new ODefaultConsoleReader();
    protected boolean interactiveMode;
    protected String[] args;
    protected TreeMap<Method, Object> methods;
    protected boolean debugMode;

    public OConsoleApplication(String[] iArgs) {
        this.args = iArgs;
        this.debugMode = Boolean.valueOf(System.getProperty("debugMode"));
    }

    public static String getCorrectMethodName(Method m) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(OConsoleApplication.getClearName(m.getName()));
        for (int i = 0; i < m.getParameterAnnotations().length; ++i) {
            for (int j = 0; j < m.getParameterAnnotations()[i].length; ++j) {
                if (!(m.getParameterAnnotations()[i][j] instanceof ConsoleParameter)) continue;
                buffer.append(" <" + ((ConsoleParameter)m.getParameterAnnotations()[i][j]).name() + ">");
            }
        }
        return buffer.toString();
    }

    public static String getClearName(String iJavaName) {
        StringBuilder buffer = new StringBuilder();
        if (iJavaName != null) {
            buffer.append(iJavaName.charAt(0));
            for (int i = 1; i < iJavaName.length(); ++i) {
                char c = iJavaName.charAt(i);
                if (Character.isUpperCase(c)) {
                    buffer.append(' ');
                }
                buffer.append(Character.toLowerCase(c));
            }
        }
        return buffer.toString();
    }

    public void setReader(OConsoleReader iReader) {
        this.reader = iReader;
        this.reader.setConsole(this);
    }

    public int run() {
        int result;
        block5: {
            this.interactiveMode = this.isInteractiveMode(this.args);
            this.onBefore();
            result = 0;
            if (this.interactiveMode) {
                String consoleInput = null;
                while (true) {
                    try {
                        do {
                            if (this.commandBuffer.length() != 0) continue;
                            this.out.println();
                            this.out.print(this.getPrompt());
                        } while ((consoleInput = this.reader.readLine()) == null || consoleInput.length() == 0 || this.executeCommands(new ODFACommandStream(consoleInput), false));
                        break block5;
                    }
                    catch (Exception e) {
                        result = 1;
                        this.out.print("Error on reading console input: " + e.getMessage());
                        OLogManager.instance().error((Object)this, "Error on reading console input: %s", e, consoleInput);
                        continue;
                    }
                    break;
                }
            }
            result = this.executeBatch(this.getCommandLine(this.args)) ? 0 : 1;
        }
        this.onAfter();
        return result;
    }

    public void message(String iMessage, Object ... iArgs) {
        int verboseLevel = this.getVerboseLevel();
        if (verboseLevel > 1) {
            if (iArgs != null && iArgs.length > 0) {
                this.out.printf(iMessage, iArgs);
            } else {
                this.out.print(iMessage);
            }
        }
    }

    public void error(String iMessage, Object ... iArgs) {
        int verboseLevel = this.getVerboseLevel();
        if (verboseLevel > 0) {
            if (iArgs != null && iArgs.length > 0) {
                this.out.printf(iMessage, iArgs);
            } else {
                this.out.print(iMessage);
            }
        }
    }

    public int getVerboseLevel() {
        String v = this.properties.get("verbose");
        int verboseLevel = v != null ? Integer.parseInt(v) : 2;
        return verboseLevel;
    }

    protected int getConsoleWidth() {
        String width = this.properties.get("width");
        return width == null ? this.reader.getConsoleWidth() : Integer.parseInt(width);
    }

    public boolean isEchoEnabled() {
        return this.isPropertyEnabled("echo");
    }

    protected boolean isPropertyEnabled(String iPropertyName) {
        String v = this.properties.get(iPropertyName);
        if (v != null) {
            return (v = v.toLowerCase()).equals("true") || v.equals("on");
        }
        return false;
    }

    protected String getPrompt() {
        return String.format("%s> ", this.getContext());
    }

    protected String getContext() {
        return "";
    }

    protected boolean isInteractiveMode(String[] args) {
        return args.length == 0;
    }

    protected boolean executeBatch(String commandLine) {
        ODFACommandStream scanner;
        File commandFile = new File(commandLine);
        if (!commandFile.isAbsolute()) {
            commandFile = new File(new File("."), commandLine);
        }
        try {
            scanner = new ODFACommandStream(commandFile);
        }
        catch (FileNotFoundException e) {
            scanner = new ODFACommandStream(commandLine);
        }
        return this.executeCommands(scanner, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean executeCommands(OCommandStream commandStream, boolean iBatchMode) {
        try {
            RESULT status;
            while (commandStream.hasNext()) {
                String commandLine = commandStream.nextCommand();
                if (commandLine.isEmpty() || this.isComment(commandLine)) continue;
                if (this.isCollectingCommands(commandLine)) {
                    this.out.println("[Started multi-line command. Type just 'end' to finish and execute]");
                    this.commandBuffer.append(commandLine);
                    commandLine = null;
                } else if (commandLine.startsWith("end") && this.commandBuffer.length() > 0) {
                    commandLine = this.commandBuffer.toString();
                    this.commandBuffer.setLength(0);
                } else if (this.commandBuffer.length() > 0) {
                    this.commandBuffer.append(' ');
                    this.commandBuffer.append(commandLine);
                    this.commandBuffer.append(';');
                    commandLine = null;
                }
                if (commandLine == null) continue;
                if (iBatchMode || this.isEchoEnabled()) {
                    this.out.println();
                    this.out.print(this.getPrompt());
                    this.out.print(commandLine);
                    this.out.println();
                }
                RESULT status2 = this.execute(commandLine);
                commandLine = null;
                if (status2 != RESULT.EXIT && (status2 != RESULT.ERROR || Boolean.parseBoolean(this.properties.get("ignoreErrors")) || !iBatchMode)) continue;
                boolean bl = false;
                return bl;
            }
            if (this.commandBuffer.length() != 0) return true;
            if (this.commandBuffer.length() <= 0) return true;
            if (iBatchMode) {
                this.out.println();
                this.out.print(this.getPrompt());
                this.out.print(this.commandBuffer);
                this.out.println();
            }
            if ((status = this.execute(this.commandBuffer.toString())) != RESULT.EXIT) {
                if (status != RESULT.ERROR) return true;
                if (Boolean.parseBoolean(this.properties.get("ignoreErrors"))) return true;
                if (!iBatchMode) return true;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            commandStream.close();
        }
    }

    protected boolean isComment(String commandLine) {
        for (String comment : COMMENT_PREFIXS) {
            if (!commandLine.startsWith(comment)) continue;
            return true;
        }
        return false;
    }

    protected boolean isCollectingCommands(String iLine) {
        return false;
    }

    protected RESULT execute(String iCommand) {
        if ((iCommand = iCommand.trim()).length() == 0) {
            return RESULT.OK;
        }
        if (this.isComment(iCommand)) {
            return RESULT.OK;
        }
        String[] commandWords = OStringParser.getWords(iCommand, this.wordSeparator);
        for (String cmd : this.helpCommands) {
            if (!cmd.equals(commandWords[0])) continue;
            if (iCommand.length() > cmd.length()) {
                this.help(iCommand.substring(cmd.length() + 1));
            } else {
                this.help(null);
            }
            return RESULT.OK;
        }
        for (String cmd : this.exitCommands) {
            if (!cmd.equalsIgnoreCase(commandWords[0])) continue;
            return RESULT.EXIT;
        }
        Method lastMethodInvoked = null;
        StringBuilder lastCommandInvoked = new StringBuilder(1024);
        String commandLowerCase = "";
        for (int i = 0; i < commandWords.length; ++i) {
            if (i > 0) {
                commandLowerCase = commandLowerCase + " ";
            }
            commandLowerCase = commandLowerCase + commandWords[i].toLowerCase();
        }
        for (Map.Entry<Method, Object> entry : this.getConsoleMethods().entrySet()) {
            Object[] methodArgs;
            Method m = entry.getKey();
            String methodName = m.getName();
            ConsoleCommand ann = m.getAnnotation(ConsoleCommand.class);
            StringBuilder commandName = new StringBuilder();
            int commandWordCount = 1;
            for (int i = 0; i < methodName.length(); ++i) {
                char ch = methodName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    commandName.append(" ");
                    ch = Character.toLowerCase(ch);
                    ++commandWordCount;
                }
                commandName.append(ch);
            }
            if (!commandLowerCase.equals(commandName.toString()) && !commandLowerCase.startsWith(commandName.toString() + " ")) {
                String[] aliases;
                if (ann == null || (aliases = ann.aliases()) == null || aliases.length == 0) continue;
                boolean aliasMatch = false;
                for (String alias : aliases) {
                    if (!iCommand.startsWith(alias.split(" ")[0])) continue;
                    aliasMatch = true;
                    commandWordCount = 1;
                    break;
                }
                if (!aliasMatch) continue;
            }
            if (ann != null && !ann.splitInWords()) {
                methodArgs = new String[]{iCommand.substring(iCommand.indexOf(32) + 1)};
            } else {
                int actualParamCount = commandWords.length - commandWordCount;
                if (m.getParameterTypes().length > actualParamCount) {
                    block9: for (int paramNum = m.getParameterAnnotations().length - 1; paramNum > actualParamCount - 1; --paramNum) {
                        Annotation[] paramAnn = m.getParameterAnnotations()[paramNum];
                        if (paramAnn == null) continue;
                        for (int annNum = paramAnn.length - 1; annNum > -1; --annNum) {
                            if (!(paramAnn[annNum] instanceof ConsoleParameter)) continue;
                            ConsoleParameter annotation = (ConsoleParameter)paramAnn[annNum];
                            if (!annotation.optional()) continue block9;
                            commandWords = OArrays.copyOf(commandWords, commandWords.length + 1);
                            continue block9;
                        }
                    }
                }
                methodArgs = OArrays.copyOfRange(commandWords, commandWordCount, commandWords.length);
            }
            try {
                m.invoke(entry.getValue(), methodArgs);
            }
            catch (IllegalArgumentException e) {
                lastMethodInvoked = m;
                lastCommandInvoked.setLength(0);
                for (int i = 0; i < commandWordCount; ++i) {
                    if (lastCommandInvoked.length() > 0) {
                        lastCommandInvoked.append(" ");
                    }
                    lastCommandInvoked.append(commandWords[i]);
                }
                continue;
            }
            catch (Exception e) {
                if (e.getCause() != null) {
                    this.onException(e.getCause());
                } else {
                    e.printStackTrace(this.err);
                }
                return RESULT.ERROR;
            }
            return RESULT.OK;
        }
        if (lastMethodInvoked != null) {
            this.syntaxError(lastCommandInvoked.toString(), lastMethodInvoked);
        }
        this.error("\n!Unrecognized command: '%s'", iCommand);
        return RESULT.ERROR;
    }

    protected Method getMethod(String iCommand) {
        Method m;
        if ((iCommand = iCommand.trim()).length() == 0) {
            return null;
        }
        if (this.isComment(iCommand)) {
            return null;
        }
        String commandLowerCase = iCommand.toLowerCase();
        Map<Method, Object> methodMap = this.getConsoleMethods();
        StringBuilder commandSignature = new StringBuilder();
        boolean separator = false;
        for (int i = 0; i < iCommand.length(); ++i) {
            char ch = iCommand.charAt(i);
            if (ch == ' ') {
                separator = true;
                continue;
            }
            if (separator) {
                separator = false;
                commandSignature.append(Character.toUpperCase(ch));
                continue;
            }
            commandSignature.append(ch);
        }
        String commandSignatureToCheck = commandSignature.toString();
        for (Map.Entry<Method, Object> entry : methodMap.entrySet()) {
            m = entry.getKey();
            if (!m.getName().equals(commandSignatureToCheck)) continue;
            return m;
        }
        for (Map.Entry<Method, Object> entry : methodMap.entrySet()) {
            m = entry.getKey();
            String methodName = m.getName();
            ConsoleCommand ann = m.getAnnotation(ConsoleCommand.class);
            StringBuilder commandName = new StringBuilder();
            for (int i = 0; i < methodName.length(); ++i) {
                char ch = methodName.charAt(i);
                if (Character.isUpperCase(ch)) {
                    commandName.append(" ");
                    ch = Character.toLowerCase(ch);
                }
                commandName.append(ch);
            }
            if (!commandLowerCase.equals(commandName.toString()) && !commandLowerCase.startsWith(commandName.toString() + " ")) {
                String[] aliases;
                if (ann == null || (aliases = ann.aliases()) == null || aliases.length == 0) continue;
                for (String alias : aliases) {
                    if (!iCommand.startsWith(alias.split(" ")[0])) continue;
                    return m;
                }
                continue;
            }
            return m;
        }
        this.error("\n!Unrecognized command: '%s'", iCommand);
        return null;
    }

    protected void syntaxError(String iCommand, Method m) {
        this.error("\n!Wrong syntax. If you're running in batch mode make sure all commands are delimited by semicolon (;) or a linefeed (\\n). Expected: \n\r\n\r%s", this.formatCommandSpecs(iCommand, m));
    }

    protected String formatCommandSpecs(String iCommand, Method m) {
        StringBuilder buffer = new StringBuilder();
        StringBuilder signature = new StringBuilder();
        signature.append(iCommand);
        String paramName = null;
        String paramDescription = null;
        boolean paramOptional = false;
        buffer.append("\n\nWHERE:\n\n");
        Annotation[][] annotationArray = m.getParameterAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n; ++i) {
            Annotation[] annotations;
            for (Annotation ann : annotations = annotationArray[i]) {
                if (!(ann instanceof ConsoleParameter)) continue;
                paramName = ((ConsoleParameter)ann).name();
                paramDescription = ((ConsoleParameter)ann).description();
                paramOptional = ((ConsoleParameter)ann).optional();
                break;
            }
            if (paramName == null) {
                paramName = "?";
            }
            if (paramOptional) {
                signature.append(" [<" + paramName + ">]");
            } else {
                signature.append(" <" + paramName + ">");
            }
            buffer.append("* ");
            buffer.append(String.format("%-18s", paramName));
            if (paramDescription != null) {
                buffer.append(paramDescription);
            }
            if (paramOptional) {
                buffer.append(" (optional)");
            }
            buffer.append("\n");
        }
        signature.append((CharSequence)buffer);
        return signature.toString();
    }

    protected Map<Method, Object> getConsoleMethods() {
        if (this.methods != null) {
            return this.methods;
        }
        Iterator<OConsoleCommandCollection> ite = ServiceLoader.load(OConsoleCommandCollection.class).iterator();
        ArrayList<Object> candidates = new ArrayList<Object>();
        candidates.add(this);
        while (ite.hasNext()) {
            try {
                OConsoleCommandCollection cc = (OConsoleCommandCollection)ite.next().getClass().newInstance();
                cc.setContext(this);
                candidates.add(cc);
            }
            catch (InstantiationException ex) {
                Logger.getLogger(OConsoleApplication.class.getName()).log(Level.WARNING, ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(OConsoleApplication.class.getName()).log(Level.WARNING, ex.getMessage());
            }
        }
        this.methods = new TreeMap(new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                ConsoleCommand ann1 = o1.getAnnotation(ConsoleCommand.class);
                ConsoleCommand ann2 = o2.getAnnotation(ConsoleCommand.class);
                if (ann1 != null && ann2 != null && ann1.priority() != ann2.priority()) {
                    return ann1.priority() - ann2.priority();
                }
                int res = o1.getName().compareTo(o2.getName());
                if (res == 0) {
                    res = o1.toString().compareTo(o2.toString());
                }
                return res;
            }
        });
        for (Object e : candidates) {
            Method[] classMethods;
            for (Method m : classMethods = e.getClass().getMethods()) {
                if (Modifier.isAbstract(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || !Modifier.isPublic(m.getModifiers()) || m.getReturnType() != Void.TYPE) continue;
                this.methods.put(m, e);
            }
        }
        return this.methods;
    }

    protected Map<String, Object> addCommand(Map<String, Object> commandsTree, String commandLine) {
        return commandsTree;
    }

    @ConsoleCommand(splitInWords=false, description="Receives help on available commands or a specific one. Use 'help -online <cmd>' to fetch online documentation")
    public void help(@ConsoleParameter(name="command", description="Command to receive help") String iCommand) {
        Method m;
        boolean onlineMode;
        if (iCommand == null || iCommand.trim().isEmpty()) {
            this.message("\nAVAILABLE COMMANDS:\n", new Object[0]);
            for (Method m2 : this.getConsoleMethods().keySet()) {
                ConsoleCommand annotation = m2.getAnnotation(ConsoleCommand.class);
                if (annotation == null) continue;
                this.message("* %-85s%s\n", OConsoleApplication.getCorrectMethodName(m2), annotation.description());
            }
            this.message("* %-85s%s\n", OConsoleApplication.getClearName("exit"), "Close the console");
            return;
        }
        String[] commandWords = OStringParser.getWords(iCommand, this.wordSeparator);
        boolean bl = onlineMode = commandWords.length > 1 && commandWords[0].equalsIgnoreCase("-online");
        if (onlineMode) {
            iCommand = iCommand.substring("-online".length() + 1);
        }
        if ((m = this.getMethod(iCommand)) != null) {
            ConsoleCommand ann = m.getAnnotation(ConsoleCommand.class);
            this.message("\nCOMMAND: " + iCommand + "\n\n", new Object[0]);
            if (ann != null) {
                if (onlineMode && !ann.onlineHelp().isEmpty()) {
                    String text = this.getOnlineHelp(ONLINE_HELP_URL + ann.onlineHelp() + ONLINE_HELP_EXT);
                    if (text != null && !text.isEmpty()) {
                        this.message(text, new Object[0]);
                        return;
                    }
                    this.error("!CANNOT FETCH ONLINE DOCUMENTATION, CHECK IF COMPUTER IS CONNECTED TO THE INTERNET.", new Object[0]);
                    return;
                }
                this.message(ann.description() + ".\r\n\r\nSYNTAX: ", new Object[0]);
                this.message(this.formatCommandSpecs(iCommand, m), new Object[0]);
            } else {
                this.message("No description available", new Object[0]);
            }
        }
    }

    protected String getCommandLine(String[] iArguments) {
        StringBuilder command = new StringBuilder(512);
        for (int i = 0; i < iArguments.length; ++i) {
            if (i > 0) {
                command.append(" ");
            }
            command.append(iArguments[i]);
        }
        return command.toString();
    }

    protected void onBefore() {
    }

    protected void onAfter() {
    }

    protected void onException(Throwable throwable) {
        throwable.printStackTrace(this.err);
    }

    public void setOutput(PrintStream iOut) {
        this.out = iOut;
    }

    protected String getOnlineHelp(String urlToRead) {
        StringBuilder result = new StringBuilder();
        try {
            String line;
            URL url = new URL(urlToRead);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                if (line.startsWith("```") || line.startsWith("# ")) continue;
                if (result.length() > 0) {
                    result.append("\n");
                }
                result.append(line);
            }
            rd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString();
    }

    protected static enum RESULT {
        OK,
        ERROR,
        EXIT;

    }
}

