/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.directmemory.OByteBufferPool;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.listener.OListenerManger;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.profiler.OProfilerStub;
import com.orientechnologies.common.util.OClassLoaderHelper;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.OOrientShutdownListener;
import com.orientechnologies.orient.core.OOrientStartupListener;
import com.orientechnologies.orient.core.OSignalHandler;
import com.orientechnologies.orient.core.OrientShutdownHook;
import com.orientechnologies.orient.core.cache.OLocalRecordCacheFactory;
import com.orientechnologies.orient.core.cache.OLocalRecordCacheFactoryImpl;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategyFactory;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.db.ODatabaseThreadLocalFactory;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.ORecordFactoryManager;
import com.orientechnologies.orient.core.security.OSecuritySystem;
import com.orientechnologies.orient.core.shutdown.OShutdownHandler;
import com.orientechnologies.orient.core.storage.OIdentifiableStorage;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.File;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Orient
extends OListenerManger<OOrientListener> {
    public static final String ORIENTDB_HOME = "ORIENTDB_HOME";
    public static final String URL_SYNTAX = "<engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*";
    private static final Orient instance = new Orient();
    private static volatile boolean registerDatabaseByPath = false;
    private final ConcurrentMap<String, OEngine> engines = new ConcurrentHashMap<String, OEngine>();
    private final ConcurrentMap<String, OStorage> storages = new ConcurrentHashMap<String, OStorage>();
    private final ConcurrentHashMap<Integer, Boolean> storageIds = new ConcurrentHashMap();
    private final Map<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> dbLifecycleListeners = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>();
    private final OScriptManager scriptManager = new OScriptManager();
    private final ThreadGroup threadGroup;
    private final ReadWriteLock engineLock = new ReentrantReadWriteLock();
    private final ORecordConflictStrategyFactory recordConflictStrategy = new ORecordConflictStrategyFactory();
    private final ReferenceQueue<OOrientStartupListener> removedStartupListenersQueue = new ReferenceQueue();
    private final ReferenceQueue<OOrientShutdownListener> removedShutdownListenersQueue = new ReferenceQueue();
    private final Set<OOrientStartupListener> startupListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WeakHashSetValueHolder<OOrientStartupListener>> weakStartupListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<WeakHashSetValueHolder<OOrientShutdownListener>> weakShutdownListeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private final PriorityQueue<OShutdownHandler> shutdownHandlers = new PriorityQueue<OShutdownHandler>(11, new Comparator<OShutdownHandler>(){

        @Override
        public int compare(OShutdownHandler handlerOne, OShutdownHandler handlerTwo) {
            if (handlerOne.getPriority() > handlerTwo.getPriority()) {
                return 1;
            }
            if (handlerOne.getPriority() < handlerTwo.getPriority()) {
                return -1;
            }
            return 0;
        }
    });
    private final OLocalRecordCacheFactory localRecordCache = new OLocalRecordCacheFactoryImpl();
    private final String os;
    private volatile Timer timer;
    private volatile ORecordFactoryManager recordFactoryManager = new ORecordFactoryManager();
    private OrientShutdownHook shutdownHook;
    private volatile OProfiler profiler;
    private ODatabaseThreadLocalFactory databaseThreadFactory;
    private volatile boolean active = false;
    private ThreadPoolExecutor workers;
    private OSignalHandler signalHandler;
    private volatile OSecuritySystem security;
    private boolean runningDistributed = false;

    protected Orient() {
        super(true);
        this.os = System.getProperty("os.name").toLowerCase();
        this.threadGroup = new ThreadGroup("OrientDB");
        this.threadGroup.setDaemon(false);
    }

    public static Orient instance() {
        return instance;
    }

    public static String getHomePath() {
        String v = System.getProperty("orient.home");
        if (v == null) {
            v = OSystemVariableResolver.resolveVariable(ORIENTDB_HOME);
        }
        return OFileUtils.getPath(v);
    }

    public static String getTempPath() {
        return OFileUtils.getPath(System.getProperty("java.io.tmpdir") + "/orientdb/");
    }

    public static boolean isRegisterDatabaseByPath() {
        return registerDatabaseByPath;
    }

    public static void setRegisterDatabaseByPath(boolean iValue) {
        registerDatabaseByPath = iValue;
    }

    public ORecordConflictStrategyFactory getRecordConflictStrategy() {
        return this.recordConflictStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Orient startup() {
        this.engineLock.writeLock().lock();
        try {
            if (this.active) {
                Orient orient = this;
                return orient;
            }
            if (this.timer == null) {
                this.timer = new Timer(true);
            }
            this.profiler = new OProfilerStub();
            this.shutdownHook = new OrientShutdownHook();
            if (this.signalHandler == null) {
                this.signalHandler = new OSignalHandler();
                this.signalHandler.installDefaultSignals();
            }
            int cores = Runtime.getRuntime().availableProcessors();
            this.workers = new ThreadPoolExecutor(cores, cores * 3, 10L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue<Runnable>(cores * 500){

                @Override
                public boolean offer(Runnable e) {
                    try {
                        this.put(e);
                        return true;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return false;
                    }
                }
            });
            this.registerEngines();
            if (OGlobalConfiguration.ENVIRONMENT_DUMP_CFG_AT_STARTUP.getValueAsBoolean()) {
                OGlobalConfiguration.dumpConfiguration(System.out);
            }
            this.active = true;
            for (OOrientStartupListener oOrientStartupListener : this.startupListeners) {
                try {
                    if (oOrientStartupListener == null) continue;
                    oOrientStartupListener.onStartup();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on startup", e, new Object[0]);
                }
            }
            this.purgeWeakStartupListeners();
            for (WeakHashSetValueHolder weakHashSetValueHolder : this.weakStartupListeners) {
                try {
                    OOrientStartupListener l;
                    if (weakHashSetValueHolder == null || (l = (OOrientStartupListener)weakHashSetValueHolder.get()) == null) continue;
                    l.onStartup();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on startup", e, new Object[0]);
                }
            }
            this.initShutdownQueue();
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
        return this;
    }

    public void addShutdownHandler(OShutdownHandler shutdownHandler) {
        this.engineLock.writeLock().lock();
        try {
            this.shutdownHandlers.add(shutdownHandler);
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    private void initShutdownQueue() {
        this.addShutdownHandler(new OShutdownWorkersHandler());
        this.addShutdownHandler(new OShutdownEnginesHandler());
        this.addShutdownHandler(new OShutdownPendingThreadsHandler());
        this.addShutdownHandler(new OShutdownProfilerHandler());
        this.addShutdownHandler(new OShutdownCallListenersHandler());
    }

    private void registerEngines() {
        ClassLoader classLoader = Orient.class.getClassLoader();
        Iterator<OEngine> engines = OClassLoaderHelper.lookupProviderWithOrientClassLoader(OEngine.class, classLoader);
        OEngine engine = null;
        while (engines.hasNext()) {
            try {
                engine = engines.next();
                this.registerEngine(engine);
            }
            catch (IllegalArgumentException e) {
                if (engine == null) continue;
                OLogManager.instance().debug((Object)this, "Failed to replace engine " + engine.getName(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Orient shutdown() {
        this.engineLock.writeLock().lock();
        try {
            if (!this.active) {
                Orient orient = this;
                return orient;
            }
            this.active = false;
            OLogManager.instance().info((Object)this, "Orient Engine is shutting down...", new Object[0]);
            for (OShutdownHandler handler : this.shutdownHandlers) {
                try {
                    OLogManager.instance().debug((Object)this, "Shutdown handler %s is going to be called", handler);
                    handler.shutdown();
                    OLogManager.instance().debug((Object)this, "Shutdown handler %s completed", handler);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Exception during calling of shutdown handler %s", handler);
                }
            }
            this.shutdownHandlers.clear();
            OLogManager.instance().info((Object)this, "OrientDB Engine shutdown complete", new Object[0]);
            OLogManager.instance().flush();
        }
        finally {
            try {
                this.removeShutdownHook();
            }
            finally {
                try {
                    this.removeSignalHandler();
                }
                finally {
                    this.engineLock.writeLock().unlock();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(TimerTask task, long delay, long period) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                if (period > 0L) {
                    this.timer.schedule(task, delay, period);
                } else {
                    this.timer.schedule(task, delay);
                }
            } else {
                OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be scheduled.", new Object[0]);
            }
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(TimerTask task, Date firstTime, long period) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                if (period > 0L) {
                    this.timer.schedule(task, firstTime, period);
                } else {
                    this.timer.schedule(task, firstTime);
                }
            } else {
                OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be scheduled.", new Object[0]);
            }
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public void closeAllStorages() {
        this.shutdownAllStorages();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAllStorages() {
        this.engineLock.writeLock().lock();
        try {
            ArrayList storagesCopy = new ArrayList(this.storages.values());
            for (OStorage stg : storagesCopy) {
                try {
                    OLogManager.instance().info((Object)this, "- shutdown storage: " + stg.getName() + "...", new Object[0]);
                    stg.shutdown();
                }
                catch (Throwable e) {
                    OLogManager.instance().warn((Object)this, "-- error on shutdown storage", e, new Object[0]);
                }
            }
            this.storages.clear();
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    public boolean isActive() {
        return this.active;
    }

    @Deprecated
    public ThreadPoolExecutor getWorkers() {
        return this.workers;
    }

    public Future<?> submit(Runnable runnable) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                Future<?> future = this.workers.submit(runnable);
                return future;
            }
            OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be submitted.", new Object[0]);
            throw new IllegalStateException("OrientDB engine is down. Task will not be submitted.");
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public <V> Future<V> submit(Callable<V> callable) {
        this.engineLock.readLock().lock();
        try {
            if (this.active) {
                Future<V> future = this.workers.submit(callable);
                return future;
            }
            OLogManager.instance().warn((Object)this, "OrientDB engine is down. Task will not be submitted.", new Object[0]);
            throw new IllegalStateException("OrientDB engine is down. Task will not be submitted.");
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage loadStorage(String iURL) {
        int pos;
        if (iURL == null || iURL.length() == 0) {
            throw new IllegalArgumentException("URL missed");
        }
        if (iURL.endsWith("/")) {
            iURL = iURL.substring(0, iURL.length() - 1);
        }
        if ((pos = iURL.indexOf(58)) <= 0) {
            throw new OConfigurationException("Error in database URL: the engine was not specified. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
        }
        String engineName = iURL.substring(0, pos);
        this.engineLock.readLock().lock();
        try {
            String dbName;
            String dbNameCaseInsensitive;
            OStorage storage;
            String dbPath;
            OEngine engine = (OEngine)this.engines.get(engineName.toLowerCase());
            if (engine == null) {
                throw new OConfigurationException("Error on opening database: the engine '" + engineName + "' was not found. URL was: " + iURL + ". Registered engines are: " + this.engines.keySet());
            }
            if (!engine.isRunning()) {
                ArrayList knownEngines = new ArrayList(this.engines.keySet());
                if (!this.startEngine(engine)) {
                    throw new OConfigurationException("Error on opening database: the engine '" + engineName + "' was unable to start. URL was: " + iURL + ". Registered engines was: " + knownEngines);
                }
            }
            iURL = iURL.substring(pos + 1);
            iURL = this.isWindowsOS() ? iURL.charAt(0) + iURL.substring(1).replace("//", "/") : iURL.replace("//", "/");
            pos = iURL.indexOf(63);
            HashMap<String, String> parameters = null;
            if (pos > 0) {
                String[] pairs;
                dbPath = iURL.substring(0, pos);
                iURL = iURL.substring(pos + 1);
                parameters = new HashMap<String, String>();
                for (String pair : pairs = iURL.split("&")) {
                    String[] kv = pair.split("=");
                    if (kv.length < 2) {
                        throw new OConfigurationException("Error on opening database: parameter has no value. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
                    }
                    parameters.put(kv[0], kv[1]);
                }
            } else {
                dbPath = iURL;
            }
            if (registerDatabaseByPath) {
                try {
                    dbPath = new File(dbPath).getCanonicalPath();
                }
                catch (IOException pairs) {
                    // empty catch block
                }
            }
            if ((storage = (OStorage)this.storages.get(dbNameCaseInsensitive = (dbName = registerDatabaseByPath ? dbPath : engine.getNameFromPath(dbPath)).toLowerCase())) == null) {
                while ((storage = engine.createStorage(dbPath, parameters)) instanceof OIdentifiableStorage && this.storageIds.putIfAbsent(((OIdentifiableStorage)storage).getId(), Boolean.TRUE) != null) {
                }
                OStorage oldStorage = this.storages.putIfAbsent(dbNameCaseInsensitive, storage);
                if (oldStorage != null) {
                    storage = oldStorage;
                }
                for (OOrientListener l : this.browseListeners()) {
                    l.onStorageRegistered(storage);
                }
            }
            OStorage oStorage = storage;
            return oStorage;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public boolean isWindowsOS() {
        return this.os.contains("win");
    }

    public OStorage getStorage(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Storage name is null");
        }
        this.engineLock.readLock().lock();
        try {
            OStorage oStorage = (OStorage)this.storages.get(name.toLowerCase());
            return oStorage;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    protected void registerEngine(OEngine iEngine) throws IllegalArgumentException {
        OEngine oEngine = (OEngine)this.engines.get(iEngine.getName());
        if (oEngine != null && !oEngine.getClass().isAssignableFrom(iEngine.getClass())) {
            throw new IllegalArgumentException("Cannot replace storage " + iEngine.getName());
        }
        this.engines.put(iEngine.getName(), iEngine);
    }

    public OEngine getEngine(String engineName) {
        this.engineLock.readLock().lock();
        try {
            OEngine oEngine = (OEngine)this.engines.get(engineName);
            return oEngine;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OEngine getEngineIfRunning(String engineName) {
        this.engineLock.readLock().lock();
        try {
            OEngine engine = (OEngine)this.engines.get(engineName);
            OEngine oEngine = engine == null || !engine.isRunning() ? null : engine;
            return oEngine;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OEngine getRunningEngine(String engineName) {
        this.engineLock.readLock().lock();
        try {
            OEngine engine = (OEngine)this.engines.get(engineName);
            if (engine == null) {
                throw new IllegalStateException("Engine '" + engineName + "' is not found.");
            }
            if (!engine.isRunning() && !this.startEngine(engine)) {
                throw new IllegalStateException("Engine '" + engineName + "' is failed to start.");
            }
            OEngine oEngine = engine;
            return oEngine;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public Set<String> getEngines() {
        this.engineLock.readLock().lock();
        try {
            Set<String> set = Collections.unmodifiableSet(this.engines.keySet());
            return set;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    public void unregisterStorageByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Storage name is null");
        }
        String dbName = registerDatabaseByPath ? name : OIOUtils.getRelativePathIfAny(name, null);
        OStorage stg = (OStorage)this.storages.get(dbName.toLowerCase());
        this.unregisterStorage(stg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStorage(OStorage storage) {
        if (!this.active) {
            return;
        }
        if (storage == null) {
            return;
        }
        this.engineLock.writeLock().lock();
        try {
            Iterable listenerCopy = this.getListenersCopy();
            for (OOrientListener l : listenerCopy) {
                this.unregisterListener(l);
                l.onStorageUnregistered(storage);
            }
            ArrayList storagesToRemove = new ArrayList();
            for (Map.Entry s : this.storages.entrySet()) {
                if (!((OStorage)s.getValue()).equals(storage)) continue;
                storagesToRemove.add(s.getKey());
            }
            for (String dbName : storagesToRemove) {
                this.storages.remove(dbName.toLowerCase());
            }
            for (OEngine engine : this.engines.values()) {
                engine.removeStorage(storage);
            }
        }
        finally {
            this.engineLock.writeLock().unlock();
        }
    }

    public Collection<OStorage> getStorages() {
        this.engineLock.readLock().lock();
        try {
            ArrayList<OStorage> arrayList = new ArrayList<OStorage>(this.storages.values());
            return arrayList;
        }
        finally {
            this.engineLock.readLock().unlock();
        }
    }

    @Deprecated
    public Timer getTimer() {
        return this.timer;
    }

    public void removeShutdownHook() {
        if (this.shutdownHook != null) {
            this.shutdownHook.cancel();
            this.shutdownHook = null;
        }
    }

    public OSignalHandler getSignalHandler() {
        return this.signalHandler;
    }

    public void removeSignalHandler() {
        if (this.signalHandler != null) {
            this.signalHandler.cancel();
            this.signalHandler = null;
        }
    }

    public boolean isSelfManagedShutdown() {
        return this.shutdownHook != null;
    }

    public Iterator<ODatabaseLifecycleListener> getDbLifecycleListeners() {
        return new HashSet<ODatabaseLifecycleListener>(this.dbLifecycleListeners.keySet()).iterator();
    }

    public void addDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY> tmp = new LinkedHashMap<ODatabaseLifecycleListener, ODatabaseLifecycleListener.PRIORITY>(this.dbLifecycleListeners);
        if (iListener.getPriority() == null) {
            throw new IllegalArgumentException("Priority of DatabaseLifecycleListener '" + iListener + "' cannot be null");
        }
        tmp.put(iListener, iListener.getPriority());
        this.dbLifecycleListeners.clear();
        for (ODatabaseLifecycleListener.PRIORITY p : ODatabaseLifecycleListener.PRIORITY.values()) {
            for (Map.Entry e : tmp.entrySet()) {
                if (e.getValue() != p) continue;
                this.dbLifecycleListeners.put((ODatabaseLifecycleListener)e.getKey(), (ODatabaseLifecycleListener.PRIORITY)((Object)e.getValue()));
            }
        }
    }

    public void removeDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.remove(iListener);
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public ODatabaseThreadLocalFactory getDatabaseThreadFactory() {
        return this.databaseThreadFactory;
    }

    public ORecordFactoryManager getRecordFactoryManager() {
        return this.recordFactoryManager;
    }

    public void setRecordFactoryManager(ORecordFactoryManager iRecordFactoryManager) {
        this.recordFactoryManager = iRecordFactoryManager;
    }

    public OProfiler getProfiler() {
        return this.profiler;
    }

    public void setProfiler(OProfiler iProfiler) {
        this.profiler = iProfiler;
    }

    public OSecuritySystem getSecurity() {
        return this.security;
    }

    public void setSecurity(OSecuritySystem security) {
        this.security = security;
    }

    public void registerThreadDatabaseFactory(ODatabaseThreadLocalFactory iDatabaseFactory) {
        this.databaseThreadFactory = iDatabaseFactory;
    }

    public OScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @Override
    public void registerListener(OOrientListener listener) {
        if (listener instanceof OOrientStartupListener) {
            this.registerOrientStartupListener((OOrientStartupListener)((Object)listener));
        }
        super.registerListener(listener);
    }

    @Override
    public void unregisterListener(OOrientListener listener) {
        if (listener instanceof OOrientStartupListener) {
            this.unregisterOrientStartupListener((OOrientStartupListener)((Object)listener));
        }
        super.unregisterListener(listener);
    }

    public void registerOrientStartupListener(OOrientStartupListener listener) {
        this.startupListeners.add(listener);
    }

    public void registerWeakOrientStartupListener(OOrientStartupListener listener) {
        this.purgeWeakStartupListeners();
        this.weakStartupListeners.add(new WeakHashSetValueHolder(listener, this.removedStartupListenersQueue));
    }

    public void unregisterOrientStartupListener(OOrientStartupListener listener) {
        this.startupListeners.remove(listener);
    }

    public void unregisterWeakOrientStartupListener(OOrientStartupListener listener) {
        this.purgeWeakStartupListeners();
        this.weakStartupListeners.remove(new WeakHashSetValueHolder(listener, null));
    }

    public void registerWeakOrientShutdownListener(OOrientShutdownListener listener) {
        this.purgeWeakShutdownListeners();
        this.weakShutdownListeners.add(new WeakHashSetValueHolder(listener, this.removedShutdownListenersQueue));
    }

    public void unregisterWeakOrientShutdownListener(OOrientShutdownListener listener) {
        this.purgeWeakShutdownListeners();
        this.weakShutdownListeners.remove(new WeakHashSetValueHolder(listener, null));
    }

    @Override
    public void resetListeners() {
        super.resetListeners();
        this.weakShutdownListeners.clear();
        this.startupListeners.clear();
        this.weakStartupListeners.clear();
    }

    public OLocalRecordCacheFactory getLocalRecordCache() {
        return this.localRecordCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWeakStartupListeners() {
        ReferenceQueue<OOrientStartupListener> referenceQueue = this.removedStartupListenersQueue;
        synchronized (referenceQueue) {
            WeakHashSetValueHolder ref = (WeakHashSetValueHolder)this.removedStartupListenersQueue.poll();
            while (ref != null) {
                this.weakStartupListeners.remove(ref);
                ref = (WeakHashSetValueHolder)this.removedStartupListenersQueue.poll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeWeakShutdownListeners() {
        ReferenceQueue<OOrientShutdownListener> referenceQueue = this.removedShutdownListenersQueue;
        synchronized (referenceQueue) {
            WeakHashSetValueHolder ref = (WeakHashSetValueHolder)this.removedShutdownListenersQueue.poll();
            while (ref != null) {
                this.weakShutdownListeners.remove(ref);
                ref = (WeakHashSetValueHolder)this.removedShutdownListenersQueue.poll();
            }
        }
    }

    private boolean startEngine(OEngine engine) {
        String name = engine.getName();
        try {
            engine.startup();
            return true;
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error during initialization of engine '%s', engine will be removed", e, name);
            try {
                engine.shutdown();
            }
            catch (Exception se) {
                OLogManager.instance().error((Object)this, "Error during engine shutdown", se, new Object[0]);
            }
            this.engines.remove(name);
            return false;
        }
    }

    public boolean isRunningDistributed() {
        return this.runningDistributed;
    }

    public void setRunningDistributed(boolean runningDistributed) {
        this.runningDistributed = runningDistributed;
    }

    static {
        instance.startup();
    }

    private class OShutdownCallListenersHandler
    implements OShutdownHandler {
        private OShutdownCallListenersHandler() {
        }

        @Override
        public int getPriority() {
            return 1400;
        }

        @Override
        public void shutdown() throws Exception {
            Orient.this.purgeWeakShutdownListeners();
            for (WeakHashSetValueHolder wl : Orient.this.weakShutdownListeners) {
                try {
                    OOrientShutdownListener l;
                    if (wl == null || (l = (OOrientShutdownListener)wl.get()) == null) continue;
                    l.onShutdown();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during orient shutdown", e, new Object[0]);
                }
            }
            for (OOrientListener l : Orient.this.browseListeners()) {
                if (l == null) continue;
                try {
                    l.onShutdown();
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error during orient shutdown", e, new Object[0]);
                }
            }
            System.gc();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private class OShutdownProfilerHandler
    implements OShutdownHandler {
        private OShutdownProfilerHandler() {
        }

        @Override
        public int getPriority() {
            return 1300;
        }

        @Override
        public void shutdown() throws Exception {
            Orient.this.profiler.shutdown();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private class OShutdownPendingThreadsHandler
    implements OShutdownHandler {
        private OShutdownPendingThreadsHandler() {
        }

        @Override
        public int getPriority() {
            return 1200;
        }

        @Override
        public void shutdown() throws Exception {
            if (Orient.this.threadGroup != null) {
                Orient.this.threadGroup.interrupt();
            }
            if (Orient.this.timer != null) {
                Orient.this.timer.cancel();
                Orient.this.timer = null;
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public class OShutdownEnginesHandler
    implements OShutdownHandler {
        @Override
        public int getPriority() {
            return 1100;
        }

        @Override
        public void shutdown() throws Exception {
            Orient.this.shutdownAllStorages();
            for (OEngine engine : Orient.this.engines.values()) {
                if (!engine.isRunning()) continue;
                engine.shutdown();
            }
            Orient.this.engines.clear();
            OByteBufferPool.instance().verifyState();
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    public class OShutdownWorkersHandler
    implements OShutdownHandler {
        @Override
        public int getPriority() {
            return 1000;
        }

        @Override
        public void shutdown() throws Exception {
            Orient.this.workers.shutdown();
            try {
                Orient.this.workers.awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    private static class WeakHashSetValueHolder<T>
    extends WeakReference<T> {
        private final int hashCode;

        private WeakHashSetValueHolder(T referent, ReferenceQueue<? super T> q) {
            super(referent, q);
            this.hashCode = referent.hashCode();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WeakHashSetValueHolder that = (WeakHashSetValueHolder)o;
            if (this.hashCode != that.hashCode) {
                return false;
            }
            Object thisObject = this.get();
            Object thatObject = that.get();
            if (thisObject == null && thatObject == null) {
                return super.equals(that);
            }
            if (thisObject != null && thatObject != null) {
                return thisObject.equals(thatObject);
            }
            return false;
        }
    }
}

