/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.ORecordTrackedList;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentComparator;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.method.OSQLMethod;
import com.orientechnologies.orient.core.util.ODateHelper;
import java.lang.reflect.Array;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ODocumentHelper {
    public static final String ATTRIBUTE_THIS = "@this";
    public static final String ATTRIBUTE_RID = "@rid";
    public static final String ATTRIBUTE_RID_ID = "@rid_id";
    public static final String ATTRIBUTE_RID_POS = "@rid_pos";
    public static final String ATTRIBUTE_VERSION = "@version";
    public static final String ATTRIBUTE_CLASS = "@class";
    public static final String ATTRIBUTE_TYPE = "@type";
    public static final String ATTRIBUTE_SIZE = "@size";
    public static final String ATTRIBUTE_FIELDS = "@fields";
    public static final String ATTRIBUTE_RAW = "@raw";

    public static void sort(List<? extends OIdentifiable> ioResultSet, List<OPair<String, String>> iOrderCriteria, OCommandContext context) {
        if (ioResultSet != null) {
            Collections.sort(ioResultSet, new ODocumentComparator(iOrderCriteria, context));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static <RET> RET convertField(ODocument iDocument, String iFieldName, OType type, Class<?> iFieldType, Object iValue) {
        if (iFieldType == null && type != null) {
            iFieldType = type.getDefaultJavaType();
        }
        if (iFieldType == null) {
            return (RET)iValue;
        }
        if (ORID.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
            if (iValue instanceof ORecord) {
                return (RET)((ORecord)iValue).getIdentity();
            }
        } else if (OIdentifiable.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof ORID || iValue instanceof ORecord) {
                return (RET)iValue;
            }
            if (iValue instanceof String) {
                return (RET)new ORecordId((String)iValue);
            }
        } else if (Set.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof Set) return (RET)iValue;
            AbstractCollection newValue = type.isLink() ? new ORecordLazySet(iDocument) : new OTrackedSet(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.isEmpty()) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
            if (OMultiValue.isMultiValue(iValue)) {
                for (Object s : OMultiValue.getMultiValueIterable(iValue, false)) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
        } else if (List.class.isAssignableFrom(iFieldType)) {
            if (iValue instanceof List) return (RET)iValue;
            OTrackedList newValue = type.isLink() ? new ORecordLazyList(iDocument) : new OTrackedList(iDocument);
            if (iValue instanceof Collection) {
                newValue.addAll((Collection)iValue);
                return (RET)newValue;
            }
            if (iValue instanceof Map) {
                newValue.addAll(((Map)iValue).values());
                return (RET)newValue;
            }
            if (iValue instanceof String) {
                String[] items;
                String stringValue = (String)iValue;
                if (stringValue == null || stringValue.isEmpty()) return (RET)newValue;
                for (String s : items = stringValue.split(",")) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
            if (OMultiValue.isMultiValue(iValue)) {
                for (Object s : OMultiValue.getMultiValueIterable(iValue)) {
                    newValue.add(s);
                }
                return (RET)newValue;
            }
        } else if (iValue instanceof Enum) {
            iValue = Number.class.isAssignableFrom(iFieldType) ? Integer.valueOf(((Enum)iValue).ordinal()) : iValue.toString();
            if (!(iValue instanceof String) && !iFieldType.isAssignableFrom(iValue.getClass())) {
                throw new IllegalArgumentException("Property '" + iFieldName + "' of type '" + iFieldType + "' cannot accept value of type: " + iValue.getClass());
            }
        } else if (Date.class.isAssignableFrom(iFieldType) && iValue instanceof String && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            OStorageConfiguration config = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration();
            SimpleDateFormat formatter = config.getDateFormatInstance();
            if (((String)iValue).length() > config.dateFormat.length()) {
                formatter = config.getDateTimeFormatInstance();
            }
            try {
                Date newValue = formatter.parse((String)iValue);
                return (RET)newValue;
            }
            catch (ParseException pe) {
                String dateFormat = ((String)iValue).length() > config.dateFormat.length() ? config.dateTimeFormat : config.dateFormat;
                throw OException.wrapException(new OQueryParsingException("Error on conversion of date '" + iValue + "' using the format: " + dateFormat), pe);
            }
        }
        iValue = OType.convert(iValue, iFieldType);
        return (RET)iValue;
    }

    public static <RET> RET getFieldValue(Object value, String iFieldName) {
        return ODocumentHelper.getFieldValue(value, iFieldName, null);
    }

    public static <RET> RET getFieldValue(Object value, String iFieldName, OCommandContext iContext) {
        if (value == null) {
            return null;
        }
        int fieldNameLength = iFieldName.length();
        if (fieldNameLength == 0) {
            return (RET)value;
        }
        OIdentifiable currentRecord = value instanceof OIdentifiable ? (OIdentifiable)value : null;
        int beginPos = iFieldName.charAt(0) == '.' ? 1 : 0;
        int nextSeparatorPos = iFieldName.charAt(0) == '.' ? 1 : 0;
        boolean firstInChain = true;
        do {
            String fieldName;
            int nextSeparator = 32;
            while (nextSeparatorPos < fieldNameLength && (nextSeparator = (int)iFieldName.charAt(nextSeparatorPos)) != 46 && nextSeparator != 91) {
                ++nextSeparatorPos;
            }
            if (nextSeparatorPos < fieldNameLength) {
                fieldName = iFieldName.substring(beginPos, nextSeparatorPos);
            } else {
                nextSeparator = 32;
                fieldName = beginPos > 0 ? iFieldName.substring(beginPos) : iFieldName;
            }
            if (nextSeparator == 91) {
                int i;
                int end;
                if (fieldName != null && fieldName.length() > 0) {
                    if (currentRecord != null) {
                        value = ODocumentHelper.getIdentifiableValue(currentRecord, fieldName);
                    } else if (value instanceof Map) {
                        value = ODocumentHelper.getMapEntry((Map)value, fieldName);
                    } else if (OMultiValue.isMultiValue(value)) {
                        LinkedHashSet temp = new LinkedHashSet();
                        for (Object o : OMultiValue.getMultiValueIterable(value, false)) {
                            RET r;
                            if (!(o instanceof OIdentifiable) || (r = ODocumentHelper.getFieldValue(o, iFieldName)) == null) continue;
                            OMultiValue.add(temp, r);
                        }
                        value = temp;
                    }
                }
                if (value == null) {
                    return null;
                }
                if (value instanceof OIdentifiable) {
                    currentRecord = (OIdentifiable)value;
                }
                if ((end = ODocumentHelper.findClosingBracketPosition(iFieldName, nextSeparatorPos)) == -1) {
                    throw new IllegalArgumentException("Missed closed ']'");
                }
                String indexPart = iFieldName.substring(nextSeparatorPos + 1, end);
                if (indexPart.length() == 0) {
                    return null;
                }
                nextSeparatorPos = end;
                if (value instanceof OCommandContext) {
                    value = ((OCommandContext)value).getVariables();
                }
                if (value instanceof OIdentifiable) {
                    boolean backtick;
                    Object record;
                    Object v0 = record = currentRecord != null && currentRecord instanceof OIdentifiable ? currentRecord.getRecord() : null;
                    if (indexPart.startsWith("`") && indexPart.endsWith("`")) {
                        indexPart = OIOUtils.getStringContent(indexPart);
                        backtick = true;
                    } else {
                        backtick = false;
                    }
                    Object index = ODocumentHelper.getIndexPart(iContext, indexPart);
                    String indexAsString = index != null ? index.toString() : null;
                    List<String> indexParts = OStringSerializerHelper.smartSplit(indexAsString, ',', OStringSerializerHelper.DEFAULT_IGNORE_CHARS);
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(indexAsString, '-', ' ');
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(indexAsString, '=', ' ');
                    if (backtick || indexParts.size() == 1 && indexCondition.size() == 1 && indexRanges.size() == 1) {
                        value = ((ODocument)record).field(indexAsString);
                    } else if (indexParts.size() > 1) {
                        Object[] values = new Object[indexParts.size()];
                        for (i = 0; i < indexParts.size(); ++i) {
                            values[i] = ((ODocument)record).field(OIOUtils.getStringContent(indexParts.get(i)));
                        }
                        value = values;
                    } else if (indexRanges.size() > 1) {
                        String from = indexRanges.get(0);
                        String to = indexRanges.get(1);
                        ODocument doc = record;
                        String[] fieldNames = doc.fieldNames();
                        int rangeFrom = from != null && !from.isEmpty() ? Integer.parseInt(from) : 0;
                        int rangeTo = to != null && !to.isEmpty() ? Math.min(Integer.parseInt(to), fieldNames.length - 1) : fieldNames.length - 1;
                        Object[] values = new Object[rangeTo - rangeFrom + 1];
                        for (int i2 = rangeFrom; i2 <= rangeTo; ++i2) {
                            values[i2 - rangeFrom] = doc.field(fieldNames[i2]);
                        }
                        value = values;
                    } else if (!indexCondition.isEmpty()) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OIOUtils.getStringContent(conditionFieldValue);
                        }
                        RET fieldValue = ODocumentHelper.getFieldValue(currentRecord, conditionFieldName);
                        if (conditionFieldValue != null && fieldValue != null) {
                            conditionFieldValue = OType.convert(conditionFieldValue, fieldValue.getClass());
                        }
                        if (fieldValue == null && !conditionFieldValue.equals("null") || fieldValue != null && !fieldValue.equals(conditionFieldValue)) {
                            value = null;
                        }
                    }
                } else if (value instanceof Map) {
                    boolean backtick;
                    if (indexPart.startsWith("`") && indexPart.endsWith("`")) {
                        indexPart = OIOUtils.getStringContent(indexPart);
                        backtick = true;
                    } else {
                        backtick = false;
                    }
                    Object index = ODocumentHelper.getIndexPart(iContext, indexPart);
                    String indexAsString = index != null ? index.toString() : null;
                    List<String> indexParts = OStringSerializerHelper.smartSplit(indexAsString, ',', OStringSerializerHelper.DEFAULT_IGNORE_CHARS);
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(indexAsString, '-', ' ');
                    if (!ODocumentHelper.allIntegers(indexRanges)) {
                        indexRanges.clear();
                        indexRanges.add(indexAsString);
                    }
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(indexAsString, '=', ' ');
                    Map map = (Map)value;
                    if (backtick || indexParts.size() == 1 && indexCondition.size() == 1 && indexRanges.size() == 1) {
                        value = map.get(index);
                    } else if (indexParts.size() > 1) {
                        Object[] values = new Object[indexParts.size()];
                        for (i = 0; i < indexParts.size(); ++i) {
                            values[i] = map.get(OIOUtils.getStringContent(indexParts.get(i)));
                        }
                        value = values;
                    } else if (indexRanges.size() > 1) {
                        String from = indexRanges.get(0);
                        String to = indexRanges.get(1);
                        ArrayList fieldNames = new ArrayList(map.keySet());
                        int rangeFrom = from != null && !from.isEmpty() ? Integer.parseInt(from) : 0;
                        int rangeTo = to != null && !to.isEmpty() ? Math.min(Integer.parseInt(to), fieldNames.size() - 1) : fieldNames.size() - 1;
                        Object[] values = new Object[rangeTo - rangeFrom + 1];
                        for (int i3 = rangeFrom; i3 <= rangeTo; ++i3) {
                            values[i3 - rangeFrom] = map.get(fieldNames.get(i3));
                        }
                        value = values;
                    } else if (!indexCondition.isEmpty()) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OIOUtils.getStringContent(conditionFieldValue);
                        }
                        Object fieldValue = map.get(conditionFieldName);
                        if (conditionFieldValue != null && fieldValue != null) {
                            conditionFieldValue = OType.convert(conditionFieldValue, fieldValue.getClass());
                        }
                        if (fieldValue == null && !conditionFieldValue.equals("null") || fieldValue != null && !fieldValue.equals(conditionFieldValue)) {
                            value = null;
                        }
                    }
                } else if (OMultiValue.isMultiValue(value)) {
                    Object index = ODocumentHelper.getIndexPart(iContext, indexPart);
                    String indexAsString = index != null ? index.toString() : null;
                    List<String> indexParts = OStringSerializerHelper.smartSplit(indexAsString, ',', new char[0]);
                    List<String> indexRanges = OStringSerializerHelper.smartSplit(indexAsString, '-', new char[0]);
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(indexAsString, '=', ' ');
                    if (ODocumentHelper.isFieldName(indexAsString)) {
                        value = value instanceof Map ? ODocumentHelper.getMapEntry((Map)value, index) : (Character.isDigit(indexAsString.charAt(0)) ? OMultiValue.getValue(value, Integer.parseInt(indexAsString)) : ODocumentHelper.getFieldValue(value, indexAsString, iContext));
                    } else if (ODocumentHelper.isListOfNumbers(indexParts)) {
                        Object[] values = new Object[indexParts.size()];
                        for (int i4 = 0; i4 < indexParts.size(); ++i4) {
                            values[i4] = OMultiValue.getValue(value, Integer.parseInt(indexParts.get(i4)));
                        }
                        value = indexParts.size() > 1 ? values : values[0];
                    } else if (ODocumentHelper.isListOfNumbers(indexRanges)) {
                        int rangeFrom;
                        String from = indexRanges.get(0);
                        String to = indexRanges.get(1);
                        int rangeTo = to != null && !to.isEmpty() ? Math.min(Integer.parseInt(to), OMultiValue.getSize(value) - 1) : OMultiValue.getSize(value) - 1;
                        int arraySize = rangeTo - (rangeFrom = from != null && !from.isEmpty() ? Integer.parseInt(from) : 0) + 1;
                        if (arraySize < 0) {
                            arraySize = 0;
                        }
                        Object[] values = new Object[arraySize];
                        for (int i5 = rangeFrom; i5 <= rangeTo; ++i5) {
                            values[i5 - rangeFrom] = OMultiValue.getValue(value, i5);
                        }
                        value = values;
                    } else {
                        OSQLPredicate pred = new OSQLPredicate(indexAsString);
                        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
                        for (Object v : OMultiValue.getMultiValueIterable(value)) {
                            Object result;
                            if (!(v instanceof OIdentifiable) || !Boolean.TRUE.equals(result = pred.evaluate((OIdentifiable)v, (ODocument)((OIdentifiable)v).getRecord(), iContext))) continue;
                            values.add(v);
                        }
                        value = values.isEmpty() ? values : (values.size() == 1 ? values.iterator().next() : values);
                    }
                }
            } else {
                if (fieldName.length() == 0) {
                    beginPos = ++nextSeparatorPos;
                    continue;
                }
                if (fieldName.startsWith("$")) {
                    value = iContext.getVariable(fieldName);
                } else if (fieldName.contains("(")) {
                    boolean executedMethod = false;
                    if (!firstInChain && fieldName.endsWith("()")) {
                        OSQLEngine.getInstance();
                        OSQLMethod method = OSQLEngine.getMethod(fieldName.substring(0, fieldName.length() - 2));
                        if (method != null) {
                            value = method.execute(value, currentRecord, iContext, value, new Object[0]);
                            executedMethod = true;
                        }
                    }
                    if (!executedMethod) {
                        value = ODocumentHelper.evaluateFunction(value, fieldName, iContext);
                    }
                } else {
                    List<String> indexCondition = OStringSerializerHelper.smartSplit(fieldName, '=', ' ');
                    if (indexCondition.size() == 2) {
                        String conditionFieldName = indexCondition.get(0);
                        Object conditionFieldValue = ORecordSerializerStringAbstract.getTypeValue(indexCondition.get(1));
                        if (conditionFieldValue instanceof String) {
                            conditionFieldValue = OIOUtils.getStringContent(conditionFieldValue);
                        }
                        value = ODocumentHelper.filterItem(conditionFieldName, conditionFieldValue, value);
                    } else if (currentRecord != null) {
                        value = ODocumentHelper.getIdentifiableValue(currentRecord, fieldName);
                        if (value != null && value instanceof ORecord && ((ORecord)value).getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                            ((ORecord)value).reload();
                        }
                    } else if (value instanceof Map) {
                        value = ODocumentHelper.getMapEntry((Map)value, fieldName);
                    } else if (OMultiValue.isMultiValue(value)) {
                        LinkedHashSet<Object> values = new LinkedHashSet<Object>();
                        for (Object v : OMultiValue.getMultiValueIterable(value, false)) {
                            Object item = v instanceof OIdentifiable ? ODocumentHelper.getIdentifiableValue((OIdentifiable)v, fieldName) : (v instanceof Map ? ((Map)v).get(fieldName) : null);
                            if (item == null) continue;
                            if (item instanceof Collection) {
                                values.addAll((Collection)item);
                                continue;
                            }
                            values.add(item);
                        }
                        value = values.isEmpty() ? null : values;
                    } else {
                        return null;
                    }
                }
            }
            currentRecord = value instanceof OIdentifiable ? (OIdentifiable)value : null;
            beginPos = ++nextSeparatorPos;
            firstInChain = false;
        } while (nextSeparatorPos < fieldNameLength && value != null);
        return (RET)value;
    }

    private static boolean allIntegers(List<String> indexRanges) {
        if (indexRanges == null) {
            return true;
        }
        for (String s : indexRanges) {
            try {
                Integer.parseInt(s);
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    private static int findClosingBracketPosition(String iFieldName, int nextSeparatorPos) {
        Character currentQuote = null;
        boolean escaping = false;
        int innerBrackets = 0;
        char[] chars = iFieldName.toCharArray();
        for (int i = nextSeparatorPos + 1; i < chars.length; ++i) {
            char next = chars[i];
            if (escaping) {
                escaping = false;
                continue;
            }
            if (next == '\\') {
                escaping = true;
                continue;
            }
            if (next == '`' || next == '\'' || next == '\"') {
                if (currentQuote == null) {
                    currentQuote = Character.valueOf(next);
                    continue;
                }
                if (currentQuote.charValue() != next) continue;
                currentQuote = null;
                continue;
            }
            if (next == '[') {
                ++innerBrackets;
                continue;
            }
            if (next != ']') continue;
            if (innerBrackets == 0) {
                return i;
            }
            --innerBrackets;
        }
        return -1;
    }

    private static boolean isFieldName(String indexAsString) {
        if ((indexAsString = indexAsString.trim()).startsWith("`") && indexAsString.endsWith("`")) {
            return !indexAsString.substring(1, indexAsString.length() - 1).contains("`");
        }
        boolean firstChar = true;
        for (char c : indexAsString.toCharArray()) {
            if (!(ODocumentHelper.isLetter(c) || ODocumentHelper.isNumber(c) && !firstChar)) {
                return false;
            }
            firstChar = false;
        }
        return true;
    }

    private static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLetter(char c) {
        if (c == '$' || c == '_' || c == '@') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c >= 'A' && c <= 'Z';
    }

    private static boolean isListOfNumbers(List<String> list) {
        for (String s : list) {
            try {
                Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    protected static Object getIndexPart(OCommandContext iContext, String indexPart) {
        Object index = indexPart;
        if (indexPart.indexOf(44) == -1 && (indexPart.charAt(0) == '\"' || indexPart.charAt(0) == '\'')) {
            index = OIOUtils.getStringContent(indexPart);
        } else if (indexPart.charAt(0) == '$') {
            Object ctxValue = iContext.getVariable(indexPart);
            if (ctxValue == null) {
                return null;
            }
            index = ctxValue;
        } else if (!Character.isDigit(indexPart.charAt(0))) {
            index = indexPart;
        }
        return index;
    }

    protected static Object filterItem(String iConditionFieldName, Object iConditionFieldValue, Object iValue) {
        if (iValue instanceof OIdentifiable) {
            Object rec = ((OIdentifiable)iValue).getRecord();
            if (rec instanceof ODocument) {
                ODocument doc = (ODocument)rec;
                Object fieldValue = doc.field(iConditionFieldName);
                if (iConditionFieldValue == null) {
                    return fieldValue == null ? doc : null;
                }
                if ((fieldValue = OType.convert(fieldValue, iConditionFieldValue.getClass())) != null && fieldValue.equals(iConditionFieldValue)) {
                    return doc;
                }
            }
        } else if (iValue instanceof Map) {
            Map map = (Map)iValue;
            Object fieldValue = ODocumentHelper.getMapEntry(map, iConditionFieldName);
            if ((fieldValue = OType.convert(fieldValue, iConditionFieldValue.getClass())) != null && fieldValue.equals(iConditionFieldValue)) {
                return map;
            }
        }
        return null;
    }

    public static Object getMapEntry(Map<String, ?> iMap, Object iKey) {
        if (iMap == null || iKey == null) {
            return null;
        }
        if (iKey instanceof String) {
            Object value;
            String iName = (String)iKey;
            int pos = iName.indexOf(46);
            if (pos > -1) {
                iName = iName.substring(0, pos);
            }
            if ((value = iMap.get(iName)) == null) {
                return null;
            }
            if (pos > -1) {
                String restFieldName = iName.substring(pos + 1);
                if (value instanceof ODocument) {
                    return ODocumentHelper.getFieldValue(value, restFieldName);
                }
                if (value instanceof Map) {
                    return ODocumentHelper.getMapEntry((Map)value, restFieldName);
                }
            }
            return value;
        }
        return iMap.get(iKey);
    }

    public static Object getIdentifiableValue(OIdentifiable iCurrent, String iFieldName) {
        if (iFieldName == null || iFieldName.length() == 0) {
            return null;
        }
        char begin = iFieldName.charAt(0);
        if (begin == '@') {
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_THIS)) {
                return iCurrent.getRecord();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID)) {
                return iCurrent.getIdentity();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID_ID)) {
                return iCurrent.getIdentity().getClusterId();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RID_POS)) {
                return iCurrent.getIdentity().getClusterPosition();
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_VERSION)) {
                Object rec = iCurrent.getRecord();
                if (rec != null) {
                    return rec.getVersion();
                }
                return null;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_CLASS)) {
                ODocument rec = (ODocument)iCurrent.getRecord();
                if (rec != null) {
                    return rec.getClassName();
                }
                return null;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_TYPE)) {
                Object rec = iCurrent.getRecord();
                if (rec != null) {
                    return Orient.instance().getRecordFactoryManager().getRecordTypeName(ORecordInternal.getRecordType(rec));
                }
                return null;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_SIZE)) {
                Object rec = iCurrent.getRecord();
                if (rec != null) {
                    byte[] stream = rec.toStream();
                    return stream != null ? stream.length : 0;
                }
                return null;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_FIELDS)) {
                ODocument rec = (ODocument)iCurrent.getRecord();
                if (rec != null) {
                    return rec.fieldNames();
                }
                return null;
            }
            if (iFieldName.equalsIgnoreCase(ATTRIBUTE_RAW)) {
                ODocument rec = (ODocument)iCurrent.getRecord();
                if (rec != null) {
                    return new String(rec.toStream());
                }
                return null;
            }
        }
        if (iCurrent == null) {
            return null;
        }
        ODocument doc = (ODocument)iCurrent.getRecord();
        if (doc == null) {
            return null;
        }
        doc.checkForFields(iFieldName);
        ODocumentEntry entry = doc._fields.get(iFieldName);
        return entry != null ? entry.value : null;
    }

    public static Object evaluateFunction(Object currentValue, String iFunction, OCommandContext iContext) {
        if (currentValue == null) {
            return null;
        }
        Object result = null;
        String function = iFunction.toUpperCase();
        if (function.startsWith("SIZE(")) {
            result = currentValue instanceof ORecord ? 1 : OMultiValue.getSize(currentValue);
        } else if (function.startsWith("LENGTH(")) {
            result = currentValue.toString().length();
        } else if (function.startsWith("TOUPPERCASE(")) {
            result = currentValue.toString().toUpperCase();
        } else if (function.startsWith("TOLOWERCASE(")) {
            result = currentValue.toString().toLowerCase();
        } else if (function.startsWith("TRIM(")) {
            result = currentValue.toString().trim();
        } else if (function.startsWith("TOJSON(")) {
            result = currentValue instanceof ODocument ? ((ODocument)currentValue).toJSON() : null;
        } else if (function.startsWith("KEYS(")) {
            result = currentValue instanceof Map ? ((Map)currentValue).keySet() : null;
        } else if (function.startsWith("VALUES(")) {
            result = currentValue instanceof Map ? ((Map)currentValue).values() : null;
        } else if (function.startsWith("ASSTRING(")) {
            result = currentValue.toString();
        } else if (function.startsWith("ASINTEGER(")) {
            result = new Integer(currentValue.toString());
        } else if (function.startsWith("ASFLOAT(")) {
            result = new Float(currentValue.toString());
        } else if (function.startsWith("ASBOOLEAN(")) {
            if (currentValue instanceof String) {
                result = new Boolean((String)currentValue);
            } else if (currentValue instanceof Number) {
                int bValue = ((Number)currentValue).intValue();
                if (bValue == 0) {
                    result = Boolean.FALSE;
                } else if (bValue == 1) {
                    result = Boolean.TRUE;
                }
            }
        } else if (function.startsWith("ASDATE(")) {
            if (currentValue instanceof Date) {
                result = currentValue;
            } else if (currentValue instanceof Number) {
                result = new Date(((Number)currentValue).longValue());
            } else {
                try {
                    result = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateFormatInstance().parse(currentValue.toString());
                }
                catch (ParseException bValue) {}
            }
        } else if (function.startsWith("ASDATETIME(")) {
            if (currentValue instanceof Date) {
                result = currentValue;
            } else if (currentValue instanceof Number) {
                result = new Date(((Number)currentValue).longValue());
            } else {
                try {
                    result = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().getDateTimeFormatInstance().parse(currentValue.toString());
                }
                catch (ParseException bValue) {}
            }
        } else {
            String stringValue;
            List<String> args = OStringSerializerHelper.getParameters(iFunction.substring(iFunction.indexOf(40)));
            ORecord currentRecord = iContext != null ? (ORecord)iContext.getVariable("$current") : null;
            for (int i = 0; i < args.size(); ++i) {
                String arg = args.get(i);
                Object o = OSQLHelper.getValue(arg, currentRecord, iContext);
                if (o == null) continue;
                args.set(i, o.toString());
            }
            if (function.startsWith("CHARAT(")) {
                result = Character.valueOf(currentValue.toString().charAt(Integer.parseInt(args.get(0))));
            } else if (function.startsWith("INDEXOF(")) {
                result = args.size() == 1 ? Integer.valueOf(currentValue.toString().indexOf(OIOUtils.getStringContent(args.get(0)))) : Integer.valueOf(currentValue.toString().indexOf(OIOUtils.getStringContent(args.get(0)), Integer.parseInt(args.get(1))));
            } else if (function.startsWith("SUBSTRING(")) {
                result = args.size() == 1 ? currentValue.toString().substring(Integer.parseInt(args.get(0))) : currentValue.toString().substring(Integer.parseInt(args.get(0)), Integer.parseInt(args.get(1)));
            } else if (function.startsWith("APPEND(")) {
                result = currentValue.toString() + OIOUtils.getStringContent(args.get(0));
            } else if (function.startsWith("PREFIX(")) {
                result = OIOUtils.getStringContent(args.get(0)) + currentValue.toString();
            } else if (function.startsWith("FORMAT(")) {
                if (currentValue instanceof Date) {
                    SimpleDateFormat formatter = new SimpleDateFormat(OIOUtils.getStringContent(args.get(0)));
                    formatter.setTimeZone(ODateHelper.getDatabaseTimeZone());
                    result = formatter.format(currentValue);
                } else {
                    result = String.format(OIOUtils.getStringContent(args.get(0)), currentValue.toString());
                }
            } else if (function.startsWith("LEFT(")) {
                int len = Integer.parseInt(args.get(0));
                result = stringValue.substring(0, len <= (stringValue = currentValue.toString()).length() ? len : stringValue.length());
            } else if (function.startsWith("RIGHT(")) {
                int offset = Integer.parseInt(args.get(0));
                result = stringValue.substring(offset < (stringValue = currentValue.toString()).length() ? stringValue.length() - offset : 0);
            } else {
                OSQLFunctionRuntime f = OSQLHelper.getFunction(null, iFunction);
                if (f != null) {
                    result = f.execute(currentRecord, currentRecord, null, iContext);
                }
            }
        }
        return result;
    }

    public static Object cloneValue(ODocument iCloned, Object fieldValue) {
        if (fieldValue != null) {
            if (fieldValue instanceof ODocument && !((ODocument)fieldValue).getIdentity().isValid()) {
                return ((ODocument)fieldValue).copy();
            }
            if (fieldValue instanceof ORidBag) {
                ORidBag newBag = ((ORidBag)fieldValue).copy();
                newBag.setOwner(iCloned);
                return newBag;
            }
            if (fieldValue instanceof ORecordLazyList) {
                return ((ORecordLazyList)fieldValue).copy(iCloned);
            }
            if (fieldValue instanceof ORecordTrackedList) {
                ORecordTrackedList newList = new ORecordTrackedList(iCloned);
                newList.addAll((ORecordTrackedList)fieldValue);
                return newList;
            }
            if (fieldValue instanceof OTrackedList) {
                OTrackedList newList = new OTrackedList(iCloned);
                newList.addAll((OTrackedList)fieldValue);
                return newList;
            }
            if (fieldValue instanceof List) {
                return new ArrayList((List)fieldValue);
            }
            if (fieldValue instanceof ORecordLazySet) {
                ORecordLazySet newList = new ORecordLazySet(iCloned);
                newList.addAll((ORecordLazySet)fieldValue);
                return newList;
            }
            if (fieldValue instanceof ORecordTrackedSet) {
                ORecordTrackedSet newList = new ORecordTrackedSet(iCloned);
                newList.addAll((ORecordTrackedSet)fieldValue);
                return newList;
            }
            if (fieldValue instanceof OTrackedSet) {
                OTrackedSet newList = new OTrackedSet(iCloned);
                newList.addAll((OTrackedSet)fieldValue);
                return newList;
            }
            if (fieldValue instanceof Set) {
                return new HashSet((Set)fieldValue);
            }
            if (fieldValue instanceof ORecordLazyMap) {
                ORecordLazyMap newMap = new ORecordLazyMap(iCloned, ((ORecordLazyMap)fieldValue).getRecordType());
                newMap.putAll((ORecordLazyMap)fieldValue);
                return newMap;
            }
            if (fieldValue instanceof OTrackedMap) {
                OTrackedMap newMap = new OTrackedMap(iCloned);
                newMap.putAll((OTrackedMap)fieldValue);
                return newMap;
            }
            if (fieldValue instanceof Map) {
                return new LinkedHashMap((Map)fieldValue);
            }
            return fieldValue;
        }
        return null;
    }

    public static boolean hasSameContentItem(Object iCurrent, ODatabaseDocumentInternal iMyDb, Object iOther, ODatabaseDocumentInternal iOtherDb, RIDMapper ridMapper) {
        if (iCurrent instanceof ODocument) {
            ODocument current = (ODocument)iCurrent;
            if (iOther instanceof ORID) {
                if (!current.isDirty()) {
                    ORID mappedId;
                    ORID id = ridMapper != null ? ((mappedId = ridMapper.map(current.getIdentity())) != null ? mappedId : current.getIdentity()) : current.getIdentity();
                    if (!id.equals(iOther)) {
                        return false;
                    }
                } else {
                    ODocument otherDoc = (ODocument)iOtherDb.load((ORID)iOther);
                    if (!ODocumentHelper.hasSameContentOf(current, iMyDb, otherDoc, iOtherDb, ridMapper)) {
                        return false;
                    }
                }
            } else if (!ODocumentHelper.hasSameContentOf(current, iMyDb, (ODocument)iOther, iOtherDb, ridMapper)) {
                return false;
            }
        } else if (!ODocumentHelper.compareScalarValues(iCurrent, iMyDb, iOther, iOtherDb, ridMapper)) {
            return false;
        }
        return true;
    }

    public static boolean hasSameContentOf(ODocument iCurrent, ODatabaseDocumentInternal iMyDb, ODocument iOther, ODatabaseDocumentInternal iOtherDb, RIDMapper ridMapper) {
        return ODocumentHelper.hasSameContentOf(iCurrent, iMyDb, iOther, iOtherDb, ridMapper, true);
    }

    public static boolean hasSameContentOf(final ODocument iCurrent, ODatabaseDocumentInternal iMyDb, final ODocument iOther, ODatabaseDocumentInternal iOtherDb, RIDMapper ridMapper, boolean iCheckAlsoIdentity) {
        if (iOther == null) {
            return false;
        }
        if (iCheckAlsoIdentity && iCurrent.getIdentity().isValid() && !iCurrent.getIdentity().equals(iOther.getIdentity())) {
            return false;
        }
        if (iMyDb != null) {
            ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call(ODatabaseDocumentInternal database) {
                    if (iCurrent.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                        iCurrent.reload();
                    }
                    return null;
                }
            });
        }
        if (iOtherDb != null) {
            ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call(ODatabaseDocumentInternal database) {
                    if (iOther.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                        iOther.reload();
                    }
                    return null;
                }
            });
        }
        if (iMyDb != null) {
            ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call(ODatabaseDocumentInternal database) {
                    iCurrent.checkForFields(new String[0]);
                    return null;
                }
            });
        } else {
            iCurrent.checkForFields(new String[0]);
        }
        if (iOtherDb != null) {
            ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                @Override
                public Object call(ODatabaseDocumentInternal database) {
                    iOther.checkForFields(new String[0]);
                    return null;
                }
            });
        } else {
            iOther.checkForFields(new String[0]);
        }
        if (iCurrent.fields() != iOther.fields()) {
            return false;
        }
        for (Map.Entry<String, Object> f : iCurrent) {
            Object otherFieldValue;
            Object myFieldValue = f.getValue();
            if (myFieldValue == (otherFieldValue = iOther._fields.get((Object)f.getKey()).value)) continue;
            if (myFieldValue == null ? otherFieldValue != null : otherFieldValue == null) {
                return false;
            }
            if (myFieldValue == null || !(myFieldValue instanceof Set && otherFieldValue instanceof Set ? !ODocumentHelper.compareSets(iMyDb, (Set)myFieldValue, iOtherDb, (Set)otherFieldValue, ridMapper) : (myFieldValue instanceof Collection && otherFieldValue instanceof Collection ? !ODocumentHelper.compareCollections(iMyDb, (Collection)myFieldValue, iOtherDb, (Collection)otherFieldValue, ridMapper) : (myFieldValue instanceof ORidBag && otherFieldValue instanceof ORidBag ? !ODocumentHelper.compareBags(iMyDb, (ORidBag)myFieldValue, iOtherDb, (ORidBag)otherFieldValue, ridMapper) : (myFieldValue instanceof Map && otherFieldValue instanceof Map ? !ODocumentHelper.compareMaps(iMyDb, (Map)myFieldValue, iOtherDb, (Map)otherFieldValue, ridMapper) : (myFieldValue instanceof ODocument && otherFieldValue instanceof ODocument ? !ODocumentHelper.hasSameContentOf((ODocument)myFieldValue, iMyDb, (ODocument)otherFieldValue, iOtherDb, ridMapper) : !ODocumentHelper.compareScalarValues(myFieldValue, iMyDb, otherFieldValue, iOtherDb, ridMapper))))))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareMaps(ODatabaseDocumentInternal iMyDb, Map<Object, Object> myFieldValue, ODatabaseDocumentInternal iOtherDb, Map<Object, Object> otherFieldValue, RIDMapper ridMapper) {
        final Map<Object, Object> myMap = myFieldValue;
        final Map<Object, Object> otherMap = otherFieldValue;
        if (myMap.size() != otherMap.size()) {
            return false;
        }
        boolean oldMyAutoConvert = false;
        boolean oldOtherAutoConvert = false;
        if (myMap instanceof ORecordLazyMultiValue) {
            oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)myMap)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(false);
        }
        if (otherMap instanceof ORecordLazyMultiValue) {
            oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherMap)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(false);
        }
        try {
            final Iterator<Map.Entry<Object, Object>> myEntryIterator = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<Map.Entry<Object, Object>>>(){

                @Override
                public Iterator<Map.Entry<Object, Object>> call(ODatabaseDocumentInternal database) {
                    return myMap.entrySet().iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call(ODatabaseDocumentInternal database) {
                    return myEntryIterator.hasNext();
                }
            }).booleanValue()) {
                Object otherValue;
                final Map.Entry<Object, Object> myEntry = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Map.Entry<Object, Object>>(){

                    @Override
                    public Map.Entry<Object, Object> call(ODatabaseDocumentInternal database) {
                        return (Map.Entry)myEntryIterator.next();
                    }
                });
                final Object myKey = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call(ODatabaseDocumentInternal database) {
                        return myEntry.getKey();
                    }
                });
                if (ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                    @Override
                    public Boolean call(ODatabaseDocumentInternal database) {
                        return !otherMap.containsKey(myKey);
                    }
                }).booleanValue()) {
                    boolean bl = false;
                    return bl;
                }
                if (myEntry.getValue() instanceof ODocument) {
                    if (ODocumentHelper.hasSameContentOf(ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<ODocument>(){

                        @Override
                        public ODocument call(ODatabaseDocumentInternal database) {
                            return (ODocument)myEntry.getValue();
                        }
                    }), iMyDb, ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<ODocument>(){

                        @Override
                        public ODocument call(ODatabaseDocumentInternal database) {
                            return (ODocument)otherMap.get(myEntry.getKey());
                        }
                    }), iOtherDb, ridMapper)) continue;
                    boolean bl = false;
                    return bl;
                }
                Object myValue = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call(ODatabaseDocumentInternal database) {
                        return myEntry.getValue();
                    }
                });
                if (ODocumentHelper.compareScalarValues(myValue, iMyDb, otherValue = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call(ODatabaseDocumentInternal database) {
                        return otherMap.get(myEntry.getKey());
                    }
                }), iOtherDb, ridMapper)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (myMap instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)myMap)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (otherMap instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)otherMap)).setAutoConvertToRecord(oldOtherAutoConvert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareCollections(ODatabaseDocumentInternal iMyDb, Collection<?> myFieldValue, ODatabaseDocumentInternal iOtherDb, Collection<?> otherFieldValue, RIDMapper ridMapper) {
        final Collection<?> myCollection = myFieldValue;
        final Collection<?> otherCollection = otherFieldValue;
        if (myCollection.size() != otherCollection.size()) {
            return false;
        }
        boolean oldMyAutoConvert = false;
        boolean oldOtherAutoConvert = false;
        if (myCollection instanceof ORecordLazyMultiValue) {
            oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)myCollection)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(false);
        }
        if (otherCollection instanceof ORecordLazyMultiValue) {
            oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherCollection)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(false);
        }
        try {
            final Iterator myIterator = (Iterator)ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<?>>(){

                @Override
                public Iterator<?> call(ODatabaseDocumentInternal database) {
                    return myCollection.iterator();
                }
            });
            final Iterator otherIterator = (Iterator)ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Iterator<?>>(){

                @Override
                public Iterator<?> call(ODatabaseDocumentInternal database) {
                    return otherCollection.iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call(ODatabaseDocumentInternal database) {
                    return myIterator.hasNext();
                }
            }).booleanValue()) {
                Object otherNextVal;
                Object myNextVal = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call(ODatabaseDocumentInternal database) {
                        return myIterator.next();
                    }
                });
                if (ODocumentHelper.hasSameContentItem(myNextVal, iMyDb, otherNextVal = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call(ODatabaseDocumentInternal database) {
                        return otherIterator.next();
                    }
                }), iOtherDb, ridMapper)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (myCollection instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)myCollection)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (otherCollection instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)otherCollection)).setAutoConvertToRecord(oldOtherAutoConvert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareSets(ODatabaseDocumentInternal iMyDb, Set<?> myFieldValue, ODatabaseDocumentInternal iOtherDb, Set<?> otherFieldValue, RIDMapper ridMapper) {
        int otherSize;
        final Set<?> mySet = myFieldValue;
        final Set<?> otherSet = otherFieldValue;
        int mySize = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call(ODatabaseDocumentInternal database) {
                return mySet.size();
            }
        });
        if (mySize != (otherSize = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call(ODatabaseDocumentInternal database) {
                return otherSet.size();
            }
        }).intValue())) {
            return false;
        }
        boolean oldMyAutoConvert = false;
        boolean oldOtherAutoConvert = false;
        if (mySet instanceof ORecordLazyMultiValue) {
            oldMyAutoConvert = ((ORecordLazyMultiValue)((Object)mySet)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(false);
        }
        if (otherSet instanceof ORecordLazyMultiValue) {
            oldOtherAutoConvert = ((ORecordLazyMultiValue)((Object)otherSet)).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(false);
        }
        try {
            final Iterator myIterator = (Iterator)ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<?>>(){

                @Override
                public Iterator<?> call(ODatabaseDocumentInternal database) {
                    return mySet.iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call(ODatabaseDocumentInternal database) {
                    return myIterator.hasNext();
                }
            }).booleanValue()) {
                final Iterator otherIterator = (Iterator)ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Iterator<?>>(){

                    @Override
                    public Iterator<?> call(ODatabaseDocumentInternal database) {
                        return otherSet.iterator();
                    }
                });
                Object myNextVal = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call(ODatabaseDocumentInternal database) {
                        return myIterator.next();
                    }
                });
                boolean found = false;
                while (!found && ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                    @Override
                    public Boolean call(ODatabaseDocumentInternal database) {
                        return otherIterator.hasNext();
                    }
                }).booleanValue()) {
                    Object otherNextVal = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                        @Override
                        public Object call(ODatabaseDocumentInternal database) {
                            return otherIterator.next();
                        }
                    });
                    found = ODocumentHelper.hasSameContentItem(myNextVal, iMyDb, otherNextVal, iOtherDb, ridMapper);
                }
                if (found) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (mySet instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)mySet)).setAutoConvertToRecord(oldMyAutoConvert);
            }
            if (otherSet instanceof ORecordLazyMultiValue) {
                ((ORecordLazyMultiValue)((Object)otherSet)).setAutoConvertToRecord(oldOtherAutoConvert);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compareBags(ODatabaseDocumentInternal iMyDb, ORidBag myFieldValue, ODatabaseDocumentInternal iOtherDb, ORidBag otherFieldValue, RIDMapper ridMapper) {
        int otherSize;
        final ORidBag myBag = myFieldValue;
        final ORidBag otherBag = otherFieldValue;
        int mySize = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call(ODatabaseDocumentInternal database) {
                return myBag.size();
            }
        });
        if (mySize != (otherSize = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Integer>(){

            @Override
            public Integer call(ODatabaseDocumentInternal database) {
                return otherBag.size();
            }
        }).intValue())) {
            return false;
        }
        boolean oldMyAutoConvert = myBag.isAutoConvertToRecord();
        myBag.setAutoConvertToRecord(false);
        boolean oldOtherAutoConvert = otherBag.isAutoConvertToRecord();
        otherBag.setAutoConvertToRecord(false);
        final ORidBag otherBagCopy = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<ORidBag>(){

            @Override
            public ORidBag call(ODatabaseDocumentInternal database) {
                ORidBag otherRidBag = new ORidBag();
                otherRidBag.setAutoConvertToRecord(false);
                for (OIdentifiable identifiable : otherBag) {
                    otherRidBag.add(identifiable);
                }
                return otherRidBag;
            }
        });
        try {
            final Iterator<OIdentifiable> myIterator = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Iterator<OIdentifiable>>(){

                @Override
                public Iterator<OIdentifiable> call(ODatabaseDocumentInternal database) {
                    return myBag.iterator();
                }
            });
            while (ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call(ODatabaseDocumentInternal database) {
                    return myIterator.hasNext();
                }
            }).booleanValue()) {
                ORID convertedRid;
                OIdentifiable myIdentifiable = ODocumentHelper.makeDbCall(iMyDb, new ODbRelatedCall<OIdentifiable>(){

                    @Override
                    public OIdentifiable call(ODatabaseDocumentInternal database) {
                        return (OIdentifiable)myIterator.next();
                    }
                });
                final ORID otherRid = ridMapper != null ? ((convertedRid = ridMapper.map(myIdentifiable.getIdentity())) != null ? convertedRid : myIdentifiable.getIdentity()) : myIdentifiable.getIdentity();
                ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Object>(){

                    @Override
                    public Object call(ODatabaseDocumentInternal database) {
                        otherBagCopy.remove(otherRid);
                        return null;
                    }
                });
            }
            boolean bl = ODocumentHelper.makeDbCall(iOtherDb, new ODbRelatedCall<Boolean>(){

                @Override
                public Boolean call(ODatabaseDocumentInternal database) {
                    return otherBagCopy.isEmpty();
                }
            });
            return bl;
        }
        finally {
            myBag.setAutoConvertToRecord(oldMyAutoConvert);
            otherBag.setAutoConvertToRecord(oldOtherAutoConvert);
        }
    }

    private static boolean compareScalarValues(Object myValue, ODatabaseDocumentInternal iMyDb, Object otherValue, ODatabaseDocumentInternal iOtherDb, RIDMapper ridMapper) {
        ORID convertedValue;
        if (myValue == null && otherValue != null || myValue != null && otherValue == null) {
            return false;
        }
        if (myValue == null) {
            return true;
        }
        if (myValue.getClass().isArray() && !otherValue.getClass().isArray() || !myValue.getClass().isArray() && otherValue.getClass().isArray()) {
            return false;
        }
        if (myValue.getClass().isArray() && otherValue.getClass().isArray()) {
            int otherArraySize;
            int myArraySize = Array.getLength(myValue);
            if (myArraySize != (otherArraySize = Array.getLength(otherValue))) {
                return false;
            }
            for (int i = 0; i < myArraySize; ++i) {
                Object first = Array.get(myValue, i);
                Object second = Array.get(otherValue, i);
                if (first == null && second != null) {
                    return false;
                }
                if (first instanceof ODocument && second instanceof ODocument) {
                    return ODocumentHelper.hasSameContentOf((ODocument)first, iMyDb, (ODocument)second, iOtherDb, ridMapper);
                }
                if (first == null || first.equals(second)) continue;
                return false;
            }
            return true;
        }
        if (myValue instanceof Number && otherValue instanceof Number) {
            Number myNumberValue = (Number)myValue;
            Number otherNumberValue = (Number)otherValue;
            if (ODocumentHelper.isInteger(myNumberValue) && ODocumentHelper.isInteger(otherNumberValue)) {
                return myNumberValue.longValue() == otherNumberValue.longValue();
            }
            if (ODocumentHelper.isFloat(myNumberValue) && ODocumentHelper.isFloat(otherNumberValue)) {
                return myNumberValue.doubleValue() == otherNumberValue.doubleValue();
            }
        }
        if (ridMapper != null && myValue instanceof ORID && otherValue instanceof ORID && ((ORID)myValue).isPersistent() && (convertedValue = ridMapper.map((ORID)myValue)) != null) {
            myValue = convertedValue;
        }
        return myValue.equals(otherValue);
    }

    private static boolean isInteger(Number value) {
        return value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long;
    }

    private static boolean isFloat(Number value) {
        return value instanceof Float || value instanceof Double;
    }

    public static void deleteCrossRefs(ORID iRid, ODocument iContent) {
        for (String fieldName : iContent.fieldNames()) {
            Object fieldValue = iContent.field(fieldName);
            if (fieldValue == null) continue;
            if (fieldValue.equals(iRid)) {
                iContent.field(fieldName, (Object)null);
                iContent.save();
                continue;
            }
            if (fieldValue instanceof ODocument && ((ODocument)fieldValue).isEmbedded()) {
                ODocumentHelper.deleteCrossRefs(iRid, (ODocument)fieldValue);
                continue;
            }
            if (!OMultiValue.isMultiValue(fieldValue)) continue;
            Iterator<Object> it = OMultiValue.getMultiValueIterator(fieldValue);
            while (it.hasNext()) {
                Object item = it.next();
                if (fieldValue.equals(iRid)) {
                    it.remove();
                    continue;
                }
                if (!(item instanceof ODocument) || !((ODocument)item).isEmbedded()) continue;
                ODocumentHelper.deleteCrossRefs(iRid, (ODocument)item);
            }
        }
    }

    public static <T> T makeDbCall(ODatabaseDocumentInternal databaseRecord, ODbRelatedCall<T> function) {
        if (databaseRecord != null) {
            databaseRecord.activateOnCurrentThread();
        }
        return function.call(databaseRecord);
    }

    public static interface RIDMapper {
        public ORID map(ORID var1);
    }

    public static interface ODbRelatedCall<T> {
        public T call(ODatabaseDocumentInternal var1);
    }
}

