/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security.symmetrickey;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OCredentialInterceptor;
import com.orientechnologies.orient.core.security.symmetrickey.OSymmetricKey;

public class OSymmetricKeyCI
implements OCredentialInterceptor {
    private String username;
    private String encodedJSON = "";

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.encodedJSON;
    }

    @Override
    public void intercept(String url, String username, String password) throws OSecurityException {
        if (username == null || username.isEmpty()) {
            throw new OSecurityException("OSymmetricKeyCI username is not valid!");
        }
        if (password == null || password.isEmpty()) {
            throw new OSecurityException("OSymmetricKeyCI password is not valid!");
        }
        this.username = username;
        String algorithm = OGlobalConfiguration.CLIENT_CI_KEYALGORITHM.getValueAsString();
        String transform = OGlobalConfiguration.CLIENT_CI_CIPHERTRANSFORM.getValueAsString();
        String keystoreFile = OGlobalConfiguration.CLIENT_CI_KEYSTORE_FILE.getValueAsString();
        String keystorePassword = OGlobalConfiguration.CLIENT_CI_KEYSTORE_PASSWORD.getValueAsString();
        ODocument jsonDoc = null;
        try {
            jsonDoc = new ODocument().fromJSON(password, "noMap");
        }
        catch (Exception ex) {
            throw new OSecurityException("OSymmetricKeyCI.intercept() Exception: " + ex.getMessage());
        }
        if (jsonDoc.containsField("algorithm")) {
            algorithm = (String)jsonDoc.field("algorithm");
        }
        if (jsonDoc.containsField("transform")) {
            transform = (String)jsonDoc.field("transform");
        }
        if (transform == null || transform.isEmpty()) {
            throw new OSecurityException("OSymmetricKeyCI.intercept() cipher transformation is required");
        }
        if (algorithm == null) {
            algorithm = OSymmetricKey.separateAlgorithm(transform);
        }
        OSymmetricKey key = null;
        if (jsonDoc.containsField("key")) {
            String base64Key = (String)jsonDoc.field("key");
            key = OSymmetricKey.fromString(algorithm, base64Key);
            key.setDefaultCipherTransform(transform);
        } else if (jsonDoc.containsField("keyFile")) {
            key = OSymmetricKey.fromFile(algorithm, (String)jsonDoc.field("keyFile"));
            key.setDefaultCipherTransform(transform);
        } else if (jsonDoc.containsField("keyStore")) {
            String keyAlias;
            ODocument ksDoc = (ODocument)jsonDoc.field("keyStore");
            if (ksDoc.containsField("file")) {
                keystoreFile = (String)ksDoc.field("file");
            }
            if (keystoreFile == null || keystoreFile.isEmpty()) {
                throw new OSecurityException("OSymmetricKeyCI.intercept() keystore file is required");
            }
            if (ksDoc.containsField("password")) {
                keystorePassword = (String)ksDoc.field("password");
            }
            if ((keyAlias = (String)ksDoc.field("keyAlias")) == null || keyAlias.isEmpty()) {
                throw new OSecurityException("OSymmetricKeyCI.intercept() keystore key alias is required");
            }
            String keyPassword = (String)ksDoc.field("keyPassword");
            key = OSymmetricKey.fromKeystore(keystoreFile, keystorePassword, keyAlias, keyPassword);
            key.setDefaultCipherTransform(transform);
        } else {
            throw new OSecurityException("OSymmetricKeyCI.intercept() No suitable symmetric key property exists");
        }
        if (key == null) {
            throw new OSecurityException("OSymmetricKeyCI.intercept() OSymmetricKey is null");
        }
        this.encodedJSON = key.encrypt(transform, username);
    }
}

