/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;

public class OStorageMemoryConfiguration
extends OStorageConfiguration {
    private static final long serialVersionUID = 7001342008735208586L;
    private byte[] serializedContent;

    public OStorageMemoryConfiguration(OStorage iStorage) {
        super(iStorage, Charset.forName("UTF-8"));
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void create() throws IOException {
        super.create();
    }

    @Override
    public OStorageConfiguration load(Map<String, Object> iProperties) throws OSerializationException {
        this.initConfiguration();
        this.bindPropertiesToContext(iProperties);
        try {
            this.fromStream(this.serializedContent, 0, this.serializedContent.length, Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            throw OException.wrapException(new OSerializationException("Cannot load database configuration. The database seems corrupted"), e);
        }
        return this;
    }

    @Override
    public void lock() throws IOException {
    }

    @Override
    public void unlock() throws IOException {
    }

    @Override
    public void update() throws OSerializationException {
        try {
            this.serializedContent = this.toStream(Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            throw OException.wrapException(new OSerializationException("Error on update storage configuration"), e);
        }
    }

    @Override
    public void synch() throws IOException {
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) throws IOException {
    }
}

