/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.thread;

import com.orientechnologies.common.util.OService;
import com.orientechnologies.common.util.OUncaughtExceptionHandler;

public abstract class OSoftThread
extends Thread
implements OService {
    private volatile boolean shutdownFlag;
    private boolean dumpExceptions = true;

    public OSoftThread() {
        OSoftThread.setDefaultUncaughtExceptionHandler(new OUncaughtExceptionHandler());
    }

    public OSoftThread(ThreadGroup iThreadGroup) {
        super(iThreadGroup, OSoftThread.class.getSimpleName());
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
    }

    public OSoftThread(String name) {
        super(name);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
    }

    public OSoftThread(ThreadGroup group, String name) {
        super(group, name);
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(new OUncaughtExceptionHandler());
    }

    protected abstract void execute() throws Exception;

    @Override
    public void startup() {
    }

    @Override
    public void shutdown() {
    }

    public void sendShutdown() {
        this.shutdownFlag = true;
        this.interrupt();
    }

    public void softShutdown() {
        this.shutdownFlag = true;
    }

    public boolean isShutdownFlag() {
        return this.shutdownFlag;
    }

    @Override
    public void run() {
        this.startup();
        while (!this.shutdownFlag && !this.isInterrupted()) {
            try {
                this.beforeExecution();
                this.execute();
                this.afterExecution();
            }
            catch (Throwable t) {
                if (!this.dumpExceptions) continue;
                t.printStackTrace();
            }
        }
        this.shutdown();
    }

    public static boolean pauseCurrentThread(long iTime) {
        try {
            if (iTime <= 0L) {
                iTime = Long.MAX_VALUE;
            }
            Thread.sleep(iTime);
            return true;
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean isDumpExceptions() {
        return this.dumpExceptions;
    }

    public void setDumpExceptions(boolean dumpExceptions) {
        this.dumpExceptions = dumpExceptions;
    }

    protected void beforeExecution() throws InterruptedException {
    }

    protected void afterExecution() throws InterruptedException {
    }
}

