/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.embedded;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBagDelegate;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.UUID;

public class OEmbeddedRidBag
implements ORidBagDelegate {
    private boolean contentWasChanged = false;
    private Object[] entries = OCommonConst.EMPTY_OBJECT_ARRAY;
    private int entriesLength = 0;
    private boolean convertToRecord = true;
    private int size = 0;
    private transient ORecord owner;
    private List<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> changeListeners;

    @Override
    public ORecord getOwner() {
        return this.owner;
    }

    @Override
    public boolean contains(OIdentifiable identifiable) {
        if (identifiable == null) {
            return false;
        }
        for (int i = 0; i < this.entriesLength; ++i) {
            if (!identifiable.equals(this.entries[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setOwner(ORecord owner) {
        Object entry;
        int i;
        if (owner != null && this.owner != null && !this.owner.equals(owner)) {
            throw new IllegalStateException("This data structure is owned by document " + owner + " if you want to use it in other document create new rid bag instance and copy content of current one.");
        }
        if (this.owner != null) {
            for (i = 0; i < this.entriesLength; ++i) {
                entry = this.entries[i];
                if (!(entry instanceof OIdentifiable)) continue;
                ORecordInternal.unTrack(this.owner, (OIdentifiable)entry);
            }
        }
        this.owner = owner;
        if (this.owner != null) {
            for (i = 0; i < this.entriesLength; ++i) {
                entry = this.entries[i];
                if (!(entry instanceof OIdentifiable)) continue;
                ORecordInternal.track(this.owner, (OIdentifiable)entry);
            }
        }
    }

    @Override
    public void addAll(Collection<OIdentifiable> values) {
        for (OIdentifiable value : values) {
            this.add(value);
        }
    }

    @Override
    public void add(OIdentifiable identifiable) {
        if (identifiable == null) {
            throw new IllegalArgumentException("Impossible to add a null identifiable in a ridbag");
        }
        this.addEntry(identifiable);
        ++this.size;
        this.contentWasChanged = true;
        this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.ADD, identifiable, identifiable));
    }

    public OEmbeddedRidBag copy() {
        OEmbeddedRidBag copy = new OEmbeddedRidBag();
        copy.contentWasChanged = this.contentWasChanged;
        copy.entries = this.entries;
        copy.entriesLength = this.entriesLength;
        copy.convertToRecord = this.convertToRecord;
        copy.size = this.size;
        copy.owner = this.owner;
        if (this.changeListeners != null) {
            copy.changeListeners = new LinkedList<OMultiValueChangeListener<OIdentifiable, OIdentifiable>>(this.changeListeners);
        }
        return copy;
    }

    @Override
    public void remove(OIdentifiable identifiable) {
        if (this.removeEntry(identifiable)) {
            --this.size;
            this.contentWasChanged = true;
            if (this.owner != null) {
                ORecordInternal.unTrack(this.owner, identifiable);
            }
            this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, identifiable, null, identifiable));
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new EntriesIterator(this.convertToRecord);
    }

    @Override
    public Iterator<OIdentifiable> rawIterator() {
        return new EntriesIterator(false);
    }

    @Override
    public void convertLinks2Records() {
        for (int i = 0; i < this.entriesLength; ++i) {
            OIdentifiable identifiable;
            Object record;
            Object entry = this.entries[i];
            if (!(entry instanceof OIdentifiable) || (record = (identifiable = (OIdentifiable)entry).getRecord()) == null) continue;
            if (this.owner != null) {
                ORecordInternal.unTrack(this.owner, identifiable);
                ORecordInternal.track(this.owner, record);
            }
            this.entries[i] = record;
        }
    }

    @Override
    public boolean convertRecords2Links() {
        for (int i = 0; i < this.entriesLength; ++i) {
            OIdentifiable identifiable;
            Object entry = this.entries[i];
            if (!(entry instanceof OIdentifiable) || !((identifiable = (OIdentifiable)entry) instanceof ORecord)) continue;
            ORecord record = (ORecord)identifiable;
            this.entries[i] = record.getIdentity();
        }
        return true;
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.convertToRecord;
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.convertToRecord = convertToRecord;
    }

    @Override
    public boolean detach() {
        return this.convertRecords2Links();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        if (this.size < 10) {
            StringBuilder sb = new StringBuilder(256);
            sb.append('[');
            Iterator<OIdentifiable> it = this.rawIterator();
            while (it.hasNext()) {
                try {
                    OIdentifiable e = it.next();
                    if (e == null) continue;
                    if (sb.length() > 1) {
                        sb.append(", ");
                    }
                    sb.append(e.getIdentity());
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            return sb.append(']').toString();
        }
        return "[size=" + this.size + "]";
    }

    @Override
    public void addChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new LinkedList<OMultiValueChangeListener<OIdentifiable, OIdentifiable>>();
        }
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeRecordChangeListener(OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener) {
        if (this.changeListeners != null) {
            this.changeListeners.remove(changeListener);
        }
    }

    @Override
    public Object returnOriginalState(List<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> multiValueChangeEvents) {
        OEmbeddedRidBag reverted = new OEmbeddedRidBag();
        for (OIdentifiable identifiable : this) {
            reverted.add(identifiable);
        }
        ListIterator<OMultiValueChangeEvent<OIdentifiable, OIdentifiable>> listIterator = multiValueChangeEvents.listIterator(multiValueChangeEvents.size());
        block5: while (listIterator.hasPrevious()) {
            OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event = listIterator.previous();
            switch (event.getChangeType()) {
                case ADD: {
                    reverted.remove(event.getKey());
                    continue block5;
                }
                case REMOVE: {
                    reverted.add(event.getOldValue());
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Invalid change type : " + (Object)((Object)event.getChangeType()));
        }
        return reverted;
    }

    @Override
    public int getSerializedSize() {
        int size = 4;
        return size += this.size * 10;
    }

    @Override
    public int getSerializedSize(byte[] stream, int offset) {
        return OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset) * 10 + 4;
    }

    @Override
    public int serialize(byte[] stream, int offset, UUID ownerUuid) {
        OIntegerSerializer.INSTANCE.serializeLiteral(this.size, stream, offset);
        offset += 4;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        for (Object entry : this.entries) {
            if (!(entry instanceof OIdentifiable)) continue;
            OIdentifiable link = (OIdentifiable)entry;
            ORID rid = link.getIdentity();
            if (db != null && db.getTransaction().isActive() && !link.getIdentity().isPersistent()) {
                link = db.getTransaction().getRecord(link.getIdentity());
                this.entries[i] = link;
            }
            if (link == null) {
                throw new OSerializationException("Found null entry in ridbag with rid=" + rid);
            }
            OLinkSerializer.INSTANCE.serialize(link, stream, offset, new Object[0]);
            offset += 10;
        }
        return offset;
    }

    @Override
    public int deserialize(byte[] stream, int offset) {
        this.size = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset);
        int entriesSize = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, offset);
        offset += 4;
        for (int i = 0; i < entriesSize; ++i) {
            ORecordId rid = OLinkSerializer.INSTANCE.deserialize(stream, offset);
            offset += 10;
            ORecordId identifiable = null;
            if (rid.isTemporary()) {
                identifiable = (ORecordId)rid.getRecord();
            }
            if (identifiable == null) {
                identifiable = rid;
            }
            if (identifiable == null) {
                OLogManager.instance().warn((Object)this, "Found null reference during ridbag deserialization (rid=%s)", rid);
                continue;
            }
            this.addEntry(identifiable);
        }
        return offset;
    }

    @Override
    public void requestDelete() {
    }

    @Override
    public Class<?> getGenericClass() {
        return OIdentifiable.class;
    }

    @Override
    public List<OMultiValueChangeListener<OIdentifiable, OIdentifiable>> getChangeListeners() {
        if (this.changeListeners == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.changeListeners);
    }

    @Override
    public void fireCollectionChangedEvent(OMultiValueChangeEvent<OIdentifiable, OIdentifiable> event) {
        if (this.changeListeners != null) {
            for (OMultiValueChangeListener<OIdentifiable, OIdentifiable> changeListener : this.changeListeners) {
                if (changeListener == null) continue;
                changeListener.onAfterRecordChanged(event);
            }
        }
    }

    private void addEntry(OIdentifiable identifiable) {
        if (this.entries.length == this.entriesLength) {
            if (this.entriesLength == 0) {
                int cfgValue = OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.getValueAsInteger();
                this.entries = new Object[cfgValue > 0 ? Math.min(cfgValue, 40) : 40];
            } else {
                Object[] oldEntries = this.entries;
                this.entries = new Object[this.entries.length << 1];
                System.arraycopy(oldEntries, 0, this.entries, 0, oldEntries.length);
            }
        }
        if (this.owner != null) {
            ORecordInternal.track(this.owner, identifiable);
        }
        this.entries[this.entriesLength] = identifiable;
        ++this.entriesLength;
    }

    private boolean removeEntry(OIdentifiable identifiable) {
        int i;
        for (i = 0; i < this.entriesLength; ++i) {
            Object entry = this.entries[i];
            if (!entry.equals(identifiable)) continue;
            this.entries[i] = Tombstone.TOMBSTONE;
            break;
        }
        return i < this.entriesLength;
    }

    @Override
    public void replace(OMultiValueChangeEvent<Object, Object> event, Object newValue) {
    }

    private final class EntriesIterator
    implements Iterator<OIdentifiable>,
    OResettable,
    OSizeable {
        private final boolean convertToRecord;
        private int currentIndex = -1;
        private int nextIndex = -1;
        private boolean currentRemoved;

        private EntriesIterator(boolean convertToRecord) {
            this.reset();
            this.convertToRecord = convertToRecord;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndex > -1) {
                if (OEmbeddedRidBag.this.entries[this.nextIndex] instanceof OIdentifiable) {
                    return true;
                }
                this.nextIndex = this.nextIndex();
            }
            return this.nextIndex > -1;
        }

        @Override
        public OIdentifiable next() {
            this.currentRemoved = false;
            this.currentIndex = this.nextIndex;
            if (this.currentIndex == -1) {
                throw new NoSuchElementException();
            }
            Object nextValue = OEmbeddedRidBag.this.entries[this.currentIndex];
            if (!(nextValue instanceof OIdentifiable)) {
                this.currentIndex = this.nextIndex = this.nextIndex();
                if (this.currentIndex == -1) {
                    throw new NoSuchElementException();
                }
                nextValue = OEmbeddedRidBag.this.entries[this.currentIndex];
            }
            this.nextIndex = this.nextIndex();
            OIdentifiable identifiable = (OIdentifiable)nextValue;
            if (this.convertToRecord && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
                return identifiable.getRecord();
            }
            return identifiable;
        }

        @Override
        public void remove() {
            if (this.currentRemoved) {
                throw new IllegalStateException("Current element has already been removed");
            }
            if (this.currentIndex == -1) {
                throw new IllegalStateException("Next method was not called for given iterator");
            }
            this.currentRemoved = true;
            OIdentifiable nextValue = (OIdentifiable)OEmbeddedRidBag.this.entries[this.currentIndex];
            ((OEmbeddedRidBag)OEmbeddedRidBag.this).entries[this.currentIndex] = Tombstone.TOMBSTONE;
            OEmbeddedRidBag.this.size--;
            OEmbeddedRidBag.this.contentWasChanged = true;
            if (OEmbeddedRidBag.this.owner != null) {
                ORecordInternal.unTrack(OEmbeddedRidBag.this.owner, nextValue);
            }
            OEmbeddedRidBag.this.fireCollectionChangedEvent(new OMultiValueChangeEvent<OIdentifiable, OIdentifiable>(OMultiValueChangeEvent.OChangeType.REMOVE, nextValue, null, nextValue));
        }

        @Override
        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.currentRemoved = false;
            this.nextIndex = this.nextIndex();
        }

        @Override
        public int size() {
            return OEmbeddedRidBag.this.size;
        }

        private int nextIndex() {
            for (int i = this.currentIndex + 1; i < OEmbeddedRidBag.this.entriesLength; ++i) {
                Object entry = OEmbeddedRidBag.this.entries[i];
                if (!(entry instanceof OIdentifiable)) continue;
                return i;
            }
            return -1;
        }
    }

    private static enum Tombstone {
        TOMBSTONE;

    }
}

