/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OMemory;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;

public class OMemoryAndLocalPaginatedEnginesInitializer {
    public static final OMemoryAndLocalPaginatedEnginesInitializer INSTANCE = new OMemoryAndLocalPaginatedEnginesInitializer();
    private boolean initialized = false;

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.configureDefaults();
        OMemory.checkDirectMemoryConfiguration();
        OMemory.checkByteBufferPoolConfiguration();
        OMemory.checkCacheMemoryConfiguration();
        OMemory.fixCommonConfigurationProblems();
    }

    private void configureDefaults() {
        if (!OGlobalConfiguration.DISK_CACHE_SIZE.isChanged()) {
            this.configureDefaultDiskCacheSize();
        }
        if (!OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.isChanged()) {
            this.configureDefaultWalRestoreBatchSize();
        }
    }

    private void configureDefaultWalRestoreBatchSize() {
        long jvmMaxMemory = Runtime.getRuntime().maxMemory();
        if (jvmMaxMemory > 0x80000000L) {
            OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.setValue(50000);
        } else if (jvmMaxMemory > 0x20000000L) {
            OGlobalConfiguration.WAL_RESTORE_BATCH_SIZE.setValue(10000);
        }
    }

    private void configureDefaultDiskCacheSize() {
        long osMemory = OMemory.getPhysicalMemorySize();
        long jvmMaxMemory = OMemory.getCappedRuntimeMaxMemory(0x80000000L);
        long maxDirectMemory = OMemory.getConfiguredMaxDirectMemory();
        if (maxDirectMemory == -1L) {
            long diskCacheInMB = jvmMaxMemory / 1024L / 1024L - 2L;
            OLogManager.instance().info((Object)this, "OrientDB auto-config DISKCACHE=%,dMB (heap=%,dMB direct=%,dMB os=%,dMB), assuming maximum direct memory size equals to maximum JVM heap size", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, jvmMaxMemory / 1024L / 1024L, osMemory / 1024L / 1024L);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
            OGlobalConfiguration.MEMORY_CHUNK_SIZE.setValue(Math.min(diskCacheInMB * 1024L * 1024L, OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong()));
            return;
        }
        long maxDirectMemoryInMB = maxDirectMemory / 1024L / 1024L;
        long diskCacheInMB = (osMemory - jvmMaxMemory) / 0x100000L - 2048L;
        if (diskCacheInMB > 0L) {
            diskCacheInMB = Math.min(diskCacheInMB, maxDirectMemoryInMB);
            OLogManager.instance().info((Object)this, "OrientDB auto-config DISKCACHE=%,dMB (heap=%,dMB direct=%,dMB os=%,dMB)", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, maxDirectMemoryInMB, osMemory / 1024L / 1024L);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
            OGlobalConfiguration.MEMORY_CHUNK_SIZE.setValue(Math.min(diskCacheInMB * 1024L * 1024L, OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong()));
        } else {
            diskCacheInMB = Math.min(256L, maxDirectMemoryInMB);
            OLogManager.instance().warn((Object)this, "Not enough physical memory available for DISKCACHE: %,dMB (heap=%,dMB direct=%,dMB). Set lower Maximum Heap (-Xmx setting on JVM) and restart OrientDB. Now running with DISKCACHE=" + diskCacheInMB + "MB", osMemory / 1024L / 1024L, jvmMaxMemory / 1024L / 1024L, maxDirectMemoryInMB);
            OGlobalConfiguration.DISK_CACHE_SIZE.setValue(diskCacheInMB);
            OGlobalConfiguration.MEMORY_CHUNK_SIZE.setValue(Math.min(diskCacheInMB * 1024L * 1024L, OGlobalConfiguration.MEMORY_CHUNK_SIZE.getValueAsLong()));
            OLogManager.instance().info((Object)this, "OrientDB config DISKCACHE=%,dMB (heap=%,dMB direct=%,dMB os=%,dMB)", diskCacheInMB, jvmMaxMemory / 1024L / 1024L, maxDirectMemoryInMB, osMemory / 1024L / 1024L);
        }
    }
}

