/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.ODefaultIndexFactory;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMetadata;
import com.orientechnologies.orient.core.index.OIndexRemoteMultiValue;
import com.orientechnologies.orient.core.index.OIndexRemoteOneValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class OIndexManagerRemote
extends OIndexManagerAbstract {
    private static final String QUERY_DROP = "drop index %s";
    private static final long serialVersionUID = -6570577338095096235L;

    public OIndexManagerRemote(ODatabaseDocument iDatabase) {
        super(iDatabase);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition iIndexDefinition, int[] iClusterIdsToIndex, OProgressListener progressListener, ODocument metadata, String engine) {
        String createIndexDDL = iIndexDefinition != null ? iIndexDefinition.toCreateIndexDDL(iName, iType, engine) : new OSimpleKeyIndexDefinition().toCreateIndexDDL(iName, iType, engine);
        if (metadata != null) {
            createIndexDDL = createIndexDDL + " METADATA " + metadata.toJSON();
        }
        this.acquireExclusiveLock();
        try {
            if (progressListener != null) {
                progressListener.onBegin(this, 0L, false);
            }
            OIndexManagerRemote.getDatabase().command(new OCommandSQL(createIndexDDL)).execute(new Object[0]);
            ORecordInternal.setIdentity(this.document, new ORecordId(ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getConfiguration().indexMgrRecordId));
            if (progressListener != null) {
                progressListener.onCompletition(this, true);
            }
            this.reload();
            Locale locale = this.getServerLocale();
            OIndex<?> oIndex = this.preProcessBeforeReturn((OIndex)this.indexes.get(iName.toLowerCase(locale)));
            return oIndex;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public OIndex<?> createIndex(String iName, String iType, OIndexDefinition indexDefinition, int[] clusterIdsToIndex, OProgressListener progressListener, ODocument metadata) {
        return this.createIndex(iName, iType, indexDefinition, clusterIdsToIndex, progressListener, metadata, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OIndexManager dropIndex(String iIndexName) {
        this.acquireExclusiveLock();
        try {
            String text = String.format(QUERY_DROP, iIndexName);
            OIndexManagerRemote.getDatabase().command(new OCommandSQL(text)).execute(new Object[0]);
            Locale locale = this.getServerLocale();
            this.indexes.remove(iIndexName.toLowerCase(locale));
            this.reload();
            OIndexManagerRemote oIndexManagerRemote = this;
            return oIndexManagerRemote;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public ODocument toStream() {
        throw new UnsupportedOperationException("Remote index cannot be streamed");
    }

    @Override
    public void recreateIndexes() {
        throw new UnsupportedOperationException("recreateIndexes()");
    }

    @Override
    public void waitTillIndexRestore() {
    }

    @Override
    public boolean autoRecreateIndexesAfterCrash() {
        return false;
    }

    @Override
    public void removeClassPropertyIndex(OIndex<?> idx) {
    }

    protected OIndex<?> getRemoteIndexInstance(boolean isMultiValueIndex, String type, String name, String algorithm, Set<String> clustersToIndex, OIndexDefinition indexDefinition, ORID identity, ODocument configuration) {
        if (isMultiValueIndex) {
            return new OIndexRemoteMultiValue(name, type, algorithm, identity, indexDefinition, configuration, clustersToIndex);
        }
        return new OIndexRemoteOneValue(name, type, algorithm, identity, indexDefinition, configuration, clustersToIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fromStream() {
        this.acquireExclusiveLock();
        try {
            this.clearMetadata();
            Collection idxs = (Collection)this.document.field("indexes");
            if (idxs != null) {
                for (ODocument d : idxs) {
                    d.setLazyLoad(false);
                    try {
                        boolean isMultiValue = ODefaultIndexFactory.isMultiValueIndex((String)d.field("type"));
                        OIndexMetadata newIndexMetadata = OIndexAbstract.loadMetadataInternal(d, (String)d.field("type"), (String)d.field("algorithm"), (String)d.field("valueContainerAlgorithm"));
                        this.addIndexInternal(this.getRemoteIndexInstance(isMultiValue, newIndexMetadata.getType(), newIndexMetadata.getName(), newIndexMetadata.getAlgorithm(), newIndexMetadata.getClustersToIndex(), newIndexMetadata.getIndexDefinition(), (ORID)d.field("mapRid"), d));
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on loading of index by configuration: %s", e, d);
                    }
                }
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    protected OIndex<?> preProcessBeforeReturn(OIndex<?> index) {
        if (index instanceof OIndexRemoteMultiValue) {
            return new OIndexTxAwareMultiValue(OIndexManagerRemote.getDatabase(), index);
        }
        if (index instanceof OIndexRemoteOneValue) {
            return new OIndexTxAwareOneValue(OIndexManagerRemote.getDatabase(), (OIndex<OIdentifiable>)index);
        }
        return index;
    }
}

