/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.OStorage;

public class ORecordIteratorCluster<REC extends ORecord>
extends OIdentifiableIterator<REC> {
    private ORecord currentRecord;

    public ORecordIteratorCluster(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase, int iClusterId) {
        this(iDatabase, iLowLevelDatabase, iClusterId, -1L, -1L, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    public ORecordIteratorCluster(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase, int iClusterId, long firstClusterEntry, long lastClusterEntry) {
        this(iDatabase, iLowLevelDatabase, iClusterId, firstClusterEntry, lastClusterEntry, false, OStorage.LOCKING_STRATEGY.NONE);
    }

    @Deprecated
    public ORecordIteratorCluster(ODatabaseDocumentInternal iDatabase, ODatabaseDocumentInternal iLowLevelDatabase, int iClusterId, long firstClusterEntry, long lastClusterEntry, boolean iterateThroughTombstones, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        super(iDatabase, iLowLevelDatabase, iterateThroughTombstones, iLockingStrategy);
        if (iClusterId == -1) {
            throw new IllegalArgumentException("The clusterId is invalid");
        }
        this.checkForSystemClusters(iDatabase, new int[]{iClusterId});
        this.current.setClusterId(iClusterId);
        long[] range = this.database.getStorage().getClusterDataRange(this.current.getClusterId());
        if (firstClusterEntry == -1L) {
            this.firstClusterEntry = range[0];
        } else {
            long l = this.firstClusterEntry = firstClusterEntry > range[0] ? firstClusterEntry : range[0];
        }
        this.lastClusterEntry = lastClusterEntry == -1L ? range[1] : (lastClusterEntry < range[1] ? lastClusterEntry : range[1]);
        this.totalAvailableRecords = this.database.countClusterElements(this.current.getClusterId(), iterateThroughTombstones);
        this.txEntries = iDatabase.getTransaction().getNewRecordEntriesByClusterIds(new int[]{iClusterId});
        if (this.txEntries != null) {
            for (ORecordOperation entry : this.txEntries) {
                switch (entry.type) {
                    case 3: {
                        ++this.totalAvailableRecords;
                        break;
                    }
                    case 2: {
                        --this.totalAvailableRecords;
                    }
                }
            }
        }
        this.begin();
    }

    @Override
    public boolean hasPrevious() {
        boolean thereAreRecordsToBrowse;
        this.checkDirection(false);
        this.updateRangesOnLiveUpdate();
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        boolean bl = thereAreRecordsToBrowse = this.getCurrentEntry() > this.firstClusterEntry;
        if (thereAreRecordsToBrowse) {
            ORecord record = this.getRecord();
            this.currentRecord = this.readCurrentRecord(record, -1);
        }
        return this.currentRecord != null;
    }

    @Override
    public boolean hasNext() {
        this.checkDirection(true);
        if (Thread.interrupted()) {
            return false;
        }
        this.updateRangesOnLiveUpdate();
        if (this.currentRecord != null) {
            return true;
        }
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.current.getClusterPosition() >= -1L && this.getCurrentEntry() < this.lastClusterEntry) {
            ORecord record = this.getRecord();
            try {
                this.currentRecord = this.readCurrentRecord(record, 1);
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during read of record", e, new Object[0]);
                ORID recordRid = this.currentRecord.getIdentity();
                if (recordRid != null) {
                    this.brokenRIDs.add(recordRid.copy());
                }
                this.currentRecord = null;
            }
            if (this.currentRecord != null) {
                return true;
            }
        }
        if (this.txEntries != null) {
            return this.txEntries.size() - (this.currentTxEntryPosition + 1) > 0;
        }
        return false;
    }

    public REC previous() {
        this.checkDirection(false);
        if (this.currentRecord != null) {
            try {
                ORecord oRecord = this.currentRecord;
                return (REC)oRecord;
            }
            finally {
                this.currentRecord = null;
            }
        }
        if (this.hasPrevious()) {
            try {
                ORecord oRecord = this.currentRecord;
                return (REC)oRecord;
            }
            finally {
                this.currentRecord = null;
            }
        }
        return null;
    }

    @Override
    public REC next() {
        this.checkDirection(true);
        while (this.hasNext()) {
            if (this.currentRecord != null) {
                try {
                    ORecord oRecord = this.currentRecord;
                    return (REC)oRecord;
                }
                finally {
                    this.currentRecord = null;
                }
            }
            ORecord record = this.getTransactionEntry();
            if (record == null) continue;
            return (REC)record;
        }
        return null;
    }

    @Override
    public ORecordIteratorCluster<REC> begin() {
        this.browsedRecords = 0L;
        this.updateRangesOnLiveUpdate();
        this.resetCurrentPosition();
        this.currentRecord = this.readCurrentRecord(this.getRecord(), 1);
        return this;
    }

    @Override
    public ORecordIteratorCluster<REC> last() {
        this.browsedRecords = 0L;
        this.updateRangesOnLiveUpdate();
        this.resetCurrentPosition();
        this.currentRecord = this.readCurrentRecord(this.getRecord(), -1);
        return this;
    }

    @Override
    public ORecordIteratorCluster<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        if (iLiveUpdated) {
            this.firstClusterEntry = 0L;
            this.lastClusterEntry = Long.MAX_VALUE;
        } else {
            long[] range = this.database.getStorage().getClusterDataRange(this.current.getClusterId());
            this.firstClusterEntry = range[0];
            this.lastClusterEntry = range[1];
        }
        this.totalAvailableRecords = this.database.countClusterElements(this.current.getClusterId(), this.isIterateThroughTombstones());
        return this;
    }

    private void updateRangesOnLiveUpdate() {
        if (this.liveUpdated) {
            long[] range = this.database.getStorage().getClusterDataRange(this.current.getClusterId());
            this.firstClusterEntry = range[0];
            this.lastClusterEntry = range[1];
        }
    }
}

