/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.cache.OCommandCacheSoftRefs;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OIndexManagerRemote;
import com.orientechnologies.orient.core.index.OIndexManagerShared;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibrary;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryImpl;
import com.orientechnologies.orient.core.metadata.function.OFunctionLibraryProxy;
import com.orientechnologies.orient.core.metadata.schema.OImmutableSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.security.OSecurity;
import com.orientechnologies.orient.core.metadata.security.OSecurityProxy;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibrary;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryImpl;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibraryProxy;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.schedule.OSchedulerImpl;
import com.orientechnologies.orient.core.schedule.OSchedulerProxy;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class OMetadataDefault
implements OMetadataInternal {
    public static final String CLUSTER_INTERNAL_NAME = "internal";
    public static final String CLUSTER_INDEX_NAME = "index";
    public static final String CLUSTER_MANUAL_INDEX_NAME = "manindex";
    protected int schemaClusterId;
    protected OSchemaProxy schema;
    protected OSecurity security;
    protected OIndexManagerProxy indexManager;
    protected OFunctionLibraryProxy functionLibrary;
    protected OSchedulerProxy scheduler;
    protected OSequenceLibraryProxy sequenceLibrary;
    protected OCommandCache commandCache;
    protected static final OProfiler PROFILER = Orient.instance().getProfiler();
    private OImmutableSchema immutableSchema = null;
    private int immutableCount = 0;
    private ODatabaseDocumentInternal database;

    public OMetadataDefault() {
    }

    public OMetadataDefault(ODatabaseDocumentInternal databaseDocument) {
        this.database = databaseDocument;
    }

    @Override
    public void load() {
        long timer = PROFILER.startChrono();
        try {
            this.init(true);
        }
        finally {
            PROFILER.stopChrono(PROFILER.getDatabaseMetric(this.getDatabase().getName(), "metadata.load"), "Loading of database metadata", timer, "db.*.metadata.load");
        }
    }

    @Override
    public void create() throws IOException {
        this.init(false);
        this.schema.create();
        this.indexManager.create();
        this.security.create();
        this.functionLibrary.create();
        this.sequenceLibrary.create();
        this.security.createClassTrigger();
        this.scheduler.create();
        this.schema.createClass("V");
        this.schema.createClass("E");
    }

    @Override
    public OSchemaProxy getSchema() {
        return this.schema;
    }

    @Override
    public OCommandCache getCommandCache() {
        return this.commandCache;
    }

    @Override
    public void makeThreadLocalSchemaSnapshot() {
        if (this.immutableCount == 0 && this.schema != null) {
            this.immutableSchema = this.schema.makeSnapshot();
        }
        ++this.immutableCount;
    }

    @Override
    public void clearThreadLocalSchemaSnapshot() {
        --this.immutableCount;
        if (this.immutableCount == 0) {
            this.immutableSchema = null;
        }
    }

    @Override
    public OImmutableSchema getImmutableSchemaSnapshot() {
        if (this.immutableSchema == null) {
            if (this.schema == null) {
                return null;
            }
            return this.schema.makeSnapshot();
        }
        return this.immutableSchema;
    }

    @Override
    public OSecurity getSecurity() {
        return this.security;
    }

    @Override
    public OIndexManagerProxy getIndexManager() {
        return this.indexManager;
    }

    @Override
    public int getSchemaClusterId() {
        return this.schemaClusterId;
    }

    private void init(final boolean iLoad) {
        final ODatabaseDocumentInternal database = this.getDatabase();
        this.schemaClusterId = database.getClusterIdByName(CLUSTER_INTERNAL_NAME);
        final AtomicBoolean schemaLoaded = new AtomicBoolean(false);
        this.schema = new OSchemaProxy(database.getStorage().getResource(OSchema.class.getSimpleName(), new Callable<OSchemaShared>(){

            @Override
            public OSchemaShared call() {
                ODatabaseDocumentInternal database = OMetadataDefault.this.getDatabase();
                OSchemaShared instance = new OSchemaShared(database.getStorageVersions().classesAreDetectedByClusterId());
                if (iLoad) {
                    instance.load();
                }
                schemaLoaded.set(true);
                return instance;
            }
        }), database);
        this.indexManager = new OIndexManagerProxy(database.getStorage().getResource(OIndexManager.class.getSimpleName(), new Callable<OIndexManager>(){

            @Override
            public OIndexManager call() {
                OIndexManagerAbstract instance = database.getStorage() instanceof OStorageProxy ? new OIndexManagerRemote(database) : new OIndexManagerShared(database);
                if (iLoad) {
                    try {
                        instance.load();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "[OMetadata] Error on loading index manager, reset index configuration", e, new Object[0]);
                        instance.create();
                    }
                }
                return instance;
            }
        }), database);
        this.security = new OSecurityProxy(database.getStorage().getResource(OSecurity.class.getSimpleName(), new Callable<OSecurity>(){

            @Override
            public OSecurity call() {
                OSecurity instance = OSecurityManager.instance().newSecurity();
                if (iLoad) {
                    OMetadataDefault.this.security = instance;
                    instance.load();
                }
                return instance;
            }
        }), database);
        this.commandCache = database.getStorage().getResource(OCommandCache.class.getSimpleName(), new Callable<OCommandCache>(){

            @Override
            public OCommandCache call() {
                return new OCommandCacheSoftRefs(database.getName());
            }
        });
        Class securityClass = (Class)database.getProperty(ODatabase.OPTIONS.SECURITY.toString());
        if (securityClass != null) {
            try {
                OSecurity wrapped = this.security;
                this.security = (OSecurity)securityClass.getDeclaredConstructor(OSecurity.class, ODatabaseDocumentInternal.class).newInstance(wrapped, database);
            }
            catch (Exception e) {
                throw OException.wrapException(new OSecurityException("Cannot install custom security implementation (" + securityClass + ")"), e);
            }
        }
        this.functionLibrary = new OFunctionLibraryProxy(database.getStorage().getResource(OFunctionLibrary.class.getSimpleName(), new Callable<OFunctionLibrary>(){

            @Override
            public OFunctionLibrary call() {
                OFunctionLibraryImpl instance = new OFunctionLibraryImpl();
                if (iLoad && !(database.getStorage() instanceof OStorageProxy)) {
                    instance.load();
                }
                return instance;
            }
        }), database);
        this.sequenceLibrary = new OSequenceLibraryProxy(database.getStorage().getResource(OSequenceLibrary.class.getSimpleName(), new Callable<OSequenceLibrary>(){

            @Override
            public OSequenceLibrary call() throws Exception {
                OSequenceLibraryImpl instance = new OSequenceLibraryImpl();
                if (iLoad) {
                    instance.load();
                }
                return instance;
            }
        }), database);
        this.scheduler = new OSchedulerProxy(database.getStorage().getResource(OScheduler.class.getSimpleName(), new Callable<OScheduler>(){

            @Override
            public OScheduler call() {
                OSchedulerImpl instance = new OSchedulerImpl();
                if (iLoad && !(database.getStorage() instanceof OStorageProxy)) {
                    instance.load();
                }
                return instance;
            }
        }), database);
        if (schemaLoaded.get()) {
            this.schema.onPostIndexManagement();
        }
    }

    @Override
    public void reload() {
        if (this.schema != null) {
            this.schema.reload();
        }
        if (this.indexManager != null) {
            this.indexManager.reload();
        }
        if (this.security != null) {
            this.security.load();
        }
        if (this.functionLibrary != null) {
            this.functionLibrary.load();
        }
        if (this.sequenceLibrary != null) {
            this.sequenceLibrary.load();
        }
        if (this.commandCache != null) {
            this.commandCache.clear();
        }
        if (this.scheduler != null) {
            this.scheduler.load();
        }
    }

    @Override
    public void close() {
        if (this.scheduler != null) {
            this.scheduler.close();
        }
        if (this.schema != null) {
            this.schema.close();
        }
        if (this.security != null) {
            this.security.close(false);
        }
        if (this.commandCache != null) {
            this.commandCache.clear();
            this.commandCache.shutdown();
        }
    }

    protected ODatabaseDocumentInternal getDatabase() {
        return this.database;
    }

    @Override
    public OFunctionLibrary getFunctionLibrary() {
        return this.functionLibrary;
    }

    @Override
    public OSequenceLibrary getSequenceLibrary() {
        return this.sequenceLibrary;
    }

    @Override
    public OScheduler getScheduler() {
        return this.scheduler;
    }
}

