/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OCronExpression;
import com.orientechnologies.orient.core.schedule.OScheduler;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.TimerTask;

public class OScheduledEvent
extends ODocumentWrapper {
    public static final String CLASS_NAME = "OSchedule";
    public static final String PROP_NAME = "name";
    public static final String PROP_RULE = "rule";
    public static final String PROP_ARGUMENTS = "arguments";
    public static final String PROP_STATUS = "status";
    public static final String PROP_FUNC = "function";
    public static final String PROP_STARTTIME = "starttime";
    public static final String PROP_EXEC_ID = "nextExecId";
    private ODatabaseDocument db;
    private OFunction function;
    private boolean isRunning = false;
    private OCronExpression cron;
    private volatile TimerTask timer;
    private long nextExecutionId;

    public OScheduledEvent(ODocument doc) {
        super(doc);
        this.getFunction();
        try {
            this.cron = new OCronExpression(this.getRule());
        }
        catch (ParseException e) {
            OLogManager.instance().error(this, "Error on compiling cron expression " + this.getRule(), e, new Object[0]);
        }
    }

    public void interrupt() {
        TimerTask t = this.timer;
        this.timer = null;
        if (t != null) {
            t.cancel();
        }
    }

    public OFunction getFunction() {
        OFunction fun = this.getFunctionSafe();
        if (fun == null) {
            throw new OCommandScriptException("Function cannot be null");
        }
        return fun;
    }

    public String getRule() {
        return (String)this.document.field(PROP_RULE);
    }

    public String getName() {
        return (String)this.document.field(PROP_NAME);
    }

    public long getNextExecutionId() {
        Long value = (Long)this.document.field(PROP_EXEC_ID);
        if (value == null) {
            return 0L;
        }
        return value;
    }

    @Override
    public <RET extends ODocumentWrapper> RET save() {
        if (this.db == null) {
            this.bindDb();
        } else {
            this.db.activateOnCurrentThread();
        }
        return super.save();
    }

    public String getStatus() {
        return (String)this.document.field(PROP_STATUS);
    }

    public Map<Object, Object> getArguments() {
        return (Map)this.document.field(PROP_ARGUMENTS);
    }

    public Date getStartTime() {
        return (Date)this.document.field(PROP_STARTTIME);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public OScheduledEvent schedule() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.bindDb();
        this.timer = new ScheduledTimer();
        this.nextExecutionId = this.getNextExecutionId() + 1L;
        Orient.instance().scheduleTask(this.timer, this.cron.getNextValidTimeAfter(new Date()), 0L);
        return this;
    }

    @Override
    public String toString() {
        return "OSchedule [name:" + this.getName() + ",rule:" + this.getRule() + ",current status:" + this.getStatus() + ",func:" + this.getFunctionSafe() + ",started:" + this.getStartTime() + "]";
    }

    @Override
    public void fromStream(ODocument iDocument) {
        super.fromStream(iDocument);
        this.bindDb();
        try {
            this.cron.buildExpression(this.getRule());
        }
        catch (ParseException e) {
            OLogManager.instance().error(this, "Error on compiling cron expression " + this.getRule(), e, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeFunction() {
        this.isRunning = true;
        OLogManager.instance().info((Object)this, "Checking for the execution of the scheduled event '%s' executionId=%d...", this.getName(), this.nextExecutionId);
        Object result = null;
        try {
            if (this.db != null) {
                this.db.activateOnCurrentThread();
            }
            boolean executeEvent = false;
            for (int retry = 0; retry < 10; ++retry) {
                block21: {
                    if (this.isEventAlreadyExecuted()) break;
                    try {
                        this.document.field(PROP_STATUS, (Object)OScheduler.STATUS.RUNNING);
                        this.document.field(PROP_STARTTIME, System.currentTimeMillis());
                        this.document.field(PROP_EXEC_ID, this.nextExecutionId);
                        this.document.save();
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on saving status for event '%s'", e, this.getName());
                        if (this.isRunning) break block21;
                        this.isRunning = false;
                        return;
                    }
                }
                try {
                    executeEvent = true;
                    break;
                }
                catch (ONeedRetryException e) {
                    if (this.isEventAlreadyExecuted()) break;
                    OLogManager.instance().info((Object)this, "Cannot change the status of the scheduled event '%s' executionId=%d, retry %d", this.getName(), this.nextExecutionId, retry);
                    continue;
                }
                catch (ORecordNotFoundException e) {
                    OLogManager.instance().info((Object)this, "Scheduled event '%s' executionId=%d not found on database, removing event", this.getName(), this.nextExecutionId);
                    this.timer = null;
                    break;
                }
                catch (Throwable e) {
                    OLogManager.instance().error(this, "Error during starting of scheduled event '%s' executionId=%d", e, this.getName(), this.nextExecutionId);
                    this.timer = null;
                    break;
                }
            }
            if (!executeEvent) {
                return;
            }
            OLogManager.instance().info((Object)this, "Executing scheduled event '%s' executionId=%d...", this.getName(), this.nextExecutionId);
            try {
                result = this.function.execute(this.getArguments());
            }
            catch (Throwable throwable) {
                OLogManager.instance().info((Object)this, "Scheduled event '%s' executionId=%d completed with result: %s", this.getName(), this.nextExecutionId, result);
                try {
                    this.document.field(PROP_STATUS, (Object)OScheduler.STATUS.WAITING);
                    this.document.save();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error on saving status for event '%s'", e, this.getName());
                }
                throw throwable;
            }
            OLogManager.instance().info((Object)this, "Scheduled event '%s' executionId=%d completed with result: %s", this.getName(), this.nextExecutionId, result);
            try {
                this.document.field(PROP_STATUS, (Object)OScheduler.STATUS.WAITING);
                this.document.save();
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error on saving status for event '%s'", e, this.getName());
            }
        }
        finally {
            this.isRunning = false;
        }
    }

    private boolean isEventAlreadyExecuted() {
        Object rec = this.document.getIdentity().getRecord();
        if (rec == null) {
            return true;
        }
        ODocument updated = (ODocument)rec.reload();
        Long currentExecutionId = (Long)updated.field(PROP_EXEC_ID);
        if (currentExecutionId == null) {
            return false;
        }
        if (currentExecutionId >= this.nextExecutionId) {
            OLogManager.instance().info((Object)this, "Scheduled event '%s' with id %d is already running (current id=%d)", this.getName(), this.nextExecutionId, currentExecutionId);
            return true;
        }
        return false;
    }

    private void bindDb() {
        ODatabaseDocumentInternal tlDb = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (tlDb != null && !tlDb.isClosed()) {
            this.db = ((ODatabaseDocumentTx)tlDb).copy();
        }
    }

    private OFunction getFunctionSafe() {
        Object funcDoc;
        if (this.function == null && (funcDoc = this.document.field(PROP_FUNC)) != null) {
            if (funcDoc instanceof OFunction) {
                this.function = (OFunction)funcDoc;
                this.document.field(PROP_FUNC, this.function.getId());
            } else if (funcDoc instanceof ODocument) {
                this.function = new OFunction((ODocument)funcDoc);
            } else if (funcDoc instanceof ORecordId) {
                this.function = new OFunction((ORecordId)funcDoc);
            }
        }
        return this.function;
    }

    private class ScheduledTimer
    extends TimerTask {
        private ScheduledTimer() {
        }

        @Override
        public void run() {
            if (OScheduledEvent.this.isRunning) {
                OLogManager.instance().error(this, "Error: The scheduled event '" + OScheduledEvent.this.getName() + "' is already running", null, new Object[0]);
                return;
            }
            if (OScheduledEvent.this.function == null) {
                OLogManager.instance().error(this, "Error: The scheduled event '" + OScheduledEvent.this.getName() + "' has no configured function", null, new Object[0]);
                return;
            }
            try {
                OScheduledEvent.this.executeFunction();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (OScheduledEvent.this.timer != null) {
                    OScheduledEvent.this.schedule();
                }
            }
        }
    }
}

