/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sharding.auto;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.clusterselection.OClusterSelectionStrategy;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sharding.auto.OAutoShardingIndexEngine;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import java.util.List;

public class OAutoShardingClusterSelectionStrategy
implements OClusterSelectionStrategy {
    public static final String NAME = "auto-sharding";
    private final OIndex index;
    private final OIndexEngine indexEngine;
    private final List<String> indexedFields;
    private final int[] clusters;

    public OAutoShardingClusterSelectionStrategy(OClass clazz, OIndex autoShardingIndex) {
        this.index = autoShardingIndex;
        if (this.index == null) {
            throw new OConfigurationException("Cannot use auto-sharding cluster strategy because class '" + clazz + "' has no auto-sharding index defined");
        }
        this.indexedFields = this.index.getDefinition().getFields();
        if (this.indexedFields.size() != 1) {
            throw new OConfigurationException("Cannot use auto-sharding cluster strategy because class '" + clazz + "' has an auto-sharding index defined with multiple fields");
        }
        OStorage stg = ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        if (!(stg instanceof OAbstractPaginatedStorage)) {
            throw new OConfigurationException("Cannot use auto-sharding cluster strategy because storage is not embedded");
        }
        try {
            this.indexEngine = ((OAbstractPaginatedStorage)stg).getIndexEngine(this.index.getIndexId());
        }
        catch (OInvalidIndexEngineIdException e) {
            throw OException.wrapException(new OConfigurationException("Cannot use auto-sharding cluster strategy because the underlying index has not found"), e);
        }
        if (this.indexEngine == null) {
            throw new OConfigurationException("Cannot use auto-sharding cluster strategy because the underlying index has not found");
        }
        this.clusters = clazz.getClusterIds();
    }

    @Override
    public int getCluster(OClass clazz, ODocument doc) {
        Object fieldValue = doc.field(this.indexedFields.get(0));
        return this.clusters[((OAutoShardingIndexEngine)this.indexEngine).getStrategy().getPartitionsId(fieldValue, this.clusters.length)];
    }

    @Override
    public String getName() {
        return NAME;
    }
}

