/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexCursorCollectionValue;
import com.orientechnologies.orient.core.index.OIndexCursorSingleValue;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.OBinaryField;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerBinary;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class OQueryOperatorEquals
extends OQueryOperatorEqualityNotNulls {
    private boolean binaryEvaluate = false;

    public OQueryOperatorEquals() {
        super("=", 5, false);
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
        if (db != null) {
            this.binaryEvaluate = db.getSerializer().getSupportBinaryEvaluate();
        }
    }

    public static boolean equals(Object iLeft, Object iRight, OType type) {
        if (type == null) {
            return OQueryOperatorEquals.equals(iLeft, iRight);
        }
        Object left = OType.convert(iLeft, type.getDefaultJavaType());
        Object right = OType.convert(iRight, type.getDefaultJavaType());
        return OQueryOperatorEquals.equals(left, right);
    }

    public static boolean equals(Object iLeft, Object iRight) {
        if (iLeft == null || iRight == null) {
            return false;
        }
        if (iLeft == iRight) {
            return true;
        }
        if (iLeft instanceof ORecord) {
            return OQueryOperatorEquals.comparesValues(iRight, (ORecord)iLeft, true);
        }
        if (iRight instanceof ORecord) {
            return OQueryOperatorEquals.comparesValues(iLeft, (ORecord)iRight, true);
        }
        if (iLeft instanceof Number && iRight instanceof Number) {
            Number[] couple = OType.castComparableNumber((Number)iLeft, (Number)iRight);
            return couple[0].equals(couple[1]);
        }
        try {
            Object right = OType.convert(iRight, iLeft.getClass());
            if (right == null) {
                return false;
            }
            if (iLeft instanceof byte[] && iRight instanceof byte[]) {
                return Arrays.equals((byte[])iLeft, (byte[])iRight);
            }
            return iLeft.equals(right);
        }
        catch (Exception e) {
            OLogManager.instance().debug(OQueryOperatorEquals.class, "Error on SQL operator `equals`", e, new Object[0]);
            return false;
        }
    }

    protected static boolean comparesValues(Object iValue, ORecord iRecord, boolean iConsiderIn) {
        ORID other = iRecord.getIdentity();
        if (!other.isPersistent() && iRecord instanceof ODocument) {
            Object fieldValue;
            String[] firstFieldName = ((ODocument)iRecord).fieldNames();
            if (firstFieldName.length > 0 && (fieldValue = ((ODocument)iRecord).field(firstFieldName[0])) != null) {
                if (iConsiderIn && OMultiValue.isMultiValue(fieldValue)) {
                    for (Object o : OMultiValue.getMultiValueIterable(fieldValue, false)) {
                        if (o == null || !o.equals(iValue)) continue;
                        return true;
                    }
                }
                return fieldValue.equals(iValue);
            }
            return false;
        }
        return other.equals(iValue);
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iLeft instanceof OIdentifiable && iRight instanceof OIdentifiable) {
            return OIndexReuseType.NO_INDEX;
        }
        if (iRight == null || iLeft == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public OIndexCursor executeIndexQuery(OCommandContext iContext, OIndex<?> index, List<Object> keyParams, boolean ascSortOrder) {
        OIndexCursor cursor;
        OIndexDefinition indexDefinition = index.getDefinition();
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, key) : new OIndexCursorCollectionValue((Collection)indexResult, key);
        } else {
            OCompositeIndexDefinition compositeIndexDefinition = (OCompositeIndexDefinition)indexDefinition;
            OCompositeKey keyOne = compositeIndexDefinition.createSingleValue(keyParams);
            if (keyOne == null) {
                return null;
            }
            OCompositeKey keyTwo = compositeIndexDefinition.createSingleValue(keyParams);
            if (internalIndex.hasRangeQuerySupport()) {
                cursor = index.iterateEntriesBetween(keyOne, true, keyTwo, true, ascSortOrder);
            } else if (indexDefinition.getParamCount() == keyParams.size()) {
                Object indexResult = index.get(keyOne);
                cursor = indexResult == null || indexResult instanceof OIdentifiable ? new OIndexCursorSingleValue((OIdentifiable)indexResult, keyOne) : new OIndexCursorCollectionValue((Collection)indexResult, keyOne);
            } else {
                return null;
            }
        }
        this.updateProfiler(iContext, index, keyParams, indexDefinition);
        return cursor;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof ORID) {
                return (ORID)iRight;
            }
            if (iRight instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iRight).getValue(null, null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iRight).getValue(null, null, null);
            }
        }
        if (iRight instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iRight).getRoot())) {
            if (iLeft instanceof ORID) {
                return (ORID)iLeft;
            }
            if (iLeft instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iLeft).getValue(null, null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iLeft).getValue(null, null, null);
            }
        }
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return this.getBeginRidRange(iLeft, iRight);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        return OQueryOperatorEquals.equals(iLeft, iRight);
    }

    @Override
    public boolean evaluate(OBinaryField iFirstField, OBinaryField iSecondField, OCommandContext iContext) {
        return ORecordSerializerBinary.INSTANCE.getCurrentSerializer().getComparator().isEqual(iFirstField, iSecondField);
    }

    @Override
    public boolean isSupportingBinaryEvaluate() {
        return this.binaryEvaluate;
    }
}

