/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.parser.OMatchFilter;
import com.orientechnologies.orient.core.sql.parser.OMatchPathItem;
import com.orientechnologies.orient.core.sql.parser.OMatchStatement;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OMatchPathItemIterator
implements Iterator<OIdentifiable> {
    private final OMatchStatement.MatchContext matchContext;
    private final OCommandContext ctx;
    OMatchPathItem item;
    OIdentifiable nextElement = null;
    List<Iterator> stack = new LinkedList<Iterator>();

    OMatchPathItemIterator(OMatchPathItem item, OMatchStatement.MatchContext matchContext, OCommandContext iCommandContext, final OIdentifiable startingPoint) {
        this.item = item;
        this.matchContext = matchContext;
        this.ctx = iCommandContext;
        this.stack.add(new Iterator(){
            boolean executed = false;

            @Override
            public boolean hasNext() {
                return !this.executed;
            }

            public Object next() {
                if (this.executed) {
                    throw new IllegalStateException();
                }
                this.executed = true;
                return startingPoint;
            }

            @Override
            public void remove() {
            }
        });
        this.loadNext();
    }

    protected void loadNext() {
        while (this.stack.size() > 0) {
            if (!this.stack.get(0).hasNext()) {
                this.stack.remove(0);
                continue;
            }
            this.loadNextInternal();
            if (this.nextElement == null) continue;
            return;
        }
    }

    protected void loadNextInternal() {
        if (this.stack == null || this.stack.size() == 0) {
            this.nextElement = null;
            return;
        }
        int depth = this.stack.size() - 1;
        Object oldDepth = this.ctx.getVariable("$depth", depth);
        this.ctx.setVariable("$depth", depth);
        OWhereClause filter = this.item.filter == null ? null : this.item.filter.getFilter();
        String className = this.item.filter == null ? null : this.item.filter.getClassName(this.ctx);
        OClass clazz = className == null ? null : ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(className);
        OWhereClause whileCondition = this.item.filter == null ? null : this.item.filter.getWhileCondition();
        Integer maxDepth = this.maxDepth(this.item.filter);
        OClass oClass = this.item.filter == null ? null : SimpleNode.getDatabase().getMetadata().getSchema().getClass(this.item.filter.getClassName(this.ctx));
        boolean notDeep = this.item.filter == null || whileCondition == null && this.item.filter.getMaxDepth() == null;
        OIdentifiable startingPoint = (OIdentifiable)this.stack.get(0).next();
        this.nextElement = null;
        if (this.item.filter == null || whileCondition == null && this.item.filter.getMaxDepth() == null) {
            if (depth == 1) {
                Object prevMatch = this.ctx.getVariable("$currentMatch");
                Object prevCurrent = this.ctx.getVariable("$current");
                this.ctx.setVariable("$currentMatch", startingPoint);
                this.ctx.setVariable("$current", startingPoint);
                if ((filter == null || filter.matchesFilters(startingPoint, this.ctx)) && (clazz == null || clazz.isSuperClassOf(((ODocument)startingPoint.getRecord()).getSchemaClass()))) {
                    this.nextElement = startingPoint;
                }
                this.ctx.setVariable("$current", prevCurrent);
                this.ctx.setVariable("$currentMatch", prevMatch);
            }
        } else {
            Object prevMatch = this.ctx.getVariable("$currentMatch");
            this.ctx.setVariable("$currentMatch", startingPoint);
            if ((filter == null || filter.matchesFilters(startingPoint, this.ctx)) && (clazz == null || clazz.isSuperClassOf(((ODocument)startingPoint.getRecord()).getSchemaClass()))) {
                this.nextElement = startingPoint;
            }
            this.ctx.setVariable("$currentMatch", prevMatch);
        }
        if (notDeep && depth == 0 || (maxDepth == null || depth < maxDepth) && (whileCondition == null || whileCondition.matchesFilters(startingPoint, this.ctx))) {
            this.stack.add(0, this.item.traversePatternEdge(this.matchContext, startingPoint, this.ctx).iterator());
        }
        this.ctx.setVariable("$depth", oldDepth);
    }

    @Override
    public boolean hasNext() {
        while (this.stack.size() > 0 && this.nextElement == null) {
            this.loadNext();
        }
        return this.nextElement != null;
    }

    private Integer maxDepth(OMatchFilter filter) {
        if (filter == null) {
            return 1;
        }
        if (filter.getMaxDepth() != null) {
            return filter.getMaxDepth();
        }
        if (filter.getWhileCondition() == null) {
            return 1;
        }
        return null;
    }

    private boolean matchesClass(OClass oClass, OIdentifiable startingPoint) {
        if (oClass == null) {
            return true;
        }
        ODocument doc = (ODocument)startingPoint.getRecord();
        if (doc == null) {
            return false;
        }
        OClass clazz = doc.getSchemaClass();
        if (clazz == null) {
            return false;
        }
        return clazz.isSubClassOf(oClass);
    }

    @Override
    public OIdentifiable next() {
        if (this.nextElement == null) {
            throw new IllegalStateException();
        }
        OIdentifiable result = this.nextElement;
        this.nextElement = null;
        while (this.stack.size() > 0 && this.nextElement == null) {
            this.loadNext();
        }
        return result;
    }

    @Override
    public void remove() {
    }
}

