/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class OPaginatedStorageDirtyFlag {
    private final String dirtyFilePath;
    private File dirtyFile;
    private RandomAccessFile dirtyFileData;
    private FileChannel channel;
    private FileLock fileLock;
    private volatile boolean dirtyFlag;
    private volatile boolean indexRebuildScheduled;
    private final Lock lock = new ReentrantLock();

    public OPaginatedStorageDirtyFlag(String dirtyFilePath) {
        this.dirtyFilePath = dirtyFilePath;
    }

    public void create() throws IOException {
        this.lock.lock();
        try {
            boolean fileDeleted;
            this.dirtyFile = new File(this.dirtyFilePath);
            if (this.dirtyFile.exists() && !(fileDeleted = this.dirtyFile.delete())) {
                throw new IllegalStateException("Cannot delete file : " + this.dirtyFilePath);
            }
            boolean fileCreated = this.dirtyFile.createNewFile();
            if (!fileCreated) {
                throw new IllegalStateException("Cannot create file : " + this.dirtyFilePath);
            }
            this.dirtyFileData = new RandomAccessFile(this.dirtyFile, "rwd");
            this.channel = this.dirtyFileData.getChannel();
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.lockFile();
            }
            this.dirtyFlag = true;
            this.indexRebuildScheduled = false;
            this.writeState(this.dirtyFlag, this.indexRebuildScheduled);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void lockFile() throws IOException {
        try {
            this.fileLock = this.channel.tryLock();
        }
        catch (OverlappingFileLockException e) {
            OLogManager.instance().warn((Object)this, "Database is open by another process", new Object[0]);
        }
        if (this.fileLock == null) {
            throw new OStorageException("Cannot open storage it is acquired by other process");
        }
    }

    public boolean exists() {
        this.lock.lock();
        try {
            boolean bl = new File(this.dirtyFilePath).exists();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void open() throws IOException {
        this.lock.lock();
        try {
            this.dirtyFile = new File(this.dirtyFilePath);
            if (!this.dirtyFile.exists()) {
                boolean fileCreated = this.dirtyFile.createNewFile();
                if (!fileCreated) {
                    throw new IllegalStateException("Cannot create file : " + this.dirtyFilePath);
                }
                this.dirtyFileData = new RandomAccessFile(this.dirtyFile, "rwd");
                this.channel = this.dirtyFileData.getChannel();
                this.writeState(false, false);
            }
            this.dirtyFileData = new RandomAccessFile(this.dirtyFile, "rwd");
            this.channel = this.dirtyFileData.getChannel();
            if (OGlobalConfiguration.FILE_LOCK.getValueAsBoolean()) {
                this.lockFile();
            }
            this.channel.position(0L);
            if (this.channel.size() < 2L) {
                ByteBuffer buffer = ByteBuffer.allocate(1);
                this.readByteBuffer(buffer, this.channel);
                buffer.position(0);
                this.dirtyFlag = buffer.get() > 0;
                this.writeState(this.dirtyFlag, this.indexRebuildScheduled);
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(2);
                this.readByteBuffer(buffer, this.channel);
                buffer.position(0);
                this.dirtyFlag = buffer.get() > 0;
                this.indexRebuildScheduled = buffer.get() > 0;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.dirtyFile == null) {
                return;
            }
            if (this.dirtyFile.exists()) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.dirtyFileData.close();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void delete() throws IOException {
        this.lock.lock();
        try {
            if (this.dirtyFile == null) {
                return;
            }
            if (this.dirtyFile.exists()) {
                if (this.fileLock != null) {
                    this.fileLock.release();
                    this.fileLock = null;
                }
                this.channel.close();
                this.dirtyFileData.close();
                boolean deleted = this.dirtyFile.delete();
                while (!deleted) {
                    deleted = !this.dirtyFile.exists() || this.dirtyFile.delete();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void makeDirty() throws IOException {
        if (this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (this.dirtyFlag) {
                return;
            }
            this.dirtyFlag = true;
            this.writeState(this.dirtyFlag, this.indexRebuildScheduled);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearDirty() throws IOException {
        if (!this.dirtyFlag) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.dirtyFlag) {
                return;
            }
            this.dirtyFlag = false;
            this.writeState(this.dirtyFlag, this.indexRebuildScheduled);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void scheduleIndexRebuild() throws IOException {
        if (this.indexRebuildScheduled) {
            return;
        }
        this.lock.lock();
        try {
            if (this.indexRebuildScheduled) {
                return;
            }
            this.indexRebuildScheduled = true;
            this.writeState(this.dirtyFlag, this.indexRebuildScheduled);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void clearIndexRebuild() throws IOException {
        if (!this.indexRebuildScheduled) {
            return;
        }
        this.lock.lock();
        try {
            if (!this.indexRebuildScheduled) {
                return;
            }
            this.indexRebuildScheduled = false;
            this.writeState(this.dirtyFlag, this.indexRebuildScheduled);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public boolean isIndexRebuildScheduled() {
        return this.indexRebuildScheduled;
    }

    private void writeByteBuffer(ByteBuffer buffer, FileChannel channel) throws IOException {
        int bytesToWrite = buffer.limit();
        for (int written = 0; written < bytesToWrite; written += channel.write(buffer, written)) {
        }
    }

    private void readByteBuffer(ByteBuffer buffer, FileChannel channel) throws IOException {
        int r;
        int bytesToRead = buffer.limit();
        for (int read = 0; read < bytesToRead; read += r) {
            r = channel.read(buffer);
            if (r != -1) continue;
            throw new EOFException("End of file is reached");
        }
    }

    private void writeState(boolean dirtyFlag, boolean indexRebuildScheduled) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(2);
        buffer.put(dirtyFlag ? (byte)1 : 0);
        buffer.put(indexRebuildScheduled ? (byte)1 : 0);
        this.channel.position(0L);
        buffer.position(0);
        this.writeByteBuffer(buffer, this.channel);
    }
}

