/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.util.NavigableMap;
import java.util.TreeMap;

public class OTransactionIndexChanges {
    public NavigableMap<Object, OTransactionIndexChangesPerKey> changesPerKey = new TreeMap<Object, OTransactionIndexChangesPerKey>(ODefaultComparator.INSTANCE);
    public OTransactionIndexChangesPerKey nullKeyChanges = new OTransactionIndexChangesPerKey(null);
    public boolean cleared = false;
    private OIndexInternal<?> resolvedIndex = null;

    public OTransactionIndexChangesPerKey getChangesPerKey(Object key) {
        if (key == null) {
            return this.nullKeyChanges;
        }
        OTransactionIndexChangesPerKey changes = (OTransactionIndexChangesPerKey)this.changesPerKey.get(key);
        if (changes == null) {
            changes = new OTransactionIndexChangesPerKey(key);
            this.changesPerKey.put(key, changes);
        }
        return changes;
    }

    public void setCleared() {
        this.changesPerKey.clear();
        this.nullKeyChanges.clear();
        this.cleared = true;
    }

    public Object getFirstKey() {
        return this.changesPerKey.firstKey();
    }

    public Object getLastKey() {
        return this.changesPerKey.lastKey();
    }

    public Object getLowerKey(Object key) {
        return this.changesPerKey.lowerKey(key);
    }

    public Object getHigherKey(Object key) {
        return this.changesPerKey.higherKey(key);
    }

    public Object getCeilingKey(Object key) {
        return this.changesPerKey.ceilingKey(key);
    }

    public Object getFloorKey(Object key) {
        return this.changesPerKey.floorKey(key);
    }

    public OIndexInternal<?> resolveAssociatedIndex(String indexName, OIndexManager indexManager) {
        OIndex<?> index;
        if (this.resolvedIndex == null && (index = indexManager.getIndex(indexName)) != null) {
            this.resolvedIndex = index.getInternal();
        }
        return this.resolvedIndex;
    }

    public OIndexInternal<?> getAssociatedIndex() {
        return this.resolvedIndex;
    }

    public static enum OPERATION {
        PUT,
        REMOVE,
        CLEAR;

    }
}

