/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODirtyManager;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.ORollbackException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private static AtomicInteger txSerial = new AtomicInteger();
    private boolean usingLog = true;
    private int txStartCounter;
    private ORecordCallback<Long> recordCreatedCallback = null;
    private ORecordCallback<Integer> recordUpdatedCallback = null;

    public OTransactionOptimistic(ODatabaseDocumentTx iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
    }

    @Override
    public void begin() {
        if (this.txStartCounter < 0) {
            throw new OTransactionException("Invalid value of TX counter.");
        }
        if (this.txStartCounter == 0) {
            this.status = OTransaction.TXSTATUS.BEGUN;
        }
        ++this.txStartCounter;
        if (this.txStartCounter > 1) {
            OLogManager.instance().debug((Object)this, "Transaction was already started and will be reused.", new Object[0]);
        }
    }

    @Override
    public void commit() {
        this.commit(false);
    }

    @Override
    public void commit(boolean force) {
        this.checkTransaction();
        if (this.txStartCounter < 0) {
            throw new OStorageException("Invalid value of tx counter");
        }
        this.txStartCounter = force ? 0 : --this.txStartCounter;
        if (this.txStartCounter == 0) {
            this.doCommit();
        } else if (this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was not committed.", new Object[0]);
        } else {
            throw new OTransactionException("Transaction was committed more times than it is started.");
        }
    }

    @Override
    public int amountOfNestedTxs() {
        return this.txStartCounter;
    }

    @Override
    public void rollback() {
        this.rollback(false, -1);
    }

    @Override
    public void rollback(boolean force, int commitLevelDiff) {
        if (this.txStartCounter < 0) {
            throw new OStorageException("Invalid value of TX counter");
        }
        this.checkTransaction();
        this.txStartCounter += commitLevelDiff;
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        if (!force && this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was scheduled for rollback.", new Object[0]);
            return;
        }
        if (this.txStartCounter < 0) {
            throw new OTransactionException("Transaction was rolled back more times than it was started.");
        }
        this.database.getStorage().callInLock(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                OTransactionOptimistic.this.database.getStorage().rollback(OTransactionOptimistic.this);
                return null;
            }
        }, true);
        this.database.getLocalCache().clear();
        for (ORecordOperation v : this.allEntries.values()) {
            ORecord rec = v.getRecord();
            if (!rec.isDirty()) continue;
            if (rec instanceof ODocument && ((ODocument)rec).isTrackingChanges()) {
                ((ODocument)rec).undo();
                continue;
            }
            rec.unload();
        }
        this.close();
        this.status = OTransaction.TXSTATUS.ROLLED_BACK;
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY lockingStrategy) {
        return this.loadRecord(rid, iRecord, fetchPlan, ignoreCache, true, loadTombstone, lockingStrategy);
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY lockingStrategy) {
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            if (iRecord != null && txRecord != iRecord) {
                OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", iRecord.getIdentity());
            }
            return txRecord;
        }
        if (rid.isTemporary()) {
            return null;
        }
        Object record = this.database.executeReadRecord((ORecordId)rid, iRecord, -1, fetchPlan, ignoreCache, iUpdateCache, loadTombstone, lockingStrategy, new ODatabaseDocumentTx.SimpleRecordReader(this.database.isPrefetchRecords()));
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord loadRecordIfVersionIsNotLatest(ORID rid, int recordVersion, String fetchPlan, boolean ignoreCache) throws ORecordNotFoundException {
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            throw new ORecordNotFoundException(rid);
        }
        if (txRecord != null) {
            if (txRecord.getVersion() > recordVersion) {
                return txRecord;
            }
            return null;
        }
        if (rid.isTemporary()) {
            throw new ORecordNotFoundException(rid);
        }
        Object record = this.database.executeReadRecord((ORecordId)rid, null, recordVersion, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, new ODatabaseDocumentTx.SimpleRecordReader(this.database.isPrefetchRecords()));
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache) {
        return this.reloadRecord(rid, iRecord, fetchPlan, ignoreCache, true);
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord passedRecord, String fetchPlan, boolean ignoreCache, boolean force) {
        Object record;
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            if (passedRecord != null && txRecord != passedRecord) {
                OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", passedRecord.getIdentity());
            }
            return txRecord;
        }
        if (rid.isTemporary()) {
            return null;
        }
        try {
            ODatabaseDocumentTx.RecordReader recordReader = force ? new ODatabaseDocumentTx.SimpleRecordReader(this.database.isPrefetchRecords()) : new ODatabaseDocumentTx.LatestVersionRecordReader();
            Object loadedRecord = this.database.executeReadRecord((ORecordId)rid, passedRecord, -1, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, recordReader);
            record = force ? loadedRecord : (loadedRecord == null ? passedRecord : loadedRecord);
        }
        catch (ORecordNotFoundException ignore) {
            return null;
        }
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord record, String fetchPlan, boolean ignoreCache) {
        return this.loadRecord(rid, record, fetchPlan, ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE);
    }

    @Override
    public void deleteRecord(ORecord iRecord, ODatabase.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public void recycleRecord(ORecord iRecord) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)4, null);
    }

    @Override
    public ORecord saveRecord(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<Integer> iRecordUpdatedCallback) {
        this.recordCreatedCallback = iRecordCreatedCallback;
        this.recordUpdatedCallback = iRecordUpdatedCallback;
        if (iRecord == null) {
            return null;
        }
        boolean originalSaved = false;
        ODirtyManager dirtyManager = ORecordInternal.getDirtyManager(iRecord);
        do {
            Set<ORecord> newRecord = dirtyManager.getNewRecords();
            Set<ORecord> updatedRecord = dirtyManager.getUpdateRecords();
            dirtyManager.clear();
            if (newRecord != null) {
                for (ORecord rec : newRecord) {
                    if (rec instanceof ODocument) {
                        ODocumentInternal.convertAllMultiValuesToTrackedVersions((ODocument)rec);
                    }
                    if (rec == iRecord) {
                        this.addRecord(rec, (byte)3, iClusterName);
                        originalSaved = true;
                        continue;
                    }
                    this.addRecord(rec, (byte)3, this.getClusterName(rec));
                }
            }
            if (updatedRecord == null) continue;
            for (ORecord rec : updatedRecord) {
                if (rec instanceof ODocument) {
                    ODocumentInternal.convertAllMultiValuesToTrackedVersions((ODocument)rec);
                }
                if (rec == iRecord) {
                    byte operation = iForceCreate ? (byte)3 : (iRecord.getIdentity().isValid() ? (byte)1 : 3);
                    this.addRecord(rec, operation, iClusterName);
                    originalSaved = true;
                    continue;
                }
                this.addRecord(rec, (byte)1, this.getClusterName(rec));
            }
        } while (dirtyManager.getNewRecords() != null || dirtyManager.getUpdateRecords() != null);
        if (!originalSaved && iRecord.isDirty()) {
            byte operation = iForceCreate ? (byte)3 : (iRecord.getIdentity().isValid() ? (byte)1 : 3);
            this.addRecord(iRecord, operation, iClusterName);
        }
        return iRecord;
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.allEntries.size() + ", idxEntries=" + this.indexEntries.size() + ']';
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }

    public void setStatus(OTransaction.TXSTATUS iStatus) {
        this.status = iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(ORecord iRecord, byte iStatus, String iClusterName) {
        this.checkTransaction();
        if (iStatus != 0) {
            this.changedDocuments.remove(iRecord);
        }
        try {
            switch (iStatus) {
                case 3: 
                case 4: {
                    this.database.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_CREATE, (Object)iClusterName);
                    ORecordHook.RESULT res = this.database.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord);
                    if (res != ORecordHook.RESULT.RECORD_CHANGED || !(iRecord instanceof ODocument)) break;
                    ((ODocument)iRecord).validate();
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    this.database.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_UPDATE, (Object)iClusterName);
                    ORecordHook.RESULT res = this.database.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord);
                    if (res != ORecordHook.RESULT.RECORD_CHANGED || !(iRecord instanceof ODocument)) break;
                    ((ODocument)iRecord).validate();
                    break;
                }
                case 2: {
                    this.database.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)iClusterName);
                    this.database.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, iRecord);
                }
            }
            try {
                ORecordOperation txEntry;
                ORecordId rid = (ORecordId)iRecord.getIdentity();
                if (!rid.isValid()) {
                    ORecordInternal.onBeforeIdentityChanged(iRecord);
                    this.database.assignAndCheckCluster(iRecord, iClusterName);
                    rid.setClusterPosition(this.newObjectCounter--);
                    ORecordInternal.onAfterIdentityChanged(iRecord);
                }
                if ((txEntry = this.getRecordEntry(rid)) == null) {
                    if (!rid.isTemporary() || iStatus == 3) {
                        txEntry = new ORecordOperation(iRecord, iStatus);
                        this.allEntries.put(rid.copy(), txEntry);
                    }
                } else {
                    txEntry.record = iRecord;
                    switch (txEntry.type) {
                        case 0: {
                            switch (iStatus) {
                                case 1: {
                                    txEntry.type = 1;
                                    break;
                                }
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 1: {
                            switch (iStatus) {
                                case 2: {
                                    txEntry.type = (byte)2;
                                }
                            }
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            switch (iStatus) {
                                case 2: {
                                    this.allEntries.remove(rid);
                                }
                            }
                        }
                    }
                }
                switch (iStatus) {
                    case 3: 
                    case 4: {
                        this.database.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, iRecord);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, iRecord);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, iRecord);
                    }
                }
                if (iRecord instanceof ODocument && ((ODocument)iRecord).isTrackingChanges()) {
                    ODocumentInternal.clearTrackData((ODocument)iRecord);
                }
            }
            catch (Exception e) {
                switch (iStatus) {
                    case 3: 
                    case 4: {
                        this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, iRecord);
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, iRecord);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, iRecord);
                    }
                }
                throw OException.wrapException(new ODatabaseException("Error on saving record " + iRecord.getIdentity()), e);
            }
        }
        finally {
            switch (iStatus) {
                case 3: 
                case 4: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_CREATION, iRecord);
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_UPDATE, iRecord);
                    break;
                }
                case 2: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_DELETION, iRecord);
                }
            }
        }
    }

    @Override
    public void close() {
        this.recordCreatedCallback = null;
        this.recordUpdatedCallback = null;
        super.close();
    }

    private void doCommit() {
        if (this.status == OTransaction.TXSTATUS.ROLLED_BACK || this.status == OTransaction.TXSTATUS.ROLLBACKING) {
            throw new ORollbackException("Given transaction was rolled back and cannot be used.");
        }
        this.status = OTransaction.TXSTATUS.COMMITTING;
        if (!this.allEntries.isEmpty() || !this.indexEntries.isEmpty()) {
            this.database.getStorage().commit(this, null);
        }
        this.invokeCallbacks();
        this.close();
        this.status = OTransaction.TXSTATUS.COMPLETED;
    }

    private void invokeCallbacks() {
        if (this.recordCreatedCallback != null || this.recordUpdatedCallback != null) {
            for (ORecordOperation operation : this.allEntries.values()) {
                ORecord record = operation.getRecord();
                ORID identity = record.getIdentity();
                if ((operation.type == 3 || operation.type == 4) && this.recordCreatedCallback != null) {
                    this.recordCreatedCallback.call(new ORecordId(identity), identity.getClusterPosition());
                    continue;
                }
                if (operation.type != 1 || this.recordUpdatedCallback == null) continue;
                this.recordUpdatedCallback.call(new ORecordId(identity), record.getVersion());
            }
        }
    }
}

