/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OComparableLockManager<T extends Comparable> {
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private long acquireTimeout;
    protected final ConcurrentSkipListMap<T, CountableLock> map;
    private final boolean enabled;
    private static final Object NULL_KEY;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OComparableLockManager(boolean iEnabled, int iAcquireTimeout) {
        this(iEnabled, iAcquireTimeout, OComparableLockManager.defaultConcurrency());
    }

    public OComparableLockManager(boolean iEnabled, int iAcquireTimeout, int concurrencyLevel) {
        int cL = OComparableLockManager.closestInteger(concurrencyLevel);
        this.map = new ConcurrentSkipListMap();
        this.acquireTimeout = iAcquireTimeout;
        this.enabled = iEnabled;
    }

    public void acquireSharedLock(T key) {
        this.acquireLock(key, LOCK.SHARED);
    }

    public void releaseSharedLock(T key) {
        this.releaseLock(Thread.currentThread(), key, LOCK.SHARED);
    }

    public void acquireExclusiveLock(T key) {
        this.acquireLock(key, LOCK.EXCLUSIVE);
    }

    public void releaseExclusiveLock(T key) {
        this.releaseLock(Thread.currentThread(), key, LOCK.EXCLUSIVE);
    }

    public void acquireLock(T iResourceId, LOCK iLockType) {
        this.acquireLock(iResourceId, iLockType, this.acquireTimeout);
    }

    public void acquireLock(T iResourceId, LOCK iLockType, long iTimeout) {
        block15: {
            CountableLock lock;
            CountableLock oldLock;
            if (!this.enabled) {
                return;
            }
            if (!this.enabled) {
                return;
            }
            Object immutableResource = this.getImmutableResourceId(iResourceId);
            if (immutableResource == null) {
                immutableResource = (Comparable)NULL_KEY;
            }
            while ((oldLock = this.map.putIfAbsent(immutableResource, lock = new CountableLock())) != null) {
                lock = oldLock;
                int oldValue = lock.countLocks.get();
                if (oldValue >= 0) {
                    if (!lock.countLocks.compareAndSet(oldValue, oldValue + 1)) continue;
                    assert (this.map.get(immutableResource) == lock);
                    break;
                }
                this.map.remove(immutableResource, lock);
            }
            try {
                if (iTimeout <= 0L) {
                    if (iLockType == LOCK.SHARED) {
                        lock.readWriteLock.readLock().lock();
                    } else {
                        lock.readWriteLock.writeLock().lock();
                    }
                    break block15;
                }
                try {
                    if (iLockType == LOCK.SHARED ? !lock.readWriteLock.readLock().tryLock(iTimeout, TimeUnit.MILLISECONDS) : !lock.readWriteLock.writeLock().tryLock(iTimeout, TimeUnit.MILLISECONDS)) {
                        throw new OLockException("Timeout (" + iTimeout + "ms) on acquiring resource '" + iResourceId + "' because is locked from another thread");
                    }
                }
                catch (InterruptedException e) {
                    throw OException.wrapException(new OLockException("Thread interrupted while waiting for resource '" + iResourceId + "'"), e);
                }
            }
            catch (RuntimeException e) {
                int usages = lock.countLocks.decrementAndGet();
                if (usages == 0) {
                    this.map.remove(immutableResource);
                }
                throw e;
            }
        }
    }

    public void releaseLock(Object iRequester, T iResourceId, LOCK iLockType) throws OLockException {
        CountableLock lock;
        if (!this.enabled) {
            return;
        }
        if (iResourceId == null) {
            iResourceId = (Comparable)NULL_KEY;
        }
        if ((lock = this.map.get(iResourceId)) == null) {
            throw new OLockException("Error on releasing a non acquired lock by the requester '" + iRequester + "' against the resource: '" + iResourceId + "'");
        }
        int lockCount = lock.countLocks.decrementAndGet();
        if (lockCount == 0 && lock.countLocks.compareAndSet(0, -1)) {
            this.map.remove(iResourceId, lock);
        }
        if (iLockType == LOCK.SHARED) {
            lock.readWriteLock.readLock().unlock();
        } else {
            lock.readWriteLock.writeLock().unlock();
        }
    }

    public int getCountCurrentLocks() {
        return this.map.size();
    }

    protected T getImmutableResourceId(T iResourceId) {
        return iResourceId;
    }

    private static int defaultConcurrency() {
        return Runtime.getRuntime().availableProcessors() << 6 > 16 ? Runtime.getRuntime().availableProcessors() << 6 : 16;
    }

    private static int closestInteger(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    static {
        try {
            try {
                NULL_KEY = new Object();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    private static class CountableLock {
        private final AtomicInteger countLocks = new AtomicInteger(1);
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private CountableLock() {
        }
    }

    public static final class LOCK
    extends Enum<LOCK> {
        public static final /* enum */ LOCK SHARED;
        public static final /* enum */ LOCK EXCLUSIVE;
        private static final /* synthetic */ LOCK[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static LOCK[] values() {
            return (LOCK[])$VALUES.clone();
        }

        public static LOCK valueOf(String name) {
            return Enum.valueOf(LOCK.class, name);
        }

        static {
            try {
                try {
                    SHARED = new LOCK();
                    EXCLUSIVE = new LOCK();
                    $VALUES = new LOCK[]{SHARED, EXCLUSIVE};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

