/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.console;

import com.orientechnologies.common.console.OCommandStream;
import com.orientechnologies.common.log.OLogManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ODFACommandStream
implements OCommandStream {
    public static final int BUFFER_SIZE = 1024;
    private final Set<Character> separators = new HashSet<Character>(Arrays.asList(Character.valueOf(';'), Character.valueOf('\n')));
    private Reader reader;
    private Character nextCharacter;
    private State state;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ODFACommandStream(String commands) {
        this.reader = new StringReader(commands);
        this.init();
    }

    public ODFACommandStream(File file) throws FileNotFoundException {
        this.reader = new BufferedReader(new FileReader(file), 1024);
        this.init();
    }

    private void init() {
        try {
            int next = this.reader.read();
            this.nextCharacter = next > -1 ? Character.valueOf((char)next) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Character nextCharacter() throws IOException {
        if (this.nextCharacter == null) {
            return null;
        }
        Character result = this.nextCharacter;
        int next = this.reader.read();
        this.nextCharacter = next < 0 ? null : Character.valueOf((char)next);
        return result;
    }

    @Override
    public boolean hasNext() {
        return this.nextCharacter != null;
    }

    @Override
    public String nextCommand() {
        try {
            this.state = State.S;
            StringBuilder result = new StringBuilder();
            StringBuilder stateWord = new StringBuilder();
            while (this.state != State.E) {
                Symbol s;
                Character c = this.nextCharacter();
                String sch = null;
                if (c == null) {
                    s = Symbol.EOF;
                } else if (c.equals(Character.valueOf('\''))) {
                    s = Symbol.AP;
                } else if (c.equals(Character.valueOf('\"'))) {
                    s = Symbol.QT;
                } else if (this.separators.contains(c)) {
                    s = Symbol.SEP;
                } else if (Character.isWhitespace(c.charValue())) {
                    s = Symbol.WS;
                } else if (c.charValue() == '\\') {
                    Character nextCharacter = this.nextCharacter();
                    sch = "" + c + nextCharacter;
                    s = Symbol.LATTER;
                } else {
                    s = Symbol.LATTER;
                }
                State newState = this.transition(this.state, s);
                if (newState == State.F) {
                    throw new IllegalStateException("Unexpected end of file");
                }
                State oldState = this.state;
                this.state = newState;
                if (this.state != State.E && this.state != State.S) {
                    if (this.state != oldState) {
                        result.append((CharSequence)stateWord);
                        stateWord = new StringBuilder();
                    }
                    if (sch != null) {
                        stateWord.append(sch);
                    } else {
                        stateWord.append(c);
                    }
                }
                if (this.state != State.E || stateWord.length() <= 0 || oldState == State.D) continue;
                result.append((CharSequence)stateWord);
            }
            return result.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Symbol symbol(Character c) {
        if (c.equals(Character.valueOf('\''))) {
            return Symbol.AP;
        }
        if (c.equals(Character.valueOf('\"'))) {
            return Symbol.QT;
        }
        if (this.separators.contains(c)) {
            return Symbol.SEP;
        }
        if (Character.isWhitespace(c.charValue())) {
            return Symbol.WS;
        }
        return Symbol.LATTER;
    }

    private State transition(State s, Symbol c) {
        switch (s) {
            case S: {
                switch (c) {
                    case LATTER: {
                        return State.A;
                    }
                    case WS: {
                        return State.S;
                    }
                    case AP: {
                        return State.B;
                    }
                    case QT: {
                        return State.C;
                    }
                    case SEP: {
                        return State.S;
                    }
                    case EOF: {
                        return State.E;
                    }
                }
                break;
            }
            case A: 
            case D: {
                switch (c) {
                    case LATTER: {
                        return State.A;
                    }
                    case WS: {
                        return State.D;
                    }
                    case AP: {
                        return State.B;
                    }
                    case QT: {
                        return State.C;
                    }
                    case SEP: {
                        return State.E;
                    }
                    case EOF: {
                        return State.E;
                    }
                }
                break;
            }
            case B: {
                switch (c) {
                    case LATTER: {
                        return State.B;
                    }
                    case WS: {
                        return State.B;
                    }
                    case AP: {
                        return State.A;
                    }
                    case QT: {
                        return State.B;
                    }
                    case SEP: {
                        return State.B;
                    }
                    case EOF: {
                        return State.F;
                    }
                }
                break;
            }
            case C: {
                switch (c) {
                    case LATTER: {
                        return State.C;
                    }
                    case WS: {
                        return State.C;
                    }
                    case AP: {
                        return State.C;
                    }
                    case QT: {
                        return State.A;
                    }
                    case SEP: {
                        return State.C;
                    }
                    case EOF: {
                        return State.F;
                    }
                }
                break;
            }
            case E: {
                return State.E;
            }
            case F: {
                return State.F;
            }
        }
        throw new IllegalStateException();
    }

    private static final class Symbol
    extends Enum<Symbol> {
        public static final /* enum */ Symbol LATTER;
        public static final /* enum */ Symbol WS;
        public static final /* enum */ Symbol QT;
        public static final /* enum */ Symbol AP;
        public static final /* enum */ Symbol SEP;
        public static final /* enum */ Symbol EOF;
        private static final /* synthetic */ Symbol[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static Symbol[] values() {
            return (Symbol[])$VALUES.clone();
        }

        public static Symbol valueOf(String name) {
            return Enum.valueOf(Symbol.class, name);
        }

        static {
            try {
                try {
                    LATTER = new Symbol();
                    WS = new Symbol();
                    QT = new Symbol();
                    AP = new Symbol();
                    SEP = new Symbol();
                    EOF = new Symbol();
                    $VALUES = new Symbol[]{LATTER, WS, QT, AP, SEP, EOF};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State S;
        public static final /* enum */ State A;
        public static final /* enum */ State B;
        public static final /* enum */ State C;
        public static final /* enum */ State D;
        public static final /* enum */ State E;
        public static final /* enum */ State F;
        private static final /* synthetic */ State[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String name) {
            return Enum.valueOf(State.class, name);
        }

        static {
            try {
                try {
                    S = new State();
                    A = new State();
                    B = new State();
                    C = new State();
                    D = new State();
                    E = new State();
                    F = new State();
                    $VALUES = new State[]{S, A, B, C, D, E, F};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

