/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.OBinaryConverter;
import java.nio.ByteOrder;

public class OSafeBinaryConverter
implements OBinaryConverter {
    public static final OSafeBinaryConverter INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public void putShort(byte[] buffer, int index, short value, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            OSafeBinaryConverter.short2BytesBigEndian(value, buffer, index);
        } else {
            OSafeBinaryConverter.short2BytesLittleEndian(value, buffer, index);
        }
    }

    @Override
    public short getShort(byte[] buffer, int index, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return OSafeBinaryConverter.bytes2ShortBigEndian(buffer, index);
        }
        return OSafeBinaryConverter.bytes2ShortLittleEndian(buffer, index);
    }

    @Override
    public void putInt(byte[] buffer, int pointer, int value, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            OSafeBinaryConverter.int2BytesBigEndian(value, buffer, pointer);
        } else {
            OSafeBinaryConverter.int2BytesLittleEndian(value, buffer, pointer);
        }
    }

    @Override
    public int getInt(byte[] buffer, int pointer, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return OSafeBinaryConverter.bytes2IntBigEndian(buffer, pointer);
        }
        return OSafeBinaryConverter.bytes2IntLittleEndian(buffer, pointer);
    }

    @Override
    public void putLong(byte[] buffer, int index, long value, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            OSafeBinaryConverter.long2BytesBigEndian(value, buffer, index);
        } else {
            OSafeBinaryConverter.long2BytesLittleEndian(value, buffer, index);
        }
    }

    @Override
    public long getLong(byte[] buffer, int index, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return OSafeBinaryConverter.bytes2LongBigEndian(buffer, index);
        }
        return OSafeBinaryConverter.bytes2LongLittleEndian(buffer, index);
    }

    @Override
    public void putChar(byte[] buffer, int index, char character, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            buffer[index] = (byte)(character >>> 8);
            buffer[index + 1] = (byte)character;
        } else {
            buffer[index + 1] = (byte)(character >>> 8);
            buffer[index] = (byte)character;
        }
    }

    @Override
    public char getChar(byte[] buffer, int index, ByteOrder byteOrder) {
        if (byteOrder.equals(ByteOrder.BIG_ENDIAN)) {
            return (char)(((buffer[index] & 0xFF) << 8) + (buffer[index + 1] & 0xFF));
        }
        return (char)(((buffer[index + 1] & 0xFF) << 8) + (buffer[index] & 0xFF));
    }

    @Override
    public boolean nativeAccelerationUsed() {
        return false;
    }

    private static byte[] short2BytesBigEndian(short value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value & 0xFF);
        return b;
    }

    private static byte[] short2BytesLittleEndian(short value, byte[] b, int iBeginOffset) {
        b[iBeginOffset + 1] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset] = (byte)(value & 0xFF);
        return b;
    }

    private static short bytes2ShortBigEndian(byte[] b, int offset) {
        return (short)(b[offset] << 8 | b[offset + 1] & 0xFF);
    }

    private static short bytes2ShortLittleEndian(byte[] b, int offset) {
        return (short)(b[offset + 1] << 8 | b[offset] & 0xFF);
    }

    private static int bytes2IntBigEndian(byte[] b, int offset) {
        return b[offset] << 24 | (0xFF & b[offset + 1]) << 16 | (0xFF & b[offset + 2]) << 8 | 0xFF & b[offset + 3];
    }

    private static int bytes2IntLittleEndian(byte[] b, int offset) {
        return b[offset + 3] << 24 | (0xFF & b[offset + 2]) << 16 | (0xFF & b[offset + 1]) << 8 | 0xFF & b[offset];
    }

    private static byte[] int2BytesBigEndian(int value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 24 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value >>> 16 & 0xFF);
        b[iBeginOffset + 2] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset + 3] = (byte)(value & 0xFF);
        return b;
    }

    private static byte[] int2BytesLittleEndian(int value, byte[] b, int iBeginOffset) {
        b[iBeginOffset + 3] = (byte)(value >>> 24 & 0xFF);
        b[iBeginOffset + 2] = (byte)(value >>> 16 & 0xFF);
        b[iBeginOffset + 1] = (byte)(value >>> 8 & 0xFF);
        b[iBeginOffset] = (byte)(value & 0xFF);
        return b;
    }

    private static byte[] long2BytesBigEndian(long value, byte[] b, int iBeginOffset) {
        b[iBeginOffset] = (byte)(value >>> 56 & 0xFFL);
        b[iBeginOffset + 1] = (byte)(value >>> 48 & 0xFFL);
        b[iBeginOffset + 2] = (byte)(value >>> 40 & 0xFFL);
        b[iBeginOffset + 3] = (byte)(value >>> 32 & 0xFFL);
        b[iBeginOffset + 4] = (byte)(value >>> 24 & 0xFFL);
        b[iBeginOffset + 5] = (byte)(value >>> 16 & 0xFFL);
        b[iBeginOffset + 6] = (byte)(value >>> 8 & 0xFFL);
        b[iBeginOffset + 7] = (byte)(value & 0xFFL);
        return b;
    }

    private static byte[] long2BytesLittleEndian(long value, byte[] b, int iBeginOffset) {
        b[iBeginOffset + 7] = (byte)(value >>> 56 & 0xFFL);
        b[iBeginOffset + 6] = (byte)(value >>> 48 & 0xFFL);
        b[iBeginOffset + 5] = (byte)(value >>> 40 & 0xFFL);
        b[iBeginOffset + 4] = (byte)(value >>> 32 & 0xFFL);
        b[iBeginOffset + 3] = (byte)(value >>> 24 & 0xFFL);
        b[iBeginOffset + 2] = (byte)(value >>> 16 & 0xFFL);
        b[iBeginOffset + 1] = (byte)(value >>> 8 & 0xFFL);
        b[iBeginOffset] = (byte)(value & 0xFFL);
        return b;
    }

    private static long bytes2LongBigEndian(byte[] b, int offset) {
        return (long)(0xFF & b[offset + 7] | (0xFF & b[offset + 6]) << 8 | (0xFF & b[offset + 5]) << 16) | (long)(0xFF & b[offset + 4]) << 24 | (long)(0xFF & b[offset + 3]) << 32 | (long)(0xFF & b[offset + 2]) << 40 | (long)(0xFF & b[offset + 1]) << 48 | (long)(0xFF & b[offset]) << 56;
    }

    private static long bytes2LongLittleEndian(byte[] b, int offset) {
        return (long)(0xFF & b[offset] | (0xFF & b[offset + 1]) << 8 | (0xFF & b[offset + 2]) << 16) | (long)(0xFF & b[offset + 3]) << 24 | (long)(0xFF & b[offset + 4]) << 32 | (long)(0xFF & b[offset + 5]) << 40 | (long)(0xFF & b[offset + 6]) << 48 | (long)(0xFF & b[offset + 7]) << 56;
    }

    static {
        try {
            try {
                INSTANCE = new OSafeBinaryConverter();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

