/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OIntegerSerializer
implements OBinarySerializer<Integer> {
    public static final byte ID = 8;
    public static final int INT_SIZE = 4;
    private static final OBinaryConverter CONVERTER;
    public static final OIntegerSerializer INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public int getObjectSize(Integer object, Object ... hints) {
        return 4;
    }

    @Override
    public void serialize(Integer object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object, stream, startPosition);
    }

    public void serializeLiteral(int value, byte[] stream, int startPosition) {
        stream[startPosition] = (byte)(value >>> 24 & 0xFF);
        stream[startPosition + 1] = (byte)(value >>> 16 & 0xFF);
        stream[startPosition + 2] = (byte)(value >>> 8 & 0xFF);
        stream[startPosition + 3] = (byte)(value >>> 0 & 0xFF);
    }

    @Override
    public Integer deserialize(byte[] stream, int startPosition) {
        return this.deserializeLiteral(stream, startPosition);
    }

    public int deserializeLiteral(byte[] stream, int startPosition) {
        return stream[startPosition] << 24 | (0xFF & stream[startPosition + 1]) << 16 | (0xFF & stream[startPosition + 2]) << 8 | 0xFF & stream[startPosition + 3];
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public byte getId() {
        return 8;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 4;
    }

    @Override
    public void serializeNativeObject(Integer object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putInt(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    @Override
    public Integer deserializeNativeObject(byte[] stream, int startPosition) {
        return CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder());
    }

    public void serializeNative(int object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putInt(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    public int deserializeNative(byte[] stream, int startPosition) {
        return CONVERTER.getInt(stream, startPosition, ByteOrder.nativeOrder());
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 4;
    }

    @Override
    public Integer preprocess(Integer value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Integer object, ByteBuffer buffer, Object ... hints) {
        buffer.putInt(object);
    }

    @Override
    public Integer deserializeFromByteBufferObject(ByteBuffer buffer) {
        return buffer.getInt();
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 4;
    }

    @Override
    public Integer deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getIntValue(buffer, offset);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 4;
    }

    static {
        try {
            try {
                CONVERTER = OBinaryConverterFactory.getConverter();
                INSTANCE = new OIntegerSerializer();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

