/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class OShortSerializer
implements OBinarySerializer<Short> {
    public static final byte ID = 12;
    public static final int SHORT_SIZE = 2;
    private static final OBinaryConverter CONVERTER;
    public static final OShortSerializer INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public int getObjectSize(Short object, Object ... hints) {
        return 2;
    }

    @Override
    public void serialize(Short object, byte[] stream, int startPosition, Object ... hints) {
        this.serializeLiteral(object, stream, startPosition);
    }

    public void serializeLiteral(short value, byte[] stream, int startPosition) {
        stream[startPosition] = (byte)(value >>> 8 & 0xFF);
        stream[startPosition + 1] = (byte)(value >>> 0 & 0xFF);
    }

    @Override
    public Short deserialize(byte[] stream, int startPosition) {
        return this.deserializeLiteral(stream, startPosition);
    }

    public short deserializeLiteral(byte[] stream, int startPosition) {
        return (short)(stream[startPosition] << 8 | stream[startPosition + 1] & 0xFF);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public byte getId() {
        return 12;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 2;
    }

    @Override
    public void serializeNativeObject(Short object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putShort(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    @Override
    public Short deserializeNativeObject(byte[] stream, int startPosition) {
        return CONVERTER.getShort(stream, startPosition, ByteOrder.nativeOrder());
    }

    public void serializeNative(short object, byte[] stream, int startPosition, Object ... hints) {
        CONVERTER.putShort(stream, startPosition, object, ByteOrder.nativeOrder());
    }

    public short deserializeNative(byte[] stream, int startPosition) {
        return CONVERTER.getShort(stream, startPosition, ByteOrder.nativeOrder());
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 2;
    }

    @Override
    public Short preprocess(Short value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(Short object, ByteBuffer buffer, Object ... hints) {
        buffer.putShort(object);
    }

    @Override
    public Short deserializeFromByteBufferObject(ByteBuffer buffer) {
        return buffer.getShort();
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 2;
    }

    @Override
    public Short deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getShortValue(buffer, offset);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 2;
    }

    static {
        try {
            try {
                CONVERTER = OBinaryConverterFactory.getConverter();
                INSTANCE = new OShortSerializer();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

