/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;

public class OStringSerializer
implements OBinarySerializer<String> {
    public static final OStringSerializer INSTANCE;
    public static final byte ID = 13;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public int getObjectSize(String object, Object ... hints) {
        return object.length() * 2 + 4;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition, Object ... hints) {
        int length = object.length();
        OIntegerSerializer.INSTANCE.serializeLiteral(length, stream, startPosition);
        startPosition += 4;
        char[] stringContent = new char[length];
        object.getChars(0, length, stringContent, 0);
        for (char character : stringContent) {
            stream[startPosition] = (byte)character;
            stream[++startPosition] = (byte)(character >>> 8);
            ++startPosition;
        }
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
        char[] buffer = new char[len];
        startPosition += 4;
        for (int i = 0; i < len; ++i) {
            buffer[i] = (char)(0xFF & stream[startPosition] | (0xFF & stream[startPosition + 1]) << 8);
            startPosition += 2;
        }
        return new String(buffer);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeLiteral(stream, startPosition) * 2 + 4;
    }

    @Override
    public byte getId() {
        return 13;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition) * 2 + 4;
    }

    @Override
    public void serializeNativeObject(String object, byte[] stream, int startPosition, Object ... hints) {
        int length = object.length();
        OIntegerSerializer.INSTANCE.serializeNative(length, stream, startPosition, new Object[0]);
        startPosition += 4;
        char[] stringContent = new char[length];
        object.getChars(0, length, stringContent, 0);
        for (char character : stringContent) {
            stream[startPosition] = (byte)character;
            stream[++startPosition] = (byte)(character >>> 8);
            ++startPosition;
        }
    }

    @Override
    public String deserializeNativeObject(byte[] stream, int startPosition) {
        int len = OIntegerSerializer.INSTANCE.deserializeNative(stream, startPosition);
        char[] buffer = new char[len];
        startPosition += 4;
        for (int i = 0; i < len; ++i) {
            buffer[i] = (char)(0xFF & stream[startPosition] | (0xFF & stream[startPosition + 1]) << 8);
            startPosition += 2;
        }
        return new String(buffer);
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        throw new UnsupportedOperationException("Length of serialized string is not fixed.");
    }

    @Override
    public String preprocess(String value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(String object, ByteBuffer buffer, Object ... hints) {
        int length = object.length();
        buffer.putInt(length);
        byte[] binaryData = new byte[length * 2];
        char[] stringContent = new char[length];
        object.getChars(0, length, stringContent, 0);
        int counter = 0;
        for (char character : stringContent) {
            binaryData[counter] = (byte)character;
            binaryData[++counter] = (byte)(character >>> 8);
            ++counter;
        }
        buffer.put(binaryData);
    }

    @Override
    public String deserializeFromByteBufferObject(ByteBuffer buffer) {
        int len = buffer.getInt();
        char[] chars = new char[len];
        byte[] binaryData = new byte[2 * len];
        buffer.get(binaryData);
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(0xFF & binaryData[i << 1] | (0xFF & binaryData[(i << 1) + 1]) << 8);
        }
        return new String(chars);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return buffer.getInt() * 2 + 4;
    }

    @Override
    public String deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        int len = walChanges.getIntValue(buffer, offset);
        char[] chars = new char[len];
        byte[] binaryData = walChanges.getBinaryValue(buffer, offset += 4, 2 * len);
        for (int i = 0; i < len; ++i) {
            chars[i] = (char)(0xFF & binaryData[i << 1] | (0xFF & binaryData[(i << 1) + 1]) << 8);
        }
        return new String(chars);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return walChanges.getIntValue(buffer, offset) * 2 + 4;
    }

    static {
        try {
            try {
                INSTANCE = new OStringSerializer();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

