/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;
import java.util.UUID;

public class OUUIDSerializer
implements OBinarySerializer<UUID> {
    public static final OUUIDSerializer INSTANCE;
    public static final int UUID_SIZE = 16;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public int getObjectSize(UUID object, Object ... hints) {
        return 16;
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 16;
    }

    @Override
    public void serialize(UUID object, byte[] stream, int startPosition, Object ... hints) {
        OLongSerializer.INSTANCE.serializeLiteral(object.getMostSignificantBits(), stream, startPosition);
        OLongSerializer.INSTANCE.serializeLiteral(object.getLeastSignificantBits(), stream, startPosition + 8);
    }

    @Override
    public UUID deserialize(byte[] stream, int startPosition) {
        long mostSignificantBits = OLongSerializer.INSTANCE.deserializeLiteral(stream, startPosition);
        long leastSignificantBits = OLongSerializer.INSTANCE.deserializeLiteral(stream, startPosition + 8);
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Override
    public byte getId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isFixedLength() {
        return OLongSerializer.INSTANCE.isFixedLength();
    }

    @Override
    public int getFixedLength() {
        return 16;
    }

    @Override
    public void serializeNativeObject(UUID object, byte[] stream, int startPosition, Object ... hints) {
        OLongSerializer.INSTANCE.serializeNative(object.getMostSignificantBits(), stream, startPosition, hints);
        OLongSerializer.INSTANCE.serializeNative(object.getLeastSignificantBits(), stream, startPosition + 8, hints);
    }

    @Override
    public UUID deserializeNativeObject(byte[] stream, int startPosition) {
        long mostSignificantBits = OLongSerializer.INSTANCE.deserializeNative(stream, startPosition);
        long leastSignificantBits = OLongSerializer.INSTANCE.deserializeNative(stream, startPosition + 8);
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 16;
    }

    @Override
    public UUID preprocess(UUID value, Object ... hints) {
        return value;
    }

    @Override
    public void serializeInByteBufferObject(UUID object, ByteBuffer buffer, Object ... hints) {
        buffer.putLong(object.getMostSignificantBits());
        buffer.putLong(object.getLeastSignificantBits());
    }

    @Override
    public UUID deserializeFromByteBufferObject(ByteBuffer buffer) {
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 16;
    }

    @Override
    public UUID deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        long mostSignificantBits = walChanges.getLongValue(buffer, offset);
        long leastSignificantBits = walChanges.getLongValue(buffer, offset + 8);
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 16;
    }

    static {
        try {
            try {
                INSTANCE = new OUUIDSerializer();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

