/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.util;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import java.util.Iterator;
import java.util.ServiceLoader;

public class OClassLoaderHelper {
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static synchronized <T> Iterator<T> lookupProviderWithOrientClassLoader(Class<T> clazz) {
        return OClassLoaderHelper.lookupProviderWithOrientClassLoader(clazz, OClassLoaderHelper.class.getClassLoader());
    }

    public static synchronized <T> Iterator<T> lookupProviderWithOrientClassLoader(Class<T> clazz, ClassLoader orientClassLoader) {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(orientClassLoader);
        try {
            Iterator<T> iterator = ServiceLoader.load(clazz).iterator();
            return iterator;
        }
        catch (Exception e) {
            OLogManager.instance().warn(null, "Cannot lookup in service registry", e, new Object[0]);
            throw OException.wrapException(new OConfigurationException("Cannot lookup in service registry"), e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }
}

