/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.script;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequestTextAbstract;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import javax.script.CompiledScript;

public class OCommandScript
extends OCommandRequestTextAbstract {
    private String language;
    private CompiledScript compiledScript;
    private OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OCommandScript() {
        this.useCache = true;
    }

    public OCommandScript(String iLanguage, String iText) {
        super(iText);
        this.setLanguage(iLanguage);
        this.useCache = true;
    }

    public OCommandScript(String iText) {
        this("sql", iText);
    }

    @Override
    public boolean isIdempotent() {
        return false;
    }

    public String getLanguage() {
        return this.language;
    }

    public OCommandScript setLanguage(String language) {
        if (language == null || language.isEmpty()) {
            throw new IllegalArgumentException("Not a valid script language specified: " + language);
        }
        this.language = language;
        return this;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream(iStream);
        this.language = buffer.getAsString();
        int currPosition = buffer.getPosition();
        String value = buffer.getAsString();
        try {
            this.executionMode = OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.valueOf(value);
        }
        catch (IllegalArgumentException ignore) {
            buffer.setPosition(currPosition);
        }
        this.fromStream(buffer);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        OMemoryStream buffer = new OMemoryStream();
        buffer.setUtf8(this.language);
        buffer.setUtf8(this.executionMode.name());
        return this.toStream(buffer);
    }

    public CompiledScript getCompiledScript() {
        return this.compiledScript;
    }

    public void setCompiledScript(CompiledScript script) {
        this.compiledScript = script;
    }

    @Override
    public String toString() {
        if (this.language != null) {
            return this.language + "." + this.text;
        }
        return "script." + this.text;
    }

    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getExecutionMode() {
        return this.executionMode;
    }

    public OCommandScript setExecutionMode(OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE executionMode) {
        this.executionMode = executionMode;
        return this;
    }
}

