/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class OTraverseContext
extends OBasicCommandContext {
    private Memory memory = new StackMemory();
    private Set<ORID> history = new HashSet<ORID>();
    private OTraverseAbstractProcess<?> currentProcess;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public void push(OTraverseAbstractProcess<?> iProcess) {
        this.memory.add(iProcess);
    }

    @Override
    public Map<String, Object> getVariables() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("depth", this.getDepth());
        map.put("path", this.getPath());
        map.put("stack", this.memory.getUnderlying());
        map.putAll(super.getVariables());
        return map;
    }

    @Override
    public Object getVariable(String iName) {
        String name = iName.trim().toUpperCase(Locale.ENGLISH);
        if ("DEPTH".startsWith(name)) {
            return this.getDepth();
        }
        if (name.startsWith("PATH")) {
            return ODocumentHelper.getFieldValue(this.getPath(), iName.substring("PATH".length()));
        }
        if (name.startsWith("STACK")) {
            Object result = ODocumentHelper.getFieldValue(this.memory.getUnderlying(), iName.substring("STACK".length()));
            if (result instanceof ArrayDeque) {
                result = ((ArrayDeque)result).clone();
            }
            return result;
        }
        if (name.startsWith("HISTORY")) {
            return ODocumentHelper.getFieldValue(this.history, iName.substring("HISTORY".length()));
        }
        return super.getVariable(iName);
    }

    public void pop(OIdentifiable currentRecord) {
        ORID rid;
        if (currentRecord != null && !this.history.remove(rid = currentRecord.getIdentity())) {
            OLogManager.instance().warn((Object)this, "Element '" + rid + "' not found in traverse history", new Object[0]);
        }
        try {
            this.memory.dropFrame();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("Traverse stack is empty", e);
        }
    }

    public OTraverseAbstractProcess<?> next() {
        this.currentProcess = this.memory.next();
        return this.currentProcess;
    }

    public boolean isEmpty() {
        return this.memory.isEmpty();
    }

    public void reset() {
        this.memory.clear();
    }

    public boolean isAlreadyTraversed(OIdentifiable identity, int iLevel) {
        return this.history.contains(identity.getIdentity());
    }

    public void addTraversed(OIdentifiable identity, int iLevel) {
        this.history.add(identity.getIdentity());
    }

    public String getPath() {
        return this.currentProcess == null ? "" : this.currentProcess.getPath().toString();
    }

    public int getDepth() {
        return this.currentProcess == null ? 0 : this.currentProcess.getPath().getDepth();
    }

    public void setStrategy(OTraverse.STRATEGY strategy) {
        this.memory = strategy == OTraverse.STRATEGY.BREADTH_FIRST ? new QueueMemory(this.memory) : new StackMemory(this.memory);
    }

    private static class QueueMemory
    extends AbstractMemory {
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public QueueMemory(Memory memory) {
            super(memory);
        }

        @Override
        public void add(OTraverseAbstractProcess<?> iProcess) {
            this.deque.addLast(iProcess);
        }
    }

    private static class StackMemory
    extends AbstractMemory {
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public StackMemory() {
        }

        public StackMemory(Memory memory) {
            super(memory);
        }

        @Override
        public void add(OTraverseAbstractProcess<?> iProcess) {
            this.deque.push(iProcess);
        }
    }

    private static abstract class AbstractMemory
    implements Memory {
        protected final Deque<OTraverseAbstractProcess<?>> deque;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public AbstractMemory() {
            this.deque = new ArrayDeque();
        }

        public AbstractMemory(Memory memory) {
            this.deque = new ArrayDeque(memory.getUnderlying());
        }

        @Override
        public OTraverseAbstractProcess<?> next() {
            return this.deque.peek();
        }

        @Override
        public void dropFrame() {
            this.deque.removeFirst();
        }

        @Override
        public void clear() {
            this.deque.clear();
        }

        @Override
        public boolean isEmpty() {
            return this.deque.isEmpty();
        }

        @Override
        public Collection<OTraverseAbstractProcess<?>> getUnderlying() {
            return this.deque;
        }
    }

    private static interface Memory {
        public static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public void add(OTraverseAbstractProcess<?> var1);

        public OTraverseAbstractProcess<?> next();

        public void dropFrame();

        public void clear();

        public Collection<OTraverseAbstractProcess<?>> getUnderlying();

        public boolean isEmpty();
    }
}

