/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.util.ArrayDeque;

public class OTraversePath {
    private static final OTraversePath EMPTY_PATH;
    private final PathItem lastPathItem;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    private OTraversePath(PathItem lastPathItem) {
        this.lastPathItem = lastPathItem;
    }

    public String toString() {
        ArrayDeque<PathItem> stack = new ArrayDeque<PathItem>();
        PathItem currentItem = this.lastPathItem;
        while (currentItem != null) {
            stack.push(currentItem);
            currentItem = currentItem.parentItem;
        }
        StringBuilder buf = new StringBuilder(1024);
        for (PathItem pathItem : stack) {
            buf.append(pathItem.toString());
        }
        return buf.toString();
    }

    public OTraversePath append(OIdentifiable record) {
        return new OTraversePath(new RecordPathItem(record, this.lastPathItem));
    }

    public OTraversePath appendField(String fieldName) {
        return new OTraversePath(new FieldPathItem(fieldName, this.lastPathItem));
    }

    public OTraversePath appendIndex(int index) {
        return new OTraversePath(new CollectionPathItem(index, this.lastPathItem));
    }

    public OTraversePath appendRecordSet() {
        return this;
    }

    public int getDepth() {
        return this.lastPathItem.depth;
    }

    public static OTraversePath empty() {
        return EMPTY_PATH;
    }

    static {
        try {
            try {
                EMPTY_PATH = new OTraversePath(new FirstPathItem());
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    private static class FirstPathItem
    extends PathItem {
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private FirstPathItem() {
            super(null, -1);
        }

        public String toString() {
            return "";
        }
    }

    private static class CollectionPathItem
    extends PathItem {
        private final int index;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private CollectionPathItem(int index, PathItem parentItem) {
            super(parentItem, parentItem.depth);
            this.index = index;
        }

        public String toString() {
            return "[" + this.index + "]";
        }
    }

    private static class FieldPathItem
    extends PathItem {
        private final String name;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private FieldPathItem(String name, PathItem parentItem) {
            super(parentItem, parentItem.depth);
            this.name = name;
        }

        public String toString() {
            return "." + this.name;
        }
    }

    private static class RecordPathItem
    extends PathItem {
        private final OIdentifiable record;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private RecordPathItem(OIdentifiable record, PathItem parentItem) {
            super(parentItem, parentItem.depth + 1);
            this.record = record;
        }

        public String toString() {
            return "(" + this.record.getIdentity().toString() + ")";
        }
    }

    private static abstract class PathItem {
        protected final PathItem parentItem;
        protected final int depth;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        private PathItem(PathItem parentItem, int depth) {
            this.parentItem = parentItem;
            this.depth = depth;
        }
    }
}

