/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class OContextConfiguration
implements Serializable {
    private final Map<String, Object> config = new ConcurrentHashMap<String, Object>();
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OContextConfiguration() {
    }

    public OContextConfiguration(Map<String, Object> iConfig) {
        this.config.putAll(iConfig);
    }

    public OContextConfiguration(OContextConfiguration iParent) {
        if (iParent != null) {
            this.config.putAll(iParent.config);
        }
    }

    public Object setValue(OGlobalConfiguration iConfig, Object iValue) {
        if (iValue == null) {
            return this.config.remove(iConfig.getKey());
        }
        return this.config.put(iConfig.getKey(), iValue);
    }

    public Object setValue(String iName, Object iValue) {
        if (iValue == null) {
            return this.config.remove(iName);
        }
        return this.config.put(iName, iValue);
    }

    public Object getValue(OGlobalConfiguration iConfig) {
        if (this.config != null && this.config.containsKey(iConfig.getKey())) {
            return this.config.get(iConfig.getKey());
        }
        return iConfig.getValue();
    }

    public <T> T getValue(String iName, T iDefaultValue) {
        if (this.config != null && this.config.containsKey(iName)) {
            return (T)this.config.get(iName);
        }
        String sysProperty = System.getProperty(iName);
        if (sysProperty != null) {
            return (T)sysProperty;
        }
        return iDefaultValue;
    }

    public boolean getValueAsBoolean(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        if (v == null) {
            return false;
        }
        return v instanceof Boolean ? (Boolean)v : Boolean.parseBoolean(v.toString());
    }

    public String getValueAsString(String iName, String iDefaultValue) {
        return this.getValue(iName, iDefaultValue);
    }

    public String getValueAsString(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    public int getValueAsInteger(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        if (v == null) {
            return 0;
        }
        return v instanceof Integer ? (Integer)v : Integer.parseInt(v.toString());
    }

    public long getValueAsLong(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        if (v == null) {
            return 0L;
        }
        return v instanceof Long ? (long)((Long)v).intValue() : Long.parseLong(v.toString());
    }

    public float getValueAsFloat(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        if (v == null) {
            return 0.0f;
        }
        return v instanceof Float ? ((Float)v).floatValue() : Float.parseFloat(v.toString());
    }

    public int getContextSize() {
        return this.config.size();
    }

    public Set<String> getContextKeys() {
        return this.config.keySet();
    }
}

