/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.ORecordCacheWeakRefs;
import com.orientechnologies.orient.core.config.OConfigurationChangeCallback;
import com.orientechnologies.orient.core.engine.local.OEngineLocalPaginated;
import com.orientechnologies.orient.core.storage.OChecksumMode;
import java.io.PrintStream;
import java.util.Locale;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;

public final class OGlobalConfiguration
extends Enum<OGlobalConfiguration> {
    public static final /* enum */ OGlobalConfiguration ENVIRONMENT_DUMP_CFG_AT_STARTUP;
    public static final /* enum */ OGlobalConfiguration ENVIRONMENT_CONCURRENT;
    public static final /* enum */ OGlobalConfiguration ENVIRONMENT_LOCK_MANAGER_CONCURRENCY_LEVEL;
    public static final /* enum */ OGlobalConfiguration ENVIRONMENT_ALLOW_JVM_SHUTDOWN;
    public static final /* enum */ OGlobalConfiguration SCRIPT_POOL;
    public static final /* enum */ OGlobalConfiguration MEMORY_USE_UNSAFE;
    public static final /* enum */ OGlobalConfiguration MEMORY_CHUNK_SIZE;
    public static final /* enum */ OGlobalConfiguration DIRECT_MEMORY_SAFE_MODE;
    public static final /* enum */ OGlobalConfiguration DIRECT_MEMORY_TRACK_MODE;
    public static final /* enum */ OGlobalConfiguration DIRECT_MEMORY_ONLY_ALIGNED_ACCESS;
    public static final /* enum */ OGlobalConfiguration JVM_GC_DELAY_FOR_OPTIMIZE;
    public static final /* enum */ OGlobalConfiguration OPEN_FILES_LIMIT;
    public static final /* enum */ OGlobalConfiguration COMPONENTS_LOCK_CACHE;
    public static final /* enum */ OGlobalConfiguration DISK_CACHE_PINNED_PAGES;
    public static final /* enum */ OGlobalConfiguration DISK_CACHE_SIZE;
    public static final /* enum */ OGlobalConfiguration DISK_WRITE_CACHE_PART;
    public static final /* enum */ OGlobalConfiguration DISK_WRITE_CACHE_PAGE_TTL;
    public static final /* enum */ OGlobalConfiguration DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL;
    public static final /* enum */ OGlobalConfiguration DISK_WRITE_CACHE_FLUSH_WRITE_INACTIVITY_INTERVAL;
    public static final /* enum */ OGlobalConfiguration DISK_WRITE_CACHE_FLUSH_LOCK_TIMEOUT;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration DISC_CACHE_FREE_SPACE_CHECK_INTERVAL;
    public static final /* enum */ OGlobalConfiguration DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES;
    public static final /* enum */ OGlobalConfiguration STORAGE_KEEP_DISK_CACHE_STATE;
    public static final /* enum */ OGlobalConfiguration STORAGE_CHECKSUM_MODE;
    public static final /* enum */ OGlobalConfiguration STORAGE_CONFIGURATION_SYNC_ON_UPDATE;
    public static final /* enum */ OGlobalConfiguration STORAGE_COMPRESSION_METHOD;
    public static final /* enum */ OGlobalConfiguration STORAGE_ENCRYPTION_METHOD;
    public static final /* enum */ OGlobalConfiguration STORAGE_ENCRYPTION_KEY;
    public static final /* enum */ OGlobalConfiguration STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration STORAGE_MAKE_FULL_CHECKPOINT_AFTER_OPEN;
    public static final /* enum */ OGlobalConfiguration STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CLUSTER_CREATE;
    public static final /* enum */ OGlobalConfiguration STORAGE_TRACK_CHANGED_RECORDS_IN_WAL;
    public static final /* enum */ OGlobalConfiguration USE_WAL;
    public static final /* enum */ OGlobalConfiguration WAL_SYNC_ON_PAGE_FLUSH;
    public static final /* enum */ OGlobalConfiguration WAL_CACHE_SIZE;
    public static final /* enum */ OGlobalConfiguration WAL_FILE_AUTOCLOSE_INTERVAL;
    public static final /* enum */ OGlobalConfiguration WAL_MAX_SEGMENT_SIZE;
    public static final /* enum */ OGlobalConfiguration WAL_MAX_SIZE;
    public static final /* enum */ OGlobalConfiguration WAL_COMMIT_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration WAL_SHUTDOWN_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration WAL_FUZZY_CHECKPOINT_INTERVAL;
    public static final /* enum */ OGlobalConfiguration WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE;
    public static final /* enum */ OGlobalConfiguration WAL_RESTORE_BATCH_SIZE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration WAL_READ_CACHE_SIZE;
    public static final /* enum */ OGlobalConfiguration WAL_FUZZY_CHECKPOINT_SHUTDOWN_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration WAL_FULL_CHECKPOINT_SHUTDOWN_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration WAL_LOCATION;
    public static final /* enum */ OGlobalConfiguration DISK_CACHE_PAGE_SIZE;
    public static final /* enum */ OGlobalConfiguration DISK_CACHE_FREE_SPACE_LIMIT;
    public static final /* enum */ OGlobalConfiguration PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY;
    public static final /* enum */ OGlobalConfiguration STORAGE_LOCK_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration STORAGE_RECORD_LOCK_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration STORAGE_USE_TOMBSTONES;
    public static final /* enum */ OGlobalConfiguration RECORD_DOWNSIZING_ENABLED;
    public static final /* enum */ OGlobalConfiguration OBJECT_SAVE_ONLY_DIRTY;
    public static final /* enum */ OGlobalConfiguration DB_POOL_MIN;
    public static final /* enum */ OGlobalConfiguration DB_POOL_MAX;
    public static final /* enum */ OGlobalConfiguration DB_POOL_IDLE_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DB_POOL_IDLE_CHECK_DELAY;
    public static final /* enum */ OGlobalConfiguration DB_MVCC_THROWFAST;
    public static final /* enum */ OGlobalConfiguration DB_VALIDATION;
    public static final /* enum */ OGlobalConfiguration NON_TX_RECORD_UPDATE_SYNCH;
    public static final /* enum */ OGlobalConfiguration NON_TX_CLUSTERS_SYNC_IMMEDIATELY;
    public static final /* enum */ OGlobalConfiguration TX_TRACK_ATOMIC_OPERATIONS;
    public static final /* enum */ OGlobalConfiguration TX_PAGE_CACHE_SIZE;
    public static final /* enum */ OGlobalConfiguration INDEX_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD;
    public static final /* enum */ OGlobalConfiguration INDEX_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD;
    public static final /* enum */ OGlobalConfiguration HASH_TABLE_SPLIT_BUCKETS_BUFFER_LENGTH;
    public static final /* enum */ OGlobalConfiguration INDEX_SYNCHRONOUS_AUTO_REBUILD;
    public static final /* enum */ OGlobalConfiguration INDEX_AUTO_LAZY_UPDATES;
    public static final /* enum */ OGlobalConfiguration INDEX_FLUSH_AFTER_CREATE;
    public static final /* enum */ OGlobalConfiguration INDEX_MANUAL_LAZY_UPDATES;
    public static final /* enum */ OGlobalConfiguration INDEX_DURABLE_IN_NON_TX_MODE;
    public static final /* enum */ OGlobalConfiguration INDEX_IGNORE_NULL_VALUES_DEFAULT;
    public static final /* enum */ OGlobalConfiguration INDEX_TX_MODE;
    public static final /* enum */ OGlobalConfiguration INDEX_CURSOR_PREFETCH_SIZE;
    public static final /* enum */ OGlobalConfiguration SBTREE_MAX_DEPTH;
    public static final /* enum */ OGlobalConfiguration SBTREE_MAX_KEY_SIZE;
    public static final /* enum */ OGlobalConfiguration SBTREE_MAX_EMBEDDED_VALUE_SIZE;
    public static final /* enum */ OGlobalConfiguration SBTREEBONSAI_BUCKET_SIZE;
    public static final /* enum */ OGlobalConfiguration SBTREEBONSAI_LINKBAG_CACHE_SIZE;
    public static final /* enum */ OGlobalConfiguration SBTREEBONSAI_LINKBAG_CACHE_EVICTION_SIZE;
    public static final /* enum */ OGlobalConfiguration SBTREEBOSAI_FREE_SPACE_REUSE_TRIGGER;
    public static final /* enum */ OGlobalConfiguration RID_BAG_EMBEDDED_DEFAULT_SIZE;
    public static final /* enum */ OGlobalConfiguration RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD;
    public static final /* enum */ OGlobalConfiguration RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD;
    public static final /* enum */ OGlobalConfiguration PREFER_SBTREE_SET;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration TRACK_FILE_CLOSE;
    public static final /* enum */ OGlobalConfiguration FILE_LOCK;
    public static final /* enum */ OGlobalConfiguration FILE_DELETE_DELAY;
    public static final /* enum */ OGlobalConfiguration FILE_DELETE_RETRY;
    public static final /* enum */ OGlobalConfiguration SECURITY_USER_PASSWORD_SALT_ITERATIONS;
    public static final /* enum */ OGlobalConfiguration SECURITY_USER_PASSWORD_SALT_CACHE_SIZE;
    public static final /* enum */ OGlobalConfiguration SECURITY_USER_PASSWORD_DEFAULT_ALGORITHM;
    public static final /* enum */ OGlobalConfiguration NETWORK_MAX_CONCURRENT_SESSIONS;
    public static final /* enum */ OGlobalConfiguration NETWORK_SOCKET_BUFFER_SIZE;
    public static final /* enum */ OGlobalConfiguration NETWORK_LOCK_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration NETWORK_SOCKET_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration NETWORK_REQUEST_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration NETWORK_SOCKET_RETRY_STRATEGY;
    public static final /* enum */ OGlobalConfiguration NETWORK_SOCKET_RETRY;
    public static final /* enum */ OGlobalConfiguration NETWORK_SOCKET_RETRY_DELAY;
    public static final /* enum */ OGlobalConfiguration NETWORK_BINARY_DNS_LOADBALANCING_ENABLED;
    public static final /* enum */ OGlobalConfiguration NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration NETWORK_BINARY_MAX_CONTENT_LENGTH;
    public static final /* enum */ OGlobalConfiguration NETWORK_BINARY_READ_RESPONSE_MAX_TIMES;
    public static final /* enum */ OGlobalConfiguration NETWORK_BINARY_DEBUG;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_INSTALL_DEFAULT_COMMANDS;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_SERVER_INFO;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_MAX_CONTENT_LENGTH;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_STREAMING;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_CONTENT_CHARSET;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_JSON_RESPONSE_ERROR;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_JSONP_ENABLED;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_SESSION_EXPIRE_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration NETWORK_HTTP_USE_TOKEN;
    public static final /* enum */ OGlobalConfiguration NETWORK_TOKEN_SECRETKEY;
    public static final /* enum */ OGlobalConfiguration NETWORK_TOKEN_ENCRYPTION_ALGORITHM;
    public static final /* enum */ OGlobalConfiguration NETWORK_TOKEN_EXPIRE_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration PROFILER_ENABLED;
    public static final /* enum */ OGlobalConfiguration PROFILER_CONFIG;
    public static final /* enum */ OGlobalConfiguration PROFILER_AUTODUMP_INTERVAL;
    public static final /* enum */ OGlobalConfiguration PROFILER_AUTODUMP_TYPE;
    public static final /* enum */ OGlobalConfiguration PROFILER_MAXVALUES;
    public static final /* enum */ OGlobalConfiguration PROFILER_MEMORYCHECK_INTERVAL;
    public static final /* enum */ OGlobalConfiguration SEQUENCE_MAX_RETRY;
    public static final /* enum */ OGlobalConfiguration SEQUENCE_RETRY_DELAY;
    public static final /* enum */ OGlobalConfiguration STORAGE_PROFILER_SNAPSHOT_INTERVAL;
    public static final /* enum */ OGlobalConfiguration STORAGE_PROFILER_CLEANUP_INTERVAL;
    public static final /* enum */ OGlobalConfiguration LOG_CONSOLE_LEVEL;
    public static final /* enum */ OGlobalConfiguration LOG_FILE_LEVEL;
    public static final /* enum */ OGlobalConfiguration CLASS_MINIMUM_CLUSTERS;
    public static final /* enum */ OGlobalConfiguration LOG_SUPPORTS_ANSI;
    public static final /* enum */ OGlobalConfiguration CACHE_LOCAL_IMPL;
    public static final /* enum */ OGlobalConfiguration COMMAND_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration COMMAND_CACHE_ENABLED;
    public static final /* enum */ OGlobalConfiguration COMMAND_CACHE_EVICT_STRATEGY;
    public static final /* enum */ OGlobalConfiguration COMMAND_CACHE_MIN_EXECUTION_TIME;
    public static final /* enum */ OGlobalConfiguration COMMAND_CACHE_MAX_RESULSET_SIZE;
    public static final /* enum */ OGlobalConfiguration QUERY_USE_SOFT_REFENCES_IN_RESULT_SET;
    public static final /* enum */ OGlobalConfiguration QUERY_PARALLEL_AUTO;
    public static final /* enum */ OGlobalConfiguration QUERY_PARALLEL_MINIMUM_RECORDS;
    public static final /* enum */ OGlobalConfiguration QUERY_PARALLEL_RESULT_QUEUE_SIZE;
    public static final /* enum */ OGlobalConfiguration QUERY_SCAN_PREFETCH_PAGES;
    public static final /* enum */ OGlobalConfiguration QUERY_SCAN_BATCH_SIZE;
    public static final /* enum */ OGlobalConfiguration QUERY_SCAN_THRESHOLD_TIP;
    public static final /* enum */ OGlobalConfiguration QUERY_LIMIT_THRESHOLD_TIP;
    public static final /* enum */ OGlobalConfiguration QUERY_LIVE_SUPPORT;
    public static final /* enum */ OGlobalConfiguration QUERY_TIMEOUT_DEFAULT_STRATEGY;
    public static final /* enum */ OGlobalConfiguration LUCENE_QUERY_PAGE_SIZE;
    public static final /* enum */ OGlobalConfiguration STATEMENT_CACHE_SIZE;
    public static final /* enum */ OGlobalConfiguration SQL_GRAPH_CONSISTENCY_MODE;
    public static final /* enum */ OGlobalConfiguration CLIENT_CHANNEL_MAX_POOL;
    public static final /* enum */ OGlobalConfiguration CLIENT_CONNECT_POOL_WAIT_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration CLIENT_DB_RELEASE_WAIT_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration CLIENT_USE_SSL;
    public static final /* enum */ OGlobalConfiguration CLIENT_SSL_KEYSTORE;
    public static final /* enum */ OGlobalConfiguration CLIENT_SSL_KEYSTORE_PASSWORD;
    public static final /* enum */ OGlobalConfiguration CLIENT_SSL_TRUSTSTORE;
    public static final /* enum */ OGlobalConfiguration CLIENT_SSL_TRUSTSTORE_PASSWORD;
    public static final /* enum */ OGlobalConfiguration SERVER_OPEN_ALL_DATABASES_AT_STARTUP;
    public static final /* enum */ OGlobalConfiguration SERVER_CHANNEL_CLEAN_DELAY;
    public static final /* enum */ OGlobalConfiguration SERVER_CACHE_FILE_STATIC;
    public static final /* enum */ OGlobalConfiguration SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL;
    public static final /* enum */ OGlobalConfiguration SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_DUMP_STATS_EVERY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_MAX_STARTUP_DELAY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_COMMAND_LONG_TASK_SYNCH_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_ASYNCH_QUEUE_SIZE;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_ASYNCH_RESPONSES_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_PURGE_RESPONSES_TIMER_DELAY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHAIN;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHECK_EVERY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_TX_EXPIRE_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_REQUEST_CHANNELS;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_RESPONSE_CHANNELS;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_QUEUE_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_HEARTBEAT_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CHECK_HEALTH_CAN_OFFLINE_SERVER;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CHECK_HEALTH_EVERY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_AUTO_REMOVE_OFFLINE_SERVERS;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_PUBLISH_NODE_STATUS_EVERY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_LOCAL_QUEUESIZE;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_DB_WORKERTHREADS;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_QUEUE_MAXSIZE;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_BACKUP_DIRECTORY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CHECKINTEGRITY_LAST_TX;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_ATOMIC_LOCK_TIMEOUT;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY;
    public static final /* enum */ OGlobalConfiguration DB_DOCUMENT_SERIALIZER;
    public static final /* enum */ OGlobalConfiguration CLIENT_KRB5_CONFIG;
    public static final /* enum */ OGlobalConfiguration CLIENT_KRB5_CCNAME;
    public static final /* enum */ OGlobalConfiguration CLIENT_KRB5_KTNAME;
    public static final /* enum */ OGlobalConfiguration CLIENT_CREDENTIAL_INTERCEPTOR;
    public static final /* enum */ OGlobalConfiguration CLIENT_CI_KEYALGORITHM;
    public static final /* enum */ OGlobalConfiguration CLIENT_CI_CIPHERTRANSFORM;
    public static final /* enum */ OGlobalConfiguration CLIENT_CI_KEYSTORE_FILE;
    public static final /* enum */ OGlobalConfiguration CLIENT_CI_KEYSTORE_PASSWORD;
    public static final /* enum */ OGlobalConfiguration CREATE_DEFAULT_USERS;
    public static final /* enum */ OGlobalConfiguration SERVER_SECURITY_FILE;
    public static final /* enum */ OGlobalConfiguration INIT_IN_SERVLET_CONTEXT_LISTENER;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration JNA_DISABLE_USE_SYSTEM_LIBRARY;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration DB_MAKE_FULL_CHECKPOINT_ON_INDEX_CHANGE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration DB_MAKE_FULL_CHECKPOINT_ON_SCHEMA_CHANGE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration CLIENT_SESSION_TOKEN_BASED;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration OAUTH2_SECRETKEY;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration STORAGE_USE_CRC32_FOR_EACH_RECORD;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration LAZYSET_WORK_ON_STREAM;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration DB_MVCC;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration DB_USE_DISTRIBUTED_VERSION;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_TIMEOUT;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_NODE_PAGE_SIZE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_LOAD_FACTOR;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_OPTIMIZE_THRESHOLD;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_ENTRYPOINTS;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_OPTIMIZE_ENTRYPOINTS_FACTOR;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_ENTRY_KEYS_IN_MEMORY;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_ENTRY_VALUES_IN_MEMORY;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_RID_BINARY_THRESHOLD;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_RID_NODE_PAGE_SIZE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration MVRBTREE_RID_NODE_SAVE_MEMORY;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration TX_COMMIT_SYNCH;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration TX_AUTO_RETRY;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration TX_LOG_TYPE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration TX_LOG_SYNCH;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration TX_USE_LOG;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration INDEX_AUTO_REBUILD_AFTER_NOTSOFTCLOSE;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration CLIENT_CHANNEL_MIN_POOL;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration STORAGE_KEEP_OPEN;
    @Deprecated
    public static final /* enum */ OGlobalConfiguration CACHE_LOCAL_ENABLED;
    public static final /* enum */ OGlobalConfiguration DISTRIBUTED_DB_SHUTDOWNTIMEOUT;
    private final Object nullValue;
    private final String key;
    private final Object defValue;
    private final Class<?> type;
    private volatile Object value;
    private final String description;
    private final OConfigurationChangeCallback changeCallback;
    private final Boolean canChangeAtRuntime;
    private final boolean hidden;
    private static final /* synthetic */ OGlobalConfiguration[] $VALUES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static OGlobalConfiguration[] values() {
        return (OGlobalConfiguration[])$VALUES.clone();
    }

    public static OGlobalConfiguration valueOf(String name) {
        return Enum.valueOf(OGlobalConfiguration.class, name);
    }

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue, OConfigurationChangeCallback iChangeAction) {
        this.value = this.nullValue = new Object();
        this.key = iKey;
        this.description = iDescription;
        this.defValue = iDefValue;
        this.type = iType;
        this.canChangeAtRuntime = true;
        this.hidden = false;
        this.changeCallback = iChangeAction;
    }

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue) {
        this(iKey, iDescription, iType, iDefValue, false);
    }

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue, Boolean iCanChange) {
        this(iKey, iDescription, iType, iDefValue, iCanChange, false);
    }

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue, boolean iCanChange, boolean iHidden) {
        this.value = this.nullValue = new Object();
        this.key = iKey;
        this.description = iDescription;
        this.defValue = iDefValue;
        this.type = iType;
        this.canChangeAtRuntime = iCanChange;
        this.hidden = iHidden;
        this.changeCallback = null;
    }

    public static void dumpConfiguration(PrintStream out) {
        out.print("OrientDB ");
        out.print(OConstants.getVersion());
        out.println(" configuration dump:");
        String lastSection = "";
        for (OGlobalConfiguration v : OGlobalConfiguration.values()) {
            String section = v.key.substring(0, v.key.indexOf(46));
            if (!lastSection.equals(section)) {
                out.print("- ");
                out.println(section.toUpperCase(Locale.ENGLISH));
                lastSection = section;
            }
            out.print("  + ");
            out.print(v.key);
            out.print(" = ");
            out.println(v.isHidden() ? "<hidden>" : String.valueOf(v.getValue()));
        }
    }

    public static OGlobalConfiguration findByKey(String iKey) {
        for (OGlobalConfiguration v : OGlobalConfiguration.values()) {
            if (!v.getKey().equalsIgnoreCase(iKey)) continue;
            return v;
        }
        return null;
    }

    public static void setConfiguration(Map<String, Object> iConfig) {
        block0: for (Map.Entry<String, Object> config : iConfig.entrySet()) {
            for (OGlobalConfiguration v : OGlobalConfiguration.values()) {
                if (v.getKey().equals(config.getKey())) {
                    v.setValue(config.getValue());
                    continue block0;
                }
                if (!v.name().equals(config.getKey())) continue;
                v.setValue(config.getValue());
                continue block0;
            }
        }
    }

    private static void readConfiguration() {
        for (OGlobalConfiguration config : OGlobalConfiguration.values()) {
            String prop = System.getProperty(config.key);
            if (prop == null) continue;
            config.setValue(prop);
        }
    }

    public <T> T getValue() {
        return (T)(this.value != this.nullValue && this.value != null ? this.value : this.defValue);
    }

    public boolean isChanged() {
        return this.value != this.nullValue;
    }

    public <T extends Enum<T>> T getValueAsEnum(Class<T> enumType) {
        T value = this.getValue();
        if (value == null) {
            return null;
        }
        if (enumType.isAssignableFrom(value.getClass())) {
            return (T)((Enum)enumType.cast(value));
        }
        if (value instanceof String) {
            String presentation = value.toString();
            return Enum.valueOf(enumType, presentation);
        }
        throw new ClassCastException("Value " + value + " can not be cast to enumeration " + enumType.getSimpleName());
    }

    public void setValue(Object iValue) {
        Object oldValue = this.value;
        if (iValue != null) {
            if (this.type == Boolean.class) {
                this.value = Boolean.parseBoolean(iValue.toString());
            } else if (this.type == Integer.class) {
                this.value = Integer.parseInt(iValue.toString());
            } else if (this.type == Float.class) {
                this.value = Float.valueOf(Float.parseFloat(iValue.toString()));
            } else if (this.type == String.class) {
                this.value = iValue.toString();
            } else if (this.type.isEnum()) {
                boolean accepted = false;
                if (this.type.isInstance(iValue)) {
                    this.value = iValue;
                    accepted = true;
                } else if (iValue instanceof String) {
                    String string = (String)iValue;
                    for (Object constant : this.type.getEnumConstants()) {
                        Enum enumConstant = (Enum)constant;
                        if (!enumConstant.name().equalsIgnoreCase(string)) continue;
                        this.value = enumConstant;
                        accepted = true;
                        break;
                    }
                }
                if (!accepted) {
                    throw new IllegalArgumentException("Invalid value of `" + this.key + "` option.");
                }
            } else {
                this.value = iValue;
            }
        }
        if (this.changeCallback != null) {
            try {
                this.changeCallback.change(oldValue == this.nullValue ? null : oldValue, this.value == this.nullValue ? null : this.value);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error during call of 'change callback'", e, new Object[0]);
            }
        }
    }

    public boolean getValueAsBoolean() {
        Object v;
        Object object = v = this.value != this.nullValue && this.value != null ? this.value : this.defValue;
        if (v == null) {
            return false;
        }
        return v instanceof Boolean ? (Boolean)v : Boolean.parseBoolean(v.toString());
    }

    public String getValueAsString() {
        return this.value != this.nullValue && this.value != null ? this.value.toString() : (this.defValue != null ? this.defValue.toString() : null);
    }

    public int getValueAsInteger() {
        Object v = this.value != this.nullValue && this.value != null ? this.value : this.defValue;
        return (int)(v instanceof Number ? (long)((Number)v).intValue() : OFileUtils.getSizeAsNumber(v.toString()));
    }

    public long getValueAsLong() {
        Object v = this.value != this.nullValue && this.value != null ? this.value : this.defValue;
        return v instanceof Number ? ((Number)v).longValue() : OFileUtils.getSizeAsNumber(v.toString());
    }

    public float getValueAsFloat() {
        Object v = this.value != this.nullValue && this.value != null ? this.value : this.defValue;
        return v instanceof Float ? ((Float)v).floatValue() : Float.parseFloat(v.toString());
    }

    public String getKey() {
        return this.key;
    }

    public Boolean isChangeableAtRuntime() {
        return this.canChangeAtRuntime;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public Object getDefValue() {
        return this.defValue;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    static {
        try {
            try {
                ENVIRONMENT_DUMP_CFG_AT_STARTUP = new OGlobalConfiguration("environment.dumpCfgAtStartup", "Dumps the configuration during application startup", Boolean.class, Boolean.FALSE);
                ENVIRONMENT_CONCURRENT = new OGlobalConfiguration("environment.concurrent", "Specifies if running in multi-thread environment. Setting this to false turns off the internal lock management", Boolean.class, Boolean.TRUE);
                ENVIRONMENT_LOCK_MANAGER_CONCURRENCY_LEVEL = new OGlobalConfiguration("environment.lockManager.concurrency.level", "Concurrency level of lock manager", Integer.class, (Object)(Runtime.getRuntime().availableProcessors() << 3), false);
                ENVIRONMENT_ALLOW_JVM_SHUTDOWN = new OGlobalConfiguration("environment.allowJVMShutdown", "Allows the shutdown of the JVM, if needed/requested", Boolean.class, (Object)true, true);
                SCRIPT_POOL = new OGlobalConfiguration("script.pool.maxSize", "Maximum number of instances in the pool of script engines", Integer.class, 20);
                MEMORY_USE_UNSAFE = new OGlobalConfiguration("memory.useUnsafe", "Indicates whether Unsafe will be used, if it is present", Boolean.class, true);
                MEMORY_CHUNK_SIZE = new OGlobalConfiguration("memory.chunk.size", "Size of single memory chunk (in bytes) which will be preallocated by OrientDB", Integer.class, Integer.MAX_VALUE);
                DIRECT_MEMORY_SAFE_MODE = new OGlobalConfiguration("memory.directMemory.safeMode", "Indicates whether to perform a range check before each direct memory update. It is true by default, but usually it can be safely set to false. It should only be to true after dramatic changes have been made in the storage structures", Boolean.class, true);
                DIRECT_MEMORY_TRACK_MODE = new OGlobalConfiguration("memory.directMemory.trackMode", "Activates the direct memory pool [leak detector](Leak-Detector.md). This detector causes a large overhead and should be used for debugging purposes only. It's also a good idea to pass the -Djava.util.logging.manager=com.orientechnologies.common.log.OLogManager$ShutdownLogManager switch to the JVM, if you use this mode, this will enable the logging from JVM shutdown hooks.", Boolean.class, false);
                DIRECT_MEMORY_ONLY_ALIGNED_ACCESS = new OGlobalConfiguration("memory.directMemory.onlyAlignedMemoryAccess", "Some architectures do not allow unaligned memory access or may suffer from speed degradation. For such platforms, this flag should be set to true", Boolean.class, true);
                JVM_GC_DELAY_FOR_OPTIMIZE = new OGlobalConfiguration("jvm.gc.delayForOptimize", "Minimal amount of time (in seconds), since the last System.gc(), when called after tree optimization", Long.class, 600);
                OPEN_FILES_LIMIT = new OGlobalConfiguration("storage.openFiles.limit", "Limit of amount of files which may be open simultaneously", Integer.class, 512);
                COMPONENTS_LOCK_CACHE = new OGlobalConfiguration("storage.componentsLock.cache", "Amount of cached locks is used for component lock to avoid constant creation of new lock instances", Integer.class, 10000);
                DISK_CACHE_PINNED_PAGES = new OGlobalConfiguration("storage.diskCache.pinnedPages", "Maximum amount of pinned pages which may be contained in cache, if this percent is reached next pages will be left in unpinned state. You can not set value more than 50", Integer.class, (Object)20, false);
                DISK_CACHE_SIZE = new OGlobalConfiguration("storage.diskCache.bufferSize", "Size of disk buffer in megabytes, disk size may be changed at runtime, but if does not enough to contain all pinned pages exception will be thrown", Integer.class, (Object)4096, new OConfigurationChangeCallback(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void change(Object currentValue, Object newValue) {
                        OEngineLocalPaginated engineLocalPaginated;
                        Orient orient = Orient.instance();
                        if (orient != null && (engineLocalPaginated = (OEngineLocalPaginated)orient.getEngineIfRunning("plocal")) != null) {
                            engineLocalPaginated.changeCacheSize((long)((Integer)newValue).intValue() * 1024L * 1024L);
                        }
                    }
                });
                DISK_WRITE_CACHE_PART = new OGlobalConfiguration("storage.diskCache.writeCachePart", "Percentage of disk cache, which is used as write cache", Integer.class, 15);
                DISK_WRITE_CACHE_PAGE_TTL = new OGlobalConfiguration("storage.diskCache.writeCachePageTTL", "Max time until a page will be flushed from write cache (in seconds)", Long.class, 86400);
                DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL = new OGlobalConfiguration("storage.diskCache.writeCachePageFlushInterval", "Interval between flushing of pages from write cache (in ms)", Integer.class, 25);
                DISK_WRITE_CACHE_FLUSH_WRITE_INACTIVITY_INTERVAL = new OGlobalConfiguration("storage.diskCache.writeCacheFlushInactivityInterval", "Interval between 2 writes to the disk cache, if writes are done with an interval more than provided, all files will be fsynced before the next write, which allows a data restore after a server crash (in ms)", Long.class, 60000);
                DISK_WRITE_CACHE_FLUSH_LOCK_TIMEOUT = new OGlobalConfiguration("storage.diskCache.writeCacheFlushLockTimeout", "Maximum amount of time the write cache will wait before a page flushes (in ms, -1 to disable)", Integer.class, -1);
                DISC_CACHE_FREE_SPACE_CHECK_INTERVAL = new OGlobalConfiguration("storage.diskCache.diskFreeSpaceCheckInterval", "The interval (in seconds), after which the storage periodically checks whether the amount of free disk space is enough to work in write mode", Integer.class, 5);
                DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES = new OGlobalConfiguration("storage.diskCache.diskFreeSpaceCheckIntervalInPages", "The interval (how many new pages should be added before free space will be checked), after which the storage periodically checks whether the amount of free disk space is enough to work in write mode", Integer.class, 2048);
                STORAGE_KEEP_DISK_CACHE_STATE = new OGlobalConfiguration("storage.diskCache.keepState", "Keep disk cache state between moment when storage is closed and moment when it is opened again. true by default", Boolean.class, true);
                STORAGE_CHECKSUM_MODE = new OGlobalConfiguration("storage.diskCache.checksumMode", "Controls the per-page checksum storage and verification done by the file cache. Possible modes: 'off' \u2013 checksums are completely off; 'store' \u2013 checksums are calculated and stored on page flushes, no verification is done on page loads, stored checksums are verified only during user-initiated health checks; 'storeAndVerify' (default) \u2013 checksums are calculated and stored on page flushes, verification is performed on each page load, errors are reported in the log; 'storeAndThrow' \u2013 same as `storeAndVerify` with addition of exceptions thrown on errors, this mode is useful for debugging and testing, but should be avoided in a production environment; 'storeAndSwitchReadOnlyMode' (default) - Same as 'storeAndVerify' with addition that storage will be switched in read only mode till it will not be repaired.", OChecksumMode.class, (Object)OChecksumMode.StoreAndSwitchReadOnlyMode, false);
                STORAGE_CONFIGURATION_SYNC_ON_UPDATE = new OGlobalConfiguration("storage.configuration.syncOnUpdate", "Indicates a force sync should be performed for each update on the storage configuration", Boolean.class, true);
                STORAGE_COMPRESSION_METHOD = new OGlobalConfiguration("storage.compressionMethod", "Record compression method used in storage Possible values : gzip, nothing, snappy, snappy-native. Default is 'nothing' that means no compression", String.class, "nothing");
                STORAGE_ENCRYPTION_METHOD = new OGlobalConfiguration("storage.encryptionMethod", "Record encryption method used in storage Possible values : 'aes' and 'des'. Default is 'nothing' for no encryption", String.class, "nothing");
                STORAGE_ENCRYPTION_KEY = new OGlobalConfiguration("storage.encryptionKey", "Contains the storage encryption key. This setting is hidden", String.class, null, false, true);
                STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE = new OGlobalConfiguration("storage.makeFullCheckpointAfterCreate", "Indicates whether a full checkpoint should be performed, if storage was created", Boolean.class, false);
                STORAGE_MAKE_FULL_CHECKPOINT_AFTER_OPEN = new OGlobalConfiguration("storage.makeFullCheckpointAfterOpen", "Indicates whether a full checkpoint should be performed, if storage was opened. It is needed so fuzzy checkpoints can work properly", Boolean.class, false);
                STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CLUSTER_CREATE = new OGlobalConfiguration("storage.makeFullCheckpointAfterClusterCreate", "Indicates whether a full checkpoint should be performed, if storage was opened", Boolean.class, true);
                STORAGE_TRACK_CHANGED_RECORDS_IN_WAL = new OGlobalConfiguration("storage.trackChangedRecordsInWAL", "If this flag is set metadata which contains rids of changed records is added at the end of each atomic operation", Boolean.class, false);
                USE_WAL = new OGlobalConfiguration("storage.useWAL", "Whether WAL should be used in paginated storage", Boolean.class, true);
                WAL_SYNC_ON_PAGE_FLUSH = new OGlobalConfiguration("storage.wal.syncOnPageFlush", "Indicates whether a force sync should be performed during WAL page flush", Boolean.class, true);
                WAL_CACHE_SIZE = new OGlobalConfiguration("storage.wal.cacheSize", "Maximum size of WAL cache (in amount of WAL pages, each page is 64k) If set to 0, caching will be disabled", Integer.class, 3000);
                WAL_FILE_AUTOCLOSE_INTERVAL = new OGlobalConfiguration("storage.wal.fileAutoCloseInterval", "Interval in seconds after which WAL file will be closed if there is no any IO operations on this file (in seconds), default value is 10", Integer.class, (Object)10, false);
                WAL_MAX_SEGMENT_SIZE = new OGlobalConfiguration("storage.wal.maxSegmentSize", "Maximum size of single WAL segment (in megabytes)", Integer.class, 128);
                WAL_MAX_SIZE = new OGlobalConfiguration("storage.wal.maxSize", "Maximum size of WAL on disk (in megabytes)", Integer.class, 4096);
                WAL_COMMIT_TIMEOUT = new OGlobalConfiguration("storage.wal.commitTimeout", "Maximum interval between WAL commits (in ms.)", Integer.class, 1000);
                WAL_SHUTDOWN_TIMEOUT = new OGlobalConfiguration("storage.wal.shutdownTimeout", "Maximum wait interval between events, when the background flush threadreceives a shutdown command and when the background flush will be stopped (in ms.)", Integer.class, 10000);
                WAL_FUZZY_CHECKPOINT_INTERVAL = new OGlobalConfiguration("storage.wal.fuzzyCheckpointInterval", "Interval between fuzzy checkpoints (in seconds)", Integer.class, 300);
                WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE = new OGlobalConfiguration("storage.wal.reportAfterOperationsDuringRestore", "Amount of processed log operations, after which status of data restore procedure will be printed (0 or a negative value, disables the logging)", Integer.class, 10000);
                WAL_RESTORE_BATCH_SIZE = new OGlobalConfiguration("storage.wal.restore.batchSize", "Amount of WAL records, which are read at once in a single batch during a restore procedure", Integer.class, 1000);
                WAL_READ_CACHE_SIZE = new OGlobalConfiguration("storage.wal.readCacheSize", "Size of WAL read cache in amount of pages", Integer.class, 1000);
                WAL_FUZZY_CHECKPOINT_SHUTDOWN_TIMEOUT = new OGlobalConfiguration("storage.wal.fuzzyCheckpointShutdownWait", "The amount of time the DB should wait until it shuts down (in seconds)", Integer.class, 600);
                WAL_FULL_CHECKPOINT_SHUTDOWN_TIMEOUT = new OGlobalConfiguration("storage.wal.fullCheckpointShutdownTimeout", "The amount of time the DB will wait, until a checkpoint is finished, during a DB shutdown (in seconds)", Integer.class, 600);
                WAL_LOCATION = new OGlobalConfiguration("storage.wal.path", "Path to the WAL file on the disk. By default, it is placed in the DB directory, but it is highly recommended to use a separate disk to store log operations", String.class, null);
                DISK_CACHE_PAGE_SIZE = new OGlobalConfiguration("storage.diskCache.pageSize", "Size of page of disk buffer (in kilobytes). !!! NEVER CHANGE THIS VALUE !!!", Integer.class, 64);
                DISK_CACHE_FREE_SPACE_LIMIT = new OGlobalConfiguration("storage.diskCache.diskFreeSpaceLimit", "Minimum amount of space on disk, which, when exceeded, will cause the database to switch to read-only mode (in megabytes)", Long.class, 2L * WAL_MAX_SEGMENT_SIZE.getValueAsLong());
                PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY = new OGlobalConfiguration("storage.lowestFreeListBound", "The least amount of free space (in kb) in a page, which is tracked in paginated storage", Integer.class, 16);
                STORAGE_LOCK_TIMEOUT = new OGlobalConfiguration("storage.lockTimeout", "Maximum amount of time (in ms) to lock the storage", Integer.class, 0);
                STORAGE_RECORD_LOCK_TIMEOUT = new OGlobalConfiguration("storage.record.lockTimeout", "Maximum of time (in ms) to lock a shared record", Integer.class, 2000);
                STORAGE_USE_TOMBSTONES = new OGlobalConfiguration("storage.useTombstones", "When a record is deleted, the space in the cluster will not be freed, but rather tombstoned", Boolean.class, false);
                RECORD_DOWNSIZING_ENABLED = new OGlobalConfiguration("record.downsizing.enabled", "On updates, if the record size is lower than before, this reduces the space taken accordingly. If enabled this could increase defragmentation, but it reduces the used disk space", Boolean.class, true);
                OBJECT_SAVE_ONLY_DIRTY = new OGlobalConfiguration("object.saveOnlyDirty", "Object Database only! It saves objects bound to dirty records", Boolean.class, (Object)false, true);
                DB_POOL_MIN = new OGlobalConfiguration("db.pool.min", "Default database pool minimum size", Integer.class, 1);
                DB_POOL_MAX = new OGlobalConfiguration("db.pool.max", "Default database pool maximum size", Integer.class, 100);
                DB_POOL_IDLE_TIMEOUT = new OGlobalConfiguration("db.pool.idleTimeout", "Timeout for checking for free databases in the pool", Integer.class, 0);
                DB_POOL_IDLE_CHECK_DELAY = new OGlobalConfiguration("db.pool.idleCheckDelay", "Delay time on checking for idle databases", Integer.class, 0);
                DB_MVCC_THROWFAST = new OGlobalConfiguration("db.mvcc.throwfast", "Use fast-thrown exceptions for MVCC OConcurrentModificationExceptions. No context information will be available. Set to true, when these exceptions are thrown, but the details are not necessary", Boolean.class, (Object)false, true);
                DB_VALIDATION = new OGlobalConfiguration("db.validation", "Enables or disables validation of records", Boolean.class, (Object)true, true);
                NON_TX_RECORD_UPDATE_SYNCH = new OGlobalConfiguration("nonTX.recordUpdate.synch", "Executes a sync against the file-system for every record operation. This slows down record updates, but guarantees reliability on unreliable drives", Boolean.class, Boolean.FALSE);
                NON_TX_CLUSTERS_SYNC_IMMEDIATELY = new OGlobalConfiguration("nonTX.clusters.sync.immediately", "List of clusters to sync immediately after update (separated by commas). Can be useful for a manual index", String.class, "manindex");
                TX_TRACK_ATOMIC_OPERATIONS = new OGlobalConfiguration("tx.trackAtomicOperations", "This setting is used only for debug purposes. It creates a stack trace of methods, when an atomic operation is started", Boolean.class, false);
                TX_PAGE_CACHE_SIZE = new OGlobalConfiguration("tx.pageCacheSize", "The size of a per-transaction page cache in pages, 12 by default, 0 to disable the cache.", Integer.class, 12);
                INDEX_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD = new OGlobalConfiguration("index.embeddedToSbtreeBonsaiThreshold", "Amount of values, after which the index implementation will use an sbtree as a values container. Set to -1, to disable and force using an sbtree", Integer.class, (Object)40, true);
                INDEX_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD = new OGlobalConfiguration("index.sbtreeBonsaiToEmbeddedThreshold", "Amount of values, after which index implementation will use an embedded values container (disabled by default)", Integer.class, (Object)-1, true);
                HASH_TABLE_SPLIT_BUCKETS_BUFFER_LENGTH = new OGlobalConfiguration("hashTable.slitBucketsBuffer.length", "Length of buffer (in pages), where buckets that were split, but not flushed to the disk, are kept. This buffer is used to minimize random IO overhead", Integer.class, 1500);
                INDEX_SYNCHRONOUS_AUTO_REBUILD = new OGlobalConfiguration("index.auto.synchronousAutoRebuild", "Synchronous execution of auto rebuilding of indexes, in case of a DB crash", Boolean.class, Boolean.TRUE);
                INDEX_AUTO_LAZY_UPDATES = new OGlobalConfiguration("index.auto.lazyUpdates", "Configure the TreeMaps for automatic indexes, as buffered or not. -1 means buffered until tx.commit() or db.close() are called", Integer.class, 10000);
                INDEX_FLUSH_AFTER_CREATE = new OGlobalConfiguration("index.flushAfterCreate", "Flush storage buffer after index creation", Boolean.class, true);
                INDEX_MANUAL_LAZY_UPDATES = new OGlobalConfiguration("index.manual.lazyUpdates", "Configure the TreeMaps for manual indexes as buffered or not. -1 means buffered until tx.commit() or db.close() are called", Integer.class, 1);
                INDEX_DURABLE_IN_NON_TX_MODE = new OGlobalConfiguration("index.durableInNonTxMode", "Indicates whether index implementation for plocal storage will be durable in non-Tx mode (true by default)", Boolean.class, true);
                INDEX_IGNORE_NULL_VALUES_DEFAULT = new OGlobalConfiguration("index.ignoreNullValuesDefault", "Controls whether null values will be ignored by default by newly created indexes or not (false by default)", Boolean.class, false);
                INDEX_TX_MODE = new OGlobalConfiguration("index.txMode", "Indicates the index durability level in TX mode. Can be ROLLBACK_ONLY or FULL (ROLLBACK_ONLY by default)", String.class, "FULL");
                INDEX_CURSOR_PREFETCH_SIZE = new OGlobalConfiguration("index.cursor.prefetchSize", "Default prefetch size of index cursor", Integer.class, 10000);
                SBTREE_MAX_DEPTH = new OGlobalConfiguration("sbtree.maxDepth", "Maximum depth of sbtree, which will be traversed during key look up until it will be treated as broken (64 by default)", Integer.class, 64);
                SBTREE_MAX_KEY_SIZE = new OGlobalConfiguration("sbtree.maxKeySize", "Maximum size of a key, which can be put in the SBTree in bytes (10240 by default)", Integer.class, 10240);
                SBTREE_MAX_EMBEDDED_VALUE_SIZE = new OGlobalConfiguration("sbtree.maxEmbeddedValueSize", "Maximum size of value which can be put in an SBTree without creation link to a standalone page in bytes (40960 by default)", Integer.class, 40960);
                SBTREEBONSAI_BUCKET_SIZE = new OGlobalConfiguration("sbtreebonsai.bucketSize", "Size of bucket in OSBTreeBonsai (in kB). Contract: bucketSize < storagePageSize, storagePageSize % bucketSize == 0", Integer.class, 2);
                SBTREEBONSAI_LINKBAG_CACHE_SIZE = new OGlobalConfiguration("sbtreebonsai.linkBagCache.size", "Amount of LINKBAG collections to be cached, to avoid constant reloading of data", Integer.class, 100000);
                SBTREEBONSAI_LINKBAG_CACHE_EVICTION_SIZE = new OGlobalConfiguration("sbtreebonsai.linkBagCache.evictionSize", "The number of cached LINKBAG collections, which will be removed, when the cache limit is reached", Integer.class, 1000);
                SBTREEBOSAI_FREE_SPACE_REUSE_TRIGGER = new OGlobalConfiguration("sbtreebonsai.freeSpaceReuseTrigger", "How much free space should be in an sbtreebonsai file, before it will be reused during the next allocation", Float.class, 0.5);
                RID_BAG_EMBEDDED_DEFAULT_SIZE = new OGlobalConfiguration("ridBag.embeddedDefaultSize", "Size of embedded RidBag array, when created (empty)", Integer.class, 4);
                RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD = new OGlobalConfiguration("ridBag.embeddedToSbtreeBonsaiThreshold", "Amount of values after which a LINKBAG implementation will use sbtree as values container. Set to -1 to always use an sbtree", Integer.class, (Object)40, true);
                RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD = new OGlobalConfiguration("ridBag.sbtreeBonsaiToEmbeddedToThreshold", "Amount of values, after which a LINKBAG implementation will use an embedded values container (disabled by default)", Integer.class, (Object)-1, true);
                PREFER_SBTREE_SET = new OGlobalConfiguration("collections.preferSBTreeSet", "This configuration setting is experimental", Boolean.class, false);
                TRACK_FILE_CLOSE = new OGlobalConfiguration("file.trackFileClose", "Log all the cases when files are closed. This is needed only for internal debugging purposes", Boolean.class, false);
                FILE_LOCK = new OGlobalConfiguration("file.lock", "Locks files when used. Default is true", Boolean.TYPE, true);
                FILE_DELETE_DELAY = new OGlobalConfiguration("file.deleteDelay", "Delay time (in ms) to wait for another attempt to delete a locked file", Integer.class, 10);
                FILE_DELETE_RETRY = new OGlobalConfiguration("file.deleteRetry", "Number of retries to delete a locked file", Integer.class, 50);
                SECURITY_USER_PASSWORD_SALT_ITERATIONS = new OGlobalConfiguration("security.userPasswordSaltIterations", "Number of iterations to generate the salt or user password. Changing this setting does not affect stored passwords", Integer.class, 65536);
                SECURITY_USER_PASSWORD_SALT_CACHE_SIZE = new OGlobalConfiguration("security.userPasswordSaltCacheSize", "Cache size of hashed salt passwords. The cache works as LRU. Use 0 to disable the cache", Integer.class, 500);
                SECURITY_USER_PASSWORD_DEFAULT_ALGORITHM = new OGlobalConfiguration("security.userPasswordDefaultAlgorithm", "Default encryption algorithm used for passwords hashing", String.class, "PBKDF2WithHmacSHA256");
                NETWORK_MAX_CONCURRENT_SESSIONS = new OGlobalConfiguration("network.maxConcurrentSessions", "Maximum number of concurrent sessions", Integer.class, (Object)1000, true);
                NETWORK_SOCKET_BUFFER_SIZE = new OGlobalConfiguration("network.socketBufferSize", "TCP/IP Socket buffer size, if 0 use the OS default", Integer.class, (Object)0, true);
                NETWORK_LOCK_TIMEOUT = new OGlobalConfiguration("network.lockTimeout", "Timeout (in ms) to acquire a lock against a channel", Integer.class, (Object)15000, true);
                NETWORK_SOCKET_TIMEOUT = new OGlobalConfiguration("network.socketTimeout", "TCP/IP Socket timeout (in ms)", Integer.class, (Object)15000, true);
                NETWORK_REQUEST_TIMEOUT = new OGlobalConfiguration("network.requestTimeout", "Request completion timeout (in ms)", Integer.class, (Object)3600000, true);
                NETWORK_SOCKET_RETRY_STRATEGY = new OGlobalConfiguration("network.retry.strategy", "Select the retry server selection strategy, possible values are auto,same-dc ", String.class, (Object)"auto", true);
                NETWORK_SOCKET_RETRY = new OGlobalConfiguration("network.retry", "Number of attempts to connect to the server on failure", Integer.class, (Object)5, true);
                NETWORK_SOCKET_RETRY_DELAY = new OGlobalConfiguration("network.retryDelay", "The time (in ms) the client must wait, before reconnecting to the server on failure", Integer.class, (Object)500, true);
                NETWORK_BINARY_DNS_LOADBALANCING_ENABLED = new OGlobalConfiguration("network.binary.loadBalancing.enabled", "Asks for DNS TXT record, to determine if load balancing is supported", Boolean.class, (Object)Boolean.FALSE, true);
                NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT = new OGlobalConfiguration("network.binary.loadBalancing.timeout", "Maximum time (in ms) to wait for the answer from DNS about the TXT record for load balancing", Integer.class, (Object)2000, true);
                NETWORK_BINARY_MAX_CONTENT_LENGTH = new OGlobalConfiguration("network.binary.maxLength", "TCP/IP max content length (in KB) of BINARY requests", Integer.class, (Object)16384, true);
                NETWORK_BINARY_READ_RESPONSE_MAX_TIMES = new OGlobalConfiguration("network.binary.readResponse.maxTimes", "Maximum attempts, until a response can be read. Otherwise, the response will be dropped from the channel", Integer.class, (Object)20, true);
                NETWORK_BINARY_DEBUG = new OGlobalConfiguration("network.binary.debug", "Debug mode: print all data incoming on the binary channel", Boolean.class, (Object)false, true);
                NETWORK_HTTP_INSTALL_DEFAULT_COMMANDS = new OGlobalConfiguration("network.http.installDefaultCommands", "Installs the default HTTP commands", Boolean.class, (Object)Boolean.TRUE, true);
                NETWORK_HTTP_SERVER_INFO = new OGlobalConfiguration("network.http.serverInfo", "Server info to send in HTTP responses. Change the default if you want to hide it is a OrientDB Server", String.class, (Object)("OrientDB Server v." + OConstants.getVersion()), true);
                NETWORK_HTTP_MAX_CONTENT_LENGTH = new OGlobalConfiguration("network.http.maxLength", "TCP/IP max content length (in bytes) for HTTP requests", Integer.class, (Object)1000000, true);
                NETWORK_HTTP_STREAMING = new OGlobalConfiguration("network.http.streaming", "Enable Http chunked streaming for json responses", Boolean.class, (Object)false, true);
                NETWORK_HTTP_CONTENT_CHARSET = new OGlobalConfiguration("network.http.charset", "Http response charset", String.class, (Object)"utf-8", true);
                NETWORK_HTTP_JSON_RESPONSE_ERROR = new OGlobalConfiguration("network.http.jsonResponseError", "Http response error in json", Boolean.class, (Object)true, true);
                NETWORK_HTTP_JSONP_ENABLED = new OGlobalConfiguration("network.http.jsonp", "Enable the usage of JSONP, if requested by the client. The parameter name to use is 'callback'", Boolean.class, (Object)false, true);
                NETWORK_HTTP_SESSION_EXPIRE_TIMEOUT = new OGlobalConfiguration("network.http.sessionExpireTimeout", "Timeout, after which an http session is considered to have expired (in seconds)", Integer.class, 300);
                NETWORK_HTTP_USE_TOKEN = new OGlobalConfiguration("network.http.useToken", "Enable Token based sessions for http", Boolean.class, false);
                NETWORK_TOKEN_SECRETKEY = new OGlobalConfiguration("network.token.secretKey", "Network token sercret key", String.class, "");
                NETWORK_TOKEN_ENCRYPTION_ALGORITHM = new OGlobalConfiguration("network.token.encryptionAlgorithm", "Network token algorithm", String.class, "HmacSHA256");
                NETWORK_TOKEN_EXPIRE_TIMEOUT = new OGlobalConfiguration("network.token.expireTimeout", "Timeout, after which a binary session is considered to have expired (in minutes)", Integer.class, 60);
                PROFILER_ENABLED = new OGlobalConfiguration("profiler.enabled", "Enables the recording of statistics and counters", Boolean.class, (Object)false, new OConfigurationChangeCallback(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void change(Object iCurrentValue, Object iNewValue) {
                        OProfiler prof;
                        Orient orient = Orient.instance();
                        if (orient != null && (prof = orient.getProfiler()) != null) {
                            if (((Boolean)iNewValue).booleanValue()) {
                                prof.startRecording();
                            } else {
                                prof.stopRecording();
                            }
                        }
                    }
                });
                PROFILER_CONFIG = new OGlobalConfiguration("profiler.config", "Configures the profiler as <seconds-for-snapshot>,<archive-snapshot-size>,<summary-size>", String.class, null, new OConfigurationChangeCallback(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void change(Object iCurrentValue, Object iNewValue) {
                        Orient.instance().getProfiler().configure(iNewValue.toString());
                    }
                });
                PROFILER_AUTODUMP_INTERVAL = new OGlobalConfiguration("profiler.autoDump.interval", "Dumps the profiler values at regular intervals (in seconds)", Integer.class, (Object)0, new OConfigurationChangeCallback(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void change(Object iCurrentValue, Object iNewValue) {
                        Orient.instance().getProfiler().setAutoDump((Integer)iNewValue);
                    }
                });
                PROFILER_AUTODUMP_TYPE = new OGlobalConfiguration("profiler.autoDump.type", "Type of profiler dump between 'full' or 'performance'", String.class, "full");
                PROFILER_MAXVALUES = new OGlobalConfiguration("profiler.maxValues", "Maximum values to store. Values are managed in a LRU", Integer.class, 200);
                PROFILER_MEMORYCHECK_INTERVAL = new OGlobalConfiguration("profiler.memoryCheckInterval", "Checks the memory usage every configured milliseconds. Use 0 to disable it", Long.class, 120000);
                SEQUENCE_MAX_RETRY = new OGlobalConfiguration("sequence.maxRetry", "Maximum number of retries between attempt to change a sequence in concurrent mode", Integer.class, 100);
                SEQUENCE_RETRY_DELAY = new OGlobalConfiguration("sequence.retryDelay", "Maximum number of ms to wait between concurrent modification exceptions. The value is computed as random between 1 and this number", Integer.class, 200);
                STORAGE_PROFILER_SNAPSHOT_INTERVAL = new OGlobalConfiguration("storageProfiler.intervalBetweenSnapshots", "Interval between snapshots of profiler state in milliseconds", Integer.class, 100);
                STORAGE_PROFILER_CLEANUP_INTERVAL = new OGlobalConfiguration("storageProfiler.cleanUpInterval", "Interval between time series in milliseconds", Integer.class, 5000);
                LOG_CONSOLE_LEVEL = new OGlobalConfiguration("log.console.level", "Console logging level", String.class, (Object)"info", new OConfigurationChangeCallback(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void change(Object iCurrentValue, Object iNewValue) {
                        OLogManager.instance().setLevel((String)iNewValue, ConsoleHandler.class);
                    }
                });
                LOG_FILE_LEVEL = new OGlobalConfiguration("log.file.level", "File logging level", String.class, (Object)"info", new OConfigurationChangeCallback(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void change(Object iCurrentValue, Object iNewValue) {
                        OLogManager.instance().setLevel((String)iNewValue, FileHandler.class);
                    }
                });
                CLASS_MINIMUM_CLUSTERS = new OGlobalConfiguration("class.minimumClusters", "Minimum clusters to create when a new class is created. 0 means Automatic", Integer.class, 0);
                LOG_SUPPORTS_ANSI = new OGlobalConfiguration("log.console.ansi", "ANSI Console support. 'auto' means automatic check if it is supported, 'true' to force using ANSI, 'false' to avoid using ANSI", String.class, "auto");
                CACHE_LOCAL_IMPL = new OGlobalConfiguration("cache.local.impl", "Local Record cache implementation", String.class, ORecordCacheWeakRefs.class.getName());
                COMMAND_TIMEOUT = new OGlobalConfiguration("command.timeout", "Default timeout for commands (in ms)", Long.class, (Object)0, true);
                COMMAND_CACHE_ENABLED = new OGlobalConfiguration("command.cache.enabled", "Enable command cache", Boolean.class, false);
                COMMAND_CACHE_EVICT_STRATEGY = new OGlobalConfiguration("command.cache.evictStrategy", "Command cache strategy between: [INVALIDATE_ALL,PER_CLUSTER]", String.class, "PER_CLUSTER");
                COMMAND_CACHE_MIN_EXECUTION_TIME = new OGlobalConfiguration("command.cache.minExecutionTime", "Minimum execution time to consider caching the result set", Integer.class, 10);
                COMMAND_CACHE_MAX_RESULSET_SIZE = new OGlobalConfiguration("command.cache.maxResultsetSize", "Maximum resultset time to consider caching result set", Integer.class, 500);
                QUERY_USE_SOFT_REFENCES_IN_RESULT_SET = new OGlobalConfiguration("query.useSoftReferencesInResultSet", "If this flag is set all query results will be wrapped in soft references, which prevents generation of OOM in case of query returns big amount of data. It is mandatory that both -Xms and -Xmx properties of JVM will be equal, otherwise queries will be aborted even if JVM has enough memory to process the query. This property is set automatically by OrientDB unless it is directly set by the user.", Boolean.class, null);
                QUERY_PARALLEL_AUTO = new OGlobalConfiguration("query.parallelAuto", "Auto enable parallel query, if requirements are met", Boolean.class, false);
                QUERY_PARALLEL_MINIMUM_RECORDS = new OGlobalConfiguration("query.parallelMinimumRecords", "Minimum number of records to activate parallel query automatically", Long.class, 300000);
                QUERY_PARALLEL_RESULT_QUEUE_SIZE = new OGlobalConfiguration("query.parallelResultQueueSize", "Size of the queue that holds results on parallel execution. The queue is blocking, so in case the queue is full, the query threads will be in a wait state", Integer.class, 20000);
                QUERY_SCAN_PREFETCH_PAGES = new OGlobalConfiguration("query.scanPrefetchPages", "Pages to prefetch during scan. Setting this value higher makes scans faster, because it reduces the number of I/O operations, though it consumes more memory. (Use 0 to disable)", Integer.class, 20);
                QUERY_SCAN_BATCH_SIZE = new OGlobalConfiguration("query.scanBatchSize", "Scan clusters in blocks of records. This setting reduces the lock time on the cluster during scans. A high value mean a faster execution, but also a lower concurrency level. Set to 0 to disable batch scanning. Disabling batch scanning is suggested for read-only databases only", Long.class, 1000);
                QUERY_SCAN_THRESHOLD_TIP = new OGlobalConfiguration("query.scanThresholdTip", "If the total number of records scanned in a query exceeds this setting, then a warning is given. (Use 0 to disable)", Long.class, 50000);
                QUERY_LIMIT_THRESHOLD_TIP = new OGlobalConfiguration("query.limitThresholdTip", "If the total number of returned records exceeds this value, then a warning is given. (Use 0 to disable)", Long.class, 10000);
                QUERY_LIVE_SUPPORT = new OGlobalConfiguration("query.live.support", "Enable/Disable the support of live query. (Use false to disable)", Boolean.class, true);
                QUERY_TIMEOUT_DEFAULT_STRATEGY = new OGlobalConfiguration("query.timeout.defaultStrategy", "Default timeout strategy for queries (can be RETURN or EXCEPTION)", String.class, "EXCEPTION");
                LUCENE_QUERY_PAGE_SIZE = new OGlobalConfiguration("lucene.query.pageSize", "Size of the page when fetching data from a lucene index", Long.class, (Object)10000, true);
                STATEMENT_CACHE_SIZE = new OGlobalConfiguration("statement.cacheSize", "Number of parsed SQL statements kept in cache", Integer.class, 100);
                SQL_GRAPH_CONSISTENCY_MODE = new OGlobalConfiguration("sql.graphConsistencyMode", "Consistency mode for graphs. It can be 'tx' (default), 'notx_sync_repair' and 'notx_async_repair'. 'tx' uses transactions to maintain consistency. Instead both 'notx_sync_repair' and 'notx_async_repair' do not use transactions, and the consistency, in case of JVM crash, is guaranteed by a database repair operation that run at startup. With 'notx_sync_repair' the repair is synchronous, so the database comes online after the repair is ended, while with 'notx_async_repair' the repair is a background process", String.class, "tx");
                CLIENT_CHANNEL_MAX_POOL = new OGlobalConfiguration("client.channel.maxPool", "Maximum size of pool of network channels between client and server. A channel is a TCP/IP connection", Integer.class, 100);
                CLIENT_CONNECT_POOL_WAIT_TIMEOUT = new OGlobalConfiguration("client.connectionPool.waitTimeout", "Maximum time, where the client should wait for a connection from the pool, when all connections busy", Integer.class, (Object)5000, true);
                CLIENT_DB_RELEASE_WAIT_TIMEOUT = new OGlobalConfiguration("client.channel.dbReleaseWaitTimeout", "Delay (in ms), after which a data modification command will be resent, if the DB was frozen", Integer.class, (Object)10000, true);
                CLIENT_USE_SSL = new OGlobalConfiguration("client.ssl.enabled", "Use SSL for client connections", Boolean.class, false);
                CLIENT_SSL_KEYSTORE = new OGlobalConfiguration("client.ssl.keyStore", "Use SSL for client connections", String.class, null);
                CLIENT_SSL_KEYSTORE_PASSWORD = new OGlobalConfiguration("client.ssl.keyStorePass", "Use SSL for client connections", String.class, null);
                CLIENT_SSL_TRUSTSTORE = new OGlobalConfiguration("client.ssl.trustStore", "Use SSL for client connections", String.class, null);
                CLIENT_SSL_TRUSTSTORE_PASSWORD = new OGlobalConfiguration("client.ssl.trustStorePass", "Use SSL for client connections", String.class, null);
                SERVER_OPEN_ALL_DATABASES_AT_STARTUP = new OGlobalConfiguration("server.openAllDatabasesAtStartup", "If true, the server opens all the available databases at startup. Available since 2.2", Boolean.class, false);
                SERVER_CHANNEL_CLEAN_DELAY = new OGlobalConfiguration("server.channel.cleanDelay", "Time in ms of delay to check pending closed connections", Integer.class, 5000);
                SERVER_CACHE_FILE_STATIC = new OGlobalConfiguration("server.cache.staticFile", "Cache static resources upon loading", Boolean.class, false);
                SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL = new OGlobalConfiguration("server.log.dumpClientExceptionLevel", "Logs client exceptions. Use any level supported by Java java.util.logging.Level class: OFF, FINE, CONFIG, INFO, WARNING, SEVERE", String.class, Level.FINE.getName());
                SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE = new OGlobalConfiguration("server.log.dumpClientExceptionFullStackTrace", "Dumps the full stack trace of the exception sent to the client", Boolean.class, (Object)Boolean.FALSE, true);
                DISTRIBUTED_DUMP_STATS_EVERY = new OGlobalConfiguration("distributed.dumpStatsEvery", "Time in ms to dump the cluster stats. Set to 0 to disable such dump", Long.class, (Object)0, true);
                DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT = new OGlobalConfiguration("distributed.crudTaskTimeout", "Maximum timeout (in ms) to wait for CRUD remote tasks", Long.class, (Object)10000L, true);
                DISTRIBUTED_MAX_STARTUP_DELAY = new OGlobalConfiguration("distributed.maxStartupDelay", "Maximum delay time (in ms) to wait for a server to start", Long.class, (Object)10000L, true);
                DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT = new OGlobalConfiguration("distributed.commandTaskTimeout", "Maximum timeout (in ms) to wait for command distributed tasks", Long.class, (Object)120000L, true);
                DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT = new OGlobalConfiguration("distributed.commandQuickTaskTimeout", "Maximum timeout (in ms) to wait for quick command distributed tasks", Long.class, (Object)5000L, true);
                DISTRIBUTED_COMMAND_LONG_TASK_SYNCH_TIMEOUT = new OGlobalConfiguration("distributed.commandLongTaskTimeout", "Maximum timeout (in ms) to wait for Long-running distributed tasks", Long.class, (Object)86400000, true);
                DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT = new OGlobalConfiguration("distributed.deployDbTaskTimeout", "Maximum timeout (in ms) to wait for database deployment", Long.class, (Object)1200000L, true);
                DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT = new OGlobalConfiguration("distributed.deployChunkTaskTimeout", "Maximum timeout (in ms) to wait for database chunk deployment", Long.class, (Object)60000L, true);
                DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION = new OGlobalConfiguration("distributed.deployDbTaskCompression", "Compression level (between 0 and 9) to use in backup for database deployment", Integer.class, (Object)7, true);
                DISTRIBUTED_ASYNCH_QUEUE_SIZE = new OGlobalConfiguration("distributed.asynchQueueSize", "Queue size to handle distributed asynchronous operations. The bigger is the queue, the more operation are buffered, but also more memory it's consumed. 0 = dynamic allocation, which means up to 2^31-1 entries", Integer.class, 0);
                DISTRIBUTED_ASYNCH_RESPONSES_TIMEOUT = new OGlobalConfiguration("distributed.asynchResponsesTimeout", "Maximum timeout (in ms) to collect all the asynchronous responses from replication. After this time the operation is rolled back (through an UNDO)", Long.class, 15000L);
                DISTRIBUTED_PURGE_RESPONSES_TIMER_DELAY = new OGlobalConfiguration("distributed.purgeResponsesTimerDelay", "Maximum timeout (in ms) to collect all the asynchronous responses from replication. This is the delay the purge thread uses to check asynchronous requests in timeout", Long.class, 15000L);
                DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHAIN = new OGlobalConfiguration("distributed.conflictResolverRepairerChain", "Chain of conflict resolver implementation to use", String.class, (Object)"quorum,content,majority,version", false);
                DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHECK_EVERY = new OGlobalConfiguration("distributed.conflictResolverRepairerCheckEvery", "Time (in ms) when the conflict resolver auto-repairer checks for records/cluster to repair", Long.class, (Object)5000, true);
                DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH = new OGlobalConfiguration("distributed.conflictResolverRepairerBatch", "Maximum number of records to repair in batch", Integer.class, (Object)50, true);
                DISTRIBUTED_TX_EXPIRE_TIMEOUT = new OGlobalConfiguration("distributed.txAliveTimeout", "Maximum timeout (in ms) a distributed transaction can be alive. This timeout is to rollback pending transactions after a while", Long.class, (Object)30000L, true);
                DISTRIBUTED_REQUEST_CHANNELS = new OGlobalConfiguration("distributed.requestChannels", "Number of network channels used to send requests", Integer.class, 1);
                DISTRIBUTED_RESPONSE_CHANNELS = new OGlobalConfiguration("distributed.responseChannels", "Number of network channels used to send responses", Integer.class, 1);
                DISTRIBUTED_QUEUE_TIMEOUT = new OGlobalConfiguration("distributed.queueTimeout", "Maximum timeout (in ms) to wait when the replication queue is full", Long.class, (Object)15000L, true);
                DISTRIBUTED_HEARTBEAT_TIMEOUT = new OGlobalConfiguration("distributed.heartbeatTimeout", "Maximum time in ms to wait for the heartbeat. If the server does not respond in time, it is put offline", Long.class, 10000L);
                DISTRIBUTED_CHECK_HEALTH_CAN_OFFLINE_SERVER = new OGlobalConfiguration("distributed.checkHealthCanOfflineServer", "In case a server does not respond to the heartbeat message, it is set offline", Boolean.class, false);
                DISTRIBUTED_CHECK_HEALTH_EVERY = new OGlobalConfiguration("distributed.checkHealthEvery", "Time in ms to check the cluster health. Set to 0 to disable it", Long.class, 10000L);
                DISTRIBUTED_AUTO_REMOVE_OFFLINE_SERVERS = new OGlobalConfiguration("distributed.autoRemoveOfflineServers", "This is the amount of time (in ms) the server has to be OFFLINE, before it is automatically removed from the distributed configuration. -1 = never, 0 = immediately, >0 the actual time to wait", Long.class, (Object)0, true);
                DISTRIBUTED_PUBLISH_NODE_STATUS_EVERY = new OGlobalConfiguration("distributed.publishNodeStatusEvery", "Time in ms to publish the node status on distributed map. Set to 0 to disable such refresh of node configuration", Long.class, (Object)10000L, true);
                DISTRIBUTED_LOCAL_QUEUESIZE = new OGlobalConfiguration("distributed.localQueueSize", "Size of the intra-thread queue for distributed messages", Integer.class, 10000);
                DISTRIBUTED_DB_WORKERTHREADS = new OGlobalConfiguration("distributed.dbWorkerThreads", "Number of parallel worker threads per database that process distributed messages. Use 0 for automatic", Integer.class, 0);
                DISTRIBUTED_QUEUE_MAXSIZE = new OGlobalConfiguration("distributed.queueMaxSize", "Maximum queue size to mark a node as stalled. If the number of messages in queue are more than this values, the node is restarted with a remote command (0 = no maximum, which means up to 2^31-1 entries)", Integer.class, 10000);
                DISTRIBUTED_BACKUP_DIRECTORY = new OGlobalConfiguration("distributed.backupDirectory", "Directory where the copy of an existent database is saved, before it is downloaded from the cluster. Leave it empty to avoid the backup.", String.class, "../backup/databases");
                DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST = new OGlobalConfiguration("distributed.backupTryIncrementalFirst", "Try to execute an incremental backup first.", Boolean.class, true);
                DISTRIBUTED_CHECKINTEGRITY_LAST_TX = new OGlobalConfiguration("distributed.checkIntegrityLastTxs", "Before asking for a delta sync, checks the integrity of the records touched by the last X transactions committed on local server.", Integer.class, 16);
                DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY = new OGlobalConfiguration("distributed.concurrentTxMaxAutoRetry", "Maximum attempts the transaction coordinator should execute a transaction automatically, if records are locked. (Minimum is 1 = no attempts)", Integer.class, (Object)15, true);
                DISTRIBUTED_ATOMIC_LOCK_TIMEOUT = new OGlobalConfiguration("distributed.atomicLockTimeout", "Timeout (in ms) to acquire a distributed lock on a record. (0=infinite)", Integer.class, (Object)1000, true);
                DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY = new OGlobalConfiguration("distributed.concurrentTxAutoRetryDelay", "Delay (in ms) between attempts on executing a distributed transaction, which had failed because of locked records. (0=no delay)", Integer.class, (Object)10, true);
                DB_DOCUMENT_SERIALIZER = new OGlobalConfiguration("db.document.serializer", "The default record serializer used by the document database", String.class, "ORecordSerializerBinary");
                CLIENT_KRB5_CONFIG = new OGlobalConfiguration("client.krb5.config", "Location of the Kerberos configuration file", String.class, null);
                CLIENT_KRB5_CCNAME = new OGlobalConfiguration("client.krb5.ccname", "Location of the Kerberos client ticketcache", String.class, null);
                CLIENT_KRB5_KTNAME = new OGlobalConfiguration("client.krb5.ktname", "Location of the Kerberos client keytab", String.class, null);
                CLIENT_CREDENTIAL_INTERCEPTOR = new OGlobalConfiguration("client.credentialinterceptor", "The name of the CredentialInterceptor class", String.class, null);
                CLIENT_CI_KEYALGORITHM = new OGlobalConfiguration("client.ci.keyalgorithm", "The key algorithm used by the symmetric key credential interceptor", String.class, "AES");
                CLIENT_CI_CIPHERTRANSFORM = new OGlobalConfiguration("client.ci.ciphertransform", "The cipher transformation used by the symmetric key credential interceptor", String.class, "AES/CBC/PKCS5Padding");
                CLIENT_CI_KEYSTORE_FILE = new OGlobalConfiguration("client.ci.keystore.file", "The file path of the keystore used by the symmetric key credential interceptor", String.class, null);
                CLIENT_CI_KEYSTORE_PASSWORD = new OGlobalConfiguration("client.ci.keystore.password", "The password of the keystore used by the symmetric key credential interceptor", String.class, null);
                CREATE_DEFAULT_USERS = new OGlobalConfiguration("security.createDefaultUsers", "Indicates whether default database users should be created", Boolean.class, true);
                SERVER_SECURITY_FILE = new OGlobalConfiguration("server.security.file", "Location of the OrientDB security.json configuration file", String.class, null);
                INIT_IN_SERVLET_CONTEXT_LISTENER = new OGlobalConfiguration("orient.initInServletContextListener", "If this value set to ture (default) OrientDB engine will be initialzed using embedded ServletContextListener", Boolean.class, true);
                JNA_DISABLE_USE_SYSTEM_LIBRARY = new OGlobalConfiguration("jna.disable.system.library", "This property disables using JNA, should it be installed on your system. (Default true) To use JNA bundled with database", Boolean.TYPE, true);
                DB_MAKE_FULL_CHECKPOINT_ON_INDEX_CHANGE = new OGlobalConfiguration("db.makeFullCheckpointOnIndexChange", "When index metadata is changed, a full checkpoint is performed", Boolean.class, (Object)true, true);
                DB_MAKE_FULL_CHECKPOINT_ON_SCHEMA_CHANGE = new OGlobalConfiguration("db.makeFullCheckpointOnSchemaChange", "When index schema is changed, a full checkpoint is performed", Boolean.class, (Object)true, true);
                CLIENT_SESSION_TOKEN_BASED = new OGlobalConfiguration("client.session.tokenBased", "Request a token based session to the server", Boolean.class, true);
                OAUTH2_SECRETKEY = new OGlobalConfiguration("oauth2.secretkey", "Http OAuth2 secret key", String.class, "");
                STORAGE_USE_CRC32_FOR_EACH_RECORD = new OGlobalConfiguration("storage.cluster.usecrc32", "Indicates whether crc32 should be used for each record to check record integrity", Boolean.class, false);
                LAZYSET_WORK_ON_STREAM = new OGlobalConfiguration("lazyset.workOnStream", "Deprecated, now BINARY serialization is used in place of CSV", Boolean.class, true);
                DB_MVCC = new OGlobalConfiguration("db.mvcc", "Deprecated, MVCC cannot be disabled anymore", Boolean.class, true);
                DB_USE_DISTRIBUTED_VERSION = new OGlobalConfiguration("db.use.distributedVersion", "Deprecated, distributed version is not used anymore", Boolean.class, Boolean.FALSE);
                MVRBTREE_TIMEOUT = new OGlobalConfiguration("mvrbtree.timeout", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Integer.class, 0);
                MVRBTREE_NODE_PAGE_SIZE = new OGlobalConfiguration("mvrbtree.nodePageSize", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Integer.class, 256);
                MVRBTREE_LOAD_FACTOR = new OGlobalConfiguration("mvrbtree.loadFactor", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Float.class, Float.valueOf(0.7f));
                MVRBTREE_OPTIMIZE_THRESHOLD = new OGlobalConfiguration("mvrbtree.optimizeThreshold", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Integer.class, 100000);
                MVRBTREE_ENTRYPOINTS = new OGlobalConfiguration("mvrbtree.entryPoints", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Integer.class, 64);
                MVRBTREE_OPTIMIZE_ENTRYPOINTS_FACTOR = new OGlobalConfiguration("mvrbtree.optimizeEntryPointsFactor", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Float.class, Float.valueOf(1.0f));
                MVRBTREE_ENTRY_KEYS_IN_MEMORY = new OGlobalConfiguration("mvrbtree.entryKeysInMemory", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Boolean.class, Boolean.FALSE);
                MVRBTREE_ENTRY_VALUES_IN_MEMORY = new OGlobalConfiguration("mvrbtree.entryValuesInMemory", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Boolean.class, Boolean.FALSE);
                MVRBTREE_RID_BINARY_THRESHOLD = new OGlobalConfiguration("mvrbtree.ridBinaryThreshold", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Integer.class, -1);
                MVRBTREE_RID_NODE_PAGE_SIZE = new OGlobalConfiguration("mvrbtree.ridNodePageSize", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Integer.class, 64);
                MVRBTREE_RID_NODE_SAVE_MEMORY = new OGlobalConfiguration("mvrbtree.ridNodeSaveMemory", "Deprecated, MVRBTREE IS NOT USED ANYMORE IN FAVOR OF SBTREE AND HASHINDEX", Boolean.class, Boolean.FALSE);
                TX_COMMIT_SYNCH = new OGlobalConfiguration("tx.commit.synch", "Synchronizes the storage after transaction commit", Boolean.class, false);
                TX_AUTO_RETRY = new OGlobalConfiguration("tx.autoRetry", "Maximum number of automatic retry if some resource has been locked in the middle of the transaction (Timeout exception)", Integer.class, 1);
                TX_LOG_TYPE = new OGlobalConfiguration("tx.log.fileType", "File type to handle transaction logs: mmap or classic", String.class, "classic");
                TX_LOG_SYNCH = new OGlobalConfiguration("tx.log.synch", "Executes a synch against the file-system at every log entry. This slows down transactions but guarantee transaction reliability on unreliable drives", Boolean.class, Boolean.FALSE);
                TX_USE_LOG = new OGlobalConfiguration("tx.useLog", "Transactions use log file to store temporary data to be rolled back in case of crash", Boolean.class, true);
                INDEX_AUTO_REBUILD_AFTER_NOTSOFTCLOSE = new OGlobalConfiguration("index.auto.rebuildAfterNotSoftClose", "Auto rebuild all automatic indexes after upon database open when wasn't closed properly", Boolean.class, true);
                CLIENT_CHANNEL_MIN_POOL = new OGlobalConfiguration("client.channel.minPool", "Minimum pool size", Integer.class, 1);
                STORAGE_KEEP_OPEN = new OGlobalConfiguration("storage.keepOpen", "Deprecated", Boolean.class, Boolean.TRUE);
                CACHE_LOCAL_ENABLED = new OGlobalConfiguration("cache.local.enabled", "Deprecated, Level1 cache cannot be disabled anymore", Boolean.class, true);
                DISTRIBUTED_DB_SHUTDOWNTIMEOUT = new OGlobalConfiguration("distributed.shutdownTimeout", "Time in ms to wait for threads to shutdown. Set to 0 to wait forever", Long.class, (Object)2000, true);
                $VALUES = new OGlobalConfiguration[]{ENVIRONMENT_DUMP_CFG_AT_STARTUP, ENVIRONMENT_CONCURRENT, ENVIRONMENT_LOCK_MANAGER_CONCURRENCY_LEVEL, ENVIRONMENT_ALLOW_JVM_SHUTDOWN, SCRIPT_POOL, MEMORY_USE_UNSAFE, MEMORY_CHUNK_SIZE, DIRECT_MEMORY_SAFE_MODE, DIRECT_MEMORY_TRACK_MODE, DIRECT_MEMORY_ONLY_ALIGNED_ACCESS, JVM_GC_DELAY_FOR_OPTIMIZE, OPEN_FILES_LIMIT, COMPONENTS_LOCK_CACHE, DISK_CACHE_PINNED_PAGES, DISK_CACHE_SIZE, DISK_WRITE_CACHE_PART, DISK_WRITE_CACHE_PAGE_TTL, DISK_WRITE_CACHE_PAGE_FLUSH_INTERVAL, DISK_WRITE_CACHE_FLUSH_WRITE_INACTIVITY_INTERVAL, DISK_WRITE_CACHE_FLUSH_LOCK_TIMEOUT, DISC_CACHE_FREE_SPACE_CHECK_INTERVAL, DISC_CACHE_FREE_SPACE_CHECK_INTERVAL_IN_PAGES, STORAGE_KEEP_DISK_CACHE_STATE, STORAGE_CHECKSUM_MODE, STORAGE_CONFIGURATION_SYNC_ON_UPDATE, STORAGE_COMPRESSION_METHOD, STORAGE_ENCRYPTION_METHOD, STORAGE_ENCRYPTION_KEY, STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CREATE, STORAGE_MAKE_FULL_CHECKPOINT_AFTER_OPEN, STORAGE_MAKE_FULL_CHECKPOINT_AFTER_CLUSTER_CREATE, STORAGE_TRACK_CHANGED_RECORDS_IN_WAL, USE_WAL, WAL_SYNC_ON_PAGE_FLUSH, WAL_CACHE_SIZE, WAL_FILE_AUTOCLOSE_INTERVAL, WAL_MAX_SEGMENT_SIZE, WAL_MAX_SIZE, WAL_COMMIT_TIMEOUT, WAL_SHUTDOWN_TIMEOUT, WAL_FUZZY_CHECKPOINT_INTERVAL, WAL_REPORT_AFTER_OPERATIONS_DURING_RESTORE, WAL_RESTORE_BATCH_SIZE, WAL_READ_CACHE_SIZE, WAL_FUZZY_CHECKPOINT_SHUTDOWN_TIMEOUT, WAL_FULL_CHECKPOINT_SHUTDOWN_TIMEOUT, WAL_LOCATION, DISK_CACHE_PAGE_SIZE, DISK_CACHE_FREE_SPACE_LIMIT, PAGINATED_STORAGE_LOWEST_FREELIST_BOUNDARY, STORAGE_LOCK_TIMEOUT, STORAGE_RECORD_LOCK_TIMEOUT, STORAGE_USE_TOMBSTONES, RECORD_DOWNSIZING_ENABLED, OBJECT_SAVE_ONLY_DIRTY, DB_POOL_MIN, DB_POOL_MAX, DB_POOL_IDLE_TIMEOUT, DB_POOL_IDLE_CHECK_DELAY, DB_MVCC_THROWFAST, DB_VALIDATION, NON_TX_RECORD_UPDATE_SYNCH, NON_TX_CLUSTERS_SYNC_IMMEDIATELY, TX_TRACK_ATOMIC_OPERATIONS, TX_PAGE_CACHE_SIZE, INDEX_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD, INDEX_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD, HASH_TABLE_SPLIT_BUCKETS_BUFFER_LENGTH, INDEX_SYNCHRONOUS_AUTO_REBUILD, INDEX_AUTO_LAZY_UPDATES, INDEX_FLUSH_AFTER_CREATE, INDEX_MANUAL_LAZY_UPDATES, INDEX_DURABLE_IN_NON_TX_MODE, INDEX_IGNORE_NULL_VALUES_DEFAULT, INDEX_TX_MODE, INDEX_CURSOR_PREFETCH_SIZE, SBTREE_MAX_DEPTH, SBTREE_MAX_KEY_SIZE, SBTREE_MAX_EMBEDDED_VALUE_SIZE, SBTREEBONSAI_BUCKET_SIZE, SBTREEBONSAI_LINKBAG_CACHE_SIZE, SBTREEBONSAI_LINKBAG_CACHE_EVICTION_SIZE, SBTREEBOSAI_FREE_SPACE_REUSE_TRIGGER, RID_BAG_EMBEDDED_DEFAULT_SIZE, RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD, RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD, PREFER_SBTREE_SET, TRACK_FILE_CLOSE, FILE_LOCK, FILE_DELETE_DELAY, FILE_DELETE_RETRY, SECURITY_USER_PASSWORD_SALT_ITERATIONS, SECURITY_USER_PASSWORD_SALT_CACHE_SIZE, SECURITY_USER_PASSWORD_DEFAULT_ALGORITHM, NETWORK_MAX_CONCURRENT_SESSIONS, NETWORK_SOCKET_BUFFER_SIZE, NETWORK_LOCK_TIMEOUT, NETWORK_SOCKET_TIMEOUT, NETWORK_REQUEST_TIMEOUT, NETWORK_SOCKET_RETRY_STRATEGY, NETWORK_SOCKET_RETRY, NETWORK_SOCKET_RETRY_DELAY, NETWORK_BINARY_DNS_LOADBALANCING_ENABLED, NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT, NETWORK_BINARY_MAX_CONTENT_LENGTH, NETWORK_BINARY_READ_RESPONSE_MAX_TIMES, NETWORK_BINARY_DEBUG, NETWORK_HTTP_INSTALL_DEFAULT_COMMANDS, NETWORK_HTTP_SERVER_INFO, NETWORK_HTTP_MAX_CONTENT_LENGTH, NETWORK_HTTP_STREAMING, NETWORK_HTTP_CONTENT_CHARSET, NETWORK_HTTP_JSON_RESPONSE_ERROR, NETWORK_HTTP_JSONP_ENABLED, NETWORK_HTTP_SESSION_EXPIRE_TIMEOUT, NETWORK_HTTP_USE_TOKEN, NETWORK_TOKEN_SECRETKEY, NETWORK_TOKEN_ENCRYPTION_ALGORITHM, NETWORK_TOKEN_EXPIRE_TIMEOUT, PROFILER_ENABLED, PROFILER_CONFIG, PROFILER_AUTODUMP_INTERVAL, PROFILER_AUTODUMP_TYPE, PROFILER_MAXVALUES, PROFILER_MEMORYCHECK_INTERVAL, SEQUENCE_MAX_RETRY, SEQUENCE_RETRY_DELAY, STORAGE_PROFILER_SNAPSHOT_INTERVAL, STORAGE_PROFILER_CLEANUP_INTERVAL, LOG_CONSOLE_LEVEL, LOG_FILE_LEVEL, CLASS_MINIMUM_CLUSTERS, LOG_SUPPORTS_ANSI, CACHE_LOCAL_IMPL, COMMAND_TIMEOUT, COMMAND_CACHE_ENABLED, COMMAND_CACHE_EVICT_STRATEGY, COMMAND_CACHE_MIN_EXECUTION_TIME, COMMAND_CACHE_MAX_RESULSET_SIZE, QUERY_USE_SOFT_REFENCES_IN_RESULT_SET, QUERY_PARALLEL_AUTO, QUERY_PARALLEL_MINIMUM_RECORDS, QUERY_PARALLEL_RESULT_QUEUE_SIZE, QUERY_SCAN_PREFETCH_PAGES, QUERY_SCAN_BATCH_SIZE, QUERY_SCAN_THRESHOLD_TIP, QUERY_LIMIT_THRESHOLD_TIP, QUERY_LIVE_SUPPORT, QUERY_TIMEOUT_DEFAULT_STRATEGY, LUCENE_QUERY_PAGE_SIZE, STATEMENT_CACHE_SIZE, SQL_GRAPH_CONSISTENCY_MODE, CLIENT_CHANNEL_MAX_POOL, CLIENT_CONNECT_POOL_WAIT_TIMEOUT, CLIENT_DB_RELEASE_WAIT_TIMEOUT, CLIENT_USE_SSL, CLIENT_SSL_KEYSTORE, CLIENT_SSL_KEYSTORE_PASSWORD, CLIENT_SSL_TRUSTSTORE, CLIENT_SSL_TRUSTSTORE_PASSWORD, SERVER_OPEN_ALL_DATABASES_AT_STARTUP, SERVER_CHANNEL_CLEAN_DELAY, SERVER_CACHE_FILE_STATIC, SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL, SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE, DISTRIBUTED_DUMP_STATS_EVERY, DISTRIBUTED_CRUD_TASK_SYNCH_TIMEOUT, DISTRIBUTED_MAX_STARTUP_DELAY, DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT, DISTRIBUTED_COMMAND_QUICK_TASK_SYNCH_TIMEOUT, DISTRIBUTED_COMMAND_LONG_TASK_SYNCH_TIMEOUT, DISTRIBUTED_DEPLOYDB_TASK_SYNCH_TIMEOUT, DISTRIBUTED_DEPLOYCHUNK_TASK_SYNCH_TIMEOUT, DISTRIBUTED_DEPLOYDB_TASK_COMPRESSION, DISTRIBUTED_ASYNCH_QUEUE_SIZE, DISTRIBUTED_ASYNCH_RESPONSES_TIMEOUT, DISTRIBUTED_PURGE_RESPONSES_TIMER_DELAY, DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHAIN, DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_CHECK_EVERY, DISTRIBUTED_CONFLICT_RESOLVER_REPAIRER_BATCH, DISTRIBUTED_TX_EXPIRE_TIMEOUT, DISTRIBUTED_REQUEST_CHANNELS, DISTRIBUTED_RESPONSE_CHANNELS, DISTRIBUTED_QUEUE_TIMEOUT, DISTRIBUTED_HEARTBEAT_TIMEOUT, DISTRIBUTED_CHECK_HEALTH_CAN_OFFLINE_SERVER, DISTRIBUTED_CHECK_HEALTH_EVERY, DISTRIBUTED_AUTO_REMOVE_OFFLINE_SERVERS, DISTRIBUTED_PUBLISH_NODE_STATUS_EVERY, DISTRIBUTED_LOCAL_QUEUESIZE, DISTRIBUTED_DB_WORKERTHREADS, DISTRIBUTED_QUEUE_MAXSIZE, DISTRIBUTED_BACKUP_DIRECTORY, DISTRIBUTED_BACKUP_TRY_INCREMENTAL_FIRST, DISTRIBUTED_CHECKINTEGRITY_LAST_TX, DISTRIBUTED_CONCURRENT_TX_MAX_AUTORETRY, DISTRIBUTED_ATOMIC_LOCK_TIMEOUT, DISTRIBUTED_CONCURRENT_TX_AUTORETRY_DELAY, DB_DOCUMENT_SERIALIZER, CLIENT_KRB5_CONFIG, CLIENT_KRB5_CCNAME, CLIENT_KRB5_KTNAME, CLIENT_CREDENTIAL_INTERCEPTOR, CLIENT_CI_KEYALGORITHM, CLIENT_CI_CIPHERTRANSFORM, CLIENT_CI_KEYSTORE_FILE, CLIENT_CI_KEYSTORE_PASSWORD, CREATE_DEFAULT_USERS, SERVER_SECURITY_FILE, INIT_IN_SERVLET_CONTEXT_LISTENER, JNA_DISABLE_USE_SYSTEM_LIBRARY, DB_MAKE_FULL_CHECKPOINT_ON_INDEX_CHANGE, DB_MAKE_FULL_CHECKPOINT_ON_SCHEMA_CHANGE, CLIENT_SESSION_TOKEN_BASED, OAUTH2_SECRETKEY, STORAGE_USE_CRC32_FOR_EACH_RECORD, LAZYSET_WORK_ON_STREAM, DB_MVCC, DB_USE_DISTRIBUTED_VERSION, MVRBTREE_TIMEOUT, MVRBTREE_NODE_PAGE_SIZE, MVRBTREE_LOAD_FACTOR, MVRBTREE_OPTIMIZE_THRESHOLD, MVRBTREE_ENTRYPOINTS, MVRBTREE_OPTIMIZE_ENTRYPOINTS_FACTOR, MVRBTREE_ENTRY_KEYS_IN_MEMORY, MVRBTREE_ENTRY_VALUES_IN_MEMORY, MVRBTREE_RID_BINARY_THRESHOLD, MVRBTREE_RID_NODE_PAGE_SIZE, MVRBTREE_RID_NODE_SAVE_MEMORY, TX_COMMIT_SYNCH, TX_AUTO_RETRY, TX_LOG_TYPE, TX_LOG_SYNCH, TX_USE_LOG, INDEX_AUTO_REBUILD_AFTER_NOTSOFTCLOSE, CLIENT_CHANNEL_MIN_POOL, STORAGE_KEEP_OPEN, CACHE_LOCAL_ENABLED, DISTRIBUTED_DB_SHUTDOWNTIMEOUT};
                OGlobalConfiguration.readConfiguration();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

