/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import java.io.Serializable;

public class OStorageSegmentConfiguration
implements Serializable {
    public transient OStorageConfiguration root;
    public volatile int id;
    public volatile String name;
    public volatile String maxSize = "0";
    public volatile String fileType = "mmap";
    public volatile String fileStartSize = "500Kb";
    public volatile String fileMaxSize = "500Mb";
    public volatile String fileIncrementSize = "50%";
    public volatile String defrag = "auto";
    public volatile STATUS status = STATUS.ONLINE;
    public OStorageFileConfiguration[] infoFiles;
    String location;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OStorageSegmentConfiguration() {
        this.infoFiles = OCommonConst.EMPTY_FILE_CONFIGURATIONS_ARRAY;
    }

    public OStorageSegmentConfiguration(OStorageConfiguration iRoot, String iSegmentName, int iId) {
        this.root = iRoot;
        this.name = iSegmentName;
        this.id = iId;
        this.infoFiles = OCommonConst.EMPTY_FILE_CONFIGURATIONS_ARRAY;
    }

    public OStorageSegmentConfiguration(OStorageConfiguration iRoot, String iSegmentName, int iId, String iDirectory) {
        this.root = iRoot;
        this.name = iSegmentName;
        this.id = iId;
        this.location = iDirectory;
        this.infoFiles = OCommonConst.EMPTY_FILE_CONFIGURATIONS_ARRAY;
    }

    public void setRoot(OStorageConfiguration iRoot) {
        this.root = iRoot;
        for (OStorageFileConfiguration f : this.infoFiles) {
            f.parent = this;
        }
    }

    public String getLocation() {
        if (this.location != null) {
            return this.location;
        }
        return this.root != null ? this.root.getDirectory() : null;
    }

    public static final class STATUS
    extends Enum<STATUS> {
        public static final /* enum */ STATUS ONLINE;
        public static final /* enum */ STATUS OFFLINE;
        private static final /* synthetic */ STATUS[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static STATUS[] values() {
            return (STATUS[])$VALUES.clone();
        }

        public static STATUS valueOf(String name) {
            return Enum.valueOf(STATUS.class, name);
        }

        static {
            try {
                try {
                    ONLINE = new STATUS();
                    OFFLINE = new STATUS();
                    $VALUES = new STATUS[]{ONLINE, OFFLINE};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

