/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import java.util.concurrent.Callable;

public class OScenarioThreadLocal
extends ThreadLocal<RunContext> {
    public static volatile OScenarioThreadLocal INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OScenarioThreadLocal() {
        this.setRunMode(RUN_MODE.DEFAULT);
    }

    public static Object executeAsDistributed(Callable<? extends Object> iCallback) {
        RUN_MODE currentDistributedMode = INSTANCE.getRunMode();
        if (currentDistributedMode != RUN_MODE.RUNNING_DISTRIBUTED) {
            INSTANCE.setRunMode(RUN_MODE.RUNNING_DISTRIBUTED);
        }
        try {
            Object object = iCallback.call();
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentDistributedMode != RUN_MODE.RUNNING_DISTRIBUTED) {
                INSTANCE.setRunMode(RUN_MODE.DEFAULT);
            }
        }
    }

    public static <T> Object executeAsDefault(Callable<T> iCallback) {
        RUN_MODE currentDistributedMode = INSTANCE.getRunMode();
        if (currentDistributedMode == RUN_MODE.RUNNING_DISTRIBUTED) {
            INSTANCE.setRunMode(RUN_MODE.DEFAULT);
        }
        try {
            T t = iCallback.call();
            return t;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentDistributedMode == RUN_MODE.RUNNING_DISTRIBUTED) {
                INSTANCE.setRunMode(RUN_MODE.RUNNING_DISTRIBUTED);
            }
        }
    }

    public void setRunMode(RUN_MODE value) {
        RunContext context = (RunContext)this.get();
        context.runMode = value;
    }

    public void setInDatabaseLock(boolean value) {
        RunContext context = (RunContext)this.get();
        context.inDatabaseLock = value;
    }

    public RUN_MODE getRunMode() {
        return ((RunContext)this.get()).runMode;
    }

    public boolean isRunModeDistributed() {
        return ((RunContext)this.get()).runMode == RUN_MODE.RUNNING_DISTRIBUTED;
    }

    public boolean isInDatabaseLock() {
        return ((RunContext)this.get()).inDatabaseLock;
    }

    @Override
    protected RunContext initialValue() {
        return new RunContext();
    }

    static {
        try {
            try {
                INSTANCE = new OScenarioThreadLocal();
                Orient.instance().registerListener(new OOrientListenerAbstract(){
                    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

                    @Override
                    public void onStartup() {
                        if (INSTANCE == null) {
                            INSTANCE = new OScenarioThreadLocal();
                        }
                    }

                    @Override
                    public void onShutdown() {
                        INSTANCE = null;
                    }
                });
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    public static class RunContext {
        public RUN_MODE runMode = RUN_MODE.DEFAULT;
        public boolean inDatabaseLock;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
    }

    public static final class RUN_MODE
    extends Enum<RUN_MODE> {
        public static final /* enum */ RUN_MODE DEFAULT;
        public static final /* enum */ RUN_MODE RUNNING_DISTRIBUTED;
        private static final /* synthetic */ RUN_MODE[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static RUN_MODE[] values() {
            return (RUN_MODE[])$VALUES.clone();
        }

        public static RUN_MODE valueOf(String name) {
            return Enum.valueOf(RUN_MODE.class, name);
        }

        static {
            try {
                try {
                    DEFAULT = new RUN_MODE();
                    RUNNING_DISTRIBUTED = new RUN_MODE();
                    $VALUES = new RUN_MODE[]{DEFAULT, RUNNING_DISTRIBUTED};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

