/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.Locale;

public class ORecordOperation
implements Comparable {
    public static final byte LOADED = 0;
    public static final byte UPDATED = 1;
    public static final byte DELETED = 2;
    public static final byte CREATED = 3;
    public static final byte RECYCLED = 4;
    public byte type;
    public OIdentifiable record;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ORecordOperation() {
    }

    public ORecordOperation(OIdentifiable iRecord, byte iStatus) {
        this.record = iRecord;
        this.type = iStatus;
    }

    public int hashCode() {
        return this.record.getIdentity().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ORecordOperation)) {
            return false;
        }
        return this.record.equals(((ORecordOperation)obj).record);
    }

    public String toString() {
        return new StringBuilder(128).append("ORecordOperation [record=").append(this.record).append(", type=").append(ORecordOperation.getName(this.type)).append("]").toString();
    }

    public OIdentifiable setRecord(OIdentifiable record) {
        this.record = record;
        return record;
    }

    public ORecord getRecord() {
        return this.record != null ? (ORecord)this.record.getRecord() : null;
    }

    public ORID getRID() {
        return this.record != null ? this.record.getIdentity() : null;
    }

    public static String getName(int type) {
        String operation = "?";
        switch (type) {
            case 3: {
                operation = "CREATE";
                break;
            }
            case 1: {
                operation = "UPDATE";
                break;
            }
            case 2: {
                operation = "DELETE";
                break;
            }
            case 0: {
                operation = "READ";
                break;
            }
            case 4: {
                operation = "RECYCLED";
            }
        }
        return operation;
    }

    public static byte getId(String iName) {
        if ((iName = iName.toUpperCase(Locale.ENGLISH)).startsWith("CREAT")) {
            return 3;
        }
        if (iName.startsWith("UPDAT")) {
            return 1;
        }
        if (iName.startsWith("DELET")) {
            return 2;
        }
        if (iName.startsWith("READ")) {
            return 0;
        }
        if (iName.startsWith("RECYCLED")) {
            return 4;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.record.compareTo(((ORecordOperation)o).record);
    }
}

