/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.tool;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.ODatabaseTool;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Iterator;
import java.util.List;

public class OCheckIndexTool
extends ODatabaseTool {
    long totalErrors = 0L;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    protected void parseSetting(String option, List<String> items) {
    }

    @Override
    public void run() {
        for (OIndex<?> index : this.database.getMetadata().getIndexManager().getIndexes()) {
            if (!this.canCheck(index)) continue;
            this.checkIndex(index);
        }
        this.message("Total errors found on indexes: " + this.getTotalErrors(), new Object[0]);
    }

    private boolean canCheck(OIndex index) {
        OIndexDefinition indexDef = index.getDefinition();
        String className = indexDef.getClassName();
        if (className == null) {
            return false;
        }
        List<String> fields = indexDef.getFields();
        List<String> fieldDefs = indexDef.getFieldsToIndex();
        for (int i = 0; i < fieldDefs.size(); ++i) {
            if (fields.get(i).equals(fieldDefs.get(i))) continue;
            return false;
        }
        return true;
    }

    private void checkIndex(OIndex index) {
        int[] clusterIds;
        List<String> fields = index.getDefinition().getFields();
        String className = index.getDefinition().getClassName();
        OClass clazz = this.database.getMetadata().getSchema().getClass(className);
        for (int clusterId : clusterIds = clazz.getPolymorphicClusterIds()) {
            this.checkCluster(clusterId, index, fields);
        }
    }

    private void checkCluster(int clusterId, OIndex index, List<String> fields) {
        long totRecordsForCluster = this.database.countClusterElements(clusterId);
        String clusterName = this.database.getClusterNameById(clusterId);
        int TOT_STEPS = 20;
        this.message("Checking cluster " + clusterName + "  for index " + index.getName() + "\n", new Object[0]);
        ORecordIteratorCluster iter = this.database.browseCluster(clusterName);
        long count = 0L;
        long step = -1L;
        while (iter.hasNext()) {
            Object record;
            long currentStep = count * 20L / totRecordsForCluster;
            if (currentStep > step) {
                this.printProgress(clusterName, clusterId, (int)currentStep, TOT_STEPS);
                step = currentStep;
            }
            if ((record = iter.next()) instanceof ODocument) {
                ODocument doc = (ODocument)record;
                this.checkThatRecordIsIndexed(doc, index, fields);
            }
            ++count;
        }
        this.printProgress(clusterName, clusterId, TOT_STEPS, TOT_STEPS);
        this.message("\n", new Object[0]);
    }

    void printProgress(String clusterName, int clusterId, int step, int totSteps) {
        StringBuilder msg = new StringBuilder();
        msg.append("\rcluster " + clusterName + " (" + clusterId + ") |");
        for (int i = 0; i < totSteps; ++i) {
            if (i < step) {
                msg.append("*");
                continue;
            }
            msg.append(" ");
        }
        msg.append("| ");
        msg.append(step * 100 / totSteps);
        msg.append("%%");
        this.message(msg.toString(), new Object[0]);
    }

    private void checkThatRecordIsIndexed(ODocument doc, OIndex index, List<String> fields) {
        Object[] vals = new Object[fields.size()];
        ORID docId = doc.getIdentity();
        for (int i = 0; i < vals.length; ++i) {
            vals[i] = doc.field(fields.get(i));
        }
        Object indexKey = index.getDefinition().createValue(vals);
        if (indexKey == null) {
            return;
        }
        Object values = index.get(indexKey);
        if (values instanceof OIdentifiable) {
            ORID indexRid = ((OIdentifiable)values).getIdentity();
            if (!indexRid.equals(docId)) {
                ++this.totalErrors;
                this.message("\rERROR: Index " + index.getName() + " - record not found: " + doc.getIdentity() + "\n", new Object[0]);
            }
        } else if (values instanceof Iterable) {
            Iterator valuesOnIndex = ((Iterable)values).iterator();
            boolean found = false;
            while (valuesOnIndex.hasNext()) {
                ORID indexRid = ((OIdentifiable)valuesOnIndex.next()).getIdentity();
                if (!docId.equals(indexRid)) continue;
                found = true;
                break;
            }
            if (!found) {
                ++this.totalErrors;
                this.message("\rERROR: Index " + index.getName() + " - record not found: " + doc.getIdentity() + "\n", new Object[0]);
            }
        }
    }

    public long getTotalErrors() {
        return this.totalErrors;
    }
}

