/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.engine;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.cache.OSnowFlakeIdGen;
import com.orientechnologies.orient.core.storage.cache.OWriteCacheIdGen;
import java.util.Map;

public abstract class OEngineAbstract
implements OEngine {
    private static final OWriteCacheIdGen writeCacheIdGen;
    private boolean running = false;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    protected int generateStorageId() {
        return writeCacheIdGen.nextId();
    }

    protected String getMode(Map<String, String> iConfiguration) {
        String dbMode = null;
        if (iConfiguration != null) {
            dbMode = iConfiguration.get("mode");
        }
        if (dbMode == null) {
            dbMode = "rw";
        }
        return dbMode;
    }

    @Override
    public void startup() {
        this.running = true;
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public void removeStorage(OStorage iStorage) {
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    static {
        try {
            try {
                writeCacheIdGen = new OSnowFlakeIdGen();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

