/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index.hashindex.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OHashTableDirectoryException;
import com.orientechnologies.orient.core.index.hashindex.local.ODirectoryFirstPage;
import com.orientechnologies.orient.core.index.hashindex.local.ODirectoryPage;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cache.OCachePointer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import java.io.IOException;

public class OHashTableDirectory
extends ODurableComponent {
    public static final int ITEM_SIZE = 8;
    public static final int LEVEL_SIZE = 256;
    public static final int BINARY_LEVEL_SIZE = 2051;
    private long fileId;
    private final long firstEntryIndex;
    private final boolean durableInNonTxMode;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OHashTableDirectory(String defaultExtension, String name, String lockName, boolean durableInNonTxMode, OAbstractPaginatedStorage storage) {
        super(storage, name, defaultExtension, lockName);
        this.durableInNonTxMode = durableInNonTxMode;
        this.firstEntryIndex = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                this.init();
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during creation of hash table", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        OAtomicOperation atomicOperation = this.startAtomicOperation(false);
        try {
            OCacheEntry firstEntry = this.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true);
            if (firstEntry == null) {
                firstEntry = this.addPage(atomicOperation, this.fileId);
                assert (firstEntry.getPageIndex() == 0L);
            }
            this.pinPage(atomicOperation, firstEntry);
            firstEntry.acquireExclusiveLock();
            try {
                ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, this.getChanges(atomicOperation, firstEntry), firstEntry);
                firstPage.setTreeSize(0);
                firstPage.setTombstone(-1);
            }
            finally {
                firstEntry.releaseExclusiveLock();
                this.releasePage(atomicOperation, firstEntry);
            }
            this.endAtomicOperation(false, null);
        }
        catch (IOException e) {
            this.endAtomicOperation(true, e);
            throw e;
        }
        catch (Exception e) {
            this.endAtomicOperation(true, e);
            throw OException.wrapException(new OHashTableDirectoryException("Error during hash table initialization", this), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                this.fileId = this.openFile(atomicOperation, this.getFullName());
                int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
                for (int i = 0; i < filledUpTo; ++i) {
                    OCacheEntry entry = this.loadPage(atomicOperation, this.fileId, i, true);
                    assert (entry != null);
                    this.pinPage(atomicOperation, entry);
                    this.releasePage(atomicOperation, entry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void close() throws IOException {
        this.startOperation();
        try {
            this.acquireExclusiveLock();
            try {
                this.readCache.closeFile(this.fileId, true, this.writeCache);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                this.deleteFile(atomicOperation, this.fileId);
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during hash table deletion", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWithoutOpen() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(false);
            this.acquireExclusiveLock();
            try {
                if (this.isFileExists(atomicOperation, this.getFullName())) {
                    this.fileId = this.openFile(atomicOperation, this.getFullName());
                    this.deleteFile(atomicOperation, this.fileId);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during deletion of hash table", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNewNode(byte maxLeftChildDepth, byte maxRightChildDepth, byte nodeLocalDepth, long[] newNode) throws IOException {
        this.startOperation();
        try {
            int nodeIndex;
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                block24: {
                    OCacheEntry firstEntry = this.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true);
                    firstEntry.acquireExclusiveLock();
                    try {
                        ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, this.getChanges(atomicOperation, firstEntry), firstEntry);
                        int tombstone = firstPage.getTombstone();
                        if (tombstone >= 0) {
                            nodeIndex = tombstone;
                        } else {
                            nodeIndex = firstPage.getTreeSize();
                            firstPage.setTreeSize(nodeIndex + 1);
                        }
                        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                            int localNodeIndex = nodeIndex;
                            firstPage.setMaxLeftChildDepth(localNodeIndex, maxLeftChildDepth);
                            firstPage.setMaxRightChildDepth(localNodeIndex, maxRightChildDepth);
                            firstPage.setNodeLocalDepth(localNodeIndex, nodeLocalDepth);
                            if (tombstone >= 0) {
                                firstPage.setTombstone((int)firstPage.getPointer(nodeIndex, 0));
                            }
                            for (int i = 0; i < newNode.length; ++i) {
                                firstPage.setPointer(localNodeIndex, i, newNode[i]);
                            }
                            break block24;
                        }
                        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                        int localLevel = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, true);
                        while (cacheEntry == null || cacheEntry.getPageIndex() < (long)pageIndex) {
                            if (cacheEntry != null) {
                                this.releasePage(atomicOperation, cacheEntry);
                            }
                            cacheEntry = this.addPage(atomicOperation, this.fileId);
                        }
                        cacheEntry.acquireExclusiveLock();
                        try {
                            ODirectoryPage page = new ODirectoryPage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), cacheEntry);
                            page.setMaxLeftChildDepth(localLevel, maxLeftChildDepth);
                            page.setMaxRightChildDepth(localLevel, maxRightChildDepth);
                            page.setNodeLocalDepth(localLevel, nodeLocalDepth);
                            if (tombstone >= 0) {
                                firstPage.setTombstone((int)page.getPointer(localLevel, 0));
                            }
                            for (int i = 0; i < newNode.length; ++i) {
                                page.setPointer(localLevel, i, newNode[i]);
                            }
                        }
                        finally {
                            cacheEntry.releaseExclusiveLock();
                            this.releasePage(atomicOperation, cacheEntry);
                        }
                    }
                    finally {
                        firstEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, firstEntry);
                    }
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (RuntimeException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            finally {
                this.releaseExclusiveLock();
            }
            int n = nodeIndex;
            return n;
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(int nodeIndex) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                block16: {
                    OCacheEntry firstEntry = this.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true);
                    firstEntry.acquireExclusiveLock();
                    try {
                        ODirectoryFirstPage firstPage = new ODirectoryFirstPage(firstEntry, this.getChanges(atomicOperation, firstEntry), firstEntry);
                        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
                            firstPage.setPointer(nodeIndex, 0, firstPage.getTombstone());
                            firstPage.setTombstone(nodeIndex);
                            break block16;
                        }
                        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
                        int localNodeIndex = nodeIndex % ODirectoryPage.NODES_PER_PAGE;
                        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, true);
                        cacheEntry.acquireExclusiveLock();
                        try {
                            ODirectoryPage page = new ODirectoryPage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), cacheEntry);
                            page.setPointer(localNodeIndex, 0, firstPage.getTombstone());
                            firstPage.setTombstone(nodeIndex);
                        }
                        finally {
                            cacheEntry.releaseExclusiveLock();
                            this.releasePage(atomicOperation, cacheEntry);
                        }
                    }
                    finally {
                        firstEntry.releaseExclusiveLock();
                        this.releasePage(atomicOperation, firstEntry);
                    }
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during node deletion", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    public byte getMaxLeftChildDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxLeftChildDepth(int nodeIndex, byte maxLeftChildDepth) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setMaxLeftChildDepth(this.getLocalNodeIndex(nodeIndex), maxLeftChildDepth);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of max left child depth", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    public byte getMaxRightChildDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRightChildDepth(int nodeIndex, byte maxRightChildDepth) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setMaxRightChildDepth(this.getLocalNodeIndex(nodeIndex), maxRightChildDepth);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of right max child depth", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    public byte getNodeLocalDepth(int nodeIndex) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeLocalDepth(int nodeIndex, byte localNodeDepth) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setNodeLocalDepth(this.getLocalNodeIndex(nodeIndex), localNodeDepth);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of local node depth", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getNode(int nodeIndex) throws IOException {
        this.startOperation();
        try {
            long[] node = new long[256];
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = this.atomicOperationsManager.getCurrentOperation();
                    ODirectoryPage page = this.loadPage(nodeIndex, false, atomicOperation);
                    try {
                        int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                        for (int i = 0; i < 256; ++i) {
                            node[i] = page.getPointer(localNodeIndex, i);
                        }
                    }
                    finally {
                        this.releasePage(page, false, atomicOperation);
                    }
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
            long[] lArray = node;
            return lArray;
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNode(int nodeIndex, long[] node) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    int localNodeIndex = this.getLocalNodeIndex(nodeIndex);
                    for (int i = 0; i < 256; ++i) {
                        page.setPointer(localNodeIndex, i, node[i]);
                    }
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of node", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * Exception decompiling
     */
    public long getNodePointer(int nodeIndex, int index) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodePointer(int nodeIndex, int index, long pointer) throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                ODirectoryPage page = this.loadPage(nodeIndex, true, atomicOperation);
                try {
                    page.setPointer(this.getLocalNodeIndex(nodeIndex), index, pointer);
                }
                finally {
                    this.releasePage(page, true, atomicOperation);
                }
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during setting of node pointer", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        this.startOperation();
        try {
            OAtomicOperation atomicOperation = this.startAtomicOperation(true);
            this.acquireExclusiveLock();
            try {
                this.truncateFile(atomicOperation, this.fileId);
                this.init();
                this.endAtomicOperation(false, null);
            }
            catch (IOException e) {
                this.endAtomicOperation(true, e);
                throw e;
            }
            catch (Exception e) {
                this.endAtomicOperation(true, e);
                throw OException.wrapException(new OHashTableDirectoryException("Error during removing of hash table directory content", this), e);
            }
            finally {
                this.releaseExclusiveLock();
            }
        }
        finally {
            this.completeOperation();
        }
    }

    public void flush() throws IOException {
        this.startOperation();
        try {
            this.atomicOperationsManager.acquireReadLock(this);
            try {
                this.acquireSharedLock();
                try {
                    this.writeCache.flush(this.fileId);
                }
                finally {
                    this.releaseSharedLock();
                }
            }
            finally {
                this.atomicOperationsManager.releaseReadLock(this);
            }
        }
        finally {
            this.completeOperation();
        }
    }

    private ODirectoryPage loadPage(int nodeIndex, boolean exclusiveLock, OAtomicOperation atomicOperation) throws IOException {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, this.firstEntryIndex, true);
            if (exclusiveLock) {
                cacheEntry.acquireExclusiveLock();
            } else {
                cacheEntry.acquireSharedLock();
            }
            return new ODirectoryFirstPage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), cacheEntry);
        }
        int pageIndex = nodeIndex / ODirectoryPage.NODES_PER_PAGE;
        OCacheEntry cacheEntry = this.loadPage(atomicOperation, this.fileId, pageIndex, true);
        if (exclusiveLock) {
            cacheEntry.acquireExclusiveLock();
        } else {
            cacheEntry.acquireSharedLock();
        }
        return new ODirectoryPage(cacheEntry, this.getChanges(atomicOperation, cacheEntry), cacheEntry);
    }

    private void releasePage(ODirectoryPage page, boolean exclusiveLock, OAtomicOperation atomicOperation) {
        OCacheEntry cacheEntry = page.getEntry();
        OCachePointer cachePointer = cacheEntry.getCachePointer();
        if (exclusiveLock) {
            cachePointer.releaseExclusiveLock();
        } else {
            cachePointer.releaseSharedLock();
        }
        this.releasePage(atomicOperation, cacheEntry);
    }

    private int getLocalNodeIndex(int nodeIndex) {
        if (nodeIndex < ODirectoryFirstPage.NODES_PER_PAGE) {
            return nodeIndex;
        }
        return (nodeIndex - ODirectoryFirstPage.NODES_PER_PAGE) % ODirectoryPage.NODES_PER_PAGE;
    }

    static {
        try {
            try {
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

