/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.common.util.OResettable;
import com.orientechnologies.common.util.OSizeable;
import com.orientechnologies.orient.core.db.record.OAutoConvertToRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class OLazyWrapperIterator<T>
implements OAutoConvertToRecord,
Iterator<T>,
Iterable<T>,
OResettable,
OSizeable {
    protected final Iterator<?> iterator;
    protected OIdentifiable nextRecord;
    protected T nextElement;
    protected final int size;
    protected boolean autoConvertToRecord = true;
    protected Object multiValue;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public OLazyWrapperIterator(Iterator<?> iterator) {
        this.iterator = iterator;
        this.size = -1;
    }

    public OLazyWrapperIterator(Iterator<?> iterator, int iSize, Object iOriginalValue) {
        this.iterator = iterator;
        this.size = iSize;
        this.multiValue = iOriginalValue;
    }

    public abstract boolean filter(T var1);

    public abstract boolean canUseMultiValueDirectly();

    public abstract T createGraphElement(Object var1);

    public OIdentifiable getGraphElementRecord(Object iObject) {
        return (OIdentifiable)iObject;
    }

    @Override
    public Iterator<T> iterator() {
        this.reset();
        return this;
    }

    @Override
    public int size() {
        if (this.size > -1) {
            return this.size;
        }
        if (this.iterator instanceof OSizeable) {
            return ((OSizeable)((Object)this.iterator)).size();
        }
        return 0;
    }

    @Override
    public void reset() {
        if (this.iterator instanceof OResettable) {
            ((OResettable)((Object)this.iterator)).reset();
        }
        this.nextElement = null;
    }

    @Override
    public boolean hasNext() {
        if (this.autoConvertToRecord) {
            while (this.nextElement == null && this.iterator.hasNext()) {
                this.nextElement = this.createGraphElement(this.iterator.next());
                if (this.nextElement == null || this.filter(this.nextElement)) continue;
                this.nextElement = null;
            }
            return this.nextElement != null;
        }
        while (this.nextRecord == null && this.iterator.hasNext()) {
            this.nextRecord = this.getGraphElementRecord(this.iterator.next());
        }
        return this.nextRecord != null;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            if (this.autoConvertToRecord) {
                try {
                    T t = this.nextElement;
                    return t;
                }
                finally {
                    this.nextElement = null;
                }
            }
            try {
                OIdentifiable oIdentifiable = this.nextRecord;
                return (T)oIdentifiable;
            }
            finally {
                this.nextRecord = null;
            }
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void setAutoConvertToRecord(boolean convertToRecord) {
        this.autoConvertToRecord = convertToRecord;
        if (this.iterator instanceof OAutoConvertToRecord) {
            ((OAutoConvertToRecord)((Object)this.iterator)).setAutoConvertToRecord(this.autoConvertToRecord);
        }
    }

    @Override
    public boolean isAutoConvertToRecord() {
        return this.autoConvertToRecord;
    }

    public Object getMultiValue() {
        return this.multiValue;
    }
}

