/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.hook.ODocumentHookAbstract;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.security.ORestrictedOperation;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import java.util.Set;

public class ORestrictedAccessHook
extends ODocumentHookAbstract
implements ORecordHook.Scoped {
    private static final ORecordHook.SCOPE[] SCOPES;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ORestrictedAccessHook(ODatabaseDocument database) {
        super(database);
    }

    @Override
    public ORecordHook.SCOPE[] getScopes() {
        return SCOPES;
    }

    @Override
    public ORecordHook.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return ORecordHook.DISTRIBUTED_EXECUTION_MODE.BOTH;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeCreate(ODocument iDocument) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument);
        if (cls != null && cls.isRestricted()) {
            String fieldNames = cls.getCustom("onCreate.fields");
            if (fieldNames == null) {
                fieldNames = ORestrictedOperation.ALLOW_ALL.getFieldName();
            }
            String[] fields = fieldNames.split(",");
            String identityType = cls.getCustom("onCreate.identityType");
            if (identityType == null) {
                identityType = "user";
            }
            OIdentifiable identity = null;
            if (identityType.equals("user")) {
                OSecurityUser user = this.database.getUser();
                if (user != null) {
                    identity = user.getIdentity();
                }
            } else if (identityType.equals("role")) {
                Set<? extends OSecurityRole> roles = this.database.getUser().getRoles();
                if (!roles.isEmpty()) {
                    identity = roles.iterator().next().getIdentity();
                }
            } else {
                throw new OConfigurationException("Wrong custom field 'onCreate.identityType' in class '" + cls.getName() + "' with value '" + identityType + "'. Supported ones are: 'user', 'role'");
            }
            if (identity != null) {
                for (String f : fields) {
                    this.database.getMetadata().getSecurity().allowIdentity(iDocument, f, identity);
                }
                return ORecordHook.RESULT.RECORD_CHANGED;
            }
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeRead(ODocument iDocument) {
        return this.isAllowed(iDocument, ORestrictedOperation.ALLOW_READ, false) ? ORecordHook.RESULT.RECORD_NOT_CHANGED : ORecordHook.RESULT.SKIP;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeUpdate(ODocument iDocument) {
        if (!this.isAllowed(iDocument, ORestrictedOperation.ALLOW_UPDATE, true)) {
            throw new OSecurityException("Cannot update record " + iDocument.getIdentity() + ": the resource has restricted access");
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    @Override
    public ORecordHook.RESULT onRecordBeforeDelete(ODocument iDocument) {
        if (!this.isAllowed(iDocument, ORestrictedOperation.ALLOW_DELETE, true)) {
            throw new OSecurityException("Cannot delete record " + iDocument.getIdentity() + ": the resource has restricted access");
        }
        return ORecordHook.RESULT.RECORD_NOT_CHANGED;
    }

    protected boolean isAllowed(ODocument iDocument, ORestrictedOperation iAllowOperation, boolean iReadOriginal) {
        return ORestrictedAccessHook.isAllowed(this.database, iDocument, iAllowOperation, iReadOriginal);
    }

    public static boolean isAllowed(ODatabaseDocument database, ODocument iDocument, ORestrictedOperation iAllowOperation, boolean iReadOriginal) {
        OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(iDocument);
        if (cls != null && cls.isRestricted()) {
            if (database.getUser() == null) {
                return true;
            }
            if (database.getUser().isRuleDefined(ORule.ResourceGeneric.BYPASS_RESTRICTED, null) && database.getUser().checkIfAllowed(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_READ) != null) {
                return true;
            }
            ODocument doc = iReadOriginal ? (ODocument)database.load(iDocument.getIdentity()) : iDocument;
            if (doc == null) {
                return false;
            }
            return database.getMetadata().getSecurity().isAllowed((Set)doc.field(ORestrictedOperation.ALLOW_ALL.getFieldName()), (Set)doc.field(iAllowOperation.getFieldName()));
        }
        return true;
    }

    static {
        try {
            try {
                SCOPES = new ORecordHook.SCOPE[]{ORecordHook.SCOPE.CREATE, ORecordHook.SCOPE.READ, ORecordHook.SCOPE.UPDATE, ORecordHook.SCOPE.DELETE};
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

