/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.security;

import com.orientechnologies.common.log.OLogManager;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class ORule
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ResourceGeneric resourceGeneric;
    private final Map<String, Byte> specificResources = new HashMap<String, Byte>();
    private Byte access = null;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public ORule(ResourceGeneric resourceGeneric, Map<String, Byte> specificResources, Byte access) {
        this.resourceGeneric = resourceGeneric;
        if (specificResources != null) {
            this.specificResources.putAll(specificResources);
        }
        this.access = access;
    }

    public static ResourceGeneric mapLegacyResourceToGenericResource(String resource) {
        Map.Entry found = ResourceGeneric.legacyToGenericMap.floorEntry(resource.toLowerCase(Locale.ENGLISH));
        if (found == null) {
            return null;
        }
        if (resource.length() < found.getKey().length()) {
            return null;
        }
        if (resource.substring(0, found.getKey().length()).equalsIgnoreCase(found.getKey())) {
            return (ResourceGeneric)found.getValue();
        }
        return null;
    }

    public static String mapResourceGenericToLegacyResource(ResourceGeneric resourceGeneric) {
        return (String)ResourceGeneric.genericToLegacyMap.get(resourceGeneric);
    }

    public static String mapLegacyResourceToSpecificResource(String resource) {
        Map.Entry found = ResourceGeneric.legacyToGenericMap.floorEntry(resource.toLowerCase(Locale.ENGLISH));
        if (found == null) {
            return resource;
        }
        if (resource.length() < found.getKey().length()) {
            return resource;
        }
        if (resource.length() == found.getKey().length()) {
            return null;
        }
        if (resource.substring(0, found.getKey().length()).equalsIgnoreCase(found.getKey())) {
            return resource.substring(found.getKey().length() + 1);
        }
        return resource;
    }

    public Byte getAccess() {
        return this.access;
    }

    public ResourceGeneric getResourceGeneric() {
        return this.resourceGeneric;
    }

    public Map<String, Byte> getSpecificResources() {
        return this.specificResources;
    }

    public void grantAccess(String resource, int operation) {
        if (resource == null) {
            this.access = this.grant((byte)operation, this.access);
        } else {
            resource = resource.toLowerCase(Locale.ENGLISH);
            Byte ac = this.specificResources.get(resource);
            this.specificResources.put(resource, this.grant((byte)operation, ac));
        }
    }

    private byte grant(byte operation, Byte ac) {
        if (operation == 0) {
            return 0;
        }
        byte currentValue = ac == null ? (byte)0 : ac;
        currentValue = (byte)(currentValue | operation);
        return currentValue;
    }

    public void revokeAccess(String resource, int operation) {
        if (operation == 0) {
            return;
        }
        if (resource == null) {
            this.access = this.revoke((byte)operation, this.access);
        } else {
            resource = resource.toLowerCase(Locale.ENGLISH);
            Byte ac = this.specificResources.get(resource);
            this.specificResources.put(resource, this.revoke((byte)operation, ac));
        }
    }

    private byte revoke(byte operation, Byte ac) {
        byte currentValue;
        if (ac == null) {
            currentValue = 0;
        } else {
            currentValue = ac;
            currentValue = (byte)(currentValue & ~operation);
        }
        return currentValue;
    }

    public Boolean isAllowed(String name, int operation) {
        if (name == null) {
            return this.allowed((byte)operation, this.access);
        }
        if (this.specificResources.isEmpty()) {
            return this.isAllowed(null, operation);
        }
        Byte ac = this.specificResources.get(name.toLowerCase(Locale.ENGLISH));
        Boolean allowed = this.allowed((byte)operation, ac);
        if (allowed == null) {
            return this.isAllowed(null, operation);
        }
        return allowed;
    }

    private Boolean allowed(byte operation, Byte ac) {
        if (ac == null) {
            return null;
        }
        byte mask = operation;
        return (ac & mask) == mask;
    }

    public boolean containsSpecificResource(String resource) {
        if (this.specificResources.isEmpty()) {
            return false;
        }
        return this.specificResources.containsKey(resource.toLowerCase(Locale.ENGLISH));
    }

    public static abstract class ResourceGeneric
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final TreeMap<String, ResourceGeneric> nameToGenericMap;
        private static final TreeMap<String, ResourceGeneric> legacyToGenericMap;
        private static final Map<ResourceGeneric, String> genericToLegacyMap;
        public static final ResourceGeneric FUNCTION;
        public static final ResourceGeneric CLASS;
        public static final ResourceGeneric CLUSTER;
        public static final ResourceGeneric BYPASS_RESTRICTED;
        public static final ResourceGeneric DATABASE;
        public static final ResourceGeneric SCHEMA;
        public static final ResourceGeneric COMMAND;
        public static final ResourceGeneric COMMAND_GREMLIN;
        public static final ResourceGeneric RECORD_HOOK;
        public static final ResourceGeneric SYSTEM_CLUSTERS;
        public static final ResourceGeneric SERVER;
        public static final ResourceGeneric DATABASE_COPY;
        public static final ResourceGeneric DATABASE_CREATE;
        public static final ResourceGeneric DATABASE_DROP;
        public static final ResourceGeneric DATABASE_EXISTS;
        public static final ResourceGeneric DATABASE_FREEZE;
        public static final ResourceGeneric DATABASE_RELEASE;
        public static final ResourceGeneric DATABASE_PASSTHROUGH;
        public static final ResourceGeneric DATABASE_BACKUP;
        public static final ResourceGeneric DATABASE_RESTORE;
        private final String name;
        private final String legacyName;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        protected ResourceGeneric(String name, String legacyName) {
            this.name = name;
            this.legacyName = legacyName != null ? legacyName : name;
            ResourceGeneric.register(this);
        }

        public String getName() {
            return this.name;
        }

        public String getLegacyName() {
            return this.legacyName;
        }

        private static void register(ResourceGeneric resource) {
            String legacyNameLowCase = resource.legacyName.toLowerCase(Locale.ENGLISH);
            if (nameToGenericMap.containsKey(resource.name) || legacyToGenericMap.containsKey(resource.legacyName.toLowerCase(Locale.ENGLISH)) || genericToLegacyMap.containsKey(resource)) {
                throw new IllegalArgumentException(resource + " already registered");
            }
            nameToGenericMap.put(resource.name, resource);
            legacyToGenericMap.put(legacyNameLowCase, resource);
            genericToLegacyMap.put(resource, resource.legacyName);
        }

        public static ResourceGeneric valueOf(String name) {
            return nameToGenericMap.get(name);
        }

        public static ResourceGeneric[] values() {
            return genericToLegacyMap.keySet().toArray(new ResourceGeneric[genericToLegacyMap.size()]);
        }

        public String toString() {
            return ResourceGeneric.class.getSimpleName() + " [name=" + this.name + ", legacyName=" + this.legacyName + "]";
        }

        static {
            try {
                try {
                    nameToGenericMap = new TreeMap();
                    legacyToGenericMap = new TreeMap();
                    genericToLegacyMap = new HashMap<ResourceGeneric, String>();
                    FUNCTION = new ResourceGeneric("FUNCTION", "database.function"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    CLASS = new ResourceGeneric("CLASS", "database.class"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    CLUSTER = new ResourceGeneric("CLUSTER", "database.cluster"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    BYPASS_RESTRICTED = new ResourceGeneric("BYPASS_RESTRICTED", "database.bypassRestricted"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE = new ResourceGeneric("DATABASE", "database"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    SCHEMA = new ResourceGeneric("SCHEMA", "database.schema"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    COMMAND = new ResourceGeneric("COMMAND", "database.command"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    COMMAND_GREMLIN = new ResourceGeneric("COMMAND_GREMLIN", "database.command.gremlin"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    RECORD_HOOK = new ResourceGeneric("RECORD_HOOK", "database.hook.record"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    SYSTEM_CLUSTERS = new ResourceGeneric("SYSTEM_CLUSTER", "database.systemclusters"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    SERVER = new ResourceGeneric("SERVER", "server"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_COPY = new ResourceGeneric("DATABASE_COPY", "database.copy"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_CREATE = new ResourceGeneric("DATABASE_CREATE", "database.create"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_DROP = new ResourceGeneric("DATABASE_DROP", "database.drop"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_EXISTS = new ResourceGeneric("DATABASE_EXISTS", "database.exists"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_FREEZE = new ResourceGeneric("DATABASE_FREEZE", "database.freeze"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_RELEASE = new ResourceGeneric("DATABASE_RELEASE", "database.release"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_PASSTHROUGH = new ResourceGeneric("DATABASE_PASSTHROUGH", "database.passthrough"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_BACKUP = new ResourceGeneric("DATABASE_BACKUP", "database.backup"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    DATABASE_RESTORE = new ResourceGeneric("DATABASE_RESTORE", "database.restore"){
                        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;
                    };
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }
}

