/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OSequenceException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Random;
import java.util.concurrent.Callable;

public abstract class OSequence {
    public static final long DEFAULT_START = 0L;
    public static final int DEFAULT_INCREMENT = 1;
    public static final int DEFAULT_CACHE = 20;
    protected static final int DEF_MAX_RETRY;
    public static final String CLASS_NAME = "OSequence";
    private static final String FIELD_START = "start";
    private static final String FIELD_INCREMENT = "incr";
    private static final String FIELD_VALUE = "value";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private ODocument document;
    private ThreadLocal<ODocument> tlDocument = new ThreadLocal();
    private int maxRetry = DEF_MAX_RETRY;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    protected OSequence() {
        this(null, null);
    }

    protected OSequence(ODocument iDocument) {
        this(iDocument, null);
    }

    protected OSequence(ODocument iDocument, CreateParams params) {
        this.document = iDocument != null ? iDocument : new ODocument(CLASS_NAME);
        this.bindOnLocalThread();
        if (iDocument == null) {
            if (params == null) {
                params = new CreateParams().setDefaults();
            }
            this.initSequence(params);
            this.document = this.getDocument();
        }
    }

    public void save(ODatabase db) {
        ODocument doc = this.tlDocument.get();
        db.save(doc);
        this.onUpdate(doc);
    }

    public void save() {
        this.save(this.getDatabase());
    }

    void bindOnLocalThread() {
        this.tlDocument.set(this.document.copy());
    }

    public ODocument getDocument() {
        return this.tlDocument.get();
    }

    protected synchronized void initSequence(CreateParams params) {
        this.setStart(params.start);
        this.setIncrement(params.increment);
        this.setValue(params.start);
        this.setSequenceType();
    }

    public synchronized boolean updateParams(CreateParams params) {
        boolean any = false;
        if (params.start != null && this.getStart() != params.start.longValue()) {
            this.setStart(params.start);
            any = true;
        }
        if (params.increment != null && this.getIncrement() != params.increment.intValue()) {
            this.setIncrement(params.increment);
            any = true;
        }
        this.save();
        this.reset();
        return any;
    }

    public void onUpdate(ODocument iDocument) {
        this.document = iDocument;
        this.tlDocument.set(iDocument);
    }

    protected synchronized long getValue() {
        return (Long)this.tlDocument.get().field(FIELD_VALUE, OType.LONG);
    }

    protected synchronized void setValue(long value) {
        this.tlDocument.get().field(FIELD_VALUE, value);
    }

    protected synchronized int getIncrement() {
        return (Integer)this.tlDocument.get().field(FIELD_INCREMENT, OType.INTEGER);
    }

    protected synchronized void setIncrement(int value) {
        this.tlDocument.get().field(FIELD_INCREMENT, value);
    }

    protected synchronized long getStart() {
        return (Long)this.tlDocument.get().field(FIELD_START, OType.LONG);
    }

    protected synchronized void setStart(long value) {
        this.tlDocument.get().field(FIELD_START, value);
    }

    public synchronized int getMaxRetry() {
        return this.maxRetry;
    }

    public synchronized void setMaxRetry(int maxRetry) {
        this.maxRetry = maxRetry;
    }

    public synchronized String getName() {
        return OSequence.getSequenceName(this.tlDocument.get());
    }

    public synchronized OSequence setName(String name) {
        this.tlDocument.get().field(FIELD_NAME, name);
        return this;
    }

    private synchronized void setSequenceType() {
        this.tlDocument.get().field(FIELD_TYPE, (Object)this.getSequenceType());
    }

    protected synchronized ODatabaseDocumentInternal getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    public static String getSequenceName(ODocument iDocument) {
        return (String)iDocument.field(FIELD_NAME, OType.STRING);
    }

    public static SEQUENCE_TYPE getSequenceType(ODocument document) {
        String sequenceTypeStr = (String)document.field(FIELD_TYPE);
        if (sequenceTypeStr != null) {
            return SEQUENCE_TYPE.valueOf(sequenceTypeStr);
        }
        return null;
    }

    public static void initClass(OClassImpl sequenceClass) {
        sequenceClass.createProperty(FIELD_START, OType.LONG, (OType)null, true);
        sequenceClass.createProperty(FIELD_INCREMENT, OType.INTEGER, (OType)null, true);
        sequenceClass.createProperty(FIELD_VALUE, OType.LONG, (OType)null, true);
        sequenceClass.createProperty(FIELD_NAME, OType.STRING, (OType)null, true);
        sequenceClass.createProperty(FIELD_TYPE, OType.STRING, (OType)null, true);
    }

    public abstract long next();

    public abstract long current();

    public abstract long reset();

    public abstract SEQUENCE_TYPE getSequenceType();

    protected void reloadSequence() {
        this.tlDocument.set(this.tlDocument.get().reload(null, true));
    }

    protected <T> T callRetry(Callable<T> callable, String method) {
        for (int retry = 0; retry < this.maxRetry; ++retry) {
            try {
                this.reloadSequence();
                return callable.call();
            }
            catch (OConcurrentModificationException ignore) {
                try {
                    Thread.sleep(1 + new Random().nextInt(OGlobalConfiguration.SEQUENCE_RETRY_DELAY.getValueAsInteger()));
                    continue;
                }
                catch (InterruptedException ignored) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            catch (OStorageException e) {
                if (e.getCause() instanceof OConcurrentModificationException) {
                    this.reloadSequence();
                    continue;
                }
                throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
            }
            catch (OException ignore) {
                this.reloadSequence();
                continue;
            }
            catch (Exception e) {
                throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
            }
        }
        try {
            return callable.call();
        }
        catch (Exception e) {
            if (e.getCause() instanceof OConcurrentModificationException) {
                throw (OConcurrentModificationException)e.getCause();
            }
            throw OException.wrapException(new OSequenceException("Error in transactional processing of " + this.getName() + "." + method + "()"), e);
        }
    }

    static {
        try {
            try {
                DEF_MAX_RETRY = OGlobalConfiguration.SEQUENCE_MAX_RETRY.getValueAsInteger();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }

    public static final class SEQUENCE_TYPE
    extends Enum<SEQUENCE_TYPE> {
        public static final /* enum */ SEQUENCE_TYPE CACHED;
        public static final /* enum */ SEQUENCE_TYPE ORDERED;
        private static final /* synthetic */ SEQUENCE_TYPE[] $VALUES;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public static SEQUENCE_TYPE[] values() {
            return (SEQUENCE_TYPE[])$VALUES.clone();
        }

        public static SEQUENCE_TYPE valueOf(String name) {
            return Enum.valueOf(SEQUENCE_TYPE.class, name);
        }

        static {
            try {
                try {
                    CACHED = new SEQUENCE_TYPE();
                    ORDERED = new SEQUENCE_TYPE();
                    $VALUES = new SEQUENCE_TYPE[]{CACHED, ORDERED};
                    return;
                }
                catch (RuntimeException runtimeException) {
                    OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                    throw runtimeException;
                }
            }
            catch (Error error) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
                throw error;
            }
        }
    }

    public static class CreateParams {
        public Long start = 0L;
        public Integer increment = 1;
        public Integer cacheSize = 20;
        private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

        public CreateParams setStart(Long start) {
            this.start = start;
            return this;
        }

        public CreateParams setIncrement(Integer increment) {
            this.increment = increment;
            return this;
        }

        public CreateParams setCacheSize(Integer cacheSize) {
            this.cacheSize = cacheSize;
            return this;
        }

        public CreateParams setDefaults() {
            this.start = this.start != null ? this.start : 0L;
            this.increment = this.increment != null ? this.increment : 1;
            this.cacheSize = this.cacheSize != null ? this.cacheSize : 20;
            return this;
        }
    }
}

