/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceCached;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceOrdered;
import com.orientechnologies.orient.core.record.impl.ODocument;

public class OSequenceHelper {
    public static final OSequence.SEQUENCE_TYPE DEFAULT_SEQUENCE_TYPE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public static OSequence createSequence(OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params, ODocument document) {
        switch (sequenceType) {
            case ORDERED: {
                return new OSequenceOrdered(document, params);
            }
            case CACHED: {
                return new OSequenceCached(document, params);
            }
        }
        throw new IllegalArgumentException("sequenceType");
    }

    public static OSequence.SEQUENCE_TYPE getSequenceTyeFromString(String typeAsString) {
        return OSequence.SEQUENCE_TYPE.valueOf(typeAsString);
    }

    public static OSequence createSequence(ODocument document) {
        OSequence.SEQUENCE_TYPE sequenceType = OSequence.getSequenceType(document);
        if (sequenceType != null) {
            return OSequenceHelper.createSequence(sequenceType, null, document);
        }
        return null;
    }

    static {
        try {
            try {
                DEFAULT_SEQUENCE_TYPE = OSequence.SEQUENCE_TYPE.CACHED;
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

