/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeListener;
import com.orientechnologies.orient.core.db.record.OMultiValueChangeTimeLine;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentEntry;
import java.lang.ref.WeakReference;

final class OSimpleMultiValueChangeListener<K, V>
implements OMultiValueChangeListener<K, V> {
    private final WeakReference<ODocument> oDocument;
    private final ODocumentEntry entry;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    OSimpleMultiValueChangeListener(ODocument oDocument, ODocumentEntry entry) {
        this.oDocument = new WeakReference<ODocument>(oDocument);
        this.entry = entry;
    }

    @Override
    public void onAfterRecordChanged(OMultiValueChangeEvent<K, V> event) {
        ODocument document = (ODocument)this.oDocument.get();
        if (document == null) {
            return;
        }
        if (document.getInternalStatus() != ORecordElement.STATUS.UNMARSHALLING) {
            if (event.isChangesOwnerContent()) {
                document.setDirty();
            } else {
                document.setDirtyNoChanged();
            }
        }
        if (!document._trackingChanges || !document.getIdentity().isValid() || document.getInternalStatus() == ORecordElement.STATUS.UNMARSHALLING) {
            return;
        }
        if (this.entry == null || this.entry.isChanged()) {
            return;
        }
        if (this.entry.timeLine == null) {
            this.entry.timeLine = new OMultiValueChangeTimeLine();
        }
        this.entry.timeLine.addCollectionChangeEvent(event);
    }
}

