/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security.symmetrickey;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.symmetrickey.OSymmetricKeyConfig;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.Key;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class OSymmetricKey {
    private String seedAlgorithm = "PBKDF2WithHmacSHA1";
    private String seedPhrase = UUID.randomUUID().toString();
    private int saltLength = 64;
    private int iteration = 65536;
    private String secretKeyAlgorithm = "AES";
    private String defaultCipherTransformation = "AES/CBC/PKCS5Padding";
    private int keySize = 128;
    private SecretKey secretKey;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    public String getDefaultCipherTransform(String transform) {
        return this.defaultCipherTransformation;
    }

    public int getIteration(int iteration) {
        return iteration;
    }

    public String getKeyAlgorithm(String algorithm) {
        return this.secretKeyAlgorithm;
    }

    public int getKeySize(int bits) {
        return this.keySize;
    }

    public int getSaltLength(int length) {
        return this.saltLength;
    }

    public String getSeedAlgorithm(String algorithm) {
        return this.seedAlgorithm;
    }

    public String getSeedPhrase(String phrase) {
        return this.seedPhrase;
    }

    public OSymmetricKey setDefaultCipherTransform(String transform) {
        this.defaultCipherTransformation = transform;
        return this;
    }

    public OSymmetricKey setIteration(int iteration) {
        this.iteration = iteration;
        return this;
    }

    public OSymmetricKey setKeyAlgorithm(String algorithm) {
        this.secretKeyAlgorithm = algorithm;
        return this;
    }

    public OSymmetricKey setKeySize(int bits) {
        this.keySize = bits;
        return this;
    }

    public OSymmetricKey setSaltLength(int length) {
        this.saltLength = length;
        return this;
    }

    public OSymmetricKey setSeedAlgorithm(String algorithm) {
        this.seedAlgorithm = algorithm;
        return this;
    }

    public OSymmetricKey setSeedPhrase(String phrase) {
        this.seedPhrase = phrase;
        return this;
    }

    public OSymmetricKey() {
        this.create();
    }

    public OSymmetricKey(String secretKeyAlgorithm, String cipherTransform, int keySize) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
        this.defaultCipherTransformation = cipherTransform;
        this.keySize = keySize;
        this.create();
    }

    public OSymmetricKey(SecretKey secretKey) throws OSecurityException {
        if (secretKey == null) {
            throw new OSecurityException("OSymmetricKey(SecretKey) secretKey is null");
        }
        this.secretKey = secretKey;
        this.secretKeyAlgorithm = secretKey.getAlgorithm();
    }

    public OSymmetricKey(String algorithm, String base64Key) throws OSecurityException {
        this.secretKeyAlgorithm = algorithm;
        try {
            byte[] keyBytes = OSymmetricKey.convertFromBase64(base64Key);
            this.secretKey = new SecretKeySpec(keyBytes, this.secretKeyAlgorithm);
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.OSymmetricKey() Exception: " + ex.getMessage()), ex);
        }
    }

    protected void create() {
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] salt = secureRandom.generateSeed(this.saltLength);
            PBEKeySpec keySpec = new PBEKeySpec(this.seedPhrase.toCharArray(), salt, this.iteration, this.keySize);
            SecretKeyFactory factory = SecretKeyFactory.getInstance(this.seedAlgorithm);
            SecretKey tempKey = factory.generateSecret(keySpec);
            this.secretKey = new SecretKeySpec(tempKey.getEncoded(), this.secretKeyAlgorithm);
        }
        catch (Exception ex) {
            throw new OSecurityException("OSymmetricKey.create() Exception: " + ex);
        }
    }

    protected static String separateAlgorithm(String cipherTransform) {
        String[] array = cipherTransform.split("/");
        if (array.length > 1) {
            return array[0];
        }
        return null;
    }

    public static OSymmetricKey fromConfig(OSymmetricKeyConfig keyConfig) {
        if (keyConfig.usesKeyString()) {
            return OSymmetricKey.fromString(keyConfig.getKeyAlgorithm(), keyConfig.getKeyString());
        }
        if (keyConfig.usesKeyFile()) {
            return OSymmetricKey.fromFile(keyConfig.getKeyAlgorithm(), keyConfig.getKeyFile());
        }
        if (keyConfig.usesKeystore()) {
            return OSymmetricKey.fromKeystore(keyConfig.getKeystoreFile(), keyConfig.getKeystorePassword(), keyConfig.getKeystoreKeyAlias(), keyConfig.getKeystoreKeyPassword());
        }
        throw new OSecurityException("OSymmetricKey(OSymmetricKeyConfig) Invalid configuration");
    }

    public static OSymmetricKey fromString(String algorithm, String base64Key) {
        return new OSymmetricKey(algorithm, base64Key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OSymmetricKey fromFile(String algorithm, String path) {
        OSymmetricKey oSymmetricKey;
        block6: {
            Object base64Key = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(OSystemVariableResolver.resolveSystemVariables(path));
                oSymmetricKey = OSymmetricKey.fromStream(algorithm, fis);
                if (fis == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw OException.wrapException(new OSecurityException("OSymmetricKey.fromFile() Exception: " + ex.getMessage()), ex);
                }
            }
            fis.close();
        }
        return oSymmetricKey;
    }

    public static OSymmetricKey fromStream(String algorithm, InputStream is) {
        String base64Key = null;
        try {
            base64Key = OIOUtils.readStreamAsString(is);
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.fromStream() Exception: " + ex.getMessage()), ex);
        }
        return new OSymmetricKey(algorithm, base64Key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OSymmetricKey fromKeystore(String path, String password, String keyAlias, String keyPassword) {
        OSymmetricKey oSymmetricKey;
        block6: {
            Object sk = null;
            KeyStore ks = KeyStore.getInstance("JCEKS");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(OSystemVariableResolver.resolveSystemVariables(path));
                oSymmetricKey = OSymmetricKey.fromKeystore(fis, password, keyAlias, keyPassword);
                if (fis == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw OException.wrapException(new OSecurityException("OSymmetricKey.fromKeystore() Exception: " + ex.getMessage()), ex);
                }
            }
            fis.close();
        }
        return oSymmetricKey;
    }

    public static OSymmetricKey fromKeystore(InputStream is, String password, String keyAlias, String keyPassword) {
        OSymmetricKey sk = null;
        try {
            KeyStore.PasswordProtection protParam;
            KeyStore.SecretKeyEntry skEntry;
            KeyStore ks = KeyStore.getInstance("JCEKS");
            char[] ksPasswdChars = null;
            if (password != null) {
                ksPasswdChars = password.toCharArray();
            }
            ks.load(is, ksPasswdChars);
            char[] ksKeyPasswdChars = null;
            if (keyPassword != null) {
                ksKeyPasswdChars = keyPassword.toCharArray();
            }
            if ((skEntry = (KeyStore.SecretKeyEntry)ks.getEntry(keyAlias, protParam = new KeyStore.PasswordProtection(ksKeyPasswdChars))) == null) {
                throw new OSecurityException("SecretKeyEntry is null for key alias: " + keyAlias);
            }
            SecretKey secretKey = skEntry.getSecretKey();
            sk = new OSymmetricKey(secretKey);
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.fromKeystore() Exception: " + ex.getMessage()), ex);
        }
        return sk;
    }

    public String getBase64Key() {
        if (this.secretKey == null) {
            throw new OSecurityException("OSymmetricKey.getBase64Key() SecretKey is null");
        }
        return OSymmetricKey.convertToBase64(this.secretKey.getEncoded());
    }

    protected static String convertToBase64(byte[] bytes) {
        String result = null;
        try {
            result = OBase64Utils.encodeBytes(bytes);
        }
        catch (Exception ex) {
            OLogManager.instance().error(null, "convertToBase64()", ex, new Object[0]);
        }
        return result;
    }

    protected static byte[] convertFromBase64(String base64) {
        byte[] result = null;
        try {
            if (base64 != null) {
                result = OBase64Utils.decode(base64.getBytes("UTF8"));
            }
        }
        catch (Exception ex) {
            OLogManager.instance().error(null, "convertFromBase64()", ex, new Object[0]);
        }
        return result;
    }

    public String encrypt(String value) {
        try {
            return this.encrypt(value.getBytes("UTF8"));
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.encrypt() Exception: " + ex.getMessage()), ex);
        }
    }

    public String encrypt(String transform, String value) {
        try {
            return this.encrypt(transform, value.getBytes("UTF8"));
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.encrypt() Exception: " + ex.getMessage()), ex);
        }
    }

    public String encrypt(byte[] bytes) {
        return this.encrypt(this.defaultCipherTransformation, bytes);
    }

    public String encrypt(String transform, byte[] bytes) {
        String encodedJSON = null;
        if (this.secretKey == null) {
            throw new OSecurityException("OSymmetricKey.encrypt() SecretKey is null");
        }
        if (transform == null) {
            throw new OSecurityException("OSymmetricKey.encrypt() Cannot determine cipher transformation");
        }
        try {
            Cipher cipher = Cipher.getInstance(transform);
            cipher.init(1, this.secretKey);
            byte[] initVector = cipher.getIV();
            byte[] encrypted = cipher.doFinal(bytes);
            encodedJSON = this.encodeJSON(encrypted, initVector);
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.encrypt() Exception: " + ex.getMessage()), ex);
        }
        return encodedJSON;
    }

    protected String encodeJSON(byte[] encrypted, byte[] initVector) {
        String encodedJSON = null;
        String encryptedBase64 = OSymmetricKey.convertToBase64(encrypted);
        String initVectorBase64 = null;
        if (initVector != null) {
            initVectorBase64 = OSymmetricKey.convertToBase64(initVector);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append("\"algorithm\":\"");
        sb.append(this.secretKeyAlgorithm);
        sb.append("\",\"transform\":\"");
        sb.append(this.defaultCipherTransformation);
        sb.append("\",\"payload\":\"");
        sb.append(encryptedBase64);
        sb.append("\"");
        if (initVectorBase64 != null) {
            sb.append(",\"iv\":\"");
            sb.append(initVectorBase64);
            sb.append("\"");
        }
        sb.append("}");
        try {
            encodedJSON = OSymmetricKey.convertToBase64(sb.toString().getBytes("UTF8"));
        }
        catch (Exception ex) {
            OLogManager.instance().error(this, "Error of conversion to base64", ex, new Object[0]);
        }
        return encodedJSON;
    }

    public String decryptAsString(String encodedJSON) {
        try {
            byte[] decrypted = this.decrypt(encodedJSON);
            return new String(decrypted, "UTF8");
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.decryptAsString() Exception: " + ex.getMessage()), ex);
        }
    }

    public byte[] decrypt(String encodedJSON) {
        byte[] result = null;
        if (encodedJSON == null) {
            throw new OSecurityException("OSymmetricKey.decrypt(String) encodedJSON is null");
        }
        try {
            byte[] decoded = OSymmetricKey.convertFromBase64(encodedJSON);
            if (decoded == null) {
                throw new OSecurityException("OSymmetricKey.decrypt(String) encodedJSON could not be decoded");
            }
            String json = new String(decoded, "UTF8");
            ODocument doc = new ODocument().fromJSON(json, "noMap");
            String algorithm = this.secretKeyAlgorithm;
            if (doc.containsField("algorithm")) {
                algorithm = (String)doc.field("algorithm");
            }
            String transform = this.defaultCipherTransformation;
            if (doc.containsField("transform")) {
                transform = (String)doc.field("transform");
            }
            String payloadBase64 = (String)doc.field("payload");
            String ivBase64 = (String)doc.field("iv");
            byte[] payload = null;
            byte[] iv = null;
            if (payloadBase64 != null) {
                payload = OSymmetricKey.convertFromBase64(payloadBase64);
            }
            if (ivBase64 != null) {
                iv = OSymmetricKey.convertFromBase64(ivBase64);
            }
            Cipher cipher = Cipher.getInstance(transform);
            if (iv != null) {
                cipher.init(2, (Key)this.secretKey, new IvParameterSpec(iv));
            } else {
                cipher.init(2, this.secretKey);
            }
            result = cipher.doFinal(payload);
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.decrypt(String) Exception: " + ex.getMessage()), ex);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToStream(OutputStream os) {
        if (os == null) {
            throw new OSecurityException("OSymmetricKey.saveToStream() OutputStream is null");
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter(os);
            try {
                BufferedWriter writer = new BufferedWriter(osw);
                try {
                    writer.write(this.getBase64Key());
                }
                finally {
                    writer.close();
                }
            }
            finally {
                os.close();
            }
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.saveToStream() Exception: " + ex.getMessage()), ex);
        }
    }

    public void saveToKeystore(OutputStream os, String ksPasswd, String keyAlias, String keyPasswd) {
        if (os == null) {
            throw new OSecurityException("OSymmetricKey.saveToKeystore() OutputStream is null");
        }
        if (ksPasswd == null) {
            throw new OSecurityException("OSymmetricKey.saveToKeystore() Keystore Password is required");
        }
        if (keyAlias == null) {
            throw new OSecurityException("OSymmetricKey.saveToKeystore() Key Alias is required");
        }
        if (keyPasswd == null) {
            throw new OSecurityException("OSymmetricKey.saveToKeystore() Key Password is required");
        }
        try {
            KeyStore ks = KeyStore.getInstance("JCEKS");
            char[] ksPasswdCA = ksPasswd.toCharArray();
            char[] keyPasswdCA = keyPasswd.toCharArray();
            ks.load(null, ksPasswdCA);
            KeyStore.PasswordProtection protParam = new KeyStore.PasswordProtection(keyPasswdCA);
            KeyStore.SecretKeyEntry skEntry = new KeyStore.SecretKeyEntry(this.secretKey);
            ks.setEntry(keyAlias, skEntry, protParam);
            ks.store(os, ksPasswdCA);
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSecurityException("OSymmetricKey.saveToKeystore() Exception: " + ex.getMessage()), ex);
        }
    }
}

