/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChanges;
import java.nio.ByteBuffer;

public class OLinkSerializer
implements OBinarySerializer<OIdentifiable> {
    public static final byte ID = 9;
    private static final int CLUSTER_POS_SIZE = 8;
    public static final int RID_SIZE = 10;
    public static final OLinkSerializer INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public int getObjectSize(OIdentifiable rid, Object ... hints) {
        return 10;
    }

    @Override
    public void serialize(OIdentifiable rid, byte[] stream, int startPosition, Object ... hints) {
        ORID r = rid.getIdentity();
        OBinaryProtocol.short2bytes((short)r.getClusterId(), stream, startPosition);
        OBinaryProtocol.long2bytes(r.getClusterPosition(), stream, startPosition + 2);
    }

    @Override
    public ORecordId deserialize(byte[] stream, int startPosition) {
        return new ORecordId(OBinaryProtocol.bytes2short(stream, startPosition), OBinaryProtocol.bytes2long(stream, startPosition + 2));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 10;
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 10;
    }

    @Override
    public void serializeNativeObject(OIdentifiable rid, byte[] stream, int startPosition, Object ... hints) {
        ORID r = rid.getIdentity();
        OShortSerializer.INSTANCE.serializeNative((short)r.getClusterId(), stream, startPosition, new Object[0]);
        OLongSerializer.INSTANCE.serialize(r.getClusterPosition(), stream, startPosition + 2, new Object[0]);
    }

    @Override
    public ORecordId deserializeNativeObject(byte[] stream, int startPosition) {
        short clusterId = OShortSerializer.INSTANCE.deserializeNative(stream, startPosition);
        long clusterPosition = OLongSerializer.INSTANCE.deserialize(stream, startPosition + 2);
        return new ORecordId(clusterId, clusterPosition);
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 10;
    }

    @Override
    public OIdentifiable preprocess(OIdentifiable value, Object ... hints) {
        if (value == null) {
            return null;
        }
        return value.getIdentity();
    }

    @Override
    public void serializeInByteBufferObject(OIdentifiable object, ByteBuffer buffer, Object ... hints) {
        ORID r = object.getIdentity();
        buffer.putShort((short)r.getClusterId());
        byte[] stream = new byte[8];
        OLongSerializer.INSTANCE.serialize(r.getClusterPosition(), stream, 0, new Object[0]);
        buffer.put(stream);
    }

    @Override
    public OIdentifiable deserializeFromByteBufferObject(ByteBuffer buffer) {
        short clusterId = buffer.getShort();
        byte[] stream = new byte[8];
        buffer.get(stream);
        long clusterPosition = OLongSerializer.INSTANCE.deserialize(stream, 0);
        return new ORecordId(clusterId, clusterPosition);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer) {
        return 10;
    }

    @Override
    public OIdentifiable deserializeFromByteBufferObject(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        short clusterId = walChanges.getShortValue(buffer, offset);
        long clusterPosition = OLongSerializer.INSTANCE.deserialize(walChanges.getBinaryValue(buffer, offset + 2, 8), 0);
        return new ORecordId(clusterId, clusterPosition);
    }

    @Override
    public int getObjectSizeInByteBuffer(ByteBuffer buffer, OWALChanges walChanges, int offset) {
        return 10;
    }

    static {
        try {
            try {
                INSTANCE = new OLinkSerializer();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

