/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class OStreamSerializerAnyRecord
implements OStreamSerializer {
    public static final String NAME = "ar";
    public static final OStreamSerializerAnyRecord INSTANCE;
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        String stream = new String(iStream, "UTF-8");
        Class<?> cls = null;
        try {
            StringBuilder content = new StringBuilder(1024);
            cls = OStreamSerializerHelper.readRecordType(stream, content);
            for (Constructor<?> c : cls.getDeclaredConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length != 2 || !params[1].equals(ORID.class)) continue;
                ORecord rec = (ORecord)c.newInstance(new ORecordId(content.toString()));
                return rec;
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new OSerializationException("Error on unmarshalling content. Class " + (cls != null ? cls.getName() : "?")), e);
        }
        throw new OSerializationException("Cannot unmarshall the record since the serialized object of class " + (cls != null ? cls.getSimpleName() : "?") + " has no constructor with suitable parameters: (ORID)");
    }

    @Override
    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        if (((ORecord)iObject).getIdentity() == null) {
            throw new OSerializationException("Cannot serialize record without identity. Store it before serialization.");
        }
        StringBuilder buffer = OStreamSerializerHelper.writeRecordType(iObject.getClass(), new StringBuilder(1024));
        buffer.append(((ORecord)iObject).getIdentity().toString());
        return buffer.toString().getBytes("UTF-8");
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            try {
                INSTANCE = new OStreamSerializerAnyRecord();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

