/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.string;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializer;

public class OStringSerializerAnyStreamable
implements OStringSerializer {
    public static final OStringSerializerAnyStreamable INSTANCE;
    public static final String NAME = "st";
    private static final boolean __TRANSFORMED_BY_JAVASSIST_MAVEN_PLUGIN__com_orientechnologies_common_javassist_OStaticInitializerExceptionLoggerWeaver = true;

    @Override
    public Object fromStream(String iStream) {
        if (iStream == null || iStream.length() == 0) {
            return null;
        }
        OSerializableStream instance = null;
        int propertyPos = iStream.indexOf(58);
        int pos = iStream.indexOf("|");
        if (pos < 0 || propertyPos > -1 && pos > propertyPos) {
            instance = new ODocument();
            pos = -1;
        } else {
            String className = iStream.substring(0, pos);
            try {
                Class<?> clazz = Class.forName(className);
                instance = (OSerializableStream)clazz.newInstance();
            }
            catch (Exception e) {
                String message = "Error on unmarshalling content. Class: " + className;
                OLogManager.instance().error(this, message, e, new Object[0]);
                throw OException.wrapException(new OSerializationException(message), e);
            }
        }
        instance.fromStream(OBase64Utils.decode(iStream.substring(pos + 1)));
        return instance;
    }

    @Override
    public StringBuilder toStream(StringBuilder iOutput, Object iValue) {
        if (iValue != null) {
            if (!(iValue instanceof OSerializableStream)) {
                throw new OSerializationException("Cannot serialize the object since it's not implements the OSerializableStream interface");
            }
            OSerializableStream stream = (OSerializableStream)iValue;
            iOutput.append(iValue.getClass().getName());
            iOutput.append("|");
            iOutput.append(OBase64Utils.encodeBytes(stream.toStream()));
        }
        return iOutput;
    }

    @Override
    public String getName() {
        return NAME;
    }

    static {
        try {
            try {
                INSTANCE = new OStringSerializerAnyStreamable();
                return;
            }
            catch (RuntimeException runtimeException) {
                OLogManager.instance().errorNoDb(null, "Error in static initializer", runtimeException, new String[0]);
                throw runtimeException;
            }
        }
        catch (Error error) {
            OLogManager.instance().errorNoDb(null, "Error in static initializer", error, new String[0]);
            throw error;
        }
    }
}

